/* gsm.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * gsm_init:
 * creates handle
 *
 * gsm_clean:
 * cleanup
 * 
 * gsm_read:
 * read compressed data from file descriptor, uncompress
 *
 * gsm_write:
 * compress, write to file descriptor
 * 
 * sizes of buffer are hardcoded, because of libgsm.a
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "gsm.h"
#include "proto.h"

/* globals */

static gsm handle;
static struct transmit{
  unsigned char  status;
  gsm_frame      frame[25];
  unsigned char  rest[192];
} data;

int gsm_init(void){

  if (!(handle = gsm_create())) {
    err_ret("gsm: gsm_init: ");
    return -1;
  }
  return 0;
}

int gsm_clean(void){
  
  gsm_destroy(handle);
  return 0;
}


int gsm_write(int fd, char *buf, int n,unsigned char status){

  int i,m;
  char *ref;
  
  ref = buf;

  for (i=0;i<n;i++){
    gsm_encode(handle,(gsm_signal*) ref, data.frame[i]);
    ref += SAMPLE;
  }

  data.status = status;
  memcpy(data.rest,ref,192);
  m = write(fd,&data,sizeof(data));

  return m;
}


int gsm_read(int fd, char *buf,unsigned char *status){
  
  int n,i;
  char *ref;
  
  ref = buf;

  n = read(fd,&data,sizeof(data)) - sizeof(unsigned char) - 192;
  n /= FRAME;
  *status = data.status;
  for (i=0;i<n;i++){
    gsm_decode(handle, data.frame[i], (gsm_signal*) ref);
    ref += SAMPLE;
  }
  memcpy(ref,data.rest,192);
  if (n == -1)
    return QUIT;
  else
    return n;
}
  


