/*
 * ident.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * ident_uid   Information about user (by uid)      
 * ident_name  Information about user (by name)      
 *
 */

#include <pwd.h>
#include <stdio.h>
#include <sys/types.h>
#include <strings.h>
#include "proto.h"

char *ident_uid (int uid){
 
  static char name[64];
  struct passwd *entry;


  if (!(entry = getpwuid(uid))){
    err_ret("Unknown User");
    return NULL;
  }
  else{
    strncpy(name,entry->pw_name,sizeof(name)-1);
    name[sizeof(name)-1] = 0;
    return name;
  }

}

uid_t ident_name (char *user){
 
  struct passwd *entry;

  if (!(entry = getpwnam(user))){
    err_ret("Unknown User");
    return 0;
  }
  return entry->pw_uid;
}

