/*
 * sock.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * udp_open: 
 * connect to given hostname and port
 * return address of host in *host
 *
 */

#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include "proto.h"

int udp_open(char *hostname, int port, struct sockaddr_in *host){

  struct sockaddr_in   client;
  struct hostent       *hp;
  unsigned long        inaddr;
  int                  fd;

  bzero ((char*) host,sizeof(struct sockaddr_in));
  host->sin_family = AF_INET;
  host->sin_port   = htons(port);
  
  if ((inaddr = inet_addr(hostname)) != INADDR_NONE)/*hostname is dotted*/
    bcopy((char*) &inaddr, (char*) &host->sin_addr,
	  sizeof(inaddr));
  else {
    if ((hp = gethostbyname(hostname)) == NULL){
      err_ret("Unknown host");
      return(-1);
    }

    bcopy (hp->h_addr, (char*) &host->sin_addr,hp->h_length);
  }

  if ((fd = socket(AF_INET, SOCK_DGRAM, 0))<0){
    err_ret("udp_open: socket: ");
    return -1;
  }

  bzero ((char*) &client,sizeof(client));
  client.sin_family = AF_INET;
  client.sin_port   = htons(0);
  client.sin_addr.s_addr   = htonl(INADDR_ANY);
  
  if (bind(fd, (struct sockaddr*) &client,sizeof(client)) < 0){
    close(fd);
    err_ret("udp_open: bind: ");
    return -1;
  }  

  return(fd);
}
int sock_listen(char *path){

  int fd,new_fd;
  struct sockaddr_un addr,addr_in;
  size_t len;

  len = sizeof(addr.sun_path)-1;
  bzero((void*) &addr,sizeof(addr)); 
  addr.sun_family = AF_UNIX;
  strncpy(addr.sun_path,path,len);
  addr.sun_path[len] = '\0';
  len = sizeof(addr.sun_family) + strlen(addr.sun_path);

  if ((fd = socket(PF_UNIX,SOCK_STREAM,0))<0){
    err_ret("sock_listen: socket: ");
    return -1;
  }
    
  if (bind (fd, (struct sockaddr *) &addr, len) < 0){
    err_ret("sock_listen: bind: ");
    return -1;
  }

  /*  sound_ring();*/
  if (listen(fd,1)<0){
    err_ret("sock_listen: listen: ");
    return -1;
  }
  
  len = sizeof(addr_in);
  new_fd = accept(fd,(struct sockaddr*) &addr_in, &len);

  return (new_fd);
}

int sock_connect(char *path){

  int fd;
  size_t len;
  struct sockaddr_un addr;

  len = sizeof(addr.sun_path)-1;
  bzero((void*) &addr,sizeof(addr)); 
  addr.sun_family = AF_UNIX;
  strncpy(addr.sun_path,path,len);
  addr.sun_path[len] = '\0';
  len = sizeof(addr.sun_family) + strlen(addr.sun_path);

  if ((fd = socket(PF_UNIX,SOCK_STREAM,0))<0){
    err_ret("sock_connect: socket:");
    return -1;
  }
    
  if (connect(fd, (struct sockaddr *) &addr, len) < 0){
    err_ret("sock_connect: connect:");
    return -1;
  }
  
  return (fd);
  
}
