/* sound.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * initializes soundcard
 * reads from and write to soundcard (not used, for test purpose only !)
 * sound_reopen, sound_sync (not used)
 *
 * sound_init:
 * set parameters
 * 
 * sound_clean:
 * cleans sound device
 *
 *
 */

#include <sys/ioctl.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include "proto.h"

int sound_init(int dir);
int sound_reopen(int dir);
int sound_sync(int dspfd);
int sound_clean(int dspfd);
int sound_ring(void);

int sound_init(int dir){

  int dspfd;
  int sampling = 8000, format = AFMT_S16_LE, stereo = 0;
  int arg = 0x8000D;

  if ((dspfd  = open("/dev/dsp", dir)) == -1) {
    err_ret("sound: sound_init: /dev/dsp");
    return -1;
  }
#ifdef FRAGMENT
  if (ioctl(dspfd,SNDCTL_DSP_SETFRAGMENT, &arg) == -1){
      err_ret("sound: sound_init: Cannot allocate DMA buffer, need 32768 Bytes ...");
      return (-1);
  }
#endif

  if (ioctl(dspfd, SNDCTL_DSP_SETFMT, &format) == -1) {
    err_ret("sound: sound_init: No 16 Bit Format possible...");
    return -1;
  }
#ifdef STEREO
    if (ioctl(dspfd, SNDCTL_DSP_STEREO, &stereo) == -1) {
    perror("sound: sound_init: stereo");
    return -1;
  }
#endif

#ifdef SRATE
  if (ioctl(dspfd, SNDCTL_DSP_SPEED, &sampling) == -1) {
    err_ret("sound: sound_init: Cannot set sampling rate to 8000");
    return -1;
  }
  
#endif

  return dspfd;
}


int sound_sync(int dspfd){

  int dummy=0;
  if (ioctl(dspfd, SNDCTL_DSP_SYNC) == -1)
    err_ret("sound: sound_sync: sync");
  return dummy;
}

int sound_clean(int dspfd){

  close(dspfd);
  return 0;
}

int sound_get_bytes(int dspfd){

  count_info info;
  
  if (ioctl(dspfd, SNDCTL_DSP_GETOPTR, &info) == -1) {
    err_ret("sound: sound_get_bytes: Couldn't get data");
    return -1;
  }
  return info.bytes;
}


int sound_get_caps(int dspfd){

 int caps;
 if (ioctl(dspfd, SNDCTL_DSP_GETCAPS, &caps) == -1) {
   err_ret("sound: sound_get_cpas: Couldn't get caps");
   return -1;
 }
 if (caps & DSP_CAP_DUPLEX)
   puts("Full Duplex");
 if (caps & DSP_CAP_BATCH )
   puts("Local Storage");
 if (caps & DSP_CAP_MMAP)
   puts("mmap possible"); 
 if (caps & DSP_CAP_REALTIME)
   puts("Realtime");
 return caps;
}

int sound_ring(void){

  char ring[32768];
  int n,m;

  n = open(RINGPATH,O_RDONLY);
  if (n<0)
    return -1;

  m = sound_init(O_WRONLY);
  if (m<0){
    close(n);
    return(-1);
  }

  read(n,ring,sizeof(ring));
  write(m,ring,sizeof(ring));
  
  sound_clean(m);
  close(n);

  return 0;
}
    
    
    
