/* 
 * answer.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * answer is invoked by destination. Uses local unix stream socket 
 * (/tmp/whisper) to communicate with whisperd
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include "proto.h"


void answer(void){

  struct termios term,term2;
  int fd;
  char c='y';
  unsigned char uc = 0;

  if ((fd = sock_connect(UNIX_STREAM))<0){
    err_ret("answer: sock_connect: ");
    return;
  }

  tcgetattr(STDIN_FILENO, &term);           /* get flags */
  tcgetattr(STDIN_FILENO, &term2);           /* get flags */
  term.c_lflag &= ~(ICANON | ECHO);         /* Turn off echoing and 
					       can. mode */
  term.c_cc[VMIN] = 1;                    
  term.c_cc[VTIME] = 0;                     
  tcsetattr(STDIN_FILENO, TCSANOW, &term);
  tcflush(STDIN_FILENO,TCIFLUSH);

/*  sleep(1);*/
  write(fd,&c,1);

  puts("stop...");

  while (1){
    read(fd,&uc,1);
    printf("talk...\n");
    if (uc == QUIT){
      printf("exiting...by client  %c\n",c);
      break;
    }
    tcflush(STDIN_FILENO,TCIFLUSH);
    read(STDIN_FILENO,&c,1);
    if (c == 'q'){
      printf("exiting...by server  %c\n",c);
      write(fd,&c,1);
      break;
    }
    printf("stop...\n");
    c = 'y';
    write(fd,&c,1);
  }
  tcflush(STDIN_FILENO,TCIFLUSH);
  tcsetattr(STDIN_FILENO, TCSANOW, &term2);
  
  close(fd);
}

