/*
 * cs_talk.c 
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * connection is accepted -> 
 *   turn off key repeat
 *   turn off terminal buffering
 *   init gsm
 *   perform communication
 *         
 */

#include <stdlib.h>
#include <termios.h>
#include <fcntl.h>
#include "proto.h"
#include <time.h>
#include <string.h>
#include <sys/times.h>

void cs_talk(int sock_fd, int snd_fd, int mul){

  char *buf,*rec_ptr;
  char c=0;
  unsigned char status=0, dir=CS;
  struct termios term, term2;
  
  int j,n=0,bytes,left,p_num_old,p_num,sum;
  int FIRST=1;
  double elapsed;
  clock_t start=0,end=0;
  struct tms time_start,time_end;

#ifdef DEBUG
  int sum = 0,b_old=0,b_new=0,b_sum=0,sent_bytes,samples;
#endif

  if (!(buf = malloc(16 * SBUF*sizeof(char)))){
    err_ret("Cannont allocate Bufferspace, need 14*SBUF Bytes...");
    return;
  }

  tcgetattr(STDIN_FILENO, &term2);           /* get flags */
  tcgetattr(STDIN_FILENO, &term);           /* get flags */
  term.c_lflag &= ~(ICANON | ECHO);         /* Turn off echoing and 
					       can. mode */
  term.c_cc[VMIN] = 0;                    
  term.c_cc[VTIME] = 0;                     
  tcsetattr(STDIN_FILENO, TCSANOW, &term);
  tcflush(STDIN_FILENO,TCIFLUSH);

  gsm_init();

  while (dir != QUIT){

    tcflush(STDIN_FILENO,TCIFLUSH);
    puts("talk...");

    rec_ptr = buf;

    while (dir == CS){

      read (STDIN_FILENO, &c,1);           
      switch (c) {
      case 0:
	break;
      case 'q':
	dir = QUIT;
	break;
      default:
	puts("ready...");
	dir = SC;                      /* free speech control */
      }
      c = 0;

      n = read(snd_fd,buf,8192);

      status &= 0x3F;                 /* clear first two bits */
      status++;                       /* package no 0 < status < 64 */
      status %= 0x40;

      status |= dir;                  /* first bits are dir */

      if (n != 8192){
	fprintf(stderr,"soundcard: Tried  to read 8192 bytes, got only %i. Aborting...\n",n);
	return;
      }
      gsm_write(sock_fd,buf,25,status);

    }

    puts("stop...");
    /*    sound_sync(snd_fd);*/
    sound_clean(snd_fd);
    snd_fd = sound_init(O_WRONLY);
    
    rec_ptr = buf;
    left = p_num = p_num_old = sum = 0;
    FIRST = 1;

#ifdef DEBUG
    end = 0;
    start = times(&time1);
    printf("%i\n",sound_get_caps(snd_fd));
#endif
    while (dir == SC){
    
      alarm(10);
      n = gsm_read(sock_fd,rec_ptr,&status);
      alarm(0);
      if (n != 25){
	printf("%i\n",n);
	err_ret("cs_talk: unknown network error");
	return;
      }
      dir = (status & 0xC0);
      if (dir == CS)
	puts("ready.");

      bytes = left + n*SAMPLE+192;        /* bytes to proceed */

      p_num = status & 0x3F;
      if ((p_num-p_num_old + 0x3F) % 0x40)
	printf("Lost a packet! %i %i %i\n",p_num,p_num_old,\
	       (p_num-p_num_old+0x3F) % 0x40);
      p_num_old = p_num;
      
#ifdef DEBUG
      b_new = sound_get_bytes(snd_fd) % 65536;
      if (b_new < b_old){
	b_sum += (65536-b_old+b_new);
      }
      else
	b_sum += (b_new - b_old);
      end1 = end;
      end = times(&time2);
      sum += n*SAMPLE+192;
      
      elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
      printf("Global: SC: %f sum:%i Rate:%f Dir: %u Bytes: %i\n"\
	     ,elapsed,sum,sum/elapsed,dir,b_sum);
      diff = elapsed - b_sum/32000.;
      elapsed = ((double) (end - end1)) / CLOCKS_PER_SEC;
      printf("Local: GS: %f read:%i Rate:%f Dir: %u Time: %f\n"\
	     ,elapsed,n*SAMPLE,n*SAMPLE/elapsed,dir,b_sum/32000.);
      printf("Diff: %f \n",diff);
      b_old = b_new;
      FIRST = 0;
#endif 
      
      if (FIRST){
	j = bytes / mul;
	if (j > 0){
	  FIRST = 0;
	  n = write(snd_fd,buf,j*mul);
	  sum = n;
	  start = times(&time_start);
	  /*	  printf("%i\n",n);*/
	  left = bytes - j*mul;
	  if(left)
	    memmove(buf,buf+j*mul,left);
	}
	else
	  left = bytes;
	rec_ptr = buf + left;
      }
      else{
	n = write(snd_fd,buf,bytes);
	sum += n;
	end = times(&time_end);
		elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
		/*printf("Time: %f  wrote: %i  Rate:%f \n"\
	       ,elapsed,sum,sum/elapsed);*/
	left = 0;
	rec_ptr = buf;
      }
    }

    if (left>0){
      n = write(snd_fd,buf,left);
      sum += n;
    }
    
    end = times(&time_end);
    elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
    /*    printf("Final -- Time: %f  wrote: %i  Rate:%f \n"\
	   ,elapsed,sum,sum/elapsed);*/
    
    /*    sound_sync(snd_fd);*/
    sound_clean(snd_fd);
    snd_fd = sound_init(O_RDONLY);
    
  }
  
  free(buf);
  tcflush(STDIN_FILENO,TCIFLUSH);
  tcsetattr(STDIN_FILENO, TCSANOW, &term2);
  gsm_clean();
}
