/*
 * start_dialog.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * first contact on well known port (may change during comm.)
 *
 * invokes 'ident'      (Identifikation of local user)
 * invokes 'udp_open'   (udp connect to server(udp) -> return fd and
 *                       server address)
 *
 * uses 'recvfrom' to get new remote address (because server forks)
 * and connect to new socket (maybe not necessary)
 * 
 * send local user name; receive answer; reconnect; send remote user name;
 * receive answer -> if 'S' -> some remote problems
 *
 */

#include "proto.h"
#include <errno.h>
#include <strings.h>
#include <stdlib.h>
 
int start_dialog(char *host, char *user,int mul){

  int n=0,addr_len,fd;
  struct sockaddr_in server_addr;
  comm_data *data;
  char buf[1024], *uname;

  addr_len = sizeof (struct sockaddr_in);

  if ((uname = ident_uid(getuid())))
    sprintf(buf,"%s",uname);
  else
    sprintf(buf,"someone unknown");
  
  fd = udp_open(host, PORT, &server_addr);
  if (fd<0){
    err_ret("start_dialog: udp_open");
    return(-1);
  }

  n = sendto(fd,buf,strlen(buf),0,
	     (struct sockaddr*) &server_addr,addr_len);
  if (n<0){
    err_ret("start_dialog: sendto");
    return(-1);
  }

  alarm(5);
  n = recvfrom(fd,buf,sizeof(buf)-1,0,
	       (struct sockaddr*) &server_addr, &addr_len);
  alarm(0);

  if (n<0){
    err_ret("start_dialog: recvfrom");
    return(-1);
  }

  buf[n] = '\0';

  if (connect(fd,(struct sockaddr*) &server_addr,
	      sizeof(server_addr)) < 0){
    close(fd);
    err_ret("start_dialog: Reconnect failed");
    return(-1);
  }

  strncpy(buf,user,sizeof(buf));
#ifdef DEBUG
  printf("client sends:    %s\n",buf);
#endif

  if ((n = write(fd,buf,strlen(buf))) < 0){
    err_ret("start_dialog: write");
    return(-1);
  }
  
  alarm(5);
  n = read(fd,buf,sizeof(buf)-1);
  alarm(0);
  if (n<0){
    err_ret("start_dialog: read");
    return(-1);
  }

  data = (comm_data*) buf; 
  if (strncmp(data->version,VERSION,sizeof(VERSION)))
    printf("Warning! Server and client have different version numbers. Because this version (%s) ist alpha, you will probably encounter some problems. To find out how to get an actual version enter 'whisper -v'\n",VERSION);
      
  data->length = sizeof(comm_data);
  strcpy(data->version,VERSION);
  data->mul = mul;
  
  if ((n = write(fd,data,sizeof(comm_data))) < 0){
    err_ret("start_dialog: write");
    return(-1);
  }
  
  alarm(5);
  n = read(fd,buf,sizeof(buf)-1);
  alarm(0);
  if (n<0){
    err_ret("start_dialog: read");
    return(-1);
  }

  buf[n] = '\0';

  if (*buf == 'S'){
    printf("Sorry, access denied.\nMaybe %s is not sitting in front of the console\n",user);
    return(-1);
  }
  else{
    printf(">> Connection accepted by server <<\n...ringing...\n");
    return(fd);
  }
  
}
