/*
 * whisper.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * if invoked without options -> answer incoming call
 *
 * analyses options and target
 * sets SIGALRM (timeouts)
 *
 * invokes 'sound_init'   (soundcard initialization)
 * invokes 'start_dialog' (contact server)
 * invokes 'cs_talk'      (dialog)
 *
 */


#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include "proto.h"
#include <linux/soundcard.h>

void main (int argc, char **argv){
  
  int mul=65536, sock_fd=0, snd_fd=0,n;
  char c, *ptr;
  char host[MAXHOSTNAMELEN];
  char name[32];

#ifdef DEBUG
  audio_buf_info info;
#endif

  signal(SIGALRM, timeout);

  if (argc == 1){
    answer();
    exit(0);
  }

  opterr = 1;
  while((c = getopt(argc,argv,"hvb:"))>0){
    switch(c){
    case 'v':
      printf("whisper 0.1 (April, 30, 1998 -- Claus Roedenbeck)\n");
      printf("http://www.itp.uni-hannover.de/~roeden/whisper.html\n");
      exit(0);
    case 'b':
      mul = 8192 * atoi(optarg);
      if (mul == 0){
	printf("Value too low, use at least '-b 1'\n");
	exit(0);
      }
      break;
    default:
      printf("usage: %s [-h] [-v] [-b num] user@host\n",*argv);
      exit(0);
    }
  }

  if (!(ptr = strchr(argv[argc-1],'@'))){
    puts("Wrong format -- use '-h'");
    exit(1);
  }

  strncpy(host,ptr+1,sizeof(host)-1);
  host[sizeof(host)-1] = '\0';
  *ptr='\0';
  strncpy(name,argv[argc-1],sizeof(name)-1);
  name[sizeof(name)-1] = '\0';

  snd_fd = sound_init(O_RDONLY);
  if (snd_fd < 0){
    err_ret("whisper: sound_init: ");
    exit(1);
  }

#ifdef DEBUG
  ioctl(snd_fd, SNDCTL_DSP_GETOSPACE, &info);

  printf("OUT: f: %i tot: %i size: %i bytes: %i\n",
	 info.fragments,info.fragstotal,info.fragsize,info.bytes);
  ioctl(snd_fd, SNDCTL_DSP_GETISPACE, &info);
  printf("IN: f: %i tot: %i size: %i bytes: %i\n",
	 info.fragments,info.fragstotal,info.fragsize,info.bytes);
#endif
  
  sock_fd = start_dialog(host,name,mul);
  if (sock_fd < 0){
    err_ret("whisper: start_dialog: ");
    sound_clean(snd_fd);
    exit(1);
  }
      
  c = 'n';
  alarm(40);
  n = read(sock_fd,&c,1);
  alarm(0);

  if (c=='y')
    cs_talk(sock_fd,snd_fd,mul);
  else
    printf("No answer, sorry ...exiting\n");

  close(sock_fd);
  sound_clean(snd_fd);
  exit(0);
}

