/*
 * message.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * start dialog on server side (<-> start_dialog)
 * invokes 'notify'            print message 
 * 
 * fd on success
 * -1 on error
 * -2 if notify failed
 */

#include "proto.h"
#include <errno.h>
#include <strings.h>

extern int h_errno;

int message(int *mul){
  
  char buf[1024], sender[64], user[64], *addr;
  int addr_len, fd, n=0;
  struct sockaddr_in  cli_addr,srv_addr;
  struct hostent *host;
  comm_data *data;

  addr_len = sizeof(struct sockaddr_in);

  n = recvfrom(1,buf,sizeof(buf)-1,0,
	       (struct sockaddr*) &cli_addr, &addr_len);
  buf[n] = '\0';

#ifdef DEBUG
  fprintf(debug,"server received: %s\n",buf);
#endif  

  close(2);
  close(1);
  close(0);

  if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0){
    err_ret("message: socket: ");
    return -1;
  }
#ifdef DEBUG
  fprintf(debug,"server: new socket %i\n",fd);
#endif

  bzero ((char*) &srv_addr,sizeof(srv_addr));
  srv_addr.sin_family = AF_INET;
  srv_addr.sin_port   = htons(0);
  srv_addr.sin_addr.s_addr   = htonl(INADDR_ANY);
  
  if (bind(fd, (struct sockaddr*) &srv_addr,sizeof(srv_addr)) < 0){
    close(fd);
    err_ret("message: bind: ");
    return -1;
  }  

  if (connect(fd,(struct sockaddr*) &cli_addr,
	      sizeof(cli_addr)) < 0){
    close(fd);
    err_ret("message: connect: Reconnect failed\n");
    exit(1);
  }

  strncpy(sender,buf,sizeof(sender)-1);
  sender[sizeof(sender)-1] = 0;

  sprintf(buf,"Contact accepted...%s, who you wanna talk to ?\n",sender);
  n = write(fd,buf,strlen(buf));

#ifdef DEBUG
  fprintf(debug,"server sends:  %s",buf);
#endif

  alarm(5);
  n = read(fd,user,sizeof(user)-1);
  alarm(0);
  if (n == -1)
    return -1;
  user[n] = 0;
#ifdef DEBUG
  fprintf(debug,"server received: %s\n",user);
#endif  
  addr = inet_ntoa(cli_addr.sin_addr);
  host = gethostbyaddr((char*) &cli_addr.sin_addr ,
		       sizeof(struct in_addr),AF_INET);

  data = (comm_data*) buf;
  data->length = sizeof(comm_data);
  data->mul = 0;
  strcpy(data->version,VERSION);
  
  write(fd,data,sizeof(comm_data));
  
  alarm(5);
  n = read(fd,buf,sizeof(buf)-1);
  alarm(0);

  if (n<0){
    err_ret("message: read");
    return(-1);
  }
  *mul = data->mul;
    
  if (host)
    sprintf(buf,"%s@%s",sender,host->h_name);
  else
    sprintf(buf,"%s@%s",sender,addr);
  
  n = notify(buf, user);
  
  if (n<0){
    strcpy(buf,"Sorry\n");
    write(fd,buf,strlen(buf));
    return(-2);
  }
  else{
    strcpy(buf,"Connect\n");
    write(fd,buf,strlen(buf));
    return(fd);
  }
}


