/*
 * notify.c
 * 
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * Try to notify user, that someone wants to talk
 * 0 on succes, -1 on error, -2 unknown user, -3 mesg n or remote
 *
 */


#include <stdio.h>
#include <utmp.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <unistd.h>
#include "proto.h"
#include <errno.h>

extern FILE *debug;

int notify(char *buf, char *user){
  
  struct utmp *entry;
  struct stat term_stat;
  FILE *fp;
  int ret = 0;
  char term[64];
  uid_t uid1,uid2;

  strcpy(term,"/dev/");
  setutent();

  while ((entry = getutent())){
    if (strncmp(entry->ut_name,user,strlen(user)))
      continue;
    if (entry->ut_type != USER_PROCESS)
      continue;
#ifdef DEBUG
    fprintf(debug,"entry %li %s %s %s %i %o\n",entry->ut_addr,
	    entry->ut_name,entry->ut_host,entry->ut_line,
	    term_stat.st_uid,term_stat.st_mode);
#endif
    if (isalnum(*entry->ut_host))
      continue;
    strncpy(term+strlen("/dev/"),entry->ut_line,sizeof(term));

    if (stat(term, &term_stat) < 0){
      err_ret("notify: stat: ");
      continue;
    }

    if (!(term_stat.st_mode &  S_IWGRP)){
#ifdef DEBUG
      fprintf(debug,"no %li %s %s %s %i %o\n",entry->ut_addr,
	      entry->ut_name,entry->ut_host,entry->ut_line,
	      term_stat.st_uid,term_stat.st_mode);
#endif
      term[strlen("/dev/")] = '\0';
      continue;
    }
    else{
#ifdef DEBUG
      fprintf(debug,"yes %li %s %s %s %i %o\n",entry->ut_addr,
	      entry->ut_name,entry->ut_host,entry->ut_line,
	      term_stat.st_uid,term_stat.st_mode);
#endif 
      break;
    }

   }
  uid1 = geteuid();
  seteuid(0);
  if (!(uid2 = ident_name(user))){
    err_ret("notify: ident_name: ");
    return -2;
  }
  if (setreuid(uid2,uid2)<0)
    err_ret("notify: seteuid:");

  /* TESTING */
  /*    sprintf(term,"%s","/dev/ttyp0");*/

#ifdef DEBUG
  fprintf(debug,"Switched to uid %i(eff) %i(real)\n",geteuid(),getuid());
  fprintf(debug,"Using Terminal %s\n",term);
#endif
  if (!(fp = fopen(term,"w"))){
#ifdef DEBUG
    fprintf(debug,"fopen not possible\n");
#endif
    return -3;
  }
  
  fprintf(fp,"\a\n
#########################################\n\
#                                       #\n\
#         Message from whisper          #\n\
#                                       #\n\
#########################################\n\n\
          %s                             \n\
          wants to talk to %s            \n",buf,user);

  seteuid(uid1);
  return(ret);
}
