/*
 * sc_talk.c 
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 *
 * server to client 
 *
 */

#include "proto.h"
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

extern FILE *debug;

void sc_talk(int sock_fd, int snd_fd, int fifo_fd, int mul){

  unsigned char status=0,dir=CS;
  unsigned char c=0;

  char *buf,*rec_ptr;
  int i,n,bytes,left=0;
  int FIRST =1;

  if (!(buf = malloc(16 * SBUF*sizeof(char)))){
   err_ret("Cannot allocate internal buffer ...");
    return;
  }

  gsm_init();
  /*  snd_fd = sound_init(O_RDWR);*/

  while (dir != QUIT){


    left = 0;
    rec_ptr = buf;
    FIRST = 1;

    while (dir == CS){
    
      alarm(20);
      n = gsm_read(sock_fd,rec_ptr,&status);
      alarm(0);

      if (n != 25){
	fprintf(stderr,"%i\n",n);
	err_ret("sc_talk: unknown network error");
	return;
      }
      
      dir = (status & 192);
      bytes = left  + n*SAMPLE + 192;        

      
      if (FIRST){
	i = bytes / mul;
	
	if (i > 0){
	  FIRST = 0;
	  write(snd_fd,buf,i*mul);
	  left = bytes - i*mul;
	  if(left)
	    memmove(buf,buf+i*mul,left);
	}
	else
	  left = bytes;
	rec_ptr = buf + left;
      }
      else{
	write(snd_fd,buf,bytes);
	left = 0;
	rec_ptr = buf;
      }
    }
    if (left>0)
      write(snd_fd,buf,left);
    
    c = dir;
    write(fifo_fd,&c,1);
    
    /* FILE */
    
    /*    lseek(snd_fd,0L,SEEK_SET);*/
    sound_clean(snd_fd);
    snd_fd = sound_init(O_RDONLY); 
    /*    sound_sync(snd_fd);*/
    

    status = 0;
    rec_ptr = buf;

    while (dir == SC){
      
      read(fifo_fd, &c, 1);
      switch(c){
      case SC:
	break;
      case 'q':
	dir = QUIT;
	break;
      default:
	dir = CS;
      }

      n = read (snd_fd,buf,8192);
      
      if (n==0)
	dir = CS;
      else
	if (n != 8192){
	   fprintf(stderr,"soundcard: Tried to read 8192 bytes, got only %i. Aborting...\n",n);
	   return;
        }	
	  
      status &= 63;
      status++;
      status %= 64;

      status |= dir;

      gsm_write(sock_fd,buf,25,status);
      
    }

    /* FILE */
    
    /*    lseek(snd_fd,0L,SEEK_SET);*/
    sound_clean(snd_fd);
    snd_fd = sound_init(O_WRONLY); 
    /*    sound_sync(snd_fd);*/
  }

  gsm_clean();
}
