/* 
 * whisperd.c
 *
 * Copyright 1998 by Claus Roedenbeck, Technische Universitaet 
 * Hannover, Germany. See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.

 * The daemon
 *
 */

#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include "proto.h"
#include <linux/soundcard.h>

FILE *debug;

void main(int argc, char **argv){

  int  flags,m, pid, sock_fd, f_sock_fd, snd_fd=0, mul=1;
  char c='n';
  uid_t uid=0;

#ifdef DEBUG
  audio_buf_info info;
  unlink(DEBUGFILE);
#endif

  unlink(UNIX_STREAM);

  if (!(uid = ident_name("nobody"))){
    fprintf(stderr,"No user 'nobody' ...");
  }

  seteuid(uid);

  if ((pid=fork()) < 0)
    err_fatal("Cannot fork");
  
  if (pid > 0)
    exit(0);
  
#ifdef DEBUG
  debug = fopen(DEBUGFILE,"w");
  setbuf(debug,NULL);
#endif

#ifdef DEBUG
  fprintf(debug,"Switched to uid %i(eff) %i(real)\n",geteuid(),getuid());
#endif
  
  signal (SIGALRM,timeout);

  if ((sock_fd = message(&mul)) <0){
    if (sock_fd == -1)
      err_ret("whisperd: message: ");
    else{
      err_ret("Unknown user or user not sitting in front of console or mesg ist n");
      write(sock_fd,"n",1);
      close(sock_fd);
    }
    unlink(UNIX_STREAM);
    exit(1);
  }

 
  alarm(30);
  f_sock_fd = sock_listen(UNIX_STREAM);
  alarm(0);

  if (f_sock_fd < 0){
    unlink(UNIX_STREAM);
    write(sock_fd,"n",1);
    close(sock_fd);
    exit(1);
  }

  m=read(f_sock_fd,&c,1);

#ifdef  DEBUG
  fprintf(debug,"sock: %c\n",c);
#endif
  

  /* FILE */
  snd_fd = sound_init(O_WRONLY);
  /*    snd_fd = open("/tmp/dsp",O_RDWR|O_TRUNC);*/

  if (snd_fd < 0){
    err_ret("whisperd: sound_init: ");
    unlink(UNIX_STREAM);
    write(sock_fd,"n",1);
    close(f_sock_fd);
    exit(1);
  }

  if (c!='y'){

#ifdef DEBUG
    fprintf(debug,"No answer, sorry\n");
#endif
    write(sock_fd,"n",1);
  }

  else{

#ifdef DEBUG
    fprintf(debug,"talk...\n");
#endif

    write(sock_fd,"y",1);
    fcntl(f_sock_fd,F_GETFL,&flags);
    flags |= O_NONBLOCK;
    fcntl(f_sock_fd,F_SETFL,&flags);
    sc_talk(sock_fd,snd_fd,f_sock_fd,mul);
    close(snd_fd);
  }
  
  close(f_sock_fd);
  close(sock_fd);
  unlink(UNIX_STREAM);
  
#ifdef DEBUG
  fclose(debug);
#endif
}



