/* 
 * fontFamily.h --
 *
 *      This file contains the declaration of the 'FontFamily' class,
 *      and the 'FontItem' structure.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef FONT_FAMILY_H
#define FONT_FAMILY_H

extern "C" {
#include <X11/Xlib.h>
}

/*
 * Allowed font styles.
 */

typedef enum {NORMAL, BOLD, ITALIC, BOLD_ITALIC} FontStyle;

struct FontItem;

class FontFamily {

private:
  char     *_family;   /* Family name     */
  FontStyle  _style;   /* Style name      */
  char   *_x11_name;   /* X11 name        */
  char    *_ps_name;   /* PostScript name */

  FontItem *_fontsPtr;

public:

  FontFamily(char *, FontStyle, char *, char *);
  ~FontFamily();

  inline char *get_family(void)     const  { return _family;  }
  inline FontStyle get_style(void)  const  { return _style;   }
  inline char *get_psName(void)     const  { return _ps_name; }

  FontItem *add_item(Display *, int);
  void del_item(int);
  FontItem *query_item(int);
};




typedef struct FontItem {
  XFontStruct      *xfs;    /* X11 XFontStruct      */
  int              size;    /* Size point           */
  int          refCount;    /* number of references */
  struct FontItem *next;    /* next fontItem        */
  FontFamily    *parent;    /* FontFamily parent    */
  int           spacing;    /* word spacing         */

  inline char *get_family(void)     const  { return parent->get_family();  }
  inline FontStyle get_style(void)  const  { return parent->get_style();   }
  inline char *get_psName(void)     const  { return parent->get_psName(); }

  inline int get_size(void)       const  { return size; }
  inline Font get_fid(void)       const  { return xfs->fid; }
  inline int get_spacing(void)    const  { return spacing;  }

  inline int get_ascent()         const  { return xfs->ascent;  }
  inline int get_descent()        const  { return xfs->descent; }

  inline int get_text_width(char *s, int n)  const  { return XTextWidth(xfs, s, n);     }
  inline int get_font_height(void)           const  { return get_ascent()+get_descent(); }

  inline int set_spacing(int s)          { spacing = s;  }  
};


#endif




