/* 
 * styleItem.cc --
 *
 *      This file contains the definitions of the 'StyleItem' class
 *      methods.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


extern "C" {
#include <stdio.h>
#include <string.h>
}

#include "styleItem.h"



/*
 *----------------------------------------------------------------------
 *
 * StyleItem --
 *
 *      This method is invoked every time a StyleItem is created.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The datas class are initialized.
 *
 *----------------------------------------------------------------------
 */

StyleItem::StyleItem(void) {
  _name = NULL;
  _font = NULL;
  _tag  = 0;
  _nstyle = NULL;
}



/*
 *----------------------------------------------------------------------
 *
 * ~StyleItem --
 *
 *      This method is invoked every time a StyleItem is deleted.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

StyleItem::~StyleItem() {
}



/*
 *----------------------------------------------------------------------
 *
 * get_attr --
 *
 *      This method is invoked to get an attribute of the StyleItem.
 *
 * Results:
 *      Returns the value of the attribute which type is 't', or
 *      NULL if not found.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void *
StyleItem::get_attr(StyleAttrType t) {


  switch( t ) {
  case STYLE_NAME:
    return (void *)_name;
    break;

  case STYLE_ALIGNMENT:
    return (void *)_alignment;
    break;
    
  case STYLE_FLINE_MARGIN:
    return (void *)_fline;
    break;

  case STYLE_BOTTOM_MARGIN:
    return (void *)get_bmargin();
    break;

  case STYLE_TOP_MARGIN:
    return (void *)get_tmargin();
    break;

  case STYLE_LEFT_MARGIN:
    return (void *)get_lmargin();
    break;

  case STYLE_RIGHT_MARGIN:
    return (void *)get_rmargin();
    break;

  case STYLE_TAG:
    return (void *)_tag;
    break;

  case STYLE_NEXT_STYLE:
    return (void *)((_nstyle==NULL) ? "Normal" : _nstyle);
    return (char *)_nstyle;
    break;

  case STYLE_FONT:
    return (void *)_font;
    break;

  default:
    fprintf(stderr,
	    "StyleItem::get_attr: StyleAttrType %d not allowed\n", (int)t);
  }
  return NULL;
}



/*
 *----------------------------------------------------------------------
 *
 * set_attr --
 *
 *      This method is invoked to set an attribute of the StyleItem.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
StyleItem::set_attr(StyleAttrType t, void *value) {


  switch( t ) {

  case STYLE_NAME:
    if( _name != NULL )
      delete _name;
    _name = strdup((char *)value);
    break;

  case STYLE_ALIGNMENT:
    _alignment = (StyleAlignType)value;
    break;
    
  case STYLE_FLINE_MARGIN:
    _fline = (unsigned int)value;
    break;

  case STYLE_BOTTOM_MARGIN:
    set_bmargin((unsigned int)value);
    break;

  case STYLE_TOP_MARGIN:
    set_tmargin((unsigned int)value);
    break;

  case STYLE_LEFT_MARGIN:
    set_lmargin((unsigned int)value);
    break;

  case STYLE_RIGHT_MARGIN:
    set_rmargin((unsigned int)value);
    break;

  case STYLE_TAG:
    _tag = (int)value;
    break;

  case STYLE_NEXT_STYLE:
    if( _nstyle != NULL )
      delete _nstyle;
    _nstyle = strdup((char *)value);
    break;

  case STYLE_FONT:
    _font = (FontItem *)value;
    break;

  default:
    fprintf(stderr,
	    "StyleItem::set_attr: StyleAttrType %d not allowed\n", (int)t);
  }
}
