/* 
 * styleManager.cc --
 *
 *      This file contains the definitions of the 'StyleManager' class
 *      methods.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


extern "C" {
#include <string.h>
#include <stdio.h>
}

#include "styleManager.h"
#include "../../tcl/commands.h"




/*
 *----------------------------------------------------------------------
 *
 * StyleManager --
 *
 *      This method is invoked every time a StyleManager is created.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The datas class are initialized.
 *
 *----------------------------------------------------------------------
 */

StyleManager::StyleManager() {

  _list = NULL;
}



/*
 *----------------------------------------------------------------------
 *
 * ~StyleManager --
 *
 *      This method is invoked every time a StyleManager is deleted.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

StyleManager::~StyleManager() {
}



/*
 *----------------------------------------------------------------------
 *
 * query_style --
 *
 *      This method is invoked to look for a style (given by name).
 *
 * Results:
 *      Returns a StyleItem if found and NULL else.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

StyleItem *
StyleManager::query_style(char *name) {
  
  StyleItem *si;

  si = _list;
  
  while( si != NULL )
    if( strcmp((char *)si->get_attr(STYLE_NAME), name) == 0 )
      break;
    else
      si = si->get_next();

  return si;
}



/*
 *----------------------------------------------------------------------
 *
 * add_style --
 *
 *      This method is invoked to add a new style in the StyleManager.
 *
 * Results:
 *      The created StyleItem is returned.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

StyleItem *
StyleManager::add_style(char *n, StyleItem *b) {
  
  StyleItem *s;

  if( query_style(n) != NULL ) {
    fprintf(stderr, "add_style: style '%s' already exists\n", n);
    return NULL;
  }

  s = new StyleItem();
  s->set_attr(STYLE_NAME, n);

  if( b != NULL ) {

    s->set_attr(STYLE_TOP_MARGIN, (void *)b->get_attr(STYLE_TOP_MARGIN) );
    s->set_attr(STYLE_BOTTOM_MARGIN, (void *)b->get_attr(STYLE_BOTTOM_MARGIN) );
    s->set_attr(STYLE_LEFT_MARGIN, (void *)b->get_attr(STYLE_LEFT_MARGIN) );
    s->set_attr(STYLE_RIGHT_MARGIN, (void *)b->get_attr(STYLE_RIGHT_MARGIN) );

    s->set_attr(STYLE_FONT, (void *)b->get_attr(STYLE_FONT));
    s->set_attr(STYLE_ALIGNMENT, (void *)b->get_attr(STYLE_ALIGNMENT));
    s->set_attr(STYLE_FLINE_MARGIN, (void *)b->get_attr(STYLE_FLINE_MARGIN));
    s->set_attr(STYLE_TAG, (void *)b->get_attr(STYLE_TAG));

    if( b->get_attr(STYLE_NEXT_STYLE) != NULL )
      s->set_attr(STYLE_NEXT_STYLE, (void *)b->get_attr(STYLE_NEXT_STYLE));

  } else {

    s->set_attr(STYLE_TOP_MARGIN, (void *)0);
    s->set_attr(STYLE_BOTTOM_MARGIN, (void *)0);
    s->set_attr(STYLE_LEFT_MARGIN, (void *)0);
    s->set_attr(STYLE_RIGHT_MARGIN, (void *)0);

    s->set_attr(STYLE_ALIGNMENT, (void *)STYLE_ALIGN_LEFT);
    s->set_attr(STYLE_FLINE_MARGIN, (void *)0);
  }
  s->set_next(_list);
  _list = s;
  return s;
}
