/* 
 * cursor.h --
 *
 *      This file contains the declaration of the 'MyCursor' class.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef CURSOR_H
#define CURSOR_H


#include "frame.h"



class MyCursor {

private:

  /*
   * Current position of the cursor
   */
  int _x;
  int _y;

  /* Absolute position of the cursor
   * In fact the true position (x, y) of the cursor
   * is an aproximation of these coordinates
   */
  int _x_abs;
  
  /*
   * Coordinates of the selection
   * This is in fact the position of the end of the
   * selection, and cursor position gives the
   * beginning of the selection
   */
  int _x_select;
  int _y_select;

  /*
   * Height of the cursor
   */
  int _height;


public:

  MyCursor();
  ~MyCursor();

  inline int get_curXpos(void)       { return _x; }
  inline int get_curYpos(void)       { return _y; }
  inline int get_curXabs(void)       { return _x_abs; }
  inline int get_curXsel(void)       { return _x_select; }
  inline int get_curYsel(void)       { return _y_select; }
  inline int get_curHeight(void)     { return _height;   }

  inline void set_curXpos(int x)        { _x = x; }
  inline void set_curYpos(int y)        { _y = y; }
  inline void set_curXabs(int x)        { _x_abs = x; }
  inline void set_curXsel(int xsel)     { _x_select = xsel; }
  inline void set_curYsel(int ysel)     { _y_select = ysel; }
  inline void set_curHeight(int h)      { _height = h;      }

  inline BOOL has_selection(void)   { return (_x_select==0 && _y_select==0) ? FALSE : TRUE; }
  
  void draw_cursor(Frame *, int);
  void clear_cursor(Frame *, int);
};

#endif
