/* 
 * margin.h --
 *
 *      This file contains the declaration and the definitions
 *      of the 'Margin' class.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef MARGIN_H
#define MARGIN_H

#include "globals.h"



class Margin {

private:

  unsigned short tmargin;         /* top margin    */
  unsigned short bmargin;         /* bottom margin */
  unsigned short lmargin;         /* left margin   */
  unsigned short rmargin;         /* right margin  */


public:

  inline Margin()       { tmargin = bmargin = lmargin = rmargin = 0; }

  inline int get_tmargin(void)       const   { return ZOOM(tmargin); }
  inline int get_bmargin(void)       const   { return ZOOM(bmargin); }
  inline int get_lmargin(void)       const   { return ZOOM(lmargin); }
  inline int get_rmargin(void)       const   { return ZOOM(rmargin); }

  inline void set_tmargin(unsigned short m)  { tmargin = UNZOOM(m); }
  inline void set_bmargin(unsigned short m)  { bmargin = UNZOOM(m); }
  inline void set_lmargin(unsigned short m)  { lmargin = UNZOOM(m); }
  inline void set_rmargin(unsigned short m)  { rmargin = UNZOOM(m); }

};


#endif
