/* 
 * marker.h --
 *
 *      This file contains the defines used to turn the output
 *      functions code, easy.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef OUTPUT_H
#define OUTPUT_H

#include <tcl.h>

extern Tcl_Channel channel;


#define OUTC2(s, c)  (Tcl_DStringAppend(&s, (char*)&c, 1))
#define OUTS2(s, m)  (Tcl_DStringAppend(&s, (char *)m, strlen((char *)m)))
#define OUTE2(s, m)  (Tcl_DStringAppendElement(&s, (char *)m))
#define OUTI2(s, d)  {char m[32]; sprintf(m, "%d", (int)d); OUTS2(s, m);}     // Tcl_DStringAppend(&s, (char *)m, strlen((char *)m));}

#define FLUSH(s, b, e)  { if( Tcl_DStringLength(&s) > 0 ) { \
		           OUTS(b);                         \
			   OUTS(OUTS2(s, e));	            \
		           Tcl_DStringSetLength(&s, 0);     \
			 }                                  \
		       }

#define OUTS(m)  (Tcl_Write(channel, (char*)m, strlen((char *)m))) // fprintf(stdout, (char *)m))
#define OUTI(d)  {char m[32]; sprintf(m, "%d", (int)d); OUTS(m);} // fprintf(stdout, "%d", (int)m))



#endif

