/* 
 * thePosition.cc --
 *
 *      This file contains the definitions of the 'ThePosition'
 *      structure fonctions.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "thePosition.h"
#include "shape.h"
#include "isfuncs.h"


static ThePosition tp;
struct ThePosition current;



/*
 *----------------------------------------------------------------------
 *
 * PositionSave --
 *
 *      This function is invoked to saves temporary the current
 *      ThePosition structure (cursor).
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      'tp' stucture is updated.
 *
 *----------------------------------------------------------------------
 */

void
PositionSave(void) {

  tp.doc  = current.doc;
  tp.shape  = current.shape;
  tp.pos  = current.pos;
}



/*
 *----------------------------------------------------------------------
 *
 * PositionSave --
 *
 *      This function is invoked to saves temporary a given ThePosition
 *      structure.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      'tp' stucture is updated.
 *
 *----------------------------------------------------------------------
 */

void
PositionSave(Document *d, Shape *s, int p) {

  tp.doc    = d;
  tp.shape  = s;
  tp.pos    = p;
}



/*
 *----------------------------------------------------------------------
 *
 * PositionRestore --
 *
 *      This function is invoked to restores the saved ThePosition
 *      structure.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
PositionRestore(void) {
  
  current.doc   = tp.doc;
  current.shape = tp.shape;
  current.pos   = tp.pos;
}



/*
 *----------------------------------------------------------------------
 *
 * PositionSet --
 *
 *      This function is invoked to sets the contents of the current
 *      ThePosition structure.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      'current' is updated.
 *
 *----------------------------------------------------------------------
 */

void
PositionSet(Document *d, Shape *s, int p) {

  current.doc  = d;
  current.shape  = s;
  current.pos  = p;
}



/*
 *----------------------------------------------------------------------
 *
 * PositionFind_And_Replace --
 *
 *      This function is invoked to sets the current ThePosition, when
 *      it has been removed and a right ThePosition is needed.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      'cur' is updated.
 *
 *----------------------------------------------------------------------
 */

BOOL
PositionFind_And_Replace(ThePosition &cur) {
  
  Shape *next;
  int where;

  next = (Shape *)cur.shape->get_next_same_container();
  where = 0;

  if( next == NULL || is_first_of_para(current) == FALSE ) {
    if( is_first_of_line(current) == FALSE ) {
      next = (Shape *)cur.shape->get_previous_same_container();
      if( next == NULL )
	return FALSE;
      where = next->get_children_num();
    } else {
      if( next == NULL ) {
	next = (Shape *)cur.shape->get_previous_same_container();
	if( next == NULL )
	  return FALSE;
	where = next->get_children_num();
      }
    }
  }
  PositionSave(current.doc, next, where);
  return TRUE;
}
