/* 
 * word.h --
 *
 *      This file contains the declaration of the 'Word' class.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef WORD_H
#define WORD_H

#include "frame.h"
#include "page.h"


/*
 * The Word class herites from the Frame class.
 */

class Word : public Frame {

private:


public:

  Word();
  ~Word();  

  Container *new_of_same_type(void);

  inline const char *type(void) const      { return "Word"; }

  inline Page *get_page_parent(void)       { return (Page *)get_parent()->get_parent(); }

  void format_frame(ThePosition &);
  void frame_to_xy(int &, int &, int);

  void recompute_size(BOOL = TRUE);
  void draw_frame(int, int);

  void debug(int=0);
};



#endif
