/* 
 * wordSegment.h --
 *
 *      This file contains the declaration of the 'WordSegment' class.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef WORDSEGMENT_H
#define WORDSEGMENT_H

#include "shape.h"


/*
 * WordSegment class derives from Shape class.
 */

class WordSegment : public Shape {

private:


public:

  WordSegment();
  ~WordSegment();  

  Container *new_of_same_type(void);

  inline const char *type(void)         const  { return "WordSegment"; }
  inline const BOOL can_append(void)    const  { return TRUE; }

  void alloc_offset(int);
  void insert_children(Container **, int, int);
  void delete_children(int, int);
  void move_children(int, int, Container *, int);

  void merge_container(Container *);

  void *get_absolute_attr(Attributes *, AttrType) const;
  FontItem *get_ws_font(void);

  void can_fit(ThePosition &);
  void recompute_size(BOOL = TRUE);
  void draw_frame(int, int);

  void frame_to_xy(int &, int &, int);
  Frame *xy_to_frame(int, int, int &);

  void debug(int = 0);

  Container *split_container(int);

  inline char *get_string(void)  const    { return (char *)_children; }

  int output_ascii(void);
  int output_papyrus(void);
  int output_ps(void);
};


#endif
