#
# papyrus-debug.tcl  -- standard debug keyboard input definitions
#
# This file is part of PAPyRUS
#
# Author: Carlos Nunes
# Date:  4/4/96
#



#
# Function : Load_Debug_Keys
# 
# Loads the debug keys for Papyrus.
# This function is invoked at the initialisation of Papyrus,
# but it's only for debugging.
#

proc Load_Debug_Keys {} {

    SetKey "Escape"      { RefreshScreen  }  "Redessine la page courante"
    SetKey "C-Escape"    { Debug tree     }  "Affiche les donnes"
    SetKey "M-Escape"    { Debug keys     }  "Affiche les raccourcis clavier"

    SetKey "F1" { InsertString "ceci est une simple dmonstration " } "Fonction de test"
    # SetKey "C-F2"   { ParaConfigure -fline 100p     }  "Aligne le paragraphe a gauche"
    # SetKey "C-F2"   { ParaConfigure -tag 100 }  "Aligne le paragraphe a gauche"
    # SetKey "C-F2"   { ParaConfigure -margins {10p 10p 30p 30p} }  "Aligne le paragraphe a gauche"
    
    set the_font  { adobe helvetica medium roman   12 Helvetica }
#    SetKey "C-F3"   "ParaConfigure -font {$the_font}" "test"
#    SetKey "C-F2"   { Incr_Left_Margin 10 } "test"

    SetKey "C-F2"   { MoveCursorNextWord } ""
    SetKey "C-F4"   { MoveCursorPreviousWord } ""


#    SetKey "C-F2"   { PapyConfigure -mask true } "test"
#    SetKey "C-F3"   { PapyConfigure -mask false } "test"
#    SetKey "C-F2"   { PapyConfigure -hideimages true } "test"
#    SetKey "C-F3"   { PapyConfigure -hideimages false } "test"

#    SetKey "C-F4"   { PapyQuery mask} "test"
#    SetKey "C-F4"   { DocQuery margins width height} "test"
#    SetKey "C-F5"   { DocConfigure -margins "100p 100p 100p 100p" } "test"
#    SetKey "C-F6"   { DocConfigure -width [expr [DocQuery width] - 20p] } "test"
    SetKey "C-F7"   { DocConfigure -width [expr [DocQuery width] + 20p] } "test"


    SetKey "F2"     { ParaConfigure -align left   }  "Aligne le paragraphe a gauche"
    SetKey "F3"     { ParaConfigure -align right  }  "Aligne le paragraphe a droite"
    SetKey "F4"     { ParaConfigure -align center }  "Centre le paragraphe"
    SetKey "F5"     { ParaConfigure -align full   }  "Justifie le paragraphe"

#    SetKey "F6"     { DocumentOutput stdout papyrus    }  "Genere le document en pap"
#    SetKey "M-F6"   { DocumentOutput stdout ascii      }  "Genere le document en ascii"
#    SetKey "C-F6"   { DocumentOutput stdout postscript }  "Genere le document en postscript"

SetKey "C-F5"   { source ~/Papyrus/doc/Rapport/Perfs/long.tcl }  "Definition"
SetKey "C-F6"   { time {DocumentOutput stdout ascii}    }  "Genere le document en pap"

#    SetKey "C-F1"   { InsertImage ../images/figure.xpm }  "Insere une image"
    SetKey "M-F7"   { Insert_SpecialChar "Q"   }  "Genere le document en ascii"
    SetKey "M-F8"   { WordConfigure -family "Symbol"   }  "Genere le document en ascii"
    SetKey "M-F9"   { WordConfigure -family "Times"   }  "Genere le document en ascii"


SetKey "C-z"    { InsertString "Figure " } ""
SetKey "C-x"    { InsertString "1 " } ""
SetKey "C-c"    { InsertString ": " } ""
SetKey "C-v"    { InsertString "Vic 20" } ""


    SetKey "F7"     { ParaConfigure -style Normal  }  "Force le style du paragraphe a Normal"
    SetKey "F8"     { ParaConfigure -style Titre1  }  "Force le style du paragraphe a Titre1"
    SetKey "F9"     { ParaConfigure -style Titre2  }  "Force le style du paragraphe a Titre2"
    SetKey "F10"    { ParaConfigure -style Titre3  }  "Force le style du paragraphe a Titre3"
    SetKey "F11"    { ParaConfigure -style Listing }  "Force le style du paragraphe a Listing"
    SetKey "F12"    { ParaConfigure -style Liste1  }  "Force le style du paragraphe a Liste"
    SetKey "C-F11"  { ParaConfigure -style Liste2  }  "Force le style du paragraphe a Liste"
    SetKey "C-F12"  { ParaConfigure -style Liste3  }  "Force le style du paragraphe a Liste"

   
    SetKey "KP_1"   { SetZoom 100 }  "Met le facteur de zoom a 100%"
    SetKey "KP_2"   { SetZoom 150 }  "Met le facteur de zoom a 150%"
    SetKey "KP_3"   { SetZoom 200 }  "Met le facteur de zoom a 200%"
    SetKey "KP_4"   { SetZoom 200 }  "Met le facteur de zoom a 200%"
    
    #    SetKey "C-z"      { SetWordAttribute -slant }   "Positionne l'attribut gras"
    #    SetKey "C-x"      { SetWordAttribute -slant }   "Positionne l'attribut gras"
    
    
    # -underline accepts a boolean ie 'yes', '1', true.
    
    SetKey "C-u"      { WordConfigure -underline yes }  "Souligne actif"
    SetKey "C-s"      { WordConfigure -size 18       }  "Taille 18"

    SetKey "C-k"   { Incr_Fline_Margin 10  }           "Add 10 to the first line margin"
    SetKey "C-l"   { Incr_Fline_Margin -10 }          "Sub 10 to the first line margin"

    SetKey "M-g"   { Info_Document }   "Give some informations about the current paragraph"
    SetKey "M-h"   { Info_Paragraph }   "Give some informations about the current paragraph"
    SetKey "M-j"   { Info_Word }   "Give some informations about the current word"



#    SetKey "C-i"    { WordConfigure -style italic  }  "Slant italique"
#    SetKey "C-g"    { WordConfigure -style bold   }  "Weight gras"
#    SetKey "C-m"    { WordConfigure -style normal }  "Weight medium"

    SetKey "C-i"    { Toggle_Italic_Attr   }  "Slant italique"
    SetKey "C-g"    { Toggle_Bold_Attr   }  "Weight gras"
    SetKey "C-m"    { WordConfigure -style normal }  "Weight medium"

}
