proc MoveCursorBeginDocument {} {

    catch MoveCursorBeginLine
    while { [catch MoveCursorUp] == 0 } { }
}



proc Delete_Word {} {

    set len [string length [WordOutput]]

    for {set i 0} {$i < $len} {incr i} {
	DeleteCharacterAfter
    }
}


proc Replace_Word {word} {

    Delete_Word
    NewWord
    InsertString $word
    NewWord
}



proc Save_As {filename} {
    global outputFormat

    #puts $filename

    if [catch {open $filename w} fileId] {
	puts stderr $fileId
    } else {
	DocOutput $fileId $outputFormat
	close $fileId
    }
}


proc Save_As_And_Verify {filename} {
    global outputFormat

    #puts $filename

    if [catch {open $filename r} fileId] {
	if [catch {open $filename w} fileId] {
	    puts stderr $fileId
	} else {
	    #puts "saving..."
	    DocOutput $fileId $outputFormat
	    close $fileId
	}
    } else {
	close $fileId
	puts "$filename existe deja, remplacer ? "
	gets stdin response

	if { $response == "o" || $response == "O" } {
	    if [catch {open $filename w} fileId] {
		puts stderr $fileId
	    } else {
		puts "saving after replacing..."
		DocOutput $fileId $outputFormat
		close $fileId
	    }
	} else {
	    puts "save canceled"
	}
    }
}



proc Toggle_Italic_Attr {} {

    set style [WordQuery style]

    switch $style {
	normal         { set style "italic" }
	italic         { set style "normal" }
	bold           { set style "bold_italic" }
	bold_italic    { set style "bold" }
    }
    WordConfigure -style $style
}



proc Toggle_Bold_Attr {} {

    set style [WordQuery style]

    #puts $style

    switch $style {
	normal         { set style "bold" }
	italic         { set style "bold_italic" }
	bold           { set style "normal" }
	bold_italic    { set style "italic" }
    }
    WordConfigure -style $style
}



proc Add_Zoom_Entry {zoom} {
    
    #
    # Add some code to insert the new entry not at the beginning,
    # to make the list sorted.
    #

    AddEntry zoom [format "%d%%" $zoom] "SetZoom $zoom"
}


proc Add_Family_Entry {family} {
    AddEntry family $family "WordConfigure -family \"$family\""
}



proc Add_Size_Entry {size} {

    #
    # Add some code to insert the new entry not at the beginning,
    # to marke the list sorted.
    #

    AddEntry size $size "WordConfigure -size $size"
}



proc Insert_SpecialChar {char} {

    set font [WordQuery family style]
    WordConfigure -family Symbol -style normal
    InsertCharacter $char
    WordConfigure -family [lindex $font 0] -style [lindex $font 1]
}



proc Toggle_Mask {} {

    set mask [PapyQuery mask]

    if { $mask == "false" } {
	set mask true
    } else {
	set mask false
    }
    PapyConfigure -mask $mask
}



proc Incr_Fline_Margin {plus} {

    set margin [ParaQuery fline]
    
    if { $margin > 0 || $plus > 0 } {
	incr margin $plus
	ParaConfigure -fline $margin
    }
}



proc Incr_Left_Margin {plus} {

    set margin [lindex [ParaQuery margins] 0]
    set lmarg [lindex $margin 2]

    if { $lmarg > 0 || $plus > 0 } {
	incr lmarg $plus
	ParaConfigure -margins [lreplace $margin 2 2 $lmarg]
    }
}



proc Info_Document {} {

    set infos [DocQuery title owner width height margins]

    puts "Document informations: "
    puts -nonewline "  title: " ; puts [lindex $infos 0]
    puts -nonewline "  owner: " ; puts [lindex $infos 1]
    puts -nonewline "  width: " ; puts [lindex $infos 2]
    puts -nonewline "  height: " ; puts [lindex $infos 3]
    puts -nonewline "  margins: " ; puts [lindex $infos 4]
}



proc Info_Paragraph {} {

    set infos [ParaQuery style nstyle align font fline margins tag]

    puts "Paragraph informations: "
    puts -nonewline "  style: " ; puts [lindex $infos 0]
    puts -nonewline "  next style: " ; puts [lindex $infos 1]
    puts -nonewline "  alignment: " ; puts [lindex $infos 2]
    puts -nonewline "  font: " ; puts [lindex $infos 3]
    puts -nonewline "  first line margin: " ; puts [lindex $infos 4]
    puts -nonewline "  margins: " ; puts [lindex $infos 5]
    puts -nonewline "  tag: " ; puts [lindex $infos 6]
}



proc Info_Word {} {

#    set infos [WordQuery weight slant size underline family voffset background foreground]
    set infos [WordQuery style size family]

    puts "Word informations: "
    puts -nonewline "  style: "     ; puts [lindex $infos 0]
    puts -nonewline "  size: "       ; puts [lindex $infos 1]
#    puts -nonewline "  underline: "  ; puts [lindex $infos 3]
    puts -nonewline "  family: "     ; puts [lindex $infos 2]
#    puts -nonewline "  voffset: "    ; puts [lindex $infos 5]
#    puts -nonewline "  background: " ; puts [lindex $infos 6]
#    puts -nonewline "  foreground: " ; puts [lindex $infos 7]

     puts -nonewline "  contenu: " ; puts [WordOutput stdout]
}



