proc Ispell_Open {dicts} {
    global fd

    set name [concat "|ispell -a -d" $dicts]
    set fd [open $name r+]
    # skips the message line
    gets $fd result    
}


proc Ispell_Close {} {
    global fd
    
    catch close $fd
}



proc Ispell_Buffer {} {
    global fd

    while { 1 } {

	set str [WordOutput]
	
	if { [regexp {^[!~@#%&*-]} $str] == 0 } {
	    puts $fd $str
	    flush $fd
	    
	    gets $fd result
	    
	    if { [string length $result] > 0 } {
		
		# flush the outup of ispell because it inserts a '\n'
		gets $fd
		
		set label [lindex $result 0]
		
		if { $label == "#" } {
		    return $result
		}
		if { $label == "&" } {
		    return $result
		}
	    }
	}
	if [ catch { MoveCursorNextWord } ] {
	    Ispell_Close
	    return "*"
	}
    }
}



proc Ispell_Document {} {

    # go to the beginning of the document
    catch MoveCursorBeginLine
    while { [catch MoveCursorUp] == 0 } { }

    # start the ispell process
    Ispell_Open "francais"

    # start the spelling of the document
    return [Ispell_Buffer]
}



proc Ispell_Ignore {} {
 
    if { [catch MoveCursorNextWord] == 0 } {
	return [Ispell_Buffer]
    }
    Ispell_Close
    return "*"
}
