/* 
 * commands.h --
 *
 *      This file contains the declaration of the PAPyRUS commands.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef COMMANDS_H
#define COMMANDS_H

#include <tcl.h>


int AddEntry_Cmd(ClientData, Tcl_Interp *, int, char **);
int AddFont_Cmd(ClientData, Tcl_Interp *, int, char **);
int AddStyle_Cmd(ClientData, Tcl_Interp *, int, char **);

int Debug_Cmd(ClientData, Tcl_Interp *, int, char **);

int DeleteCharacterAfter_Cmd(ClientData, Tcl_Interp *, int, char **);
int DeleteCharacterBefore_Cmd(ClientData, Tcl_Interp *, int, char **);

int DocumentConfigure_Cmd(ClientData, Tcl_Interp *, int, char **);
int DocumentQuery_Cmd(ClientData, Tcl_Interp *, int, char **);
int DocumentOutput_Cmd(ClientData, Tcl_Interp *, int, char **);

int InsertCharacter_Cmd(ClientData, Tcl_Interp *, int, char **);
int InsertImage_Cmd(ClientData, Tcl_Interp *, int, char **);
int InsertString_Cmd(ClientData, Tcl_Interp *, int, char **);

int MoveCursorLeft_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorRight_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorDown_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorUp_Cmd(ClientData, Tcl_Interp *, int, char **);

int MoveCursorNextWord_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorPreviousWord_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorBeginLine_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorEndLine_Cmd(ClientData, Tcl_Interp *, int, char **);
int MoveCursorXY_Cmd(ClientData, Tcl_Interp *, int, char **);

int NewDocument_Cmd(ClientData, Tcl_Interp *, int, char **);
int NewParagraph_Cmd(ClientData, Tcl_Interp *, int, char **);
int NewWord_Cmd(ClientData, Tcl_Interp *, int, char **);

int CloseDocument_Cmd(ClientData, Tcl_Interp *, int, char **);

int PapyrusConfigure_Cmd(ClientData, Tcl_Interp *, int, char **);
int PapyrusQuery_Cmd(ClientData, Tcl_Interp *, int, char **);

int ParagraphConfigure_Cmd(ClientData, Tcl_Interp *, int, char **);
int ParagraphQuery_Cmd(ClientData, Tcl_Interp *, int, char **);

int RefreshScreen_Cmd(ClientData, Tcl_Interp *, int, char **);

int SelectRegion_Cmd(ClientData, Tcl_Interp *, int, char **);
int SetZoom_Cmd(ClientData, Tcl_Interp *, int, char **);
int SetKey_Cmd(ClientData, Tcl_Interp *, int, char **);
int SetCursor_Cmd(ClientData, Tcl_Interp *, int, char **);

int WordConfigure_Cmd(ClientData, Tcl_Interp *, int, char **);
int WordQuery_Cmd(ClientData, Tcl_Interp *, int, char **);
int WordOutput_Cmd(ClientData, Tcl_Interp *, int, char **);


#endif
