/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


/* generall defs for all versions of tmview */
/* these are be #included by "src/defs.h"   */

#define MYVERSION "V00.05"

/*
***************************************************************************
general start up defaults 
***************************************************************************
*/


/* set the default resulution in dpi (option -r) */
#define XRES      300      
#define YRES      300


/* set the default papersize in mm (option -p)*/
#define PAPXMM    210.0     
#define PAPYMM    297.0

/* define default printable area  (option -k) */
#define LRANDMM 4.0         
#define RRANDMM 4.0	    
#define ORANDMM 4.0			
#define URANDMM 12.0


/* location of the top left corner from */
/* the dvifile on the page (options -h -v)*/
#define HOFFMM 25.4 
#define VOFFMM 25.4	



/* shrinkfactor corresponds to 1/zoomfactor */
/* so the following allows a zooming range from 0.05 to 2 */
#define MAXSHRINK 20.0
#define MINSHRINK 0.5

/* startup with zoomfactor 0.33 */
#define SHRINK 3.0
/* startup in the fast zooming mode, only integer-shrinkfactors */
#define ISHRINKONLY 1      
/* startup in the slow zooming mode, arbitrary shrinkfactors */
/* #define ISHRINKONLY 0      */

/* startup with 10% movement on cursor keys */
#define PMOVEOFF 10.   /* its a float ! */

/* startup with +/-18.92% zooming on <+>/<-> keys */
#define PZOOMFINE 18.92   /* its a float ! */


/* startup in the stay-where-you-are-page-moving-mode */
#define PAGEMOVETOP 0          
/* startup in the do-a-center-after-page-moving-mode */
/* #define PAGEMOVETOP 1 */          

/* startup in the scroll-over-pages-mode */
#define MOVEOVERPAGES 1           
/* startup in the dont-scroll-over-pages-mode */
/* #define MOVEOVERPAGES 0 */          
         

#define FINE 1.4142          /* faktor used with <f> and <c> */
#define PCOLORS GREYSCALE    /* startup with greyscales */
/* #define PCOLORS GREYSCALE /* startup with blacknwhite */
#define PDOEPS DOEPS         /* startup with eps enabled */
/* #define PDOEPS DONTEPS    /* startup with eps disabled */


#define VERBOSE 0         /* do not be verbose */
#define SAVESTARTUP 0     /* dont save startup values */

/* set the default unit of measurement. you may change this, see <t> */
/* UNIT has to be an integer between 0 and 7, defining: 
/* 0 -> MM, 1 -> CM, and so on ... IN, BP, PT, PC, CC, ... 7 -> DD   */
#define UNIT 0            /* set default unit to MM   */

/* set default double-page-mode: 0->off, 1->auto, 2->on */
#define PPAGEMODE 1

#define MARKON 0          /* dont show up with marks on */
#define HYPON 0           /* when MARKON is 1, HYPON 1 sets it to halfhyper */

#define MARKSIZE 30       /* size of neat square marks */



/*
***************************************************************************
  dvi-pk-etc.-file related defsinitions
***************************************************************************
*/



#define SMAX       300  /* dvi stack size: inc. vf and vf in vf */
#define MAXFONTS   256  /* max number of different fonts   */
#define VFMAXFONTS  50  /* max number of fonts within a vf */
#define MAXCHARS   256  /* max number chars in a font. DONT CHANGE! */


/* 
   for reasons of lazy programing the maximum stringlength of pathnames is
   restricted. this contains any recursivly searched paths. So if you set the
   searchpath for files to the (stupid ?) value of "//", you have to set
   MAXPATHSTR to the length of the longest path on your system.
*/
#define MAXPATHSTR 300

/*
   (not lazy but) because of safty the recursionlevel of recursiv path 
   searchin is limited to. While the total number of subdirectories between
   all "//" within a searchstring might be imense, only up to MAXPATHDEP
   will be scanned. 
*/
#define MAXPATHDEP 10

/* 
   To speed things up a little, tmview keeps (1) drawing commands expanded
   from the dvi-file (2) glyphs from pk-files and (3) rendered eps-images 
   within an LRU buffer. The follwing macros define upper limits to this
   buffer. Note that glyhs or rendered eps-images will only be drawn if they
   fit in the buffer. Similar limitations hold on pages with an extensive
   use of rules like epic figures. As only the actually required amount of 
   buffermemory will be allocated, hight limits dont hurt. However, it makes 
   not much sense to keep your machine swapping by some stupid buffer. On an
   old fasioned 4Mb laptop use about 1Mb as tmview's buffer ... and disable
   eps rendering or at least greyscaling when eps rendering. 

   Example: using 300dpi pk-font-files at the giant size of 21x28cm (600x800pt)
   result in a maximum buffersize of 8,200,000 pixels. With greyscaling enabled
   this results in up to 4Mb per character, depending on the actual zooming. 
   Restricting the maximum glyph size to 7.5x10cm gives a limit of 1Mb.
   Example: eps-files are rendered at (res*shrink)dpi, where res is the resolution
   and shrink is the inverse of the zoom factor (if greyscaling is enabled, multiply
   by GSGREY^2). Thus, a 21x28cm image at 300dpi zoomed at 0.333 requires appx. 
   100Kb (or 400Kb if greyscaling at GSGREY=2).
   Example: A rule requires appx 20 bytes in the buffer. An extensive epic-drawing
   with 10000 rules comes up to appx. 200Kb buffer memory.

   MAXLRUPOOL:     upper limit for over all buffer in unit Mb
   MAXLINMEMFRAC:  upper limit for buffering a sinle glygh as fraction of MAXLRUPOOL

   NOTE: the compiletime default may be overwriten by the startup-file parameter "lrum"
                        
*/

#ifndef LETSTRYGS
#define MAXLRUPOOL (1.5)          /* 1.5 Mb: handle reasonable complex dvi/pk */
#else
#define MAXLRUPOOL (1.5*GSGREY*GSGREY)     /* 6Mb: handle reasonable size eps */
#endif
#define MAXLINMEMFRAC (0.25)   /* max 25% by individual objects, don't change */


/*
use GAMMA to darken or lighten the displayed glyphs 
GAMMA \in(0,\infty), larger GAMMA -> darker drawings 
set GAMMA to 1 for neutral greyscales. 
Note: this is just "similar to" a gammacorrection
*/
#define GAMMA 1.3   



/*
***************************************************************************
  bitmaps 
***************************************************************************
*/


#ifdef	BMLONG
#define	BMUNIT			unsigned long
#define	BITS_PER_BMUNIT		32
#define BITS_LOG2               5
#define	BYTES_PER_BMUNIT	4
#endif
#ifdef	BMSHORT
#define	BMUNIT			unsigned short
#define	BITS_PER_BMUNIT		16
#define BITS_LOG2               4
#define	BYTES_PER_BMUNIT	2
#endif
#ifdef BMCHAR
#define BMUNIT                  unsigned char
#define	BITS_PER_BMUNIT		8
#define BITS_LOG2               3
#define	BYTES_PER_BMUNIT	1
#endif


#define BLACKNWHITE 1             /* number of bits per pixel in blacknwhite */


#define BITS_PER_GREY 4           /* must be a divisor of BITS_PER_BMUNIT */
#define BITS_PER_GREY_LOG2 2      


#ifdef GREYINBMU
#define GREYSCALE BITS_PER_BMUNIT /* number of bits per pixel in greymodus */
#define GREYSCALE_LOG2 BITS_LOG2
#else
#define GREYSCALE BITS_PER_GREY
#define GREYSCALE_LOG2 BITS_PER_GREY_LOG2
#endif




/*
***************************************************************************
 more or less private stuff: types, shortcuts ... better don't touch 
***************************************************************************
*/


#define uchar unsigned char
#define ushort unsigned short
#define uint unsigned int
#define ulong unsigned long
#define ptr void *


#ifdef DOSFILES
#define DIRSEPSTR "\\"
#define DIRSEPCHAR '\\'
#else
#define DIRSEPSTR "/"
#define DIRSEPCHAR '/'
#endif


#define	SUB(a, b)	((BMUNIT *) (((char *) a) - b))
#define MIN(a, b)	((a)<(b)?(a):(b))
#define MAX(a, b)	((a)>(b)?(a):(b))

#define MMTOPXL(a) ((long) floor(xres*(a)/25.4/fshrink + 0.5))
#define PXLTOMM(a) ((float)((a)*25.4/xres*fshrink))
#define PZTOPXL(pz) ((int) floor(MAX(0,MIN(vgaxdim-1,(pz)/100.0*vgaxdim+0.5))))
#define PXLTOPZ(pxl) ((float)(MAX(0,MIN(100,(pxl)*100.0/vgaxdim))))

#define INSIDEPXL (0.05* MIN(vgaxdim,vgaydim)) 


#define STRCASECMP(a,b) strcasecmp(a,b)
#define STRNCASECMP(a,b,c) strncasecmp(a,b,c)


#define CEIL(a) (ceil(a))
#define FLOOR(a) (floor(a))
#define ROUND(a) ( ((a)>=0 ? floor(a+0.5) : ceil(a-0.5)) )

#define LCEIL(a) ((long)(ceil(a)))
#define LFLOOR(a) ((long)(floor(a)))
#define LROUND(a) ( (long)((a)>=0 ? floor(a+0.5) : ceil(a-0.5)) )

#define ROUNDUP(x,y) (((x)+(y)-1)/(y))
#define	ADD(a, b)	((BMUNIT *) (((char *) a) + b))



typedef struct bitmap {
	short w, h;		/* width and height in pixels */
	short bmu_wide;  	/* scan-line width in BMUNIT  */
	BMUNIT *bits;		/* pointer to the bits */
        char type;              /* number of bits per pixel */
} bitmap;

typedef struct chdesc { 
   /* general inf*/ char fty; uchar ch; int fontdataptr; 
   /* pk  section*/ short hof, vof;  bitmap bmp;  long tfw, addr; uchar flag; 
   /* pk shrunken*/ short hof2,vof2; bitmap bmp2; float shrink;
   /* tfm section*/ long  tfmtfh, tfmtfw, tfmtfd;
   /* vf  section*/ long mlen; uchar* macro;
} chdesc;

#define PKTYPE 1
#define TFMTYPE 2
#define VFTYPE 4

typedef struct fontdescvect {
  long dfn;             /* font number within dvi (or vf) */
  int fontdataptr;      /* index to fontdatabase          */
} fontdescvect;

typedef struct fontdesc {
  chdesc *chv;             /* array of chdesc          */
  short mch;               /* length of chv            */
  char* fonam;             /* font id: name            */
  char* fopath;            /* .......  path            */
  long  fodvimag;          /* .......  load at mag     */
  long  foscf;             /* .......          scf     */
  long  fodsz;             /* .......          dsz     */
  char* pkfile;            /* pointer to pkfile-name   */
  char* vffile;            /* pointer to vffile-name   */
  char (* encoding)[5];    /* pointer to encoding      */
  fontdescvect *vffontvect;/* index of fonts within vf */
  long  vffirst;           /* default vf fontnr        */
  short usecount;          /* how often used           */
} fontdesc;

#define FD(a) (fontdatabase+a)


#define B_OK         0 /* ok, bmp valid */
#define B_SUSPECT    1 /* must be & allocated & rendered  */
#define B_ESCAPE     2 /* shall be ignored in furure */
#define B_SKIPONCE   3 /* shall be ignored once  */

typedef struct gslistelement {
   char* gsfile;  /* full file name */
   char* argfile; /* short file name as in special */
   float res;     /* required gs-reolution w.r.t. shrink factor */
   char* code;    /* gs-code to execute, e.g. scaling */
   int suspect;   /* 0 <=> ok, bmp valid */
   bitmap bmp;    /* B&W source from gs */ 
   bitmap bmp2;   /* greyscaled, destination size */
   void* nextgse; /* list */
} gslistelement;


typedef union drawlistdata { 
  struct { int h; int v; chdesc* chdp; } chr;
  struct { int h; int v; gslistelement* gse; } gscript;
  struct { int x; int y; int w; int h; uchar c; } rect;
} drawlistdata;

typedef void (selfdrawfunction)(drawlistdata*);

typedef struct drawlistelement {
  selfdrawfunction *drawmyself;
  union drawlistdata data; 
} drawlistelement; 


typedef struct {
	int type;   /* Type of anchor: URL, etc from WWW anchor list */
	char *name; /* Name string for anchor (Null by default) */
	char *href; /* A reference from this anchor */
	long llx, lly, urx, ury;         /* Box on page where anchor located */
	long x1pxl, y1pxl, x2pxl, y2pxl; /* Box on page where anchor located */
} HTeX_Anchor;


#define NOTDONE 0
#define DOING 1
#define DONE 2

#define HTeX_A_NAME 1
#define HTeX_A_HREF 2

typedef struct pagelistelement {
  int num;          /* number of page */ 
  long addr;        /* address in dvi-file */
  long count[10];   /* tex counters */
  drawlistelement* drawlist; /* drawlist */
  long ndraws;       /* number of drawlistelements */
  long maxdraws;     /* maximal number of drawlistelements */
  float fshr;       /* float shrink used for drawlist */
  int col;          /* colors used for drawlist */
  int dps;          /* did or didi no eps when setting up drawlist */
  int xoffset;      /* offset w.r.t. top left corner of screen */
  int yoffset;
  HTeX_Anchor* anchorlist; /* list of anchors on this page */
  int nanchors;     /* number of anchors in list */
  int maxanchors;   /* maximal number of anchors in list */
  int anchorsdone;  /* !=0 >> page parsed allready */
} pagelistelement;

typedef struct {
        char *dvifilename;
        int name;	
        int pagenum; 
	int dvixpos, dviypos;
        uchar ppagemode;
        float fshrink;
        int marksxpxl, marksypxl; 
} bookmark;

typedef struct {
  bookmark** d;
  int n;
} bookmarklist;

typedef struct {
        char *dvifilename;
        float papxmm, papymm, voffmm, hoffmm;
        float centerxmm, centerymm;
        float lrandmm, rrandmm, orandmm, urandmm;
        bookmark lastpos;
        bookmarklist bookmks;
} filemark;

#define MAXMKS 1000   /* must be addressable by int */
#define FILETYP 1
#define MANTYP 2

#define PGMAGIC 42.42e42


#define KEYNOP    128  
#define KEYNEXT   KEYNOP+1
#define KEYPREV   KEYNOP+2
#define KEYUP     KEYNOP+3
#define KEYDOWN   KEYNOP+4
#define KEYRIGHT  KEYNOP+5
#define KEYLEFT   KEYNOP+6
#define KEYCENTER KEYNOP+7
#define KEYFIRST  KEYNOP+8
#define KEYLAST   KEYNOP+9
#define KEYHOME   KEYNOP+10
#define KEYEND    KEYNOP+11
#define KEYESC    KEYNOP+12
#define KEYRET    KEYNOP+13
#define KEYRESIZE KEYNOP+14
#define KEYTAB    KEYNOP+15
#define KEYMOUSE  KEYNOP+16  /* dummy */


#define VGAXDIMMIN 320
#define VGAYDIMMIN 200

#define MAXARGSTR 80


#define COMDO 0
#define COMDEF 1

#define STATUSTYPES 2

#define DOEPS 1
#define DONTEPS 0


#ifdef HASWINDOWS
#define TRACKBALL 0
#endif
#ifndef TRACKBALL
#define TRACKBALL 0
#endif

/*
***************************************************************************
 include all headers
***************************************************************************
*/


#include "globals.h"
#include "writedis.h"
#include "subs.h"
#include "regex.h"
#include "readdvi.h"
#include "readtfm.h"
#include "readpk.h"
#include "readvf.h"
#include "epsfile.h"
#include "halfhyp.h"
#include "bookmks.h"
#include "drawit.h"
#include "rwconf.h"


#ifdef KPATHSEA
#include <kpathsea/magstep.h>
#include <kpathsea/tex-glyph.h>
#include <kpathsea/tex-file.h>
#include <kpathsea/proginit.h>
#include <kpathsea/progname.h>
#endif

