Summary: Advanced conversion of PostScript files into bitmap images
Name: ps2img
Version: 0.1.0
Release: 1
Copyright: Freely Distributable
Group: Applications/Publishing
Source: ps2img-%{version}.tar.gz
Requires: ghostscript, libpng, libungif
URL: none
BuildRoot: /tmp/rpm-build-ps2img
Prefix: /usr

%description
ps2img is a handy tool for converting PostScript files into bitmap images
(PNG or GIF format). ps2img does autocrop (limits image just to the valuable
pixels, stripping unused lines at top/bottom/left/right), antialiasing (for
getting high-quality images), per-pixel alpha (when saving in PNG format),
single-color transparency (for both GIF and PNG formats), applying a
different background color, multiple output formats (truecolor, 8-bit
(256 colors) and 4-bit (16 colors) paletted, 8-bit (256 levels) and 4-bit
(16 levels) grayscale, monochrome.

Handy as an add-on tool for latex2html translator.

%prep
%setup

%build
make all

%install
mkdir -p "$RPM_BUILD_ROOT"
mkdir -p "$RPM_BUILD_ROOT"/usr/bin
mkdir -p "$RPM_BUILD_ROOT"/usr/man/man1
DOC="$RPM_BUILD_ROOT"/usr/share/doc/ps2img-%{version}
mkdir -p "$DOC"
make prefix="$RPM_BUILD_ROOT"/usr install
gzip -9 "$RPM_BUILD_ROOT"/usr/man/man1/*
cp README COPYING.GPL COPYING.LGPL "$DOC"

%clean
rm -rf "$RPM_BUILD_ROOT"

%files
%attr(-,root,root)	/usr/bin/ps2img
%attr(-,root,root) %doc /usr/man/man1/ps2img.1.gz
