#ifndef __Lists_h
#define __Lists_h

#ifndef __Common_H_INCLUDED
  #include <common.h>
#endif


#define ListsId   0x300
#define Bad_Number  0x1
#define Bad_Size    0x2
#define Bad_Item    0x3
#define Unsorted    0x4


#ifndef IN
 #define IN %
#endif

typedef int (*TSorter)(const char *s1,const char *s2);
void Qsort(TSorter sorter, char **item, int d, int h);

extern "C++" {

class sortedlist;

// Main definition part of Class String
class list {
	   char **pstr;
	   int number;
	   int numalloc;
	   char flag;
//	   void resize(int NewMaxlen);
//	   list(int len);

   public: list(void) {numalloc=number=0;pstr=NULL;flag=0;};
	   list(const list &l);
	   list(const char *str);
	   list(char **data,int count) {numalloc=0;number=count;pstr=data;flag=1;};
	   ~list(void)				        {erase(*this);};

           list &operator=(const char *str);
	   list &operator=(const list &l);

	   inline char *operator[](const int i) const {if(i>=number) return(NULL); return(pstr[i]);}
	   int operator IN(const char *) const;

	   int operator==(const list &l) const;
	   int operator!=(const list &l) const		{return(!(*this==l));}

	   int operator+=(const char *str);

	   void sort(TSorter sorter) {Qsort(sorter,pstr,0,number-1);};


/* friend functions */
	   friend int operator IN(const char *str,const list &l);
	   friend int operator IN(const char *str,const sortedlist &l);
	   friend int length(const list &l) {return(l.number);}
	   friend int AddNewSTR(list & l,TSorter sorter, const char *str);
	   friend int InsertNewSTR(list & l, char *str);
	   friend int RemoveDups(sortedlist & l);

           friend void erase(list &l);
           friend int sync(list &l);

	   };


class sortedlist:public list {
	   TSorter sorter;

public:	   sortedlist(void) {sorter=NULL;};
	   sortedlist(const list &l):list(l) {sorter=NULL;};
	   sortedlist(const char *str):list(str) {sorter=NULL;};
	   sortedlist(TSorter NewSorter) {sorter=NewSorter;};

	   void AddSorter(TSorter NewSorter) {sorter=NewSorter;};


	   sortedlist &operator=(const list &l) {*(list*)this=l;if(sorter!=NULL) sort(sorter); return(*this);};
	   sortedlist &operator=(const sortedlist &l) {*(list*)this=l;if(sorter!=NULL && l.sorter!=sorter) sort(sorter); return(*this);};


	   int operator+=(const char *str)  {return(AddNewSTR(*this,sorter,str));};

/* friend functions */
	   friend int operator IN(const char *str,const sortedlist &l);
	   };




//Related functions to the class list

} // extern "C++"

#endif
