#include <strings.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char string::Dummy=0;

//This function fixes error in finding substring in NULL string
#ifdef __Strict_Const_Procs
const char *StrStr(const char *str1,const char *str2)
{
 if((str1==NULL)||(str2==NULL)) return(NULL);
 return(strstr(str1,str2));
}

char *StrStr(char *str1,char *str2)
{
 if((str1==NULL)||(str2==NULL)) return(NULL);
 return(strstr(str1,str2));
}

const char *StrStr(const char *str1,const string & s2)
{
 if((str1==NULL)||(length(s2)==0)) return(NULL);
 return(strstr(str1,s2()));
}
#else
char *StrStr(const char *str1,const char *str2)
{
 if((str1==NULL)||(str2==NULL)) return(NULL);
 return(strstr(str1,str2));
}

char *StrStr(const char *str1,const string & s2)
{
 if((str1==NULL)||(length(s2)==0)) return(NULL);
 return(strstr(str1,s2()));
}
#endif


//This function fixes up the error in comparing two NULL string
int StrCmp(const char *str1,const char *str2)
{
if(str1==NULL)
           {
           if(str2==NULL) return(0);
           if(*str2==0) return(0);
           return(-1);
           }
if(str2==NULL) return(1);
return(strcmp(str1,str2));
}

//This function fixes up the error in measuring a length of the NULL string
size_t StrLen(const char *str)
{
 if(str==NULL) return(0);
 return(strlen(str));
}

//This function compares one char with string
int ChStrCmp(char c, const string & s)  //-1  c<s  0 c==s  1 c>s
{
 if(s.ch==NULL)
	{
	if(c==0) return(0);
	return(1);
	}
 if(c>*s.ch) return(1);
 if(c<*s.ch || s.size>1) return(-1);
 return(0);
}


//Constructors Of string class
//string::string(void)
//{
// ch=NULL;
// size=maxlen=0;
//}

string::string(char c)
{
 if((ch=(char *)malloc(2))==NULL)
 	{
        maxlen=size=0;
        return;
	}
 maxlen=size=1;
 *ch=c;
 ch[1]=0;
}

string::string(int len)
{
 maxlen=len;
 if( (ch=(char *)malloc(len+1))==NULL ) maxlen=0;
				   else *ch=0;
 size=0;
}

string::string(const char *str)
{
 if(str==NULL)
            {
FastExit:   ch=NULL;
FastExit2:  size=maxlen=0;
            return;
            }
 if((size=StrLen(str))==0) goto FastExit;

 if((ch=(char *)malloc(size+1))==NULL)
              {
//            error(Memory Exhausted);
              goto FastExit2;
              }

 maxlen=size;
 strncpy(ch,str,maxlen+1);
}


string::string(const string &s)
{
 if(s.size==0)
 	{
        ch=NULL;
        goto FastExit;
        }

 if((ch=(char *)malloc(s.size+1))==NULL)
 	 {
FastExit:size=maxlen=0;
         return;
         }

 maxlen=size=s.size;
 strncpy(ch,s.ch,maxlen+1);
}

string::string(const char *str,int i)
{
 if((ch=(char *)malloc(i+1))==NULL)
 	{
        size=maxlen=0;
        return;
        }
 maxlen=i;
 ch[i]=0;
 strncpy(ch,str,i);
 size=strlen(ch);
}


void string::resize(int NewMaxLen)
{
 if(maxlen>=NewMaxLen) return;
 if(ch!=NULL)
 	{
        if(maxlen>0) {
		      ch=(char *)realloc(ch,NewMaxLen+1);
		      maxlen=NewMaxLen;
		      }
		 else {
		      if(size>0) ;//halt(1); //nevlastni retezce zatim neumim
			   else { //strange string has only 1 allocated byte for 0
				free(ch);
				ch=NULL;
				}
		      }
	}
 if(ch==NULL)
	{
	ch=(char *)malloc(NewMaxLen+1);
	maxlen=NewMaxLen;
	if(ch!=NULL) *ch=0;
	}
 if(ch==NULL) {
	      size=maxlen=0;
//	      if(NewMaxLen>0) halt(1); //memory exhausted
	      }
 return;
}



//Destructor Of class string
//string::~string(void)
//{
// if(ch!=NULL)
//   if (maxlen>0)||(len==0) free(ch);
// ch=NULL;
// size=maxlen=0;
//}

//Oparator for filling char
string &string::operator=(char c)
{
if(c==0)
      {
      if(ch!=NULL) *ch=0;
      size=0;
      return(*this);
      }

if(maxlen<1)
	{
	if(maxlen!=0) free(ch);
	ch=(char *)malloc(2);
	maxlen=1;
	}

if(ch!=NULL)
   {
   size=1;
   ch[0]=c;
   ch[1]=0;
   }
else maxlen=size=0;

return(*this);
}



//Oparator for filling string
string &string::operator=(const char *str)
{
int len;

if((len=StrLen(str))==0)
        {
        if(maxlen>0) *ch=0;
        size=0;
        return(*this);
        }
if(len>=maxlen) {
		if(maxlen!=0) free(ch);
		ch=(char *)malloc(len+1);
		maxlen=len;
		}
size=len;
if(ch!=NULL) strcpy(ch,str);

return(*this);
}

string &string::operator=(const string & s)
{
if(s.ch==NULL)
	{
        if(maxlen>0) *ch=0;
        size=0;
	return(*this);
	}
if(s.ch==ch) return(*this); //same pointers

if(s.size>maxlen) {
		   if(maxlen!=0) free(ch);
		   ch=(char *)malloc(s.size+1);
		   maxlen=s.size;
		   }
size=s.size;
if(ch!=NULL) strcpy(ch,s.ch);

return(*this);
}

//Receiving one character from String
//inline char string::operator[](const int i) const
//{
// if(i>=size) return(0);
// return(ch[i]);
//}

//Looking for substring in the String
//char *string::operator IN(const string &s) const
//{
// if(s.ch==NULL) return(NULL);
// return(strstr(s.ch, ch));
//}


//--- family of     Addind Strings   -------
string operator+(const string & s1, const string & s2)
{
if(s2.size==0) return(s1);

string tmp(s1.size+s2.size);
if(tmp.ch==NULL) return(tmp);	//no memory

memcpy(tmp.ch,s1.ch,s1.size);
memcpy(tmp.ch+s1.size,s2.ch,s2.size+1);
tmp.size=tmp.maxlen;
return(tmp);
}

string operator+(const string & s1, const char *str)
{
int len;
if(str==NULL) return(s1);

len=StrLen(str);
string tmp(s1.size+len);
if(tmp.ch==NULL) return(tmp);	//no memory

if(s1.size>0) memcpy(tmp.ch,s1.ch,s1.size);
memcpy(tmp.ch+s1.size,str,len+1);
tmp.size=tmp.maxlen;
return(tmp);
}

string operator+ (const char *str, const string & s2)
{
int len;
 if(str==NULL) return(s2);

 len=StrLen(str);
 string tmp(s2.size+len);
 if(tmp.ch==NULL) return(tmp);	//no memory

 memcpy(tmp.ch,str,len+1);
 if(s2.size>0) memcpy(tmp.ch+len,s2.ch,s2.size+1);
 tmp.size=tmp.maxlen;
 return(tmp);
}

string operator+ (const string & s, char c)
{
 if(length(s)==0) return(string(c));

 string tmp(s.size+1);
 if(tmp.ch==NULL) return(tmp);	//no memory

 memcpy(tmp.ch,s.ch,s.size);
 tmp.ch[s.size]=c;
 tmp.ch[s.size+1]=0;
 tmp.size=tmp.maxlen;
 return(tmp);
}

string operator+ (char c, const string & s)
{
 if(length(s)==0) return(string(c));

 string tmp(s.size+1);
 if(tmp.ch==NULL) return(tmp);	//no memory

 tmp.ch[0]=c;
 tmp.ch[1]=0;
 memcpy(tmp.ch+1,s.ch,s.size+1);
 tmp.size=tmp.maxlen;
 return(tmp);
}


string & append(string & s1, const char *str)
{
if(str!=NULL)
  {
  int StrSize=StrLen(str);
  s1.resize(s1.size+StrSize);
  if(s1.ch!=NULL)
	{
	strcat(s1.ch,str);
        s1.size+=StrSize;
	}
  }
return(s1);
}

string & append(string & s1, const string & s2)
{
if(s2.size>0)
  {
  s1.resize(s1.size+s2.size);
  if(s1.ch!=NULL)
	{
	memmove(s1.ch+s1.size,s2.ch,s2.size+1);
        s1.size+=s2.size;
        }
  }
return(s1);
}


string & append(string & s1, char c)
{
if(c!=0)
  {
  if(s1.size+1>s1.maxlen)
	{
	s1.resize(s1.size+1);
	}
  if(s1.ch!=NULL)
	{
	s1.ch[s1.size]=c;
	s1.ch[++s1.size]=0;
	}
  }
return(s1);
}

string operator*(const string& s, unsigned n)
{
 string tmp((int)n*length(s));
 if(tmp.ch==NULL) return(tmp);	//memory exhausted

 while(n-->0)
	tmp += s;
 return tmp;
}


//-----   Miscelaneous functions -----
void string::erase(void)
{
 if(ch!=NULL)
   if ((maxlen>0)||(size==0)) free(ch);
 ch=NULL;
 size=maxlen=0;
}


//this procedure check consistency of the variable string
int sync(string & s)
{
int ret=0;
char c;
int Length;

if(s.ch==NULL)
	{
        if(s.size!=0)   ret=StringsId | Bad_Length;
        if(s.maxlen!=0) ret=StringsId | Bad_MaxLen;
        s.size=s.maxlen=0;
        return(ret);
        }

if(s.size>s.maxlen)
	{
        ret=StringsId | Wrong_String;
	s.size=s.maxlen;
        }

c=s.ch[s.maxlen];
Length=s.size;

s.ch[s.maxlen]=0;
if((s.size=StrLen(s.ch))!=Length) ret=StringsId | Bad_Length;
if((c!=0)&&(s.size==s.maxlen))
	ret=StringsId | Unterminated;
return(ret);
}


////////////////////////////////////////////////////////////////
//Related procedures for class String

string & string::ToUpper(void)
{
int i;

if(ch!=NULL)
  for(i=0;i<size;i++)
	{
	ch[i] = toupper(ch[i]);
	}
return(*this);
}

string ToUpper(const char *str)
{
int i;
string s(str);

for(i=0;i<length(s);i++)
	{
	s()[i] = toupper(s()[i]);
	}
return(s);
}

string & string::ToLower(void)
{
int i;

if(ch!=NULL)
  for(i=0;i<size;i++)
	{
	ch[i] = tolower(ch[i]);
	}
return(*this);
}

string ToLower(const char *str)
{
int i;
string s(str);

for(i=0;i<length(s);i++)
	{
	s()[i] = tolower(s()[i]);
	}
return(s);
}



string copy(const string &s,int from, int len)
{
if((from>length(s))||(len<=0)||(from<0)||(length(s)==0))
	{
	string tmp;
	return(tmp);
	}

string tmp(s()+from,len);
return(tmp);
}


string del(const string &s,int from, int len)
{
if(length(s)<from+len) len=length(s)-from;

if((from>=length(s))||(len<0)||(from<0)||(length(s)==0))
	{
	string tmp;
	return(tmp);
	}

string tmp(length(s)-len);
memmove(tmp.ch,s.ch,from);
memmove(tmp.ch+from,s.ch+from+len,length(s)-from-len+1);
tmp.size=length(s)-len;
return(tmp);
}


string insert(const string &s,const string &s2,int position)
{
if((position>length(s))||(position<0))
	{
	string tmp;
	return(tmp);
	}
if(length(s)==0) return(s2);
if(length(s2)==0) return(s);

string tmp(length(s)+length(s2));
memmove(tmp.ch,s.ch,position);
memmove(tmp.ch+position,s2.ch,length(s2));
memmove(tmp.ch+position+length(s2),s.ch+position,length(s)-position+1);
tmp.size=length(s)+length(s2);
return(tmp);
}



/* This is higher level procedure for replacing one substring to another
   substring */
string replacesubstring(const string & s, const string & substring, const string & newsubstring )
{
char *newptr,*ptr;
char c;
string tmp;

if(substring=="" || length(s)<length(substring))
		 return(s);

ptr=s();
while((newptr=StrStr(ptr,substring())) != NULL)
   {
   c=*newptr;
   *newptr=0;

   tmp+=ptr+newsubstring;

   *newptr=c;
   ptr=newptr+length(substring);
   }
tmp += ptr;

return(tmp);
}


string cutspaces(const string & s)
{
int from,to;
char c;

if(length(s)==0) return string();

from=0;
to=length(s)-1;

c=s()[from];
while(isspace(c))
	{
	c=s()[++from];
	if(c==0) return string();
	}

c=s()[to];
while(isspace(c) && (to>from) )
	{
	c=s()[--to];
	}

return(copy(s,from,to-from+1));
}
