#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>

#include <strings.h>
#include "wp2latex.h"

int savestruct(FILE *F,char *description, ...); //from struct.cc
string CutFileName(const char *FullFilename); //from wp2lfuti.cc

typedef struct {
	DWORD FileId;
	DWORD DataOffset;
	WORD  ProductType;
	WORD  FileType;
	BYTE  MajorVersion;
	BYTE  MinorVersion;
	WORD  EncryptKey;
	} WPGHeader;

typedef struct {
	BYTE  RecType;
	DWORD RecLength;
       } WPGRecord;


static void Rd_WP_DWORD(FILE *f, DWORD *d)
{
   unsigned char b;

   fread(&b, sizeof(unsigned char), 1, f);
   *d = b;
   if(b<0xFF) return;

   fread(&b, sizeof(unsigned char), 1, f);
   *d = (DWORD)b ;
   fread(&b, sizeof(unsigned char), 1, f);
   *d += (DWORD)b * 256;
   if(*d<0x8000) return;

   *d = (*d & 0x7FFF) << 16;
   fread(&b, sizeof(unsigned char), 1, f);
   *d += (DWORD)b;
   fread(&b, sizeof(unsigned char), 1, f);
   *d += (DWORD)b * 256l;
   return;
}

static void Wr_WP_DWORD(FILE *f, DWORD d, char Format=0)
{
   unsigned char b;

   if(d<0xFF && Format<1)
       {
       b=d;
       fwrite(&b, 1, 1, f);
       return;
       }

  b=0xff;
  fwrite(&b, 1, 1, f);

  if(d<0x8000 && Format<2)
       {
       b = d & 255;
       fwrite(&b, 1, 1, f);
       b = d / 256;
       fwrite(&b, 1, 1, f);
       return;
       }


  b = (BYTE)((d >> 8*2) & 0x00ffl);
  fwrite( &b, 1,1,f);
  b = (BYTE)((d >> 8*3) & 0x00ffl) | 0x80;
  fwrite( &b, 1,1,f);
  b = (BYTE)((d >> 8*0) & 0x00ffl);
  fwrite( &b, 1,1,f);
  b = (BYTE)((d >> 8*1) & 0x00ffl);
  fwrite( &b, 1,1,f);
  return;
}


void MakeDummyPS(TconvertedPass1 *cq, const char *Filename, const char *NewFilename)
{
FILE *PostScript;
char c1,c2;

  if((PostScript=fopen(NewFilename,"r"))!=NULL)
	{
	c1=getc(PostScript);
	c2=getc(PostScript);
	fclose(PostScript);
	if(c1=='%' && c2=='!') return;  //file already exist, do not overwrite
	}

  PostScript=fopen(NewFilename,"w");
  if(PostScript==NULL)
	{
	if (cq->err != NULL)
	       fprintf(cq->err, _("\nWarning: Cannot write to the file %s !"),NewFilename);
	return;
	}

  fprintf(PostScript,"\
%%!PS-Adobe-2.0 EPSF-2.0\n\
%%%%Title: dummy for %s\n\
%%%%Creator: wp2latex Version %s Patchlevel 0\n\
%%%%CreationDate: Tue Nov  3 22:47:06 1998\n\
%%%%For: root@darkstar ()\n\
%%Magnification: 1.00\n\
%%%%Orientation: Portrait\n\
%%%%BoundingBox: 0 0 246 141\n\
%%%%Pages: 0\n\
%%%%BeginSetup\n\
%%%%IncludeFeature: *PageSize Letter\n\
%%%%EndSetup\n\
%%%%EndComments\n\
/$F2psDict 200 dict def\n\
$F2psDict begin\n\
$F2psDict /mtrx matrix put\n\
/col-1 {0 setgray} bind def\n\
\n\
end\n\
save\n\
-77.0 169.0 translate\n\
1 -1 scale\n\
\n\
/cp {closepath} bind def\n\
/gr {grestore} bind def\n\
/gs {gsave} bind def\n\
/rs {restore} bind def\n\
/l {lineto} bind def\n\
/m {moveto} bind def\n\
/n {newpath} bind def\n\
/s {stroke} bind def\n\
/sh {show} bind def\n\
/slw {setlinewidth} bind def\n\
/srgb {setrgbcolor} bind def\n\
/sc {scale} bind def\n\
/ff {findfont} bind def\n\
/sf {setfont} bind def\n\
/scf {scalefont} bind def\n\
/$F2psBegin {$F2psDict begin /$F2psEnteredState save def} def\n\
/$F2psEnd {$F2psEnteredState restore end} def\n\
%%%%EndProlog\n\
\n\
$F2psBegin\n\
10 setmiterlimit\n\
n 0 792 m 0 0 l 612 0 l 612 792 l cp clip\n\
 0.06000 0.06000 sc\n\
7.500 slw\n\
%% Polyline\n\
n 1305 495 m 5370 495 l 5370 2790 l 1305 2790 l cp gs col-1 s gr\n\
/Times-Roman ff 375.00 scf sf\n\
2340 1455 m\n\
gs 1 -1 sc (%s) col-1 sh gr\n\
/Times-Roman ff 375.00 scf sf\n\
1545 915 m\n\
gs 1 -1 sc (Please convert an image) col-1 sh gr\n\
/Times-Roman ff 375.00 scf sf\n\
2115 2025 m\n\
gs 1 -1 sc (to the postscript) col-1 sh gr\n\
/Times-Roman ff 375.00 scf sf\n\
2520 2550 m\n\
gs 1 -1 sc (manually!) col-1 sh gr\n\
$F2psEnd\n\
rs",Filename,version,Filename);

  fclose(PostScript);
}


void Image(TconvertedPass1 *cq, const char *Filename, TBox & Box,
	   void (*DoCaption)(TconvertedPass1 *,unsigned short), char WP )
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Image(%s) ",Filename);fflush(cq->log);
#endif

WORD ResourceNo;
DWORD ResourceSize,NewObject,i;
char ch,NumFormat;
int lines=0;
const char *ss;
string NewFilename;
string FileExtension;
FILE *SrcImage;
WPGHeader Hdr;
WPGRecord Rec;


  if(InputPS<false) return;  /* The PS image feature is disabled */

  if(WP==5)
    {
    fseek(cq->wpd, cq->ActualPos+109L, SEEK_SET); // receive an image resource No
    Rd_word(cq->wpd,&ResourceNo);
    if((ResourceSize=SelectImageResource(cq, ResourceNo))>0)
	{	// make an attempt to extract resource
	if(Filename==NULL) goto NoCopyImage;
	if(*Filename==0) goto NoCopyImage;
	NewFilename=OutputDir;
	NewFilename+=Filename;

	if(SaveWPG)
	  {
/*	  SrcImage=fopen(NewFilename.ch,"r");
	  if(SrcImage!=NULL)
		 {
		 fclose(SrcImage);
		 goto NoCopyImage;
		 }*/
	  if((SrcImage=fopen(NewFilename,"wb"))==NULL) goto NoCopyImage;
	  Hdr.FileId=0x435057FF;
	  Hdr.DataOffset=0x10;
	  Hdr.ProductType=0x1601;
	  Hdr.FileType=0x1;
	  Hdr.MajorVersion=0;
	  Hdr.MinorVersion=0;
	  Hdr.EncryptKey=0;

	  savestruct(SrcImage,"ddwwbbw",
		  Hdr.FileId,Hdr.DataOffset,Hdr.ProductType,Hdr.FileType,
		  Hdr.MajorVersion,Hdr.MinorVersion,Hdr.EncryptKey);
	  }

	cq->ActualPos=ftell(cq->wpd);
	ResourceSize+=cq->ActualPos; //end of resource


	while(cq->ActualPos<ResourceSize)
		{
		Rec.RecType=fgetc(cq->wpd);
		Rd_WP_DWORD(cq->wpd,&Rec.RecLength);
		NewObject=ftell(cq->wpd)+Rec.RecLength;

		NumFormat=0;
		switch(Rec.RecType)
			{
			case  0x1:strcpy(cq->ObjType,"Fill Attributes"); break;
			case  0x2:strcpy(cq->ObjType,"Line Attributes"); break;
			case  0x3:strcpy(cq->ObjType,"Symbol Attributes"); break;
			case  0x4:strcpy(cq->ObjType,"Polysymbol"); break;
			case  0x5:strcpy(cq->ObjType,"Line"); break;
			case  0x6:strcpy(cq->ObjType,"Curve"); break;
			case  0x7:strcpy(cq->ObjType,"Rectangle"); break;
			case  0x8:strcpy(cq->ObjType,"Polygon"); break;
			case  0x9:strcpy(cq->ObjType,"Elipsis"); break;
			case  0xA:strcpy(cq->ObjType,"Elipsis"); break;
			case  0xB:strcpy(cq->ObjType,"Bitmap l1"); break;
			case  0xC:strcpy(cq->ObjType,"Graphics Text");NumFormat=1; break; //This is a bug fix for Draw Perfect WPG
			case  0xD:strcpy(cq->ObjType,"Text Attributes"); break;
			case  0xE:strcpy(cq->ObjType,"Color Map"); break;	// NumFormat=1; // default DR
			case  0xF:strcpy(cq->ObjType,"Start WPG l1"); break;
			case 0x10:strcpy(cq->ObjType,"End WPG l1"); break;
			case 0x11:strcpy(cq->ObjType,"Start PS l1"); break;
			case 0x12:strcpy(cq->ObjType,"Output Attributes"); break;
			case 0x13:strcpy(cq->ObjType,"Plain Curve"); break;
			case 0x14:strcpy(cq->ObjType,"Bitmap l2"); break;
			case 0x15:strcpy(cq->ObjType,"Start Image"); break;
			case 0x16:strcpy(cq->ObjType,"Start Graph"); break;
			case 0x17:strcpy(cq->ObjType,"Plan Perfect"); break;
			case 0x18:strcpy(cq->ObjType,"Graphics Text l2"); break; // NumFormat=1; // default DR
			case 0x19:strcpy(cq->ObjType,"Data Start l2");  break;
			case 0x1A:strcpy(cq->ObjType,"Graphics Text l3"); break;
			case 0x1B:strcpy(cq->ObjType,"Postscript l2"); break;
			default: sprintf(cq->ObjType,"?%d?",(int)Rec.RecType); break;
			}

//Save WPG to the disk file
		if(SaveWPG)
		  {
		  fputc(Rec.RecType,SrcImage);
		  Wr_WP_DWORD(SrcImage, Rec.RecLength, NumFormat);
		  for(i=0;i<Rec.RecLength;i++)
			  {
			  ch=fgetc(cq->wpd);
			  fputc(ch,SrcImage);
			  }
		  }

//Log report a graphical image object
		if(cq->log!=NULL)
			{
			fprintf(cq->log,"\n%*s{GRtyp#%x;len:%lx;%s}",cq->recursion * 2, "",
			   (int)Rec.RecType,(long)Rec.RecLength,cq->ObjType);
			}

		if(NewObject!=ftell(cq->wpd))
			fseek(cq->wpd,NewObject,SEEK_SET);
		cq->ActualPos=NewObject;
		} /**/

	if(SaveWPG) fclose(SrcImage);
	}
    }
NoCopyImage:


  ss=GetExtension(Filename);
  if(ss!=NULL) if(*ss!=0) FileExtension=ToUpper(ss+1);
  NewFilename=OutputDir+CutFileName(Filename)+".ps";


  if(FileExtension=="PS" || FileExtension=="EPS")
     {
     if(AbsolutePath(Filename))
	if(!CopyFile(NewFilename,Filename)) goto FileIsOK;
     else
	if(!CopyFile(NewFilename,(string(InputDir)+Filename)())) goto FileIsOK;
     }

  MakeDummyPS(cq, Filename, NewFilename);


FileIsOK:
  NewFilename=CutFileName(Filename); 	//New Filename only

  if(cq->char_on_line == -20)    /* Left one enpty line for new enviroment */
	  {
	  fputc('%', cq->strip);
	  NewLine(cq);
	  cq->char_on_line = true;
	  }
  if (cq->char_on_line==true)    /* make new line for leader of minipage */
	 {
	 putc('\n', cq->strip);
	 cq->line_term = 's';   /* Soft return */
	 Make_tableentry_envir_extra_end(cq);

	 cq->nomore_valid_tabs = false;
	 cq->rownum++;
	 Make_tableentry_attr(cq);
	 cq->latex_tabpos = 0;
	 }


  if(cq->flag == HeaderText) Box.AnchorType=2;

//This write an TeX program for including an image into the document
  InputPS=true;
  if(Box.AnchorType!=2)
	{
	if(!BoxTexHeader(cq, Box)) Box.CaptionSize=0;
	putc('\n',cq->strip); lines++;
	}
  fprintf(cq->strip,"\\begin{forcewidth}");
  if(Box.HorizontalPos==3) fprintf(cq->strip,"{\\textwidth}\n");
				  else fprintf(cq->strip,"{%2.2fcm}\n",float(Box.Width)/470);
  lines++;
  if(Box.AnchorType!=2) fprintf(cq->strip," \\begin{center}");
  fprintf(cq->strip,"\\InputPS{\\FigDir/%s.ps}",NewFilename() );
  if(Box.AnchorType!=2) fprintf(cq->strip," \\end{center}");
  putc('\n',cq->strip); lines++;
//\caption[]{}
//\label{fig.probes16}
  fprintf(cq->strip,"\\end{forcewidth}\n");lines++;
  if(Box.CaptionSize>0 && Box.CaptionPos>0 && Box.AnchorType!=2)
	{
	fseek(cq->wpd,Box.CaptionPos,SEEK_SET);
	DoCaption(cq,Box.CaptionSize);
	}
  if(Box.AnchorType!=2)
	{
	BoxTexFoot(cq, Box);
	fprintf(cq->strip,"\n");
	lines++;
	}

  while(lines>0)
     {
     cq->line_term = 's';   /* Soft return */
     Make_tableentry_envir_extra_end(cq);
     cq->char_on_line = false;
     cq->nomore_valid_tabs = false;
     cq->rownum++;
     Make_tableentry_attr(cq);
     cq->latex_tabpos = 0;

     lines--;
     }

  cq->char_on_line = false;
}


