/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       pass1.cc                                                      *
 * description: This modul contains functions for first pass. In the first    *
 *              pass information of the WP binary file will splitted in two   *
 *              parts:                                                        *
 *              1) A text file containing the whole text. The special WP      *
 *                 characters are translated.                                 *
 *              2) A binary file which contains information about             *
 *                 environments, tabbings, line endings                       *
 ******************************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <ctype.h>

#include <sets.h>
#include <strings.h>
#include <lists.h>
#include "wp2latex.h"

#ifdef __UNIX__
 #include <unistd.h>
#endif
#ifdef __BORLANDC__
 #include "cp_lib/cptran.h"
#else
 #include "cptran.h"
#endif

extern list FontTable;


char *Parts[8] = {
 "part", "chapter", "section", "subsection",
 "subsubsection", "paragraph", "subparagraph","" };


#ifndef FINAL
/*This procedure isn't normally called. It can be used for exploration of new objects*/
void CrackObject(TconvertedPass1 *cq, DWORD end_of_code)
{
  FILE *txt = NULL;
  unsigned short i,y;
  long pos;
  unsigned short len;
  static char ss[13] = "00__Hack.txt";
  char c;

  pos = ftell(cq->wpd);

  len = end_of_code - ftell(cq->wpd);

  if (ss[1] > '9')
     {
     ss[1] = '0';
     ss[0]++;
     }

  txt=fopen(ss,"w");
  if (txt == NULL) return;

  for (i = 0; i <= len; i++)
      {
      fread(&c, 1, 1, cq->wpd);
      y=c & 0xFF;
      fprintf(txt, "%3u %2x ", i, y);
      if (c >= ' ' && c <= 'z')
          fprintf(txt, " %c", c);
      putc('\n', txt);
      }

  if (txt != NULL) fclose(txt);
  txt = NULL;
  ss[1]++;   /**/

  fseek(cq->wpd, pos, 0);
  if (txt != NULL) fclose(txt);
}
#endif

//++++++Procedures for manipulating with ATTR struct+++++++

/* This procedure initialize an attr structure */
void InitAttr(attribute & a)
{
 a.Math_Depth=a.Closed_Depth=a.Opened_Depth=0;
}

/* This procedure opens all temporary closed attributes in the attr structure */
void Open_All_Attr(attribute & a, FILE * f)
{
char *ch;

while(a.Opened_Depth<a.Closed_Depth)
	{
        ch=Open_com[a.stack[a.Opened_Depth++]];
        if(*ch == '$' && a.Math_Depth <= 0)
        	{
                a.Math_Depth=a.Opened_Depth;
                }
        fputs(ch,f);
        }
}

/* This procedure temporary closes all attributes in the attr structure */
void Close_All_Attr(attribute & a, FILE *f)
{
while(a.Opened_Depth>0)
	{
        fputs(Close_com[a.stack[--a.Opened_Depth]],f);
	if(a.Math_Depth>a.Opened_Depth) a.Math_Depth=0;
        }
}

/* This procedure opens one attribut (lettertype) in the attr structure */
void AttrOn(attribute & a, char Attr)
{
int i;
			/*Try to find an opened attribute in the stack */
for(i=0; i<a.Closed_Depth; i++)
	{
        if(a.stack[i]==Attr)
		{
		return;
                }
        }
a.stack[a.Closed_Depth++]=Attr;

return;
}

/* This procedure closes one attribut (lettertype) in the attr structure.
   It must generate some output to string.   */
void _AttrOff(attribute & a, char Attr, string & s)
{
int pos;

s="";

/*Try to find a currently closed attribute in the stack */
for(pos=a.Closed_Depth-1; pos>=0; pos--)
        if(a.stack[pos]==Attr) break;

if(pos<0) {
        //printf(_("Attribute cannot be closed"));
          return;
          }

	/* Close all opened attributes above closed & closed one */
while(a.Opened_Depth>pos)
	{
	s+=Close_com[a.stack[--a.Opened_Depth]];
	if(a.Math_Depth>a.Opened_Depth)
		a.Math_Depth=0;		/*First Math responsible attr is closed*/
	}

	/* Remove closed attribute from chain of clossed attributes */
a.Closed_Depth--;
while(pos<a.Closed_Depth)
	{
	a.stack[pos]=a.stack[pos+1];
	pos++;
	}

return;
}

/*This procedure closes one attribut and write closing sequence into the file cq->strip*/
void AttrOff(TconvertedPass1 *cq,char attr_num)
{
string s;

 _AttrOff(cq->attr,attr_num,s);
 if(s!="") fputs(s,cq->strip);

return;
}


/*This procedure opens an attribute. Opening sequence is delayed and it is not written now.*/
void Attr_ON(TconvertedPass1 *cq,unsigned char b)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Attr_ON() ");fflush(cq->log);
#endif

  if(b==0xFF)
     fread(&b, sizeof(unsigned char), 1, cq->wpd);   /* the attribute code */

  b &= 0x7F;			// mask bit 7: nested duplicated attr
  if(b==7) {
	   if ((LaTeX_Version & 0xFF00) < 0x300)  // outline is supported by NFSS only
		{
		strcpy(cq->ObjType, "!Attr Outlin On");
		return;
		}
	   }
  if(b==0xA) {
	     if(colors<0)
		  {
		  strcpy(cq->ObjType, "!Attr Red On");
		  return;
		  }
	     colors=true;
	     }
  if(b<16) AttrOn(cq->attr,b & 0xF);
      else if (cq->err != NULL)
	    {
	    cq->perc.Hide();
	    fprintf(cq->err, _("\nWarning: strange attribute %d!"),(int)b);
	    }

  sprintf(cq->ObjType, "Attr %d On",(int)b);
}



void Attr_OFF(TconvertedPass1 *cq,unsigned char b)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Attr_OFF() ");fflush(cq->log);
#endif
  string s;

  if(b==0xFF)
     fread(&b, sizeof(unsigned char), 1, cq->wpd);   /* less attribuut-code */
  b &= 0x7F;			// mask bit 7: nested duplicated attr

  if(b==0xA && colors<=false) goto RejectAttr;
  if ((b==7) && ((LaTeX_Version & 0xFF00) < 0x300))  goto RejectAttr;

  _AttrOff(cq->attr,b & 0xF,s);
  if(s!="") fputs(s,cq->strip);

RejectAttr:
  sprintf(cq->ObjType, "Attr %d Off",(int)b);
}


/*This procedure creates opening&closing sequence of attrs after that Base will have same items as A_new*/
void AttrFit(attribute & Base, attribute & A_New, string & s)
{
int i,pos;

s="";

Base.Closed_Depth=Base.Opened_Depth;
for(pos=0;pos<Base.Opened_Depth; pos++)
	{
	if(A_New.stack[pos]!=Base.stack[pos] || pos>=A_New.Closed_Depth)
	   {  //close all attrs Base[MaxPos] ... Base[Pos]
	   while(Base.Opened_Depth>pos)
		{
		s+=Close_com[Base.stack[--Base.Opened_Depth]];
		if(Base.Math_Depth>Base.Opened_Depth)
			Base.Math_Depth=0;		/*First Math responsible attr is closed*/
		}
	   Base.Closed_Depth=Base.Opened_Depth;
	   break;
	   }
	}

for(i=pos;i<A_New.Closed_Depth;i++)
	{
	AttrOn(Base,A_New.stack[i]);
	}
Base.Math_Depth=A_New.Math_Depth;
}


/*This procedure changes a number of columns in document*/
void Column(TconvertedPass1 *cq,signed char number)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Column(%d) ",(int)number);fflush(cq->log);
#endif
int i;
const char b='M';

if(Columns<false)
	{
	strcpy(cq->ObjType, "!Col");
	return;
	}

				/* Any of section's attr cannot be opened */
for(i=First_com_section;i<=Last_com_section;i++)
		     AttrOff(cq,i);
if(cq->char_on_line==true) NewLine(cq);

if(number>1)
	 {
	 cq->Columns=number;
	 fwrite(&b, 1, 1, cq->table);
	 fwrite(&cq->Columns, 1, 1, cq->table);
	 NewLine(cq);
	 strcpy(cq->ObjType, "Col On");
	 }
else     {
	 if(cq->Columns<=1) goto NoOneCol;
	 cq->Columns=1;
	 fwrite(&b, 1, 1, cq->table);
	 fwrite(&cq->Columns, 1, 1, cq->table);
	 NewLine(cq);
NoOneCol:strcpy(cq->ObjType, "Col Off");
	 }

if(Columns<cq->Columns)
    {
    if(Columns==1 && cq->Columns==2) Columns=3;
				else Columns=cq->Columns;
    }
}


/* This procedure finishes indenting */
void End_of_indent(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#End_of_indent() ");fflush(cq->log);
#endif
  cq->indent_end = true;
  strcpy(cq->ObjType, "End Indent");
}


/*This procedure converts Hard Line Break*/
void HardReturn(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#HardReturn() ");fflush(cq->log);
#endif

 if(cq->envir == 'B')		// Hard return
	{
	Close_All_Attr(cq->attr,cq->strip);
/*	if ((LaTeX_Version & 0xFF00) >= 0x300)
	     fputs(" \\tabularnewline ", cq->strip);
	else */
	     fputs(" \\penalty-10001 ", cq->strip);
	return;
	}
    else Terminate_Line(cq,'h');

  strcpy(cq->ObjType, "HRt");
}


/* This procedure performs conversion of [indent] symbol*/
void Indent(TconvertedPass1 *cq, char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Indent ");fflush(cq->log);
#endif
  WORD dif, abs;
  unsigned char b;

  if (cq->envir == 'T' || cq->Columns>1)
	{
	putc(' ', cq->strip);		//ignore indent
	strcpy(cq->ObjType, "!Indent");
	return;
	}


 /*Al one tabcommand gezet dus er mag geen insp */
  Close_All_Attr(cq->attr,cq->strip);
  putc('\n', cq->strip);

  cq->line_term = 's';     // Soft return
  Make_tableentry_envir_extra_end(cq);

  if(cq->envir=='I') cq->envir='i';
		else cq->envir='I';
  cq->indenting++;

  Make_tableentry_attr(cq);


  b=0;
  switch(WP)
	{
	case 0x14:fread(&b, 1, 1, cq->wpd);	//obsolette WP4
	       if(b>40) b=40;
	       abs=cq->tabpos[b];
	       b=0;
	       break;
	case 4:RdWORD_HiEnd(&abs, cq->wpd);	// WP4
	       break;
	case 5:fread(&b, 1, 1, cq->wpd);	// WP5
	       b &= 0x1;
	       Rd_word(cq->wpd, &dif);
	       Rd_word(cq->wpd, &abs);   /* Previous old column */
	       Rd_word(cq->wpd, &abs);
	       break;
	case 6:fseek(cq->wpd, 3L, SEEK_CUR);	// WP6
	       Rd_word(cq->wpd, &abs);
	       break;
	}


  if (abs <= cq->WP_sidemargin)
     {
     if (cq->err != NULL)
	{
	cq->perc.Hide();
	fprintf(cq->err, _("\nWarning: Negative indent, fixed!"));
	}
     cq->ind_leftmargin = cq->tabpos[0];
     }
     else  cq->ind_leftmargin = abs - cq->WP_sidemargin;

/*     if (b == 1)
   cq->ind_rightmargin += dif;*/
 /*Margins bepaald less voorby rest van functie-codes */

 strcpy(cq->ObjType, "Indent");
}



/*This procedure make fingerprint of all currently opened Attributes to
  the .TAB file. These are from 0 to Opened_Depth-1. */
void Make_tableentry_attr(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Make_tableentry_attr() ");fflush(cq->log);
#endif
  unsigned char num_of_attr;
  int j;

  num_of_attr = 0xF0;
  fwrite(&num_of_attr, 1, 1, cq->table);
  num_of_attr = cq->attr.Opened_Depth;
  fwrite(&num_of_attr, 1, 1, cq->table);

  for (j = 0; j < num_of_attr; j++)
      fwrite(&cq->attr.stack[j], 1, 1, cq->table);
}


void Make_tableentry_envir_extra_end(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Make_tableentry_envir_extra_end() ");fflush(cq->log);
#endif
  unsigned char b;


  switch (cq->envir)
    {
    case 'B': b = 'B';
              fwrite(&b, 1, 1, cq->table);
              break;

    case 'C':
    case 'c': b = 'C';
              fwrite(&b, 1, 1, cq->table);
              break;

    case 'L': b = 'L';
              fwrite(&b, 1, 1, cq->table);
              break;

    case 'R': b = 'R';
              fwrite(&b, 1, 1, cq->table);
              break;

/*  case 'q': b = 'q';
              fwrite(&b, 1, 1, cq->table);
              break;
    case 'Q': b = 'Q';
              fwrite(&b, 1, 1, cq->table);
              break; */

    case 'T': b = 'T';
              fwrite(&b, 1, 1, cq->table);
              break;

    case 't': b = 't';
              fwrite(&b, 1, 1, cq->table);
              break;

    case 'I':
    case 'i': b = cq->envir;
              fwrite(&b, 1, 1, cq->table);
              Wr_word(cq->table, cq->ind_leftmargin);

              fwrite(&cq->indenting, 1, 1, cq->table);
              break;

    case '!': b = '!';
              fwrite(&b, 1, 1, cq->table);
              break;
    case '^': b = '^';
              fwrite(&b, 1, 1, cq->table);
              break;
    }


  b = cq->line_term;
  fwrite(&b, sizeof(unsigned char), 1, cq->table);

  b = 0xff;
  fwrite(&b, sizeof(unsigned char), 1, cq->table);
}


void Make_tableentry_tabset(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Make_tableentry_tabset() ");fflush(cq->log);
#endif
  unsigned char b = 'S';
  long j, FORLIM;

  fwrite(&b, sizeof(unsigned char), 1, cq->table);

  b = cq->num_of_tabs;
  fwrite(&b, sizeof(unsigned char), 1, cq->table);

  FORLIM = cq->num_of_tabs;
  for (j = 0; j < FORLIM; j++)
    Wr_word(cq->table, cq->tabpos[j]);
}



//++++++General Purpose procedures for converting files+++++++
//                 alphabetically ordered

void CancelHyph(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#CancelHyph() ");fflush(cq->log);
#endif

  fprintf(cq->strip, "{\\nobreak}");

  strcpy(cq->ObjType, "Cancel Hyph");
}


/*cell in the table*/
void CellTable(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#CellTable() ");fflush(cq->log);
#endif

  if (cq->envir == 'B')
       {
       if(cq->char_on_line==true)
	 {
	 Close_All_Attr(cq->attr,cq->strip);
	 fprintf(cq->strip, " & ");
	 }
       cq->char_on_line = true;
       }

  strcpy(cq->ObjType, "Cell");
}


/* This procedure set on the center environment if there is no */
/* currently active environment .                              */
void Center(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Center() ");fflush(cq->log);
#endif

  if(cq->char_on_line == -10)	/* first line of minipages */
	{			/* a new line have to be creared */
	fputs("%\n", cq->strip);
	cq->line_term = 's';   /* Soft return */

	Make_tableentry_envir_extra_end(cq);
	cq->rownum++;

	cq->nomore_valid_tabs = false;
	Make_tableentry_attr(cq);
	cq->char_on_line = false;
	}

  if (cq->envir == ' ')		/* environment = center */
	{
	cq->envir = 'c';	// the small 'c' is turned off on by the EOL
	if(cq->char_on_line != true)
		cq->char_on_line = -20;
	}

  strcpy(cq->ObjType, "Center");
}


void CenterPage(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#CenterPage() ");fflush(cq->log);
#endif

  fprintf(cq->strip, "\\strut\\vfil ");
  cq->CentrePage=true;

  strcpy(cq->ObjType, "CenterPg");
}


/*This procedure outputs character string */
void CharacterStr(TconvertedPass1 *cq,const char *LatexCode,char RequiredFont)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#CharacterStr(%s) ",LatexCode);fflush(cq->log);
#endif
 int DollarNo;

 if(LatexCode==NULL) return;

 cq->char_on_line = true;   /*Some character is placed on line */
 if (cq->attr.Closed_Depth!=cq->attr.Opened_Depth)
	    {
	    Open_All_Attr(cq->attr,cq->strip);
	    }

 if (cq->Font != RequiredFont)
	   {
           if (RequiredFont == 0)
	     {
	     if (cq->by != '?' && (cq->by < ' ' || cq->by > ';'))
		{
	        cq->Font = 0;
	        fprintf(cq->strip, "\\rm ");
	        }
             }

           if (RequiredFont == 1)
               {
	       if (cq->Font == 0)
			  {
			  cq->Font = 1;
			  fprintf(cq->strip, "\\cyr ");
			  }
	       }
	   }


 if( cq->attr.Math_Depth>0 )
   {
   DollarNo=0;
   while( *LatexCode!=0 )		// Tohle se musi jeste trochu predelat 1.$  a 2.$ !!!!!!!!!!
	   {
	   if(*LatexCode == '\\')
		   {
		   switch(LatexCode[1])
		     {
		     case '\'':fputs("\\acute", cq->strip); break;
		     case '=':fputs("\\bar", cq->strip); break;
		     case 'u':if(!isalpha(LatexCode[2])) {fputs("\\breve", cq->strip); break;}
			      fputc('u',cq->strip); goto NextChar;
		     case '.':fputs("\\dot", cq->strip); break;
		     case '`':fputs("\\grave", cq->strip); break;
		     case '^':fputs("\\hat", cq->strip); break;
		     case '~':fputs("\\tilde", cq->strip); break;
		     case '$':fputs("\\$", cq->strip); break;
		     case '\\':fputs("\\\\", cq->strip); break;
		     default:fputc('\\',cq->strip); goto NextChar;
		     }
		   LatexCode+=2;
		   continue;
		   }
	   if(*LatexCode == '$')	// math around must be removed
	      {
	      if(DollarNo++ & 1) fputs("}{", cq->strip);
			    else fputs("}{\\rm ", cq->strip);
	      }
	   else fputc(*LatexCode, cq->strip);
NextChar:  LatexCode++;
	   }
   }
   else fputs(LatexCode, cq->strip);
}


/*This procedure converts changes of colors of the text.*/
void Color(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Color() ");fflush(cq->log);
#endif
char *ColorType="?";
BYTE Red,Green,Blue;

  if(colors<false || LaTeX_Version<0x300)
	{
	strcpy(cq->ObjType, "!Color");
	return;
	}

  colors=true;

  fseek(cq->wpd, 3l, SEEK_CUR);
  fread(&Red, 1, 1, cq->wpd);
  fread(&Green, 1, 1, cq->wpd);
  fread(&Blue, 1, 1, cq->wpd);

  if(Red==0 && Green==0 && Blue==0) ColorType="black";
  if(Red==0xFF && Green==0xFF && Blue==0xFF) ColorType="white";

  if(Red==0xFF && Green==0 && Blue==0) ColorType="red";
  if(Red==0 && Green==0xFF && Blue==0) ColorType="green";
  if(Red==0 && Green==0 && Blue==0xFF) ColorType="blue";

  if(Red==0xFF && Green==0xFF && Blue==0) ColorType="yellow";
  if(Red==0xFF && Green==0 && Blue==0xFF) ColorType="magenta";
  if(Red==0 && Green==0xFF && Blue==0xFF) ColorType="cyan";

  if(*ColorType!='?')
		fprintf(cq->strip, "\\color{%s}",ColorType);
	   else fprintf(cq->strip, "\\color[rgb]{%1.2f,%1.2f,%1.2f}",
		  ((float)Red)/0xFF,((float)Green)/0xFF,((float)Blue)/0xFF);

  sprintf(cq->ObjType, "Color:%s", ColorType);
}


void EndSection(TconvertedPass1 *cq, signed char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#EndSection() ");fflush(cq->log);
#endif
  unsigned char b;
  string s;

  if(WP>0)
    {
    if(WP==6) fseek(cq->wpd, 3L, SEEK_CUR);
    fread(&b, sizeof(unsigned char), 1, cq->wpd);   /* less attribuut-code */
    }
  else b=abs(WP);
  sprintf(cq->ObjType, "End MarkToC %d",(int)b);

  if (b > 0) b -= cq->FirstSection;

  b += OutputStyle;
  if (b > Last_com_section) return;

  if(OptimizeSection && cq->envir!='B') _AttrOff(cq->attr,b,s);
				   else _AttrOff(cq->attr,Last_com_section+1,s);
  if(s!="") fputs(s,cq->strip);
}


/*This procedure provide conversion of Hard Page code [HPg]*/
void HardPage(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#HardPage() ");fflush(cq->log);
#endif

 if(cq->flag > NormalText)
    {
    if(cq->flag > HeaderText) fputc(' ',cq->strip);
	 else Terminate_Line(cq,'h');  //hard return replaces hard page
    strcpy(cq->ObjType, "!HPg");
    }
 else {
      Terminate_Line(cq,'P');
      strcpy(cq->ObjType, "HPg");
      }
}


void InitHeaderFooter(TconvertedPass1 *cq, char HorF, char occurance)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#InitHeaderFooter(%d,%d) ",(int)HorF,(int)occurance);fflush(cq->log);
#endif

if(FancyHdr<0)
  {
  switch (HorF)
      {
      case 0:
      case 1:fprintf(cq->strip, "\\headtext"); break;

      case 2:
      case 3:fprintf(cq->strip, "\\foottext"); break;
      }
			// bit 0 - occurance on odd pages
  switch (occurance)	// bit 1 - occurance on even pages
      {
      case 0:fprintf(cq->strip, "{\\neverpages}{");   break;
      case 1:fprintf(cq->strip, "{\\allpages}{");     break;
      case 2:fprintf(cq->strip, "{\\oddpages}{");
	     twoside=true;
	     break;
      case 4:fprintf(cq->strip, "{\\evenpages}{");
	     twoside=true;
	     break;
      default:putc('{', cq->strip);
	      break;
      }
  }
else
  {
  FancyHdr=1;
  switch (HorF)
      {
      case 0:
      case 1:fprintf(cq->strip,"\\fancyhead");
	     switch (occurance)
	       {
	       case 0:fprintf(cq->strip,"{} {"); break;
	       case 1:fprintf(cq->strip,"{} \\fancyhead[L]{"); break;
	       case 2:fprintf(cq->strip,"[O]{} \\fancyhead[LO]{");
		      twoside=true;
		      break;
	       case 4:fprintf(cq->strip,"[E]{} \\fancyhead[LE]{");
		      twoside=true;
		      break;
	       default:putc('{', cq->strip);
		       break;
	       }
	     break;

      case 2:
      case 3:fprintf(cq->strip, "\\fancyfoot");
	     switch (occurance)
	       {
	       case 0:fprintf(cq->strip,"{} {"); break;
	       case 1:fprintf(cq->strip,"{} \\fancyfoot[L]{"); break;
	       case 2:fprintf(cq->strip,"[O]{} \\fancyfoot[LO]{");
		      twoside=true;
		      break;
	       case 4:fprintf(cq->strip,"[E]{} \\fancyfoot[LE]{");
		      twoside=true;
		      break;
	       default:putc('{', cq->strip);
		       break;
	       }
	     break;
      default:putc('{', cq->strip);
      }
  }
}


void Justification(TconvertedPass1 *cq,unsigned char WPx)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Justification() ");fflush(cq->log);
#endif
  BYTE b;
  char *Direction="?";
			// This is impossible to change environment for one
  if(cq->envir == 'B') goto JustifEnd; // cell in the table.

  if(WPx==5) fseek(cq->wpd, 1L, SEEK_CUR);
  if(WPx==6) fseek(cq->wpd, 3L, SEEK_CUR);
  if(WPx<0x80) fread(&b, 1, 1, cq->wpd);    /*0-Left, 3-Right, 2-Center, 1-Full */
	  else b=WPx & 3;		    /*WPx=80   WPx=83   WPx=82    WPx=81 - direct set */


  if(cq->char_on_line == -10)	//first line after minipages
  	{
        putc('%', cq->strip);
        cq->char_on_line=true;
	}
  if(cq->char_on_line==true)                      //!!!!!!!!!   ////
     {
     NewLine(cq);
     }
  cq->latex_tabpos = 0;
  cq->envir = ' ';

  switch(b)
    {
    case 0:cq->envir = 'L';     /* environment = left */
	   Direction="Left";
	   break;
    case 1:cq->envir = ' ';     /* environment = full */
	   Direction="Full";
	   break;
    case 2:cq->envir = 'C';     /* environment = center */
	   Direction="Center";
	   break;
    case 3:cq->envir = 'R';     /* environment = right */
	   Direction="Right";
	   break;
    case 4:cq->envir = ' ';     /* environment = full all lines */
	   Direction="Full all lines";
	   break;
    case 5:cq->envir = ' ';     /* environment = full all lines */
	   Direction="!Decimal";
	   break;
    default:cq->envir = ' ';	/* unknown enviroment */
	    Direction="?";
    }

  if(cq->envir != ' ')
  	cq->char_on_line = -20;

JustifEnd:
  sprintf(cq->ObjType, "Justification %s",Direction);
}


/*Switch to a new language. Note:some languages are unknown for me.*/
void Language(TconvertedPass1 *cq, boolean WP6)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Language() ");fflush(cq->log);
#endif

  char CurLang[3],OldLang[3],*LangStr;


  CurLang[2]=0;
  OldLang[2]=0;
  if(!WP6) {
	   fread(OldLang,2,1,cq->wpd);
	   fread(CurLang,2,1,cq->wpd);
	   }
      else {
	   fseek(cq->wpd, 3L, SEEK_CUR);
	   fread(CurLang,2,1,cq->wpd);
	   fread(OldLang,2,1,cq->wpd);
	   }
  LangStr=CurLang;

/* I really don't know whether are these national settings correct. */
/* If you find problems, please correct them and send me your improvement.*/
  if(!strcmp(CurLang,"BR")) LangStr="brasil";	//???
  if(!strcmp(CurLang,"CZ")){LangStr="czech";if(Czech>=false) Czech=true;}
  if(!strcmp(CurLang,"CA")) LangStr="catalan";	//???
  if(!strcmp(CurLang,"CE")) LangStr="ENcanada";	//???
  if(!strcmp(CurLang,"CF")) LangStr="FRcanada";	//???
  if(!strcmp(CurLang,"DE")){LangStr="german";if(German>=false) German=true;};
  if(!strcmp(CurLang,"ES")) LangStr="spain";	//???
  if(!strcmp(CurLang,"FR")) LangStr="french";
  if(!strcmp(CurLang,"HR")) LangStr="hrvatski";	//???
  if(!strcmp(CurLang,"HU")) LangStr="hungary";	//???
  if(!strcmp(CurLang,"IT")) LangStr="italy";	//???
  if(!strcmp(CurLang,"NL")) LangStr="nederland";	//???
  if(!strcmp(CurLang,"OZ")) LangStr="ENaustralia";//???
  if(!strcmp(CurLang,"RU")) LangStr="russian";	//???
  if(!strcmp(CurLang,"SD")) LangStr="schweiz";	//???
  if(!strcmp(CurLang,"SL")) LangStr="slovak";
  if(!strcmp(CurLang,"US")) LangStr="USenglish";
  if(!strcmp(CurLang,"UK")) LangStr="english";

  if(strcmp(CurLang,"??"))
	  fprintf(cq->strip, "\\language=\\%s ",LangStr);

  sprintf(cq->ObjType, "Lang:%s",CurLang);
}


/* This procedure write macro for current number of paragraph in the document */
void ParagraphNumber(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#ParagraphNumber() ");fflush(cq->log);
#endif
  unsigned char ParNumType;
  int i;
  static char count='A';


  fread(&ParNumType, 1, 1, cq->wpd);
  ParNumType=ParNumType ^ 0x80;
  if(ParNumType>=0x80) strcpy(cq->ObjType, "ParNum:Auto");
		  else sprintf(cq->ObjType, "ParNum:%d",(int)ParNumType);

/* check whether the section is opened */
  for (i = 0; i < cq->attr.Closed_Depth; i++)
	{
	if(cq->attr.stack[i] >= First_com_section &&
	   cq->attr.stack[i] <= Last_com_section) return;
	}


  if (cq->attr.Closed_Depth!=cq->attr.Opened_Depth)
	 {
	 Open_All_Attr(cq->attr,cq->strip);
	 }
  if(ParNumType>=0x80) {
		       ParNumType=0x80;	//!!!!!!!!!!! opravit !!!!!
		       fprintf(cq->strip, "\\label{ParNum_%c}\\ref{ParNum_%c}",count,count );
		       count++;
		       }
		  else {
		       if (ParNumType > 0) ParNumType -= cq->FirstSection;
		       ParNumType += OutputStyle - First_com_section;

		       if(ParNumType>=7) return;

		       fprintf(cq->strip, "\\the%s ", Parts[ParNumType] );
		       }

  cq->char_on_line = true;
}


/* This procedure wrote a macro for writing a number of current page */
void PageNumber(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#PageNumber() ");fflush(cq->log);
#endif

  if (cq->attr.Closed_Depth!=cq->attr.Opened_Depth)
         {
	 Open_All_Attr(cq->attr,cq->strip);
         }
  fprintf(cq->strip, "\\thepage ");

  strcpy(cq->ObjType, "Insert Pg Num");
  cq->char_on_line = true;
}


/*This procedure creates header or footer with number of page exactly positioned*/
void Page_number_position(TconvertedPass1 *cq, unsigned char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Page_number_position() ");fflush(cq->log);
#endif
  unsigned char position_code;
  char *PgNumType="?";
  BYTE Flags,IDs;

  if(WP==4) fseek(cq->wpd, 1L, SEEK_CUR);
  if(WP==5) fseek(cq->wpd, 3L, SEEK_CUR);   /*Skip length of code; always 10*/
  if(WP==6) {
	    fread(&Flags, 1, 1, cq->wpd);
	    IDs=fgetc(cq->wpd);
	    fseek(cq->wpd, 9L + 2L*IDs, SEEK_CUR);
	    }
					    /* + old information */
  fread(&position_code, 1, 1, cq->wpd);
  if(WP<6 && position_code>=9) position_code=0;

  if(FancyHdr<0)
    {
    fprintf(cq->strip, "\\pagenumpos");
    switch (position_code)
      {
      case 0x0: PgNumType="No";
NoNumber:       fprintf(cq->strip,"{\\pnno}");			      break;
      case 0x1: fprintf(cq->strip,"{\\pntl}"); PgNumType="TopLeft";   break;
      case 0x2: fprintf(cq->strip,"{\\pntc}"); PgNumType="TopCenter"; break;
      case 0x3: fprintf(cq->strip,"{\\pntr}"); PgNumType="TopRight";  break;
      case 0x4: fprintf(cq->strip,"{\\pnat}");
		PgNumType="TopAlt";
		twoside=true; 					    break;
      case 0x5: fprintf(cq->strip,"{\\pnbl}"); PgNumType="BotLeft";   break;
      case 0x6: fprintf(cq->strip,"{\\pnbc}"); PgNumType="BotCenter"; break;
      case 0x7: fprintf(cq->strip,"{\\pnbr}"); PgNumType="BotRight";  break;
      case 0x8: fprintf(cq->strip,"{\\pnab}");
		PgNumType="BottomAlt";
		twoside=true; 					    break;
      case 0x9: fprintf(cq->strip,"{\\pnit}");
		PgNumType="TopAltInside";
		twoside=true; 					    break;
      case 0xA: fprintf(cq->strip,"{\\pnib}");
		PgNumType="BotAltInside";
		twoside=true; 					    break;

      default:  goto NoNumber;
      }
    }
  else
    {
    FancyHdr=1;
    switch (position_code)
      {
      case 0x0: PgNumType="No";
NoNumber_f:     fprintf(cq->strip,"\\fancyfoot{}\\fancyhead{}"); break;
      case 0x1: fprintf(cq->strip,"\\fancyhead{}\\fancyhead[L]{\\thepage}");
		PgNumType="TopLeft";   				     break;
      case 0x2: fprintf(cq->strip,"\\fancyhead{}\\fancyhead[C]{\\thepage}");
		PgNumType="TopCenter"; 				     break;
      case 0x3: fprintf(cq->strip,"\\fancyhead{}\\fancyhead[R]{\\thepage}");
		PgNumType="TopRight"; 				     break;
      case 0x4: fprintf(cq->strip,"\\fancyhead{}\\fancyhead[RO,LE]{\\thepage}");
		PgNumType="TopAlt";
		twoside=true; 					    break;
      case 0x5: fprintf(cq->strip,"\\fancyfoot{}\\fancyfoot[L]{\\thepage}");
		PgNumType="BotLeft";                                break;
      case 0x6: fprintf(cq->strip,"\\fancyfoot{}\\fancyfoot[C]{\\thepage}");
		PgNumType="BotCenter";                              break;
      case 0x7: fprintf(cq->strip,"\\fancyfoot{}\\fancyfoot[R]{\\thepage}");
		PgNumType="BotRight";                               break;
      case 0x8: fprintf(cq->strip,"\\fancyfoot{}\\fancyfoot[RO,LE]{\\thepage}");
		PgNumType="BottomAlt";
		twoside=true; 					    break;
      case 0x9: fprintf(cq->strip,"\\fancyhead{}\\fancyhead[LO,RE]{\\thepage}");
		PgNumType="TopAltInside";
		twoside=true; 					    break;
      case 0xA: fprintf(cq->strip,"\\fancyfoot{}\\fancyfoot[LO,RE]{\\thepage}");
		PgNumType="BotAltInside";
		twoside=true; 					    break;

      default:  goto NoNumber_f;
      }
    }

  sprintf(cq->ObjType, "Pg Numbering:%s",PgNumType);
}


/*This procedure makes placing endnotes here*/
void PlaceEndnotes(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#PlaceEndnotes() ");fflush(cq->log);
#endif
  if(EndNotes<0) return;
  EndNotes=2;		/* set up endnotes */

  Close_All_Attr(cq->attr,cq->strip);

  NewLine(cq);
  fprintf(cq->strip,"\\begingroup");
  NewLine(cq);
  fprintf(cq->strip,"\\parindent 0pt \\parskip 1ex");
  NewLine(cq);
  fprintf(cq->strip,"\\def\\enotesize{\\normalsize}");
  NewLine(cq);
  fprintf(cq->strip,"\\theendnotes");
  NewLine(cq);
  fprintf(cq->strip,"\\endgroup");
  NewLine(cq);

  strcpy(cq->ObjType, "Place Endnotes");
}


/*This procedure put mark for making index here*/
void PlaceIndex(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#PlaceIndex() ");fflush(cq->log);
#endif

  Index=true;
  cq->line_term = 's';   		/* Soft return */
  if(cq->char_on_line) NewLine(cq);
  if(MakeIdx>=false) MakeIdx=true;
  fprintf(cq->strip, "\\printindex	%%here should be placed index");
  NewLine(cq);
  strcpy(cq->ObjType, "Def Mark:Index");
}


/*Performs conversion for [row] in tables*/
void RowTable(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#RowTable() ");fflush(cq->log);
#endif

  if (cq->envir == 'B')
       {
       if(cq->char_on_line==true)
	 {
	 Close_All_Attr(cq->attr,cq->strip);
	 fprintf(cq->strip, " \\\\");
	 }
       fprintf(cq->strip, " \\hline\n");
       cq->line_term = 's';   /* Soft return */
       }
   else {
	cq->line_term = 'h';   /* Hard return */
	putc('\n', cq->strip);
	}

  Make_tableentry_envir_extra_end(cq);

  cq->char_on_line = false;
  cq->nomore_valid_tabs = false;
  cq->rownum++;
  Make_tableentry_attr(cq);
  cq->latex_tabpos = 0;

  strcpy(cq->ObjType, "Row");
}


void SetFont(TconvertedPass1 *cq, int PointSize, const char *FontName)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SetFont(%d,%s) ",PointSize,chk(FontName));fflush(cq->log);
#endif
int i;
string TexFontName(FontName);
const char *FontTblItem;

 if(FontName!=NULL)
   {
   TexFontName="WP:"+TexFontName;
   for(i=0;i<length(FontTable);i++)	//Try to find LaTeX equivalent of WP font
	{
	if( (FontTblItem=FontTable[i])==NULL ) continue;
	if(strstr(FontTblItem,TexFontName())!=NULL)
		{
		if( (FontTblItem=strstr(FontTblItem,"TeX:"))==NULL ) continue;
		if(*FontTblItem==0) continue;
		TexFontName=FontTblItem+4;
		goto Found;
		}
	}
   TexFontName="";		/*Font name was not found in the table*/
   }

Found:
  if(NFSS)
    {
    i=0;
    Close_All_Attr(cq->attr,cq->strip);
    if(PointSize>0)
	{
	fprintf(cq->strip, "\\fontsize{%2.1f}{%2.1f}",float(PointSize)/50,float(PointSize+50)/50);
	i=1;
	}
    if(FontName != NULL)
      if(TexFontName != "")
	{
	fprintf(cq->strip,"\\fontshape{%s}",TexFontName());
	i|=2;
	}
    if(i>0) fprintf(cq->strip,"\\selectfont ");
    }
}


void SetFontSize(TconvertedPass1 *cq, char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SetFontSize() ");fflush(cq->log);
#endif
WORD  PointSize;
char *ig="!";

  if(WP==4) {
	    fseek(cq->wpd, 2l, SEEK_CUR);
	    PointSize=50*fgetc(cq->wpd);
	    }
  if(WP==5) {
	    fseek(cq->wpd, 28l, SEEK_CUR);
	    Rd_word(cq->wpd,&PointSize);
	    }
  if(WP==6) {
	    fseek(cq->wpd,  6l, SEEK_CUR);
	    Rd_word(cq->wpd,&PointSize);
	    }

  SetFont(cq,PointSize,NULL);
  if(NFSS) ig="";

  sprintf(cq->ObjType, "%sFont %2.2f",ig,float(PointSize)/50);
}


/*This procedure changes the number of current footnote*/
void SetFootnoteNum(TconvertedPass1 *cq, signed char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SetFootnoteNum() ");fflush(cq->log);
#endif
  WORD OldFootnoteNum,CurFootnoteNum;
  BYTE Flag,NumID;


  switch(WP)
    {
    case -4:RdWORD_HiEnd(&CurFootnoteNum, cq->wpd);/* obsolette set Footnote Num WP4.x*/
	    break;
    case 4:RdWORD_HiEnd(&OldFootnoteNum, cq->wpd);
	   RdWORD_HiEnd(&CurFootnoteNum, cq->wpd);/* bit 7 of second byte doesn't count, and the value */
	   break;                                 /* is offset by one.  */
    case 5:Rd_word(cq->wpd, &OldFootnoteNum);
	   Rd_word(cq->wpd, &CurFootnoteNum);
	   break;
    case 6:Flag=getc(cq->wpd);
	   if(Flag & 0x80) NumID=getc(cq->wpd);
		      else NumID=0;
	   fseek(cq->wpd,2l*NumID + 4,SEEK_CUR);
	   Rd_word(cq->wpd, &CurFootnoteNum);
	   CurFootnoteNum--;
	   break;
    default:return;
    }


  fprintf(cq->strip, "\\setcounter{footnote}{%u}",(unsigned)CurFootnoteNum);
  sprintf(cq->ObjType, "Footnote Num:%u",(unsigned)CurFootnoteNum);
}


/*This procedure changes the number of current page*/
void SetPgNum(TconvertedPass1 *cq, unsigned char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SetPgNum() ");fflush(cq->log);
#endif
  WORD OldPgNum,CurPgNum;

  switch(WP)
    {
    case 4:RdWORD_HiEnd(&OldPgNum, cq->wpd);
	   RdWORD_HiEnd(&CurPgNum, cq->wpd);
	   break;
    case 5:Rd_word(cq->wpd, &OldPgNum);
	   Rd_word(cq->wpd, &CurPgNum);
	   break;
    case 6:fseek(cq->wpd,5l,SEEK_CUR);
	   Rd_word(cq->wpd, &CurPgNum);
	   fseek(cq->wpd,1l,SEEK_CUR);
	   Rd_word(cq->wpd, &OldPgNum);
	   break;
//  defalut:return;
    }

  fprintf(cq->strip, "\\setcounter{page}{%u}",(int)CurPgNum);
  sprintf(cq->ObjType, "Pg Num:%u",(int)CurPgNum);
}


void SoftHyphen(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SoftHyphen() ");fflush(cq->log);
#endif

 fputs("\\-", cq->strip);

 strcpy(cq->ObjType, "- Soft Hyphen");
}


void SoftReturn(TconvertedPass1 *cq)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#SoftReturn() ");fflush(cq->log);
#endif

 if(cq->envir == 'B')		// Hard return
	{
	Close_All_Attr(cq->attr,cq->strip);
/*	if ((LaTeX_Version & 0xFF00) >= 0x300)
	     fputs(" \\tabularnewline ", cq->strip);
	else */
	     fputs(" \\penalty-10001 ", cq->strip);
	return;
	}
    else Terminate_Line(cq,'s');

  strcpy(cq->ObjType, "SRt");
}


void StartSection(TconvertedPass1 *cq, signed char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#StartSection() ");fflush(cq->log);
#endif
  unsigned char b;
  int i;

  if(WP>0)
      {
      if(WP==6)fseek(cq->wpd, 3L, SEEK_CUR);
      fread(&b, sizeof(unsigned char), 1, cq->wpd);   /* less attribute-code */
      }
  else b=abs(WP); // direct set

  sprintf(cq->ObjType, "Start MarkToC %d",(int)b);

			/* check whether any section is already opened */
  for (i = 0; i < cq->attr.Closed_Depth; i++)
	{
	if(cq->attr.stack[i] >= First_com_section &&
	   cq->attr.stack[i] <= Last_com_section)
	     {
	     if (cq->err != NULL)
	       {
	       cq->perc.Hide();
	       fprintf(cq->err, _("\nWarning: Double MarkToC inside %d, second one will be ignored!"),(int)b);
	       }
	     return;
	     }
	}


  if (cq->FirstSection > 100)
	{			   /*setup for 1'st section in the document*/
	cq->FirstSection = 0;
	if (b == 1) cq->FirstSection = 1;
	}
  if (b > 0) b -= cq->FirstSection;

  b += OutputStyle;
  if (b > Last_com_section) return;

  if(cq->envir!='B') NewLine(cq);

  if(OptimizeSection && cq->envir!='B')
	{
	AttrOn(cq->attr,b);
			//move section attribute on the first place
	if(cq->attr.Closed_Depth>1)
		{
		Close_All_Attr(cq->attr,cq->strip);
		cq->attr.stack[cq->attr.Closed_Depth-1]=cq->attr.stack[0];
		cq->attr.stack[0]=b;
		}

	}
   else {
	fprintf(cq->strip, "\\addcontentsline{toc}{%s}",Parts[b-First_com_section]);
	AttrOn(cq->attr,Last_com_section+1);
	}
}


void Suppress(TconvertedPass1 *cq, char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Suppress() ");fflush(cq->log);
#endif
  BYTE SupType;
  BYTE HA,HB,FA,FB,ForceNum;
  char *suppress="!";

  if(WP==5) fseek(cq->wpd,1l,SEEK_CUR);
  if(WP==6) fseek(cq->wpd,3l,SEEK_CUR);
  SupType=fgetc(cq->wpd);

  switch(WP)
	{
	case 4:HA = SupType & 0x10;
	       HB = SupType & 0x20;
	       FA = SupType & 0x40;
	       FB = SupType & 0x20;
	       ForceNum = SupType & 0x04;
	       break;


	case 5://bit 0-NoPgNum; 1-ThisNum; 2-HeaderA; 3-HeaderB; 4-FooterA; 5-FooterB
	case 6://               for WP6.x  6-WatermarkA; 7-WatermarkB
	       HA = SupType & 0x04;
	       HB = SupType & 0x08;
	       FA = SupType & 0x10;
	       FB = SupType & 0x20;
	       ForceNum = SupType & 0x02;
	       break;

	default:return;
	}

  if( HA && HB && FA && FB)
    {
    fprintf(cq->strip, "\\thispagestyle{%s} ",ForceNum?"plain":"empty");
    suppress="";
    }

  sprintf(cq->ObjType,"%sSuppress:%s%s%s%s",suppress,HA?" HA":"",HB?" HB":"",FA?" FA":"",FB?" FB":"");
}


/*This Procedure converts [TAB] command*/
void Tab(TconvertedPass1 *cq, char WP)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Tab() ");fflush(cq->log);
#endif
  int j;
  WORD wpu;
  int tabnum, new_tabs, FORLIM;
  char *TabType="";

  if (cq->envir != 'I' && cq->envir != 'i' && cq->envir != 'B' && !cq->nomore_valid_tabs
		       && Tabs && Columns<2 )
    {   /* No indent or table --> normal tab */

/* TabType = 0-Left, 1-Full, 2-Center, 3-Right, 4-Aligned */
    switch(WP)
      {
      case 5:if (cq->subby == 0x48) {TabType=":Right";cq->tab_type = 3;}
	     if (cq->subby == 0x40) {TabType=":Aligned";cq->tab_type = 4;}
	     if (cq->subby == 0xc8) {TabType=":Centered";cq->tab_type = 2;}

	     fseek(cq->wpd, 2L, SEEK_CUR);
	     Rd_word(cq->wpd, &wpu);   /* less abs.-indent [wpu] */
	     break;

      case 6:if ((cq->subby >> 3) == 0x12) {TabType=":Right";cq->tab_type = 3;}
	     if ((cq->subby >> 3) == 0x02) cq->tab_type = 4;
	     if ((cq->subby >> 3) == 0x09) {TabType=":Centered";cq->tab_type = 2;}

	     fseek(cq->wpd, 3L, SEEK_CUR);
	     Rd_word(cq->wpd, &wpu);   /* less abs.-indent [wpu] */
	     break;

      default:goto NoTab;
      }


    if (wpu <= cq->WP_sidemargin)
       {
       if (cq->err != NULL)
	    {
	    cq->perc.Hide();
	    fprintf(cq->err, _("\nWarning: Negative tabular, fixed!"));
	    }
       wpu = cq->tabpos[0];   /*fix negative value*/
       }
     else wpu -= cq->WP_sidemargin;  /* Correctie ivm WP kantlijn */

    tabnum = 0;
    FORLIM = cq->num_of_tabs;
    for (j = 1; j <= FORLIM; j++)
        {   /* Bepaal welke tabpos */
        if (wpu >= cq->tabpos[j-1])
				tabnum = j;
	}

    new_tabs = tabnum - cq->latex_tabpos;

    for(j=0;j<cq->attr.Closed_Depth;j++)
    	{
	if(cq->attr.stack[j]>=0x10 && cq->attr.stack[j]<=0x13)
        	{		/* \section{ attribute found */
                fprintf(cq->strip, "\\hspace*{%2.2fcm} ", wpu / 470.0);   /*Right*/
                cq->char_on_line = true;
	        new_tabs = 0;
		goto SkipTabs;
		}
        }

    if ((cq->char_on_line<=false) && cq->envir != 'T')
        {
        if(new_tabs==0) new_tabs++;
        for (j = 1; j <= new_tabs; j++)
	        fprintf(cq->strip, "\\TAB ");
	cq->char_on_line = true;
        new_tabs = 0;
	}

    if (new_tabs > 0)
	{
        cq->envir = 'T';    /* This is one or more tabs in This row */
        Close_All_Attr(cq->attr,cq->strip);
        for (j = 1; j <= new_tabs; j++)
	        fprintf(cq->strip, "\\> ");
	if (cq->tab_type==2)
		fprintf(cq->strip, "\\ctab{");
	}

SkipTabs:
    cq->latex_tabpos = tabnum;
    } else {
NoTab:	   putc(' ', cq->strip);
	   strcpy(cq->ObjType, "!Tab");
	   return;
	   }


  sprintf(cq->ObjType,"Tab%s",TabType);
}


void Terminate_Line(TconvertedPass1 *cq, char line_term)
{
#ifdef DEBUG
  fprintf(cq->log,"\n#Terminate_Line(%c) ",line_term);fflush(cq->log);
#endif
  cq->line_term = line_term;
/*       'h';   Hard return
	 's';   Soft return
	 'P';   Hard page
	 'p';   Soft page */

  if(cq->CentrePage && (line_term=='p' || line_term=='P'))
	{		/* finish page centering */
	fprintf(cq->strip, "\\vfil ");
	cq->CentrePage=false;
	}
  putc('\n', cq->strip);

  Make_tableentry_envir_extra_end(cq);

  if((line_term=='h' || line_term=='P')&&(toupper(cq->envir) == 'I'))
	{
	cq->indent_end=true;  /* enforce End of indent on [HRt] and [Hpg] */
	}

  if (cq->indent_end)
      {
      cq->envir = ' ';
      cq->indenting = 0;
      cq->ind_text1 = false;
      cq->ind_leftmargin = 0;
      cq->ind_rightmargin = 0;

      cq->indent_end = false;
      }
   else if (cq->envir != ' ' &&
	    cq->envir != 'R' && cq->envir != 'L' && cq->envir != 'C' &&
	    cq->envir != 'I' && cq->envir != 'i' && cq->envir != 'B')
		{	// turn off one line long enviroments
		if( (cq->envir == 'c' || cq->envir == 'T')
		     && cq->char_on_line == true)
			{
			cq->char_on_line = -20;
			cq->envir = ' ';
			goto NoSetCharOnLine;
			}
		cq->envir = ' ';
		}

  cq->char_on_line = false;
NoSetCharOnLine:
  cq->nomore_valid_tabs = false;

  cq->rownum++;

  Make_tableentry_attr(cq);

  cq->latex_tabpos = 0;
}


/*--------------------End of PASS1--------------------*/
