#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <ctype.h>
#include <strings.h>

#include"wp2latex.h"
#include "rtf.h"


void AttrFit(attribute & Base, attribute & A_New, string & s);

typedef class TconvertedPass1_RTF:public TconvertedPass1
       {
public:string Keyword,Parameter;
       char KeywordType;
       boolean isParam;
       long lParam;
       float fParam;


       RDS rds;
       RIS ris;

       CHP chp;
       PAP pap;
       SEP sep;
       DOP dop;
       int cGroup;
       boolean fSkipDestIfUnk;
       long cbBin;

       SAVE *psave;
       };


// RTF parser tables

// Property descriptions
PROP rgprop [ipropMax] = {
    actnByte,   propChp,    offsetof(CHP, fBold),       // ipropBold
    actnByte,   propChp,    offsetof(CHP, fItalic),     // ipropItalic
    actnByte,   propChp,    offsetof(CHP, fUnderline),  // ipropUnderline
    actnWord,   propPap,    offsetof(PAP, xaLeft),      // ipropLeftInd
    actnWord,   propPap,    offsetof(PAP, xaRight),     // ipropRightInd
    actnWord,   propPap,    offsetof(PAP, xaFirst),     // ipropFirstInd
    actnWord,   propSep,    offsetof(SEP, cCols),       // ipropCols
    actnWord,   propSep,    offsetof(SEP, xaPgn),       // ipropPgnX
    actnWord,   propSep,    offsetof(SEP, yaPgn),       // ipropPgnY
    actnWord,   propDop,    offsetof(DOP, xaPage),      // ipropXaPage
    actnWord,   propDop,    offsetof(DOP, yaPage),      // ipropYaPage
    actnWord,   propDop,    offsetof(DOP, xaLeft),      // ipropXaLeft
    actnWord,   propDop,    offsetof(DOP, xaRight),     // ipropXaRight
    actnWord,   propDop,    offsetof(DOP, yaTop),       // ipropYaTop
    actnWord,   propDop,    offsetof(DOP, yaBottom),    // ipropYaBottom
    actnWord,   propDop,    offsetof(DOP, pgnStart),    // ipropPgnStart
    actnByte,   propSep,    offsetof(SEP, sbk),         // ipropSbk
    actnByte,   propSep,    offsetof(SEP, pgnFormat),   // ipropPgnFormat
    actnByte,   propDop,    offsetof(DOP, fFacingp),    // ipropFacingp
    actnByte,   propDop,    offsetof(DOP, fLandscape),  // ipropLandscape
    actnByte,   propPap,    offsetof(PAP, just),        // ipropJust
    actnSpec,   propPap,    0,                          // ipropPard
    actnSpec,   propChp,    0,                          // ipropPlain
    actnSpec,   propSep,    0,                          // ipropSectd
};

// Keyword descriptions
SYM rgsymRtf[] = {
//  keyword     dflt    fPassDflt   kwd         idx
    "b",        1,      false,     kwdProp,    ipropBold,
    "u",        1,      false,     kwdProp,    ipropUnderline,
    "i",        1,      false,     kwdProp,    ipropItalic,
    "li",       0,      false,     kwdProp,    ipropLeftInd,
    "ri",       0,      false,     kwdProp,    ipropRightInd,
    "fi",       0,      false,     kwdProp,    ipropFirstInd,
    "cols",     1,      false,     kwdProp,    ipropCols,
    "sbknone",  sbkNon, true,      kwdProp,    ipropSbk,
    "sbkcol",   sbkCol, true,      kwdProp,    ipropSbk,
    "sbkeven",  sbkEvn, true,      kwdProp,    ipropSbk,
    "sbkodd",   sbkOdd, true,      kwdProp,    ipropSbk,
    "sbkpage",  sbkPg,  true,      kwdProp,    ipropSbk,
    "pgnx",     0,      false,     kwdProp,    ipropPgnX,
    "pgny",     0,      false,     kwdProp,    ipropPgnY,
    "pgndec",   pgDec,  true,      kwdProp,    ipropPgnFormat,
    "pgnucrm",  pgURom, true,      kwdProp,    ipropPgnFormat,
    "pgnlcrm",  pgLRom, true,      kwdProp,    ipropPgnFormat,
    "pgnucltr", pgULtr, true,      kwdProp,    ipropPgnFormat,
    "pgnlcltr", pgLLtr, true,      kwdProp,    ipropPgnFormat,
    "qc",       justC,  true,      kwdProp,    ipropJust,
    "ql",       justL,  true,      kwdProp,    ipropJust,
    "qr",       justR,  true,      kwdProp,    ipropJust,
    "qj",       justF,  true,      kwdProp,    ipropJust,
    "paperw",   12240,  false,     kwdProp,    ipropXaPage,
    "paperh",   15480,  false,     kwdProp,    ipropYaPage,
    "margl",    1800,   false,     kwdProp,    ipropXaLeft,
    "margr",    1800,   false,     kwdProp,    ipropXaRight,
    "margt",    1440,   false,     kwdProp,    ipropYaTop,
    "margb",    1440,   false,     kwdProp,    ipropYaBottom,
    "pgnstart", 1,      true,      kwdProp,    ipropPgnStart,
    "facingp",  1,      true,      kwdProp,    ipropFacingp,
    "landscape",1,      true,      kwdProp,    ipropLandscape,
    "par",      0,      false,     kwdChar,    0x0a,
    "\0x0a",    0,      false,     kwdChar,    0x0a,
    "\0x0d",    0,      false,     kwdChar,    0x0a,
    "tab",      0,      false,     kwdChar,    0x09,
    "ldblquote",0,      false,     kwdChar,    '"',
    "rdblquote",0,      false,     kwdChar,    '"',
    "bin",      0,      false,     kwdSpec,    ipfnBin,
    "*",        0,      false,     kwdSpec,    ipfnSkipDest,
    "'",        0,      false,     kwdSpec,    ipfnHex,
    "author",   0,      false,     kwdDest,    idestSkip,
    "buptim",   0,      false,     kwdDest,    idestSkip,
    "colortbl", 0,      false,     kwdDest,    idestSkip,
    "comment",  0,      false,     kwdDest,    idestSkip,
    "creatim",  0,      false,     kwdDest,    idestSkip,
    "doccomm",  0,      false,     kwdDest,    idestSkip,
    "fonttbl",  0,      false,     kwdDest,    idestSkip,
    "footer",   0,      false,     kwdDest,    idestSkip,
    "footerf",  0,      false,     kwdDest,    idestSkip,
    "footerl",  0,      false,     kwdDest,    idestSkip,
    "footerr",  0,      false,     kwdDest,    idestSkip,
    "footnote", 0,      false,     kwdDest,    idestSkip,
    "ftncn",    0,      false,     kwdDest,    idestSkip,
    "ftnsep",   0,      false,     kwdDest,    idestSkip,
    "ftnsepc",  0,      false,     kwdDest,    idestSkip,
    "header",   0,      false,     kwdDest,    idestSkip,
    "headerf",  0,      false,     kwdDest,    idestSkip,
    "headerl",  0,      false,     kwdDest,    idestSkip,
    "headerr",  0,      false,     kwdDest,    idestSkip,
    "info",     0,      false,     kwdDest,    idestSkip,
    "keywords", 0,      false,     kwdDest,    idestSkip,
    "operator", 0,      false,     kwdDest,    idestSkip,
    "pict",     0,      false,     kwdDest,    idestSkip,
    "printim",  0,      false,     kwdDest,    idestSkip,
    "private1", 0,      false,     kwdDest,    idestSkip,
    "revtim",   0,      false,     kwdDest,    idestSkip,
    "rxe",      0,      false,     kwdDest,    idestSkip,
    "stylesheet",   0,      false,     kwdDest,    idestSkip,
    "subject",  0,      false,     kwdDest,    idestSkip,
    "tc",       0,      false,     kwdDest,    idestSkip,
    "title",    0,      false,     kwdDest,    idestSkip,
    "txe",      0,      false,     kwdDest,    idestSkip,
    "xe",       0,      false,     kwdDest,    idestSkip,
    "{",        0,      false,     kwdChar,    '{',
    "}",        0,      false,     kwdChar,    '}',
    "\\",       0,      false,     kwdChar,    '\\'
    };
int isymMax = sizeof(rgsymRtf) / sizeof(SYM);


// Set a property that requires code to evaluate.
int ecParseSpecialProperty(TconvertedPass1_RTF *cq,IPROP iprop, int val)
{
  switch (iprop)
    {
    case ipropPard:
	memset(&cq->pap, 0, sizeof(cq->pap));
	return ecOK;
    case ipropPlain:
	memset(&cq->chp, 0, sizeof(cq->chp));
	return ecOK;
    case ipropSectd:
	memset(&cq->sep, 0, sizeof(cq->sep));
	return ecOK;
    default:
	return ecBadTable;
    }
  return ecBadTable;
}


// Set the property identified by _iprop_ to the value _val_.
int ecApplyPropChange(TconvertedPass1_RTF *cq,IPROP iprop, int val)
{
char *pb;

  if (cq->rds == rdsSkip)                 // If we're skipping text,
	return ecOK;                    // don't do anything.

  switch (rgprop[iprop].prop)
    {
    case propDop: pb = (char *)&cq->dop;
		  break;
    case propSep: pb = (char *)&cq->sep;
		  break;
    case propPap: pb = (char *)&cq->pap;
		  break;
    case propChp: pb = (char *)&cq->chp;
		  break;
    default: if (rgprop[iprop].actn != actnSpec) return ecBadTable;
	     break;
    }
  switch (rgprop[iprop].actn)
    {
    case actnByte: pb[rgprop[iprop].offset] = (unsigned char) val;
		   break;
    case actnWord: (*(int *) (pb+rgprop[iprop].offset)) = val;
		   break;
    case actnSpec: return ecParseSpecialProperty(cq,iprop, val);
    default:       return ecBadTable;
    }
  return ecOK;
}


// Change to the destination specified by idest.
// There's usually more to do here than this...
static int ecChangeDest(TconvertedPass1_RTF *cq,IDEST idest)
{
  if (cq->rds == rdsSkip)             // if we're skipping text,
        return ecOK;                // don't do anything

  switch (idest)
    {
    default:cq->rds = rdsSkip;              // when in doubt, skip it...
	    break;
    }
  return ecOK;
}


// Send a character to the output file.
static int ecPrintChar(TconvertedPass1_RTF *cq,const char *LatexCode)
{
  if(LatexCode==NULL) return(ecOK);
// unfortunately, we don't do a whole lot here as far as layout goes...

  CharacterStr(cq,LatexCode);
  return ecOK;
}


// Route the character to the appropriate destination stream.
static int ecParseChar(TconvertedPass1_RTF *cq,int ch)
{
  if (cq->ris == risBin && --cq->cbBin <= 0)
	       cq->ris = risNorm;
  switch (cq->rds)
    {
    case rdsSkip: return ecOK;  // Toss this character.
    case rdsNorm:switch(ch)  // Output a character.  Properties are valid at this point.
		   {
		   case  9:return ecPrintChar(cq,"\t");
		   case 10:
		   case 13:if(cq->char_on_line==true) NewLine(cq);
			   break;
		   default:return ecPrintChar(cq,Ext_chr_str(0, ch, cq));
		   }
    default:      // handle other destinations....
		  return ecOK;
    }
}


// Evaluate an RTF control that needs special processing.
int ecParseSpecialKeyword(TconvertedPass1_RTF *cq,IPFN ipfn)
{
    if (cq->rds == rdsSkip && ipfn != ipfnBin)  // if we're skipping, and it's not
        return ecOK;                        // the \bin keyword, ignore it.
    switch (ipfn)
    {
    case ipfnBin:
	  cq->ris = risBin;
	  cq->cbBin = cq->lParam;
	  break;
    case ipfnSkipDest:
	  cq->fSkipDestIfUnk = true;
	  break;
    case ipfnHex:
	  cq->ris = risHex;
	  break;
    default:return ecBadTable;
    }
    return ecOK;
}



// Step 3.
// Search rgsymRtf for szKeyword and evaluate it appropriately.
//
// Inputs:
// szKeyword:   The RTF control to evaluate.
// param:       The parameter of the RTF control.
// fParam:      true if the control had a parameter; (i.e., if param is valid)
//              false if it did not.
int ecTranslateKeyword(TconvertedPass1_RTF *cq,const char *szKeyword, int param, bool fParam)
{
int isym;

// search for szKeyword in rgsymRtf

  for (isym = 0; isym < isymMax; isym++)
        if (strcmp(szKeyword, rgsymRtf[isym].szKeyword) == 0)
            break;
  if (isym == isymMax)            // control word not found
    {
	if (cq->fSkipDestIfUnk)         // if this is a new destination
	    cq->rds = rdsSkip;          // skip the destination
				    // else just discard it
	cq->fSkipDestIfUnk = false;
	return ecOK;
    }

// found it!  use kwd and idx to determine what to do with it.

  cq->fSkipDestIfUnk = false;
  switch (rgsymRtf[isym].kwd)
    {
    case kwdProp:
        if (rgsymRtf[isym].fPassDflt || !fParam)
            param = rgsymRtf[isym].dflt;
	return ecApplyPropChange(cq,(IPROP)rgsymRtf[isym].idx, param);
    case kwdChar:
	return ecParseChar(cq,rgsymRtf[isym].idx);
    case kwdDest:
	return ecChangeDest(cq,(IDEST)rgsymRtf[isym].idx);
    case kwdSpec:
	return ecParseSpecialKeyword(cq,(IPFN)rgsymRtf[isym].idx);
    default:
	return ecBadTable;
    }
  return ecBadTable;
}


// The destination specified by rds is coming to a close.
// If there's any cleanup that needs to be done, do it now.
static int ecEndGroupAction(RDS rds)
{
    return ecOK;
}


// Save relevant info on a linked list of SAVE structures.
static int ecPushRtfState(TconvertedPass1_RTF *cq)
{
    SAVE *psaveNew = (SAVE *)malloc(sizeof(SAVE));
    if (!psaveNew)
	{
	fprintf(cq->err,_("\nError: Not enough memory!"));
	return ecStackOverflow;
	}

    psaveNew->pNext = cq->psave;
    psaveNew->CharA = cq->attr;
    psaveNew->pap = cq->pap;
    psaveNew->sep = cq->sep;
    psaveNew->dop = cq->dop;
    psaveNew->rds = cq->rds;
    psaveNew->ris = cq->ris;
    cq->ris = risNorm;
    cq->psave = psaveNew;
    cq->cGroup++;
    return ecOK;
}


// If we're ending a destination (i.e., the destination is changing),
// call ecEndGroupAction.
// Always restore relevant info from the top of the SAVE list.
static int ecPopRtfState(TconvertedPass1_RTF *cq)
{
    SAVE *psaveOld;
    string s;
    int ec;

    if (!cq->psave)
	{
	fprintf(cq->err,_("\nError: Curly brace stack '}' underflow!"));
	return ecStackUnderflow;
	}

    if (cq->rds != cq->psave->rds)
	{
	if ((ec = ecEndGroupAction(cq->rds)) != ecOK)
	    return ec;
	}

    AttrFit(cq->attr,cq->psave->CharA,s);
    if(s!="") fprintf(cq->strip,s());

    cq->pap = cq->psave->pap;
    cq->sep = cq->psave->sep;
    cq->dop = cq->psave->dop;
    cq->rds = cq->psave->rds;
    cq->ris = cq->psave->ris;

    psaveOld = cq->psave;
    cq->psave = cq->psave->pNext;
    cq->cGroup--;
    free(psaveOld);
    return ecOK;
}


// Step 2:Get a control word (and it's associated value) and
//        call ecTranslateKeyword to dispatch the control.
static int ecParseRtfKeyword(TconvertedPass1_RTF *cq)
{
int ch;
char fParam = false;
int param = 0;

 cq->Keyword = cq->Parameter = "";
 if ((ch = getc(cq->wpd)) == EOF)
	return ecEndOfFile;
 if (!isalpha(ch))           // a control symbol; no delimiter.
      {
      cq->Keyword = (char) ch;
      return ecTranslateKeyword(cq,cq->Keyword(), 0, fParam);
      }
 while(isalpha(ch))
	{
	cq->Keyword += (char) ch;
	ch = getc(cq->wpd);
	}

 if (ch == '-')
       {
       cq->Parameter = (char) ch;
       if ((ch = getc(cq->wpd)) == EOF)
	    return ecEndOfFile;
       }
 if (isdigit(ch))
      {
      fParam = true;         // a digit after the control means we have a parameter
      while(isdigit(ch))
         {
	 cq->Parameter += (char) ch;
	 ch = getc(cq->wpd);
	 }
      param = atoi(cq->Parameter());
      cq->lParam = atol(cq->Parameter());
      }
 if (ch != ' ')
	ungetc(ch, cq->wpd);
 return ecTranslateKeyword(cq,cq->Keyword(), param, fParam);
}


//returns 0 - EOF;1-Binary;2-unknown;3-Bad Hex
//        0xA;0xD - EOL;200-{;201-};202-keyword no arg;203-wrong arg;204-keyword+arg;205-character;206-HEX
static int RTFLoadKeyword(TconvertedPass1_RTF *cq)
{
int ch;

 cq->isParam=false;
 if ((ch = getc(cq->wpd)) == EOF) return(0); //no Keyword
 cq->by=ch;

 if (cq->ris == risBin)
	{
	cq->Keyword=(char)ch;
	return(1);	// if we're parsing binary data, handle it directly
	}

 if(ch==0xD || ch==0xA) return(ch);

 if(ch=='{') return(200);
 if(ch=='}') return(201);

 if(ch=='\\')
	{
	cq->Keyword = cq->Parameter = "";
	if ((ch = getc(cq->wpd)) == EOF) return(0);
	if (!isalpha(ch))           // a control symbol; no delimiter.
	     {
	     cq->Keyword = (char) ch;
	     return(202);  // ecTranslateKeyword(cq,cq->Keyword(), 0, fParam);
	     }
	while(isalpha(ch))
	       {
	       cq->Keyword += (char) ch;
	       ch = getc(cq->wpd);
	       }
	if (ch == '-')
	      {
	      cq->Parameter = (char) ch;
	      if ((ch = getc(cq->wpd)) == EOF)
		   {
		   ungetc(*cq->Parameter(), cq->wpd);
		   cq->Parameter = "";
		   return(203);		//unexpected EOF
		   }
	      }
	if (isdigit(ch))
	     {
	     cq->isParam = true;         // a digit after the control means we have a parameter
	     while(isdigit(ch))
		{
		cq->Parameter += (char) ch;
		ch = getc(cq->wpd);
		}
	     cq->fParam = atoi(cq->Parameter());
	     cq->lParam = atol(cq->Parameter());
	     }
	if (ch != ' ')
	       ungetc(ch, cq->wpd);
	return(204); // ecTranslateKeyword(cq,cq->Keyword(), param, fParam);
	}

if (cq->ris == risNorm) return(205);	//if ((ec = ecParseChar(cq,ch)) != ecOK)

if (cq->ris != risHex) return(2);

if (isdigit(ch)) cq->by = (char) ch - '0';
else {
     if (ch >= 'a' && ch <= 'f') cq->by = (char) ch - 'a';
	 else if (ch >= 'A' && ch <= 'F') cq->by = (char) ch - 'A';
	      else return(3);
     }
if ((ch = getc(cq->wpd)) == EOF) return(206);
cq->by = cq->by << 4;
if (isdigit(ch)) cq->by |= (char) ch - '0';
else {
     if (ch >= 'a' && ch <= 'f') cq->by |= (char) ch - 'a';
	 else if (ch >= 'A' && ch <= 'F') cq->by |= (char) ch - 'A';
	      else {
		   ungetc(ch, cq->wpd);
		   return(206);
		   }
     }
return(206);
}


// Step 1:
// Isolate RTF keywords and send them to ecParseRtfKeyword;
// Push and pop state at the start and end of RTF groups;
// Send text to ecParseChar for further processing.
static int ecRtfParse(TconvertedPass1_RTF *cq)
{
int ec;
int KeywordType;

  if (cq->cGroup < 0) return ecStackUnderflow;

  KeywordType=RTFLoadKeyword(cq);


  switch(KeywordType)
     {
     case 0:return ecOK;	 		    //EOF;
     case 1:if ((ec = ecParseChar(cq,cq->by)) != ecOK)  //Binary; if we're parsing binary data, handle it directly
		return ec;
	    goto RTFnext;
     case 2:if ((ec = ecParseChar(cq,cq->by)) != ecOK)  //unknown;
			return ec;
	    break;
     case 3:return ecInvalidHex;		    //Bad Hex
     case 0xA:
     case 0xD:if(cq->char_on_line==true) NewLine(cq);
		      break;          // cr and lf are noise characters...    - EOL;
     case 200:if ((ec = ecPushRtfState(cq)) != ecOK)	// {
			 return ec;
	      break;
     case 201:if ((ec = ecPopRtfState(cq)) != ecOK)	 // }
			 return ec;
	       break;
     case 202:				 //keyword no arg
     case 203:				 //wrong arg
     case 204:strncpy(cq->ObjType+1,cq->Keyword,sizeof(cq->ObjType)-1);
	      *(cq->ObjType)='/';

	      if(cq->Keyword=='~')
		  {
		  fputc('~', cq->strip);
		  break;
		  }
	      if(cq->Keyword=='b')
		  {
		  if(cq->lParam) AttrOn(cq->attr,12);	/* Start boldface */
			    else AttrOff(cq,12);	/* End boldface */
		  break;
		  }
	      if(cq->Keyword=='i')
		  {
		  if(cq->lParam) AttrOn(cq->attr,8);	/* Start italic */
			    else AttrOff(cq,8);		/* End italic */
		  break;
		  }
	      if(cq->Keyword=="outl")
		  {
		  if(cq->lParam) AttrOn(cq->attr,7);	/* Start underline */
			    else AttrOff(cq,7);		/* End underline */
		  break;
		  }
	      if(cq->Keyword=="page")
		  {
		  Terminate_Line(cq,'P');		/* Hard page */
		  break;
		  }
	      if(cq->Keyword=="par")
		  {
		  if(cq->char_on_line) Terminate_Line(cq, 'h');	/* Hard return */
		  Terminate_Line(cq, 'h');
		  break;
		  }
	      if(cq->Keyword=="scaps")
		  {
		  if(cq->lParam) {AttrOn(cq->attr,15);strcpy(cq->ObjType, "und");}  /* Start small capitals */
			    else {AttrOff(cq,15);strcpy(cq->ObjType, "~und");}	  /* End small capitals */
		  break;
		  }
	      if(cq->Keyword=="shad")
		  {
		  if(cq->lParam) {AttrOn(cq->attr,9);strcpy(cq->ObjType, "und");}  /* Start underline */
			    else {AttrOff(cq,9);strcpy(cq->ObjType, "~und");}	   /* End underline */
		  break;
		  }
	      if(cq->Keyword=="softpage")
		  {
		  Terminate_Line(cq,'p');		/* Soft page */
		  break;
		  }
	      if(cq->Keyword=="strike")
		  {
		  if(cq->lParam) {AttrOn(cq->attr,13);strcpy(cq->ObjType, "und");} /* Start strike out */
			    else {AttrOff(cq,13);strcpy(cq->ObjType, "~und");}	   /* End strike out */
		  break;
		  }
	      if(cq->Keyword=="sub")
		  {
		  if(cq->lParam) AttrOn(cq->attr,6);	/* Start subscript */
			    else AttrOff(cq,6);		/* End subscript */
		  break;
		  }
	      if(cq->Keyword=="super")
		  {
		  if(cq->lParam) AttrOn(cq->attr,5);	/* Start superscript */
			    else AttrOff(cq,5);		/* End superscript */
		  break;
		  }
	      if(cq->Keyword=="ul")
		  {
		  if(cq->lParam) AttrOn(cq->attr,14);	/* Start underline */
			    else AttrOff(cq,14);	/* End underline */
		  break;
		  }
	      if(cq->Keyword=="uldb")
		  {
		  if(cq->lParam) AttrOn(cq->attr,11);	/* Start double underline */
			    else AttrOff(cq,11);	/* End double underline */
		  break;
		  }
	      if(cq->Keyword=="ulnone")
		  {
		  AttrOff(cq,14); AttrOff(cq,11);	/* End of all underlines */
		  break;
		  }

	      *(cq->ObjType)='!';
	      ecTranslateKeyword(cq,cq->Keyword(), cq->lParam, cq->isParam); //keyword+arg
	      break;
     case 205:if ((ec = ecParseChar(cq,cq->by)) != ecOK)	// character;
			return ec;
	      break;
     case 206:if ((ec = ecParseChar(cq,cq->by)) != ecOK)	// HEX
			    return ec;
	      break;
     }


RTFnext:
  cq->ActualPos = ftell(cq->wpd);
  return ecOK;
}



void Convert_pass1_RTF(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile)
{
#ifdef DEBUG
  fprintf(LogFile,"\n#Convert_pass1_RTF() ");fflush(LogFile);
#endif
  DWORD fsize;
  TconvertedPass1_RTF cq;
  int ec;


  if(Verbosing >= 1)
     printf(_("\n>>>RTF2LaTeX<<< Conversion program: From RTF to LaTeX Version 0.01\n"
	      "      Made by J.Fojtik  (Hosted on WP2LaTeX :))))\n\n"),
	    version);

  Table_Init(lat);

  InitAttr(cq.attr);
// cq.ConvertRTF = GetTranslator("htmlTOwp5");


  cq.wpd   = FileIn;
  cq.table = table;
  cq.strip = StripOut;
  cq.log   = LogFile;
  cq.err   = ErrorFile;

  WP_Default(&cq);


  cq.DocumentStart=ftell(cq.wpd);

  cq.envir = ' ';

  cq.nomore_valid_tabs = false;

  if (Verbosing >= 1)
	{
	printf(_("First pass RTF:\n"));
	printf(_("Converting-percentage: "));
	}

  fsize=filesize(cq.wpd);
  cq.perc.Init(ftell(cq.wpd), fsize );

  cq.rownum = 0;

  Make_tableentry_attr(&cq);    /* attribuut instelling */
  Make_tableentry_tabset(&cq);  /* Geef the defaulttabinstelling door */
				/* tied the 2e pass */

  cq.ris=risNorm;
  cq.rds=rdsNorm;
  cq.cGroup=0;
  cq.fSkipDestIfUnk=false;

  cq.ActualPos = ftell(cq.wpd);
  while (cq.ActualPos < fsize)
      {
      if(Verbosing >= 1)		//actualise a procentage counter
	      cq.perc.Actualise(cq.ActualPos);

      cq.Parameter = cq.Keyword = "";

      if((ec=ecRtfParse(&cq)) != ecOK) break;
      }

  if (cq.cGroup < 0) printf(_("Error:Stack Underflow while parsing rtf.\n"));
  if (cq.cGroup > 0) printf(_("Error:Unmatched brace while parsing rtf.\n"));


  cq.line_term = 's';			   /* Soft return */
  Make_tableentry_envir_extra_end(&cq);
  if(cq.CentrePage)    /* finish page centering */
	{
	fprintf(cq.strip, "\\vfil ");
	cq.CentrePage=false;
	}

  num_of_lines_stripfile = cq.rownum;

  if(Verbosing >= 1)		//finishing a procentage counter
     {
     cq.perc.SetPercent(100);
     putchar('\n');
     }
}

