/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.x files into LaTeX                      *
 * modul:       pass2.cc                                                      *
 * description: This modul contains functions for second pass. In the second  *
 *              pass the text file stripped from the WP binary file will be   *
 *              completed with the information of the binary table file which *
 *              contains additional information about environments.           *
 ******************************************************************************/
/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "pass2.pas" */

//Ukoly: podivat se na: \\justified \\raggedright

#include <string.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>

#include <strings.h>
#include <lists.h>
#include "wp2latex.h"

extern list Counters,UserLists;


typedef struct TLinePass2
  {
  string Lstring;
  boolean new_tabset;
  char envir, line_term;
  char Columns;
  signed char Empty;

  attribute attr;

  boolean InhibitBsBslash;

  int ind_leftmargin;
  signed char Indent_Level;
  } TLinePass2;

typedef long pchar;


typedef struct TconvertedPass2 {
  Percentor perc;
  long rownum;

  TLinePass2 Lines[3];

  boolean underline, illegal_argument, just_envir_closed;

  int num_of_tabs;
  unsigned short tabpos[40];

  int tabent_num_of_tabs[3];
  unsigned int tabent_tabpos[3][40];

  short int pre, cur, next;

  FILE *table;
  FILE *Strip, *LaTeX;
  FILE *log,*err;
  unsigned int  LineSpacing;
} TconvertedPass2;



void Open_All_Attr(attribute & a, string & s)
{
s="";
while(a.Opened_Depth<a.Closed_Depth)
	{
        s+=Open_com[a.stack[a.Opened_Depth++]];
        }
}

void Close_All_Attr(attribute & a, string & s)
{
s="";
while(a.Opened_Depth>0)
	{
        s+=Close_com[a.stack[--a.Opened_Depth]];
        }
}


static void Read_tableentry(short n, TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Read_tableentry() ");fflush(cq2->log);
#endif

  WORD w;
  BYTE b;
  int j, FORLIM;

  /* Begin met one schone lei die dan door this procedure verder wordt */
  /* opgevuld. */

  cq2->Lines[n].envir = ' ';
  cq2->Lines[n].new_tabset = false;

  InitAttr(cq2->Lines[n].attr);

  if (feof(cq2->table)) return;


  b = 0;
  while (b != 0xff)
    {
    if(fread(&b, 1, 1, cq2->table)==0) // We are probaly at the end of the file
		break;

    switch (b)
	{
	case 'B':cq2->Lines[n].envir = 'B';    break;
	case 'C':cq2->Lines[n].envir = 'C';    break;
	case 'L':cq2->Lines[n].envir = 'L';    break;
	case 'R':cq2->Lines[n].envir = 'R';    break;
	case 'T':cq2->Lines[n].envir = 'T';    break;
	case 'q':cq2->Lines[n].envir = 'q';    break;
	case 'Q':cq2->Lines[n].envir = 'Q';    break;
	case 'I':
	case 'i':cq2->Lines[n].envir=b;
		 Rd_word(cq2->table, &w);
		 cq2->Lines[n].ind_leftmargin=w;
		 fread(&cq2->Lines[n].Indent_Level, 1, 1, cq2->table);
		 break;

	case 'S':cq2->Lines[n].new_tabset = true;
		 fread(&b, 1, 1, cq2->table);
		 cq2->tabent_num_of_tabs[n] = b;

		 FORLIM = cq2->tabent_num_of_tabs[n];
		 for (j = 0; j < FORLIM; j++)
		     {
		     Rd_word(cq2->table, &w);
		     cq2->tabent_tabpos[n][j] = w;
		     }
		 break;

       case 'l': Rd_word(cq2->table, &w);
		 if(w!=cq2->LineSpacing)
			    {
			    fprintf(cq2->LaTeX,"\\baselineskip=%2.2fex ",float(w)/128);
			    cq2->LineSpacing=w;
			    }
		  break;

	case 'M':fread(&cq2->Lines[n].Columns, 1, 1, cq2->table);	break;

	case 'h':
	case 's':
	case 'P':
	case 'p':cq2->Lines[n].line_term = b;
		 break;

	case '!':cq2->Lines[n].envir = '!';    break; /* Ignore enviroment before */
	case '^':cq2->Lines[n].envir = '^';    break; /* Ignore enviroment after */

		    // Read all opened attributes into attr structure
	case 0xF0:fread(&b, 1, 1, cq2->table);
		  cq2->Lines[n].attr.Opened_Depth=cq2->Lines[n].attr.Closed_Depth = b;
		  for (j = 0; j < b; j++)
			fread(&(cq2->Lines[n].attr.stack[j]), 1, 1, cq2->table);
		  b=0xF0;
		  break;

	case 0xFF:
	case 10:
	case 13:break;               //do nothing

	default:if(cq2->err!=NULL)
		    fprintf(cq2->err,_("\nError: Bad command in table file:%c !"),b);
	}
  }
}


/* -- Make the standard-heading for one latex-file -- */
static void Latex_head(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Latex_head() ");fflush(cq2->log);
#endif
  int i;

  fprintf(cq2->LaTeX,_("%% This file was created by the WP2LaTeX program version: %s \n"), version );
  if(LaTeX_Version<0x300)
    {
    fprintf(cq2->LaTeX, "\\documentstyle[11pt,");
    if(Amssymb>=1)  fprintf(cq2->LaTeX, "amssymb,");
    if(MakeIdx>=1)  fprintf(cq2->LaTeX, "makeidx,");
    fprintf(cq2->LaTeX, "wp2latex");
    if(twoside>=1)  fprintf(cq2->LaTeX, ",twoside");
    if(Columns==2)  fprintf(cq2->LaTeX, ",twocolumn");
    if(Columns>2)   fprintf(cq2->LaTeX, ",multicol");
    if(EndNotes>=1) fprintf(cq2->LaTeX, ",endnotes");
    if(Cyrilic>=1)  fprintf(cq2->LaTeX, ",cyrillic");
    if(InputPS>=1)  fprintf(cq2->LaTeX, ",InputPS");
    if(Wasy>=1)     fprintf(cq2->LaTeX, ",wasyfont");
    if(textcomp>=1) fprintf(cq2->LaTeX, ",textcomp");
    if(Bbm>=1)      fprintf(cq2->LaTeX, ",bbm");
    if(Rsfs>=1)     fprintf(cq2->LaTeX, ",mathrsfs");
    if(FancyHdr>=1) fprintf(cq2->LaTeX, ",fancyhdr");
    if(LongTable>=1)fprintf(cq2->LaTeX, ",longtable");
    if(Czech>=1)    fprintf(cq2->LaTeX, ",czech");
    if(German>=1)   fprintf(cq2->LaTeX, ",german");
    fprintf(cq2->LaTeX, "]{article}\n\n");
    }
  else
    {
    fprintf(cq2->LaTeX, "\\documentclass[11pt");
    if(twoside>=1)  fprintf(cq2->LaTeX, ",twoside");
    if(Columns==2)  fprintf(cq2->LaTeX, ",twocolumn");
    fprintf(cq2->LaTeX, "]{article}\n");
    if(Amssymb>=1)  fprintf(cq2->LaTeX, "\\usepackage{amssymb}\n");
    if(LaTeXsym>=1) fprintf(cq2->LaTeX, "\\usepackage{latexsym}\n");
    if(MakeIdx>=1)  fprintf(cq2->LaTeX, "\\usepackage{makeidx}\n");
    fprintf(cq2->LaTeX, "\\usepackage{wp2latex}\n");
    if(CPStyles) switch(CodePage)
	{
	case 0: break;
	case ISO8859_1:fprintf(cq2->LaTeX, "\\usepackage[latin1]{inputenc}\n");
		       break;
	case ISO8859_2:fprintf(cq2->LaTeX, "\\usepackage[latin2]{inputenc}\n");
		       break;
	default:fprintf(cq2->LaTeX, "\\usepackage[cp%d]{inputenc}\n", CodePage);
		break;
	}
    if(colors>=1)   fprintf(cq2->LaTeX, "\\usepackage{color}\n");
    if(Cyrilic>=1)  fprintf(cq2->LaTeX, "\\usepackage{cyrillic}\n");
    if(EndNotes>=1) fprintf(cq2->LaTeX, "\\usepackage{endnotes}\n");
    if(InputPS>=1)  fprintf(cq2->LaTeX, "\\usepackage{InputPS}\n");
    if(Columns>2)   fprintf(cq2->LaTeX, "\\usepackage{multicol}\n");
    if(Wasy>=1)     fprintf(cq2->LaTeX, "\\usepackage{wasyfont}\n");
    if(textcomp>=1) fprintf(cq2->LaTeX, "\\usepackage{textcomp}\n");
    if(Bbm>=1)      fprintf(cq2->LaTeX, "\\usepackage{bbm}\n");
    if(Rsfs>=1)     fprintf(cq2->LaTeX, "\\usepackage{mathrsfs}\n");
    if(FancyHdr>=1) fprintf(cq2->LaTeX, "\\usepackage{fancyhdr}\n");
    if(LongTable>=1)fprintf(cq2->LaTeX, "\\usepackage{longtable}\n");
    if(Czech>=1)    fprintf(cq2->LaTeX, "\\usepackage{czech}\n");
    if(German>=1)   fprintf(cq2->LaTeX, "\\usepackage{german}\n");
    fputc('\n',cq2->LaTeX);
    }

/*if (Cyrilic) fprintf(cq2->LaTeX, "\\font\\cyr=wncyr10\n");*/
  if(Columns==2)fprintf(cq2->LaTeX, "\\onecolumn\n");
  if (Index)    fprintf(cq2->LaTeX, "\\makeindex\n");
  if(FancyHdr>=1) fprintf(cq2->LaTeX, "\\pagestyle{fancy}\\renewcommand{\\headrulewidth}{0pt}\n\\fancyfoot{}\\fancyhead{}\n");
  if(InputPS>=1)fprintf(cq2->LaTeX, "\\newcommand{\\FigDir}{%s}\n"
				   "\\ShowDisplacementBoxes\n",RelativeFigDir);

  fputc('\n',cq2->LaTeX);
  if(length(Counters)>0)
	{
	for(i=0;i<length(Counters);i++)
	    {
	    fprintf(cq2->LaTeX, "\\newcounter{%s}\n",chk(Counters[i]));
	    }
	fputc('\n',cq2->LaTeX);
	}


  for(i=0;i<length(UserLists);i++)
	{
	fprintf(cq2->LaTeX, "\\InitUserList{l%c}  %%%s\n",i+'a',UserLists[i]);
	}
  if(length(UserLists)>0) fputc('\n',cq2->LaTeX);

  fprintf(cq2->LaTeX, "\\begin{document}\n");
}


/* -- Sluit the latex-file op the juiste wijze af -- */
static void Latex_foot(TconvertedPass2 * cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Latex_foot() ");fflush(cq2->log);
#endif
  if(EndNotes==1) fprintf(cq2->LaTeX,
  	"\\begingroup\n"
        "\\parindent 0pt \\parskip 1ex\n"
	"\\def\\enotesize{\\normalsize}\n"
	"\\theendnotes\n"
	"\\endgroup\n\n");

  fprintf(cq2->LaTeX, "\\end{document}\n");
}


static void Latex_tabset(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Latex_tabset() ");fflush(cq2->log);
#endif

  long atpr = 0;
  long j;
  double l;
  double ol = 0.0;
  long FORLIM;

  /* Huiding aantal tabs per row */
  FORLIM = cq2->num_of_tabs;
  for (j = 0; j < FORLIM; j++)
     {
     l = cq2->tabpos[j] / 1200.0 * 2.54;
     fprintf(cq2->LaTeX, "\\hspace{%3.2fcm}\\=", l - ol);
     atpr++;
     if (atpr >= 4)
       {
       fprintf(cq2->LaTeX, "%%\n");
       atpr = 0;
       }
     ol = l;
     }
  fprintf(cq2->LaTeX, "\\kill\n");
}


static boolean Change_envir_BOL(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Change_envir_BOL() ");fflush(cq2->log);
#endif

  return (cq2->Lines[cq2->cur].envir != cq2->Lines[cq2->pre].envir &&
	  (cq2->Lines[cq2->cur].envir == 'q' ||
	   cq2->Lines[cq2->cur].envir == 'Q' ||
	   cq2->Lines[cq2->cur].envir == 'T' ||
	   cq2->Lines[cq2->cur].envir == 'C' ||
	   cq2->Lines[cq2->cur].envir == 'R' ||
	   cq2->Lines[cq2->cur].envir == 'L' ||
	   cq2->Lines[cq2->cur].envir == 'B' ||
	   toupper(cq2->Lines[cq2->cur].envir) == 'I' ) &&

	   cq2->Lines[cq2->pre].envir != '^');
//	   && cq2->Lines[cq2->cur].envir != '!'
}


static boolean Change_envir_EOL(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Change_envir_EOL() ");fflush(cq2->log);
#endif

  return (cq2->Lines[cq2->next].envir != cq2->Lines[cq2->cur].envir &&
	  (cq2->Lines[cq2->cur].envir == 'Q' ||
           cq2->Lines[cq2->cur].envir == 'q' ||
	   toupper(cq2->Lines[cq2->cur].envir) == 'I' ||
	   cq2->Lines[cq2->cur].envir == 'T' ||
	   cq2->Lines[cq2->cur].envir == 'C' ||
	   cq2->Lines[cq2->cur].envir == 'R' ||
	   cq2->Lines[cq2->cur].envir == 'L' ||
	   cq2->Lines[cq2->cur].envir == 'B' ||
	   cq2->Lines[cq2->next].envir == 'Q' ||
           cq2->Lines[cq2->next].envir == 'q' ||
	   toupper(cq2->Lines[cq2->next].envir) == 'I' ||
	   cq2->Lines[cq2->next].envir == 'T' ||
	   cq2->Lines[cq2->next].envir == 'C' ||
	   cq2->Lines[cq2->next].envir == 'R' ||
	   cq2->Lines[cq2->next].envir == 'L' ||
	   cq2->Lines[cq2->next].envir == 'B') &&

	   cq2->Lines[cq2->next].envir != '!' &&
	   cq2->Lines[cq2->cur].envir != '^');
}


static void Close_environment(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Close_environment() ");fflush(cq2->log);
#endif

 switch (cq2->Lines[cq2->cur].envir)
   {
  case 'B':if(LongTable>=1) fprintf(cq2->LaTeX, "\\end{longtable}\n");
		       else fprintf(cq2->LaTeX, "\\end{tabular}\n");
           break;

  case 'C':fprintf(cq2->LaTeX, "\\end{center}\n");
	   break;

  case 'L':fprintf(cq2->LaTeX, "\\end{flushleft}\n");
           break;

  case 'R':fprintf(cq2->LaTeX, "\\end{flushright}\n");
           break;

  case 'T':fprintf(cq2->LaTeX, "\\end{tabbing}\n");
	   break;

  case 'I':
  case 'i':fprintf(cq2->LaTeX, "\\end{indenting}\n");
           break;

  case 'q':fprintf(cq2->LaTeX, "\\end{eqnarray}\n");
           break;
  case 'Q':fprintf(cq2->LaTeX, "\\end{displaymath}\n");
           break;
  }

  cq2->just_envir_closed = true;
}


static boolean Open_environment(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Open_environment() ");fflush(cq2->log);
#endif
  string s;

  if(cq2->Lines[cq2->cur].Columns!=cq2->Lines[cq2->pre].Columns)
	{
	if (cq2->Lines[cq2->cur].attr.Opened_Depth>0)	 /* Attributes are opened */
	    {
	    Close_All_Attr(cq2->Lines[cq2->cur].attr,s);
	    cq2->Lines[cq2->cur].Lstring=s+cq2->Lines[cq2->cur].Lstring;
	    }
	if(!cq2->just_envir_closed) Close_environment(cq2);	//Close enviroment if still opened

	if(Columns>=3)	//style Multicol used
	  {
	  if(cq2->Lines[cq2->pre].Columns>1) fprintf(cq2->LaTeX,"\\end{multicols}\n");
	  if(cq2->Lines[cq2->cur].Columns>1) fprintf(cq2->LaTeX,"\\begin{multicols}{%d}\n",(int)cq2->Lines[cq2->cur].Columns);
	  }
	else
	  {
	  switch(cq2->Lines[cq2->cur].Columns)
	     {
	     case 0:
	     case 1:fprintf(cq2->LaTeX, "\\onecolumn\n"); break;
	     case 2:fprintf(cq2->LaTeX, "\\twocolumn\n"); break;
	     default:if(cq2->err!=NULL)
			fprintf(cq2->err,_("\nError: Bad number of columns:%d !"),(int)cq2->Lines[cq2->cur].Columns);
	     }
          }
	}


  if (!Change_envir_BOL(cq2))  /* Changed environment ? */
       {
       if (cq2->Lines[cq2->cur].new_tabset && cq2->Lines[cq2->cur].envir == 'T')
       Latex_tabset(cq2);
       return(false);
       }

  if (cq2->Lines[cq2->cur].attr.Opened_Depth>0)	 /* Attributes are opened */
	{
	Close_All_Attr(cq2->Lines[cq2->cur].attr,s);
	cq2->Lines[cq2->cur].Lstring=s+cq2->Lines[cq2->cur].Lstring;
	}

  switch (cq2->Lines[cq2->cur].envir)
    {
    case 'B':if(LongTable>=1) fprintf(cq2->LaTeX, "\\begin{longtable}\n");
			 else fprintf(cq2->LaTeX, "\\begin{tabular}\n");
	     break;

    case 'C':fprintf(cq2->LaTeX, "\\begin{center}\n");
	     break;

    case 'L':fprintf(cq2->LaTeX, "\\begin{flushleft}\n");
	     break;

    case 'R':fprintf(cq2->LaTeX, "\\begin{flushright}\n");
	     break;

    case 'T':fprintf(cq2->LaTeX, "\\begin{tabbing}\n");
	     Latex_tabset(cq2);
	     break;

    case 'I':
    case 'i':if(cq2->Lines[cq2->cur].Lstring=="")  //indent nothing ??
		 {
		 return(true);
                 }
	     if ((cq2->Lines[cq2->cur].Indent_Level<2)||(toupper(cq2->Lines[cq2->pre].envir)!='I'))
		      {
		      if(cq2->Lines[cq2->pre].Lstring!="")
					   fprintf(cq2->LaTeX,"\\testlastline\n\n");
                       		      else fprintf(cq2->LaTeX,"\\zerotestlastline\n");
                      }
             fprintf(cq2->LaTeX, "\\begin{indenting}"
                                 "{%3.2fcm}\n",cq2->Lines[cq2->cur].ind_leftmargin / 1200.0 * 2.54);
             break;

    case 'q':fprintf(cq2->LaTeX, "\\begin{eqnarray}\n");
	     break;
    case 'Q':fprintf(cq2->LaTeX, "\\begin{displaymath}\n");
	     break;
    }

return(false);
}






static void Update_global_information(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Update_global_information() ");fflush(cq2->log);
#endif
  int j, FORLIM;

  if (cq2->Lines[cq2->cur].new_tabset)
        {
        cq2->num_of_tabs = cq2->tabent_num_of_tabs[cq2->cur];
        FORLIM = cq2->num_of_tabs;
        for (j = 0; j < FORLIM; j++)
        cq2->tabpos[j] = cq2->tabent_tabpos[cq2->cur][j];
	}

}


static void Select_NextLine(TconvertedPass2 *cq2)
{
#ifdef DEBUG
  fprintf(cq2->log,"\n#Select_NextLine() ");fflush(cq2->log);
#endif
  long help;

  help = cq2->pre;
  cq2->pre = cq2->cur;
  cq2->cur = cq2->next;
  cq2->next = help;
}


static boolean FixTabs(TconvertedPass2 *cq2,char * Helps)
{
  int i = 0, j = 0, tabs = 0;
  string s;
  char CharStr[10];

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  while(Helps[j++]=='\\')
  	{
	if (Helps[j++] != 'T') break;
	if (Helps[j++] != 'A') break;
	if (Helps[j++] != 'B') break;
	if (Helps[j++] != ' ') break;
        tabs++;
        }
  if (tabs <= 0) return false;

  if((j>(int)strlen(Helps))&&(cq2->Lines[cq2->cur].line_term!='s')&&(cq2->Lines[cq2->cur].line_term!='p'))
  	{
	if(cq2->err!=NULL)
	   {
	   cq2->perc.Hide();
	   fprintf(cq2->err,_("\nWarning: Incorrect line with TABs at the end - fixed."));
	   }
	*Helps=0;
        return false;
        }


  if(cq2->Lines[cq2->cur].envir == 'T')
     {
     j=0;
     for(i=0;i<tabs;i++)
  	   {
	   Helps[j++]='\\';
	   Helps[j++]='>';
           }
     i=5*tabs;
     while (Helps[i] != '\0')
            {
	    Helps[j] = Helps[i];
	    i++;
	    j++;
	    }
     Helps[j] = '\0';
     }
  else {
       i=Helps-cq2->Lines[cq2->cur].Lstring();
       s=copy(cq2->Lines[cq2->cur].Lstring,0,i);
       sprintf(CharStr,"%2.2f",float(cq2->tabpos[tabs-1])/ 470.0);
       s+="\\hspace*{";
       s+=CharStr;
       s+="cm}";
       s+=copy(cq2->Lines[cq2->cur].Lstring,i + 5*tabs,length(cq2->Lines[cq2->cur].Lstring)- i - 5*tabs);
       cq2->Lines[cq2->cur].Lstring=s;
       }
  return true;
}



static void OptimSectionStr(char * aline)
{
  boolean optimized;
  int i,r;
  char *str,*str2;

  do {
     optimized = false;
     if (aline == NULL) return;


     i=strlen(aline);
     while(aline[i]==' ')
		{
		aline[i--]=0;
		}
     if (aline == "") return;

     i=strlen(aline);
     if (aline[i-1] == '\\' && aline[i-2] == '\\')
	  {
	  aline[i-2] = '\0';
	  i -= 2;
	  }

      if ((str=StrStr(aline, "{\\bf")) != NULL)
	     {
	     str2=str+1;
	     for(r=0;r<3;r++)
		{
		*str2++=' ';
		}

	     str2=str+4;
	     r=0;
	     while(*str2!=0)
		{
		if(*str2=='{') r++;
		if(*str2=='}')
		  if(r==0)
			{
			*str2=' ';
			strcpy(str,str+4);
			i -= 4;
			optimized = true;
			break;
			}
			else r--;
		str2++;
		}

	     }


      if (((str=StrStr(aline, "{\\large")) != NULL)||
	  ((str=StrStr(aline, "{\\Large")) != NULL)||
	  ((str=StrStr(aline, "{\\LARGE")) != NULL))
	     {
	     str2=str+1;
	     for(r=0;r<6;r++)
		{
		*str2++=' ';
		}

	     str2=str+7;
	     r=0;
	     while(*str2!=0)
		{
		if(*str2=='{') r++;
		if(*str2=='}')
		  if(r==0)
			{
			*str2=' ';
			strcpy(str,str+7);
			i -= 7;
			optimized = true;
			break;
			}
			else r--;
		 str2++;
		 }
	     }



  } while (optimized);


}


static int FixBracket(string & Line)
{
  if (Line == "") return 0;

  Line="{}"+Line;

  return length(Line);
}

static boolean TryToRemoveLarge(char * Helps)
{
  int i = 0, j = 0;

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  if (Helps[j++] != '{') return false;
  if (Helps[j++] != '\\') return false;
  if (Helps[j++] != 'L') return false;
  if (Helps[j++] != 'a') return false;
  if (Helps[j++] != 'r') return false;
  if (Helps[j++] != 'g') return false;
  if (Helps[j++] != 'e') return false;
  while (Helps[j] == ' ')
  	{
        j++;
        }
  if (Helps[j++] != '}') return false;

  while (Helps[j] != '\0')
         {
	 Helps[i] = Helps[j];
	 i++;
	 j++;
	 } 
  Helps[i] = '\0';
  return true;
}



static boolean TryToRemoveRM(char * Helps)
{
  int i = 0, j = 0;

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  if (Helps[j++] != '{') return false;
  if (Helps[j++] != '\\') return false;
  if (Helps[j++] != 'r') return false;
  if (Helps[j++] != 'm') return false;
  while (Helps[j] == ' ')
  	{
        j++;
        }
  if (Helps[j++] != '}') return false;

  while (Helps[j] != '\0')
         {
         Helps[i] = Helps[j];
	 i++;
	 j++;
	 }
  Helps[i] = '\0';
  return true;
}

static boolean TryToRemoveBF(char * Helps)
{
  int i = 0, j = 0;

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  if (Helps[j++] != '{') return false;
  if (Helps[j++] != '\\') return false;
  if (Helps[j++] != 'b') return false;
  if (Helps[j++] != 'f') return false;
  while (Helps[j] == ' ')
  	{
	j++;
        }
  if (Helps[j++] != '}') return false;

  while (Helps[j] != '\0')
         {
         Helps[i] = Helps[j];
	 i++;
	 j++;
	 } 
  Helps[i] = '\0';
  return true;
}

static boolean TryToRemoveSC(char * Helps)
{
  int i = 0, j = 0;

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  if (Helps[j++] != '{') return false;
  if (Helps[j++] != '\\') return false;
  if (Helps[j++] != 's') return false;
  if (Helps[j++] != 'c') return false;
  while (Helps[j] == ' ')
  	{
        j++;
        }
  if (Helps[j++] != '}') return false;

  while (Helps[j] != '\0')
         {
         Helps[i] = Helps[j];
	 i++;
	 j++;
	 }
  Helps[i] = '\0';
  return true;
}



static boolean TryToRemoveIT(char * Helps)
{
  int i = 0, j = 0;

  if (Helps == NULL) return false;
  if (Helps == "") return false;

  if (Helps[j++] != '{') return false;
  if (Helps[j++] != '\\') return false;
  if (Helps[j++] != 'i') return false;
  if (Helps[j++] != 't') return false;
  while (Helps[j] == ' ')
  	{
        j++;
        }
  if ((Helps[j]=='\\')&&(Helps[j+1]=='/')) j+=2;
  if (Helps[j++] != '}') return false;

  while (Helps[j] != '\0')
         {
         Helps[i] = Helps[j];
	 i++;
	 j++;
	 } 
  Helps[i] = '\0';
  return true;
}


int EmptyLine(const string & s)
{
int i;
char ch;

i=0;
while(i<length(s))
	{
        ch=s[i++];
        if(ch==' ') continue;
        if(ch=='\t') continue;
	if(ch=='}') continue;
	if(ch=='{') continue;
	if(ch=='\\')
	   {
	   if(s[i]=='b')	 //ingore \bf
		 {
		 i++;
		 if(s[i++]!='f') return(0);
		 continue;
		 }

	   if(s[i]=='f')	 //ingore \foottext{\anything}
		 {
		 i++;
		 if(s[i++]!='o') return(0);
		 if(s[i++]!='o') return(0);
		 if(s[i++]!='t') return(0);
		 if(s[i++]!='t') return(0);
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='x') return(0);
		 if(s[i++]!='t') return(0);

		 if(s[i++]!='{') return(0);
		 while(s[i++]!='}')
			 {
			 if(i>=length(s)) return(1);
			 };
		 continue;
		 }


	   if(s[i]=='h')	 //ingore \headtext{\anything}
		 {
		 i++;
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='a') return(0);
		 if(s[i++]!='d') return(0);
		 if(s[i++]!='t') return(0);
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='x') return(0);
		 if(s[i++]!='t') return(0);

		 if(s[i++]!='{') return(0);
		 while(s[i++]!='}')
			 {
			 if(i>=length(s)) return(1);
			 };
		 continue;
		 }

	   if(s[i]=='l')	 //ingore \label{anything}
		 {
		 i++;
		 if(s[i++]!='a') return(0);
		 if(s[i++]!='b') goto TryLanguage;
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='l') return(0);
		 if(s[i++]!='{') return(0);
		 while(s[i++]!='}')
			 {
			 if(i>=length(s)) return(1);
			 };
		 continue;

TryLanguage:            	//ingore \language anything
		 i--;
		 if(s[i++]!='n') return(0);
		 if(s[i++]!='g') return(0);
		 if(s[i++]!='u') return(0);
		 if(s[i++]!='a') return(0);
		 if(s[i++]!='g') return(0);
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='=') return(0);
		 if(s[i++]!='\\') return(0);

		 while(isalpha(s[i]))
			 {
			 i++;
			 }
		 continue;
		 };

	   if(s[i]=='o')	 //ingore  \onecolumn
		 {
		 i++;
		 if(s[i++]!='n') return(0);
		 if(s[i++]!='e') return(0);
		 goto ColumnText;
		 }

	   if(s[i]=='p')	 //ingore  \penalty NUM
		 {
		 i++;
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='n') return(0);
		 if(s[i++]!='a') return(0);
                 if(s[i++]!='l') return(0);
		 if(s[i++]!='t') return(0);
                 if(s[i++]!='y') return(0);
	         while(s[i]==' ') i++;
	         while(isdigit(s[i])) i++;
                 continue;
	         };

	   if(s[i]=='s')
		 {
		 i++;
		 if(s[i++]=='c') continue;     //ignore \sc

		 --i;
		 if(s[i++]!='e') return(0);  //ingore  \setcounter{counter}{number}
		 if(s[i++]!='t') return(0);
                 if(s[i++]!='c') return(0);
		 if(s[i++]!='o') return(0);
		 if(s[i++]!='u') return(0);
		 if(s[i++]!='n') return(0);
                 if(s[i++]!='t') return(0);
                 if(s[i++]!='e') return(0);
                 if(s[i++]!='r') return(0);

                 if(s[i++]!='{') return(0);
                 while(s[i]!='}' && s[i]!=0) i++;
                 if(s[++i]!='{') return(0);
                 while(s[i]!='}' && s[i]!=0) i++;
                 i++;

		 continue;
		 };

	   if(s[i]=='T')	 //ingore  \TAB
		 {
		 i++;
		 if(s[i++]!='A') return(0);
		 if(s[i++]!='B') return(0);
		 continue;
		 }

	   if(s[i]=='t')	 //ingore  \twocolumn
		 {
		 i++;
		 if(s[i]!='w') goto ThisPageStyle;
		 i++;
ColumnText:	 if(s[i++]!='o') return(0);
		 if(s[i++]!='c') return(0);
		 if(s[i++]!='o') return(0);
		 if(s[i++]!='l') return(0);
		 if(s[i++]!='u') return(0);
		 if(s[i++]!='m') return(0);
		 if(s[i++]!='n') return(0);
		 if(s[i]==0) return(1);
		 if(s[i++]!=' ') return(0);
		 continue;

ThisPageStyle:   i++;
		 if(s[i++]!='h') return(0);
		 if(s[i++]!='i') return(0);
		 if(s[i++]!='s') return(0);
		 if(s[i++]!='p') return(0);
		 if(s[i++]!='a') return(0);
		 if(s[i++]!='g') return(0);
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='s') return(0);
		 if(s[i++]!='t') return(0);
		 if(s[i++]!='y') return(0);
		 if(s[i++]!='l') return(0);
		 if(s[i++]!='e') return(0);
		 if(s[i++]!='{') return(0);

		 while(isalpha(s[i]))
		       {
		       i++;
		       }
		 if(s[i++]!='}') return(0);
		 continue;
		 }

	   if(s[i]=='v')	 //ingore  \vskip xxcm
	         {
                 i++;
                 if(s[i++]!='s') return(0);
		 if(s[i++]!='k') return(0);
                 if(s[i++]!='i') return(0);
                 if(s[i++]!='p') return(0);
                 if(s[i++]!=' ') return(0);
                 while(s[i]==' ') i++;
                 while(isdigit(s[i]) || (s[i]=='-') || (s[i]=='.')) i++;
		 if(s[i]!='c') continue;
		 i++;
		 if(s[i]!='m') continue;
		 i++;
                 continue;
	         };
           }
        return(0);		//Line is not Empty
        }
return(1);			//Line is Empty
}

static void OptimizeMultiRows(string & aLine)
{
string NewLine,Cell;
int i;
char *HelpS,*aLinePtr,OldChar;
boolean shortstack;

HelpS=StrStr(aLine(), "\\penalty-10001");
shortstack=false;
aLinePtr=aLine();
OldChar=0;
while(*aLinePtr!=0)
	{
	if(aLinePtr==HelpS)
	     {
	     i=0;
	     HelpS=StrStr(++HelpS, "\\penalty-10001");
	     aLinePtr+=strlen("\\penalty-10001");
	     while(aLinePtr[i]==' ')
		 {
		 if(aLinePtr[i]==0)   goto Reject;
		 if(aLinePtr[i]=='&') goto Reject;
		 if(aLinePtr[i]=='\\')
		   {
		   if(aLinePtr[++i]=='\\') goto Reject;
		   }

		 i++;
		 }

	     if(!shortstack) Cell="\\shortstack{"+Cell;
	     Cell+="\\\\";
	     if(aLinePtr[i]=='[') Cell+="{}";
			     else if(*aLinePtr!=' ') Cell+=' ';
	     shortstack=true;
	     }


Reject: if(OldChar!='\\')
	  if(*aLinePtr==0 || *aLinePtr=='&' || (*aLinePtr=='\\' && aLinePtr[1]=='\\'))
	     {
	     NewLine+=Cell;
	     if(shortstack) NewLine+='}';

	     NewLine+=OldChar=*aLinePtr++;
	     Cell=NULL;
	     shortstack=false;
	     continue;
	     }

	Cell+=OldChar=*aLinePtr++;
	}

NewLine+=Cell;
if(shortstack) NewLine+='}';

aLine=NewLine;
}


/*******************---PASS2---******************/
void Convert_second_pass(FILE *Strip, FILE *table, FILE *FileOut, FILE *log,FILE *ErrorFile)
{
#ifdef DEBUG
  fprintf(log,"\n#Convert_second_pass() ");fflush(log);
#endif
  int i, len_reg;
  string *aLine, s;
  char *HelpS;
  TconvertedPass2 cq2;


  cq2.table = table;
  cq2.Strip = Strip;
  cq2.LaTeX = FileOut;
  cq2.log   = log;
  cq2.err   = ErrorFile;


  cq2.pre = 0;
  cq2.cur = 1;
  cq2.next = 2;

  cq2.Lines[cq2.pre].envir = ' ';
  cq2.Lines[cq2.pre].new_tabset = false;

  cq2.just_envir_closed = true;
  cq2.LineSpacing=0;

  for (i = 0; i <= 2; i++)
      {
      cq2.Lines[i].Lstring = "";
      cq2.Lines[i].Empty   = true;
      cq2.Lines[i].Columns = 1;
      cq2.Lines[i].InhibitBsBslash = false;
      InitAttr(cq2.Lines[i].attr);
      }

  cq2.rownum = 1;

  if (Verbosing >= 1)
         {
	 printf(_("\nSecond pass:\n"));
	 printf(_("Converting-percentage: "));
	 }
  cq2.perc.Init(0, num_of_lines_stripfile);


  Latex_head(&cq2);
			/*read current row from strip file*/
  Read_tableentry(cq2.cur, &cq2);
  fGets2(Strip, cq2.Lines[cq2.cur].Lstring );
  cq2.Lines[cq2.cur].Empty = EmptyLine(cq2.Lines[cq2.cur].Lstring);
			/*read next row from strip file*/
  fGets2(Strip, cq2.Lines[cq2.next].Lstring);
  Read_tableentry(cq2.next, &cq2);
  cq2.Lines[cq2.next].Empty = EmptyLine(cq2.Lines[cq2.next].Lstring);


  while ((!feof(Strip) || cq2.Lines[cq2.cur].Lstring != "" || cq2.Lines[cq2.next].Lstring != ""))
     {
     Update_global_information(&cq2);

     if(Verbosing >= 1)		//actualise a procentage counter
	      cq2.perc.Actualise(cq2.rownum);

     aLine = &cq2.Lines[cq2.cur].Lstring;
     len_reg = length(*aLine);

     /* fix an empty environments C and L */
     if(((cq2.Lines[cq2.cur].envir==' ')||(cq2.Lines[cq2.cur].envir=='Q')||(cq2.Lines[cq2.cur].envir=='B')) &&
	 (cq2.Lines[cq2.next].Empty>0) )
	   {
	   if(cq2.Lines[cq2.next].envir == 'C' || cq2.Lines[cq2.next].envir == 'L')
		{
		cq2.Lines[cq2.next].envir = ' ';
		}
	   }

    /* fix tabs, which are not in the tabbing environment */
    HelpS = StrStr((*aLine)(), "\\TAB ");
    if(HelpS!=NULL)
    	{
	FixTabs(&cq2,HelpS); /* Fix tabs must be called first because it can change environment */
	sync(*aLine);
        }
    if(cq2.Lines[cq2.cur].envir == 'T')  /* fix wrongly accented chars in Tabbing enviroment */
        {
	if(StrStr((*aLine)(), "\\'{")!=NULL)
	   *aLine=replacesubstring(*aLine,"\\'{","\\a'{");
	if(StrStr((*aLine)(), "\\`{")!=NULL)
	   *aLine=replacesubstring(*aLine,"\\`{","\\a`{");
        }


    /* More than two spaces must be fixed. */
    if (FixSpaces) {   /**/
      if (toupper(cq2.Lines[cq2.cur].envir) != 'Q') {
	for (i = 1; i < len_reg; i++)
	  {
	  if ((*aLine)[i] == ' ' && (*aLine)[i+1] == ' ')
	    {
	    (*aLine)[i+1] = '~';
	    }
	  }
      }
    }

    /* Correct illegal argument which begins '['. */
    if (len_reg >= 1 && (*aLine)[1] == '[' ||
	len_reg >= 2 && (*aLine)[1] == ' ' && (*aLine)[2] == '[') {
      len_reg = FixBracket(*aLine);
    }


    /*Try to repair \section{ */
    if (OptimizeSection)
      {
      if (StrStr((*aLine)(), "\\part{") != NULL)
          {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr(*aLine, "\\part{") + 6L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\chapter{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr(*aLine, "\\chapter{") + 9L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\section{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr(*aLine, "\\section{") + 9L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\subsection{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr(*aLine, "\\subsection{") + 12L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\subsubsection{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr( *aLine, "\\subsubsection{") + 15L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\paragraph{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr( *aLine, "\\paragraph{") + 11L);
	  sync(*aLine);
	  }
      if (StrStr((*aLine)(), "\\subparagraph{") != NULL)
	  {
	  cq2.Lines[cq2.cur].InhibitBsBslash = true;
	  cq2.Lines[cq2.next].InhibitBsBslash = true;
	  OptimSectionStr(strstr(*aLine, "\\subparagraph{") + 14L);
	  sync(*aLine);
	  }
       }

    len_reg = length(*aLine);


    /*Some optimizations of text on current line*/
			    // fix occurence \/ in the vertical mode - remove it
    if((cq2.Lines[cq2.pre].Lstring=="")&&(length(cq2.Lines[cq2.cur].Lstring)>=2))
	if (  (*aLine)[0]=='\\' &&  (*aLine)[1]=='/' )
	    *aLine=copy(*aLine,2,length(*aLine)-2);
    if((cq2.Lines[cq2.cur].Lstring=="")&&(length(cq2.Lines[cq2.next].Lstring)>=2))
	if (  (cq2.Lines[cq2.next].Lstring)[0]=='\\' &&  (cq2.Lines[cq2.next].Lstring)[1]=='/' )
	    cq2.Lines[cq2.next].Lstring=copy(cq2.Lines[cq2.next].Lstring,2,length(cq2.Lines[cq2.next].Lstring)-2);

			       // move } from the beginning of next line to the current line
    while((cq2.Lines[cq2.next].Lstring[0]=='}')&&(cq2.Lines[cq2.next].attr.Opened_Depth>0))
	       {
	       HelpS="}";
	       if(cq2.Lines[cq2.next].attr.Closed_Depth>0)
		       {
		       if(cq2.Lines[cq2.next].attr.Opened_Depth>=cq2.Lines[cq2.next].attr.Closed_Depth)
			     {		// try to remove all string belonging to the attr
			     HelpS=Close_com[cq2.Lines[cq2.next].attr.stack[cq2.Lines[cq2.next].attr.Opened_Depth-1]];
MatchAgain:		     if(strncmp(cq2.Lines[cq2.next].Lstring,HelpS,strlen(HelpS)))
				{
				if(HelpS[0]=='\\' && HelpS[1]=='/') // give a last chance to match without \/
				   {
				   HelpS+=2;
				   if(*HelpS!=0) goto MatchAgain;
				   }
				break;  // the string was not found
				}
			     cq2.Lines[cq2.next].attr.Opened_Depth--;
			     }
		       cq2.Lines[cq2.next].attr.Closed_Depth--;
		       }
	       cq2.Lines[cq2.next].Lstring=copy(cq2.Lines[cq2.next].Lstring,strlen(HelpS),length(cq2.Lines[cq2.next].Lstring)-strlen(HelpS));
	       *aLine+=HelpS;
	       }


    if( Open_environment(&cq2))    //this procedure tests change of the environment
    		{
                i=cq2.next;	//opening enviroment rejected for an empty line
		cq2.next=cq2.cur;
                cq2.cur=i;

                fGets2(Strip, cq2.Lines[cq2.next].Lstring);
		Read_tableentry(cq2.next, &cq2);

                if((cq2.Lines[cq2.cur].envir=='i')&&(cq2.Lines[cq2.pre].envir=='i'))
			cq2.Lines[cq2.pre].envir='I';
                if((cq2.Lines[cq2.cur].envir=='I')&&(cq2.Lines[cq2.pre].envir=='I'))
			cq2.Lines[cq2.pre].envir='i';

                goto SkipThisLine;
                }


//fix closed attributes problem
    if(ClosedAttr(cq2.Lines[cq2.cur].attr)) /* Are attributes closed? */
      if(*aLine == "")
	 {
	 if(cq2.Lines[cq2.next].attr.Closed_Depth==cq2.Lines[cq2.cur].attr.Closed_Depth)
		{
		for(i=0;i<cq2.Lines[cq2.next].attr.Closed_Depth;i++)
                	{
                        if(cq2.Lines[cq2.next].attr.stack[i]!=cq2.Lines[cq2.cur].attr.stack[i])
                        	{	//attributes are not same for next line
                                goto FixOpen;
				}
			}
		cq2.Lines[cq2.next].attr.Opened_Depth=cq2.Lines[cq2.cur].attr.Opened_Depth;
		}
             else {
FixOpen:	  Open_All_Attr(cq2.Lines[cq2.cur].attr,*aLine);
		  }
         }


    if (*aLine != "")
         {		/* Attributes are closed */
         if(cq2.Lines[cq2.cur].attr.Closed_Depth > cq2.Lines[cq2.cur].attr.Opened_Depth)
	 	{
		Open_All_Attr(cq2.Lines[cq2.cur].attr,s);
		cq2.Lines[cq2.cur].Lstring=s+cq2.Lines[cq2.cur].Lstring;
		}

	 HelpS = StrStr((*aLine)(), "@{\\");   /*ignore tabular formater @{...}*/
	 if(HelpS==NULL)
	   {
					   /* remove dummy items {\rm */
	   HelpS = StrStr((*aLine)(), "{\\rm");   /**/
	   while (HelpS != NULL)
	      {
	      if (!TryToRemoveRM(HelpS))
		   HelpS++;
	      HelpS = strstr(HelpS, "{\\rm");   /**/
	      }

	   HelpS = StrStr((*aLine)(), "{\\bf");   /**/
	   while (HelpS != NULL)
	      {
	      if (!TryToRemoveBF(HelpS))
		   HelpS++;
	      HelpS = strstr(HelpS, "{\\bf");   /**/
	      }

	   HelpS = StrStr((*aLine)(), "{\\sc");
	   while (HelpS != NULL)
	      {
	      if (!TryToRemoveSC(HelpS))
		   HelpS++;
	      HelpS = strstr(HelpS, "{\\sc");
	      }                                 /**/

				   /* remove dummy items {\it */
	   HelpS = StrStr((*aLine)(), "{\\it");   /**/
	   while (HelpS != NULL)
	      {
	      if (!TryToRemoveIT(HelpS))
		   HelpS++;
	      HelpS = strstr(HelpS, "{\\it");   /**/
	      }
				   /* remove dummy items {\Large */
	   HelpS = StrStr((*aLine)(), "{\\Large");   /**/
	   while (HelpS != NULL)
	      {
	      if (!TryToRemoveLarge(HelpS))
		   HelpS++;
	      HelpS = strstr(HelpS, "{\\Large");   /**/
	      }
	   }
	 sync(*aLine);

	 if(cq2.Lines[cq2.cur].envir=='B')
		{
		HelpS=StrStr((*aLine)(), "\\penalty-10001");
		if(HelpS!=NULL) OptimizeMultiRows(*aLine);
		}

	 if((i=fputs(*aLine,cq2.LaTeX))==EOF)   /*here is written current line*/
			 {
                         RunError(0x20,"");
                         }
         cq2.just_envir_closed = false;
         }

	 		   /*Is it possible to expand the tabbing enviroment? */
    HelpS=StrStr(cq2.Lines[cq2.next].Lstring(), "\\TAB ");
    if((HelpS!=NULL)&&(cq2.Lines[cq2.cur].envir=='T')&&(cq2.Lines[cq2.next].envir==' '))
    	{
        cq2.Lines[cq2.next].envir='T';  /* Tabbing expanded for next line */
        }


    switch (cq2.Lines[cq2.cur].line_term)
      {
      case 's':
      case 'p':if (Change_envir_EOL(&cq2))
		   {
		   if (cq2.Lines[cq2.next].attr.Opened_Depth>0) /* Attributes are opened */
		     {
		     Close_All_Attr(cq2.Lines[cq2.next].attr,s); /* close attributes on EOL */
		     if((cq2.Lines[cq2.pre].Lstring=="") && cq2.Lines[cq2.cur].Empty)
			s=replacesubstring(s,"\\/","");  //remove \/ in vertical mode
		     fprintf(cq2.LaTeX,s());
		     }
		   putc('\n', cq2.LaTeX);
		   Close_environment(&cq2);
		   }
	       else putc('\n', cq2.LaTeX);
               break;

      case 'h':if (toupper(cq2.Lines[cq2.cur].envir) == 'I')
       		  {
                  if (cq2.Lines[cq2.next].attr.Opened_Depth>0) /* Attributes are opened */
  	             {
                     Close_All_Attr(cq2.Lines[cq2.next].attr,cq2.LaTeX); /* close attributes on EOL */
		     }
		  putc('\n', cq2.LaTeX);
		  Close_environment(&cq2);
		  cq2.Lines[cq2.cur].envir = ' ';
	          }

               else {
	            cq2.underline = false;
	            for (i = 0; i < cq2.Lines[cq2.next].attr.Closed_Depth; i++)
	              cq2.underline = (cq2.underline ||
				       cq2.Lines[cq2.next].attr.stack[i] == 0xb || //DblUnd
				       cq2.Lines[cq2.next].attr.stack[i] == 0xd || //StrikeOut
				       cq2.Lines[cq2.next].attr.stack[i] == 0xe);  //Underline

		    if (cq2.underline && (cq2.Lines[cq2.next].attr.Opened_Depth>0) &&
			  !ClosedAttr(cq2.Lines[cq2.cur].attr) )
  	              {
                      Close_All_Attr(cq2.Lines[cq2.next].attr,cq2.LaTeX); /* close attributes on EOL */
		      }

	/* Elke Indent-environment moet na one harde Return*/
	/* Afgesloten worden.*/


	           if (Change_envir_EOL(&cq2))
	                {
	                if (cq2.just_envir_closed) fprintf(cq2.LaTeX, "\\nwln\n");
                	                      else putc('\n', cq2.LaTeX);
                        if (cq2.Lines[cq2.next].attr.Opened_Depth>0) /* Attributes are opened */
  	                         {
                                 Close_All_Attr(cq2.Lines[cq2.next].attr,cq2.LaTeX); /* close attributes on EOL */
				 }
	                Close_environment(&cq2);
	                }
	            else {
                         if(cq2.Lines[cq2.next].envir=='^'); // do not solve anything at the end of the minipage
	                 else if (cq2.Lines[cq2.cur].Lstring == "" &&
	                        cq2.Lines[cq2.pre].Lstring == "")
                                   {
		                   fprintf(cq2.LaTeX, "\\bigskip");
                                   }
			 else if (cq2.Lines[cq2.next].Empty>0)
	  	                {
	                        cq2.Lines[cq2.next].InhibitBsBslash = true;
	                        }
	                 else if (!cq2.Lines[cq2.cur].InhibitBsBslash)
	                        {
	                        if (cq2.just_envir_closed)
	                                 fprintf(cq2.LaTeX, "\\nwln");
	                           else {
					if(cq2.Lines[cq2.cur].Empty>0)
						 {
						 if(cq2.Lines[cq2.pre].Lstring!="")
							fputc('\n',cq2.LaTeX);
						 fprintf(cq2.LaTeX, " \\bigskip");
						 }
                                            else fprintf(cq2.LaTeX, "\\\\");
                                        }

                                if (cq2.Lines[cq2.next].Lstring[0] == '[')
	      			          {
				          FixBracket(cq2.Lines[cq2.next].Lstring);
				          }
                                }
	           putc('\n', cq2.LaTeX);
	           }
                 }
             break;

    case 'P':if (cq2.Lines[cq2.next].attr.Opened_Depth>0) /* Attributes are opened */
  	              {
                      Close_All_Attr(cq2.Lines[cq2.next].attr,cq2.LaTeX); /* close attributes on EOL */
		      }
	     putc('\n', cq2.LaTeX);
             Close_environment(&cq2);
             fprintf(cq2.LaTeX, "\\newpage\n");
             cq2.Lines[cq2.cur].envir = ' ';
	     break;
      }


    cq2.Lines[cq2.pre].Lstring = "";
    cq2.Lines[cq2.pre].InhibitBsBslash = false;

    Select_NextLine(&cq2);
				/*read next row from strip file*/
    fGets2(Strip, cq2.Lines[cq2.next].Lstring);
    cq2.Lines[cq2.next].Empty = EmptyLine(cq2.Lines[cq2.next].Lstring);
    cq2.Lines[cq2.next].Columns = cq2.Lines[cq2.cur].Columns;
    Read_tableentry(cq2.next, &cq2);

SkipThisLine:
    cq2.rownum++;
    }

  if(!cq2.just_envir_closed) Close_environment(&cq2);	//Close enviroment if still opened
  if(Columns>=3 && cq2.Lines[cq2.pre].Columns>1) fprintf(cq2.LaTeX,"\\end{multicols}\n");
  Latex_foot(&cq2);

  if(Verbosing >= 1)		//finishing a procentage counter
     {
     cq2.perc.SetPercent(100);
     putchar('\n');
     }
}

/* End. */
