/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 4.x,5.x and 6.x files into LaTeX          *
 * modul:       wp2latex.h                                                    *
 * description: Contains global definitions and prototypes                    *
 ******************************************************************************/
#ifndef __Wp2Latex__
#define __Wp2Latex__

#include <types.h>


#ifdef __Disable_NULL_printf
 #define chk(x) x==NULL?"NULL":x
#else
 #define chk(x) x
#endif


#define LineLength   80     /* Split lines after more than LineLength charcters */

#define version         "2.80"
#define versiondate "25 Mar 2000"  /* day (space) month (space) full year */


#define  false          0
#define  true           1
typedef  bool  boolean;


extern unsigned short CodePage, WPcharset;
extern boolean Index,NFSS,Tabs,twoside,SaveWPG,ExactFnNumbers,CPStyles;
extern SBYTE Cyrilic,colors,EndNotes,FancyHdr,Columns,InputPS,MakeIdx,Czech,German,
	     textcomp,Wasy,Amssymb,LaTeXsym,LongTable,Bbm,Rsfs;
extern int LaTeX_Version;
extern unsigned char Verbosing;
extern boolean TexChars,ExtendedCheck,OptimizeSection,FixSpaces;
extern char *InputDir,*OutputDir,*RelativeFigDir;


extern long num_of_lines_stripfile;

#define First_com_section 16
#define Last_com_section  23
#define Hidden_Text	  25
extern int OutputStyle;
extern char *Open_com[26];
extern char *Close_com[26];

typedef char LatTable[0x80][21];
extern LatTable lat;
extern char** UserWPCharSet;


/* functions from struct.cc */
int RdWORD_LoEnd( WORD *num, FILE *f );
int RdDWORD_LoEnd( DWORD *num, FILE *f );
int RdWORD_HiEnd( WORD *num, FILE *f );
int RdDWORD_HiEnd( DWORD *num, FILE *f );

int WrWORD_LoEnd( WORD num, FILE *f );
int WrDWORD_LoEnd( DWORD num, FILE *f );
int WrWORD_HiEnd( WORD num, FILE *f );
int WrDWORD_HiEnd( DWORD num, FILE *f );


/* functions of wp2lfuti.c */
int AbsolutePath(const char *TestedPath);
FILE *CheckOpen(char *name, char *type);
int  ReadAndSplitLine(FILE *fp, char *regel);
long filesize(FILE *f);
#define Rd_word(f,w) RdWORD_LoEnd(w,f);
#define Rd_dword(f,d) RdDWORD_LoEnd(d,f);
#define Wr_word(f,w) WrWORD_LoEnd(w,f);
#define Wr_dword(f,d) WrDWORD_LoEnd(d,f);

int GetPath(char *FullName);
const char *GetExtension(const char *FullName);
int CopyFile(const char *Dest, const char *Src);


/* Variables for Convert_first_pass: */
#define NormalText      0
#define HeaderText      1
#define CharsOnly       2
#define Nothing         3


#define MaxAttributes 17
struct attribute
	{
        int Math_Depth;
        int Opened_Depth;       /*This is a number of currently opened attributes*/
        int Closed_Depth;	/*This denotes a number of attributes */
        char stack[MaxAttributes+1];
	};
inline int ClosedAttr(const attribute & Attr)
	{return(Attr.Closed_Depth>Attr.Opened_Depth);}

typedef struct
	{
	BYTE  AnchorType;
	BYTE  HorizontalPos;
	BYTE  Contents;
	BYTE  Type;
	WORD  Width;
	WORD  CaptionSize;
	DWORD CaptionPos;
	} TBox;


class Percentor
	{
public: long StartValue;
	long EndValue;
	int CurrentPercent;
	boolean displayed;

	Percentor(void)	{displayed=false;CurrentPercent=-1;};

	void Actualise(long NewValue);
	void Hide(void) 	{if(displayed) printf("\b\b\b\b");
				 displayed=false;}
	void Init(long Start, long End) {StartValue=Start;EndValue=End;}
	void SetPercent(int NewPercent);
	void Show(void) 	{printf(displayed?"\b\b\b\b%3d%%":"%3d%%",CurrentPercent);
				 fflush(stdout);displayed=true;}

	};

typedef struct TconvertedPass1
  {
  Percentor perc;
  DWORD DocumentStart;
  WORD ResourceStart;
  attribute attr;

  char indenting;
  char Columns;
  boolean CentrePage;

  signed char char_on_line;
  boolean nomore_valid_tabs, indent_end, ind_text1;
  boolean Linebegin;

  char envir, line_term;

  int num_of_tabs, latex_tabpos;
  WORD tabpos[40];
  char tab_type;

  int WP_sidemargin,Lmar,Rmar;

  unsigned short ind_leftmargin, ind_rightmargin;

  unsigned char by, subby;
  DWORD ActualPos;

  unsigned rownum;

  unsigned char Font, flag;
  short int FirstSection;
  signed char recursion;
  char ObjType[32];

  FILE *wpd, *table, *strip, *log, *err;
} TconvertedPass1;


/* Variables for Convert_second_pass: */
/*  .... only in pass2.cc ...  */

/* global functions of charactr.cc */
#define ISO8859_1 1
#define ISO8859_2 2
void Table_Init(LatTable & lat);
char *Ext_chr_str(unsigned char char_set,unsigned char  char_code, TconvertedPass1 *cq);

/* global functions of pass1_4.cc */
void Convert_pass1_WP4(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);
void Convert_pass1_WP4_encrypted(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);

/* global functions of pass1.cc */
extern void Convert_pass1_WP5 (FILE *FileIn, FILE *table,
				 FILE *StripOut, FILE *LogFile,FILE *ErrorFile);
extern void Convert_pass1_WP5_encrypted(FILE *FileIn,FILE  *table,
				 FILE *StripOut,FILE *LogFile,FILE *ErrorFile);
void Make_tableentry_envir_extra_end(TconvertedPass1 *cq);
void Make_tableentry_attr(TconvertedPass1 *cq);
void Make_tableentry_tabset(TconvertedPass1 *cq);
void WP_Default(TconvertedPass1 *cq);
void InitAttr(attribute & a);
void Close_All_Attr(attribute & a, FILE *f);
DWORD SelectImageResource(TconvertedPass1 *cq, int ResourceNo);

void AttrOn(attribute & a, char Attr);
void AttrOff(TconvertedPass1 *cq, char attr_num);
void Attr_ON(TconvertedPass1 *cq,unsigned char b=0xFF);
void Attr_OFF(TconvertedPass1 *cq,unsigned char b=0xFF);
void CancelHyph(TconvertedPass1 *cq);
void CellTable(TconvertedPass1 *cq);
void Center(TconvertedPass1 *cq);
void CenterPage(TconvertedPass1 *cq);
void CharacterStr(TconvertedPass1 *cq,const char *LatexCode,char RequiredFont=0);
void Color(TconvertedPass1 *cq);
void Column(TconvertedPass1 *cq,signed char number);
void DateCode(TconvertedPass1 *cq);
void End_of_indent(TconvertedPass1 *cq);
void EndTable(TconvertedPass1 *cq);
void Flush_right(TconvertedPass1 *cq, char type);
void HardPage(TconvertedPass1 *cq);
void HardReturn(TconvertedPass1 *cq);
void Hyphenation(TconvertedPass1 *cq,char state);
void Indent(TconvertedPass1 *cq, char WP);
void InitHeaderFooter(TconvertedPass1 *cq, char HorF, char occurance);
void InvisibleSoftReturn(TconvertedPass1 *cq);
void Justification(TconvertedPass1 *cq, unsigned char WPx);
void Language(TconvertedPass1 *cq, boolean WP6);
void Open_All_Attr(attribute & a, FILE * f);
void PageNumber(TconvertedPass1 *cq);
void PlaceEndnotes(TconvertedPass1 *cq);
void PlaceIndex(TconvertedPass1 *cq);
//void PutCharacter(TconvertedPass1 *cq,char *CharStr);
void EndSection(TconvertedPass1 *cq, signed char WP);
void Page_number_position(TconvertedPass1 *cq, unsigned char WP);
void ParagraphNumber(TconvertedPass1 *cq);
void RowTable(TconvertedPass1 *cq);
void SetEndnoteNum(TconvertedPass1 *cq, unsigned char WP);
void SetFont(TconvertedPass1 *cq, int PointSize, const char *FontName);
void SetFontSize(TconvertedPass1 *cq, char WP);
void SetFootnoteNum(TconvertedPass1 *cq, signed char WP);
void SetPgNum(TconvertedPass1 *cq, unsigned char WP);
void SoftHyphen(TconvertedPass1 *cq);
void SoftReturn(TconvertedPass1 *cq);
void StartSection(TconvertedPass1 *cq, signed char WP);
void Suppress(TconvertedPass1 *cq, char WP);
void Tab(TconvertedPass1 *cq, char WP);
void TableOfContents(TconvertedPass1 *cq);
void Terminate_Line(TconvertedPass1 *cq, char line_term);
void WidowOrphan(TconvertedPass1 *cq,signed char type);

inline void NewLine(TconvertedPass1 *cq)
{
  putc('\n', cq->strip);
  cq->line_term = 's';   /* Soft return */
  Make_tableentry_envir_extra_end(cq);
  cq->char_on_line = false;
  cq->nomore_valid_tabs = false;
  cq->rownum++;
  Make_tableentry_attr(cq);
  cq->latex_tabpos = 0;
}

/* global functions of pass1_6.cc */
void Convert_pass1_WP60(FILE *FileIn,FILE  *table, FILE *StripOut,FILE  *LogFile,FILE  *ErrorFile);
void Convert_pass1_WP6_encrypted(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);

/* global functions of pass2.cc */
void Convert_second_pass(FILE *Strip,FILE *table, FILE *FileOut, FILE *log, FILE  *ErrorFile);

/* global functions of formulas.cc */
void AnyBox(TconvertedPass1 *cq, DWORD end_of_code);
void BoxTexFoot(TconvertedPass1 *cq, const TBox & Box);
boolean BoxTexHeader(TconvertedPass1 *cq, const TBox & Box);
extern int FormulaNo;

/* global functions of image.cc */
void Image(TconvertedPass1 *cq, const char *Filename, TBox & Box,
	   void (*DoCaption)(TconvertedPass1 *,unsigned short), char WP  );


/* global functions and variables of gettext.cc */
#define EnvLanguage "LANGUAGE="
void InitGettext(void);

#ifdef __gettext__
// #define HAVE_CATGETS 1
 #define ENABLE_NLS 1
 #include <locale.h>
 #include<libintl.h>
 #ifndef _
   #define _(EnString) gettext(EnString)
 #endif
#else
 #define _(arg) (arg)
#endif


/* global functions of wp2latex.cc */
extern long UnknownCharacters,UnknownObjects,CorruptedObjects;
void RunError(int ExitCode, const char *s="");


/* The Posix Standard do not require these constants to be defined. */
#ifndef SEEK_SET
 #define SEEK_SET 0
#endif
#ifndef SEEK_CUR
 #define SEEK_CUR 1
#endif
#ifndef SEEK_END
 #define SEEK_END 2
#endif

#ifdef __Strings_h  //Only Strings related stuff
void AttrFit(attribute & Base, attribute & A_New, string & s);
string & fGets2(FILE *f, string & pstr);
void OptimizeFormulaStr(TconvertedPass1 *cq, string & StrBeg);
void _AttrOff(attribute & a, char Attr, string & s);
void PutFormula(TconvertedPass1 *cq,char *Str,const TBox & Box, const char WP=0);
#endif

#endif