/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2lfuti.c                                                    *
 * description: Some File UTIlities added by Andreas Tille                    *
 ******************************************************************************/
#include <stdio.h>
#include "wp2latex.h"
#include <strings.h>
#include <types.h>

#ifndef __UNIX__
#include <io.h>
#endif



/*----------------------------------------------------*/
/*-------------Basic file I/O operations--------------*/
/*----------------------------------------------------*/
FILE *CheckOpen(char *name, char *type)
/* Open a file and check whether successful (AT)
 * --- parameters: ---
 * char  *name        : file name
 * char  *type        : type of the file
 * --- return:     ---
 * FILE  *CheckOpen() : file pointer if successful, else NULL
 */
{
   FILE *fp;

   if ( (fp = fopen(name, type)) == NULL ) {
      fprintf(stderr, "ERROR - File %s not found\n", name);
      return NULL;
   }
   return fp;
}

long filesize(FILE *f)
{
#ifdef __UNIX__
  long pos,len;
  if((pos=ftell(f))<0) return(0);
  fseek(f,0,SEEK_END);
  len=ftell(f);
  fseek(f,pos,SEEK_SET);
  return(len);
#else
  return(filelength(fileno(f)));
#endif
}


int CopyFile(const char *Dest, const char *Src)
{
FILE *in,*out;


out=fopen(Dest,"rb");
if(out!=NULL)
	{
	fclose(out);
	return(-1);	//file already exist
	}

if((in=fopen(Src,"rb"))==NULL)
	return(-2);
if((out=fopen(Dest,"wb"))==NULL)
	{
	fclose(in);
	return(-3);
	}


while (!feof(in))
   fputc(fgetc(in), out);

fclose(in);
fclose(out);


return(0);
}



/*---------------------------------------------------------*/
/*--------------File related string operations-------------*/
/*---------------------------------------------------------*/

/*This function read one line from the text file and store it to the string.*/
string & fGets2(FILE *f, string & pstr)
{
  char c;

  pstr="";
  while (!feof(f))
     {
     c = getc(f);
     if (c == '\n') break;
     if (c == '\r') continue;
     if ((unsigned char)c == 0xFF)
	if(feof(f)) break;	//Fix the situation, when 0xFF is read before eof

     pstr += c;
  }

 return(pstr);
}



/*---------------------------------------------------------*/
/*----------Filename handling string operations------------*/
/*---------------------------------------------------------*/

int AbsolutePath(const char *TestedPath)
{
if(TestedPath==NULL) return(-1);
if(*TestedPath==0) return(-2);

#ifdef __MSDOS__
if(*TestedPath>' ')
  if(TestedPath[1]==':') return(true);
#endif
#ifndef __UNIX__
if(*TestedPath=='~') return(true);
#endif

if(*TestedPath=='\\' || *TestedPath=='/') return(true);

return(false);
}


string CutFileName(const char *FullFilename)
{
char ch;
int i,j;

if(FullFilename==NULL) return string("Unknown");
while(*FullFilename==' ') FullFilename++;  //Erase spaces at the beginning of the filename
i=strlen(FullFilename);
j=0;
if(i==0) return string("Unknown");

while(i>=0)
   {
   ch=FullFilename[i];
   if(ch=='.')
   	{
	j=i-1;
        break;
	}

   if(ch=='/' || ch=='\\' || ch==':')
   	{
        j=i-1;
        i=strlen(FullFilename);
        break;
        }
   i--;
   }
if(i<0) i=0;

while(j>=0)
   {
   ch=FullFilename[j];
   if(ch=='/' || ch=='\\' || ch==':')
   	{
        j++;
	break;
        }
   j--;
   }
if(j<0) j=0;

return copy(FullFilename,j,i-j);
}


int GetPath(char *FullName)
{
unsigned LastPos;
char *NameStep;

if(FullName==NULL) return(0);

LastPos=0;
NameStep=FullName;
while(*NameStep!=0)
	{
	if(*NameStep==':')	/* Patch for MsDOS x: */
		{
		if(NameStep-FullName == 1)
			LastPos=NameStep-FullName;
		}
	if(*NameStep=='/' || *NameStep=='\\')
			LastPos=NameStep-FullName;

	NameStep++;
	}

return(LastPos);
}


const char *GetExtension(const char *FullName)
{
const char *NameStep;
int LastPos;

if(FullName==NULL) return(NULL);

LastPos=strlen(FullName);
NameStep=FullName+LastPos+1;
while(NameStep>FullName)
	{
	NameStep--;

	if(*NameStep=='/' || *NameStep=='\\' || *NameStep==':')
		break;
	if(*NameStep=='.')
		return(NameStep);
	}

return(FullName+LastPos);
}


