(******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2lsec.c                                                     *
 * description: This modul contains functions for second pass. In the second  *
 *              pass the text file stripped from the WP binary file will be   *
 *              completed with the information of the binary table file which *
 *              contains additional information about environments.           *
 ******************************************************************************)
unit Pass2;

interface
uses common,strings,charactr,
     {$ifdef windows}WinCrt;{$else}Crt;{$endif}

Procedure Convert_second_strike(var Strip:text;var Tabel:Bin;var FileOut:Text);

implementation


const MaxLineSize=2048;

type TLinePass2=record
        Lstring:      pchar;
        new_tabset:   Boolean;
        envir,line_term:char;

        num_of_attr : Integer;
        attr_BOL    : Array[$00..$10] of Byte;

        InhibitBsBslash:Boolean;

        ind_leftmargin:Word;
        indent_level  :Byte;
	end;

     TconvertedPass2=record
       rownum : Longint;
       convperc : Integer;
       LineSpacing:Word;

       Lines:array[0..2] of TLinePass2;

       underline,
       illegal_argument,
       just_envir_closed      : Boolean;

       num_of_tabs           : Integer;
       tabpos                : Array [1..40] of Word;

       tabent_num_of_tabs    : Array [0..2] of Integer;
       tabent_tabpos         : Array [0..2,1..40] of Word;


       pre,
       cur,
       next     : Integer;

       rightjust,
       new_rightjust         : Boolean;
       new_tabent_rightjust,
       tabent_rightjust      : Array [0..2] of Boolean;

       attr_closed : Boolean;

       tabel:Pbin;
       Strip,LaTeX:Ptext;
    end;

Procedure fGets2(var f:text;pstr:pchar;size:word);
var c:char;
begin
if pstr=nil then exit;
 while (size>0)and not(eof(f)) do
   begin
   read(f,c);
   if c=#10 then continue;
   if c=#13 then break;
   pstr[0]:=c;
   inc(pstr);
   dec(size);
   end;

 pstr[0]:=#0;
end;


Procedure Read_tabelentry(n:Integer;var cq2:TconvertedPass2);
Var w  : Word;
    b  : Byte;
    j  : Integer;

Begin
   { Begin met one schone lei die dan door this procedure verder wordt }
   { opgevuld. }

   cq2.Lines[n].envir:=' ';
   cq2.Lines[n].new_tabset:=False;
   cq2.new_tabent_rightjust[n]:=False;

   cq2.Lines[n].num_of_attr := 0;
   For j:=1 to 16 Do cq2.Lines[n].attr_BOL[j]:=0;

   If filepos(cq2.tabel^)<filesize(cq2.tabel^)-1 Then
           Begin
           Read(cq2.tabel^,b);
           if b=13 then Read(cq2.tabel^,b);

	   cq2.Lines[n].num_of_attr := b;
	   For j:=1 to cq2.Lines[n].num_of_attr Do
	   		 Read(cq2.tabel^,cq2.Lines[n].attr_BOL[j]);

	   b:=$00;
	   While b<>$FF Do
	         Begin
                 Read(cq2.tabel^,b);

                 Case chr(b) Of
                   'B' : cq2.Lines[n].envir:='B';
                   'C' : cq2.Lines[n].envir:='C';
                   'L' : cq2.Lines[n].envir:='L';
                   'R' : cq2.Lines[n].envir:='R';
		   'T' : cq2.Lines[n].envir:='T';
                   'Q' : cq2.Lines[n].envir:='Q';
               'i','I' : Begin
                            cq2.Lines[n].envir:=chr(b);
                            Rd_word(cq2.tabel^,cq2.Lines[n].ind_leftmargin);
                            Read(cq2.tabel^,cq2.Lines[n].indent_Level);
                         End;

		   'S' : Begin
			    cq2.Lines[n].new_tabset:=True;
                            Read(cq2.tabel^,b);
			    cq2.tabent_num_of_tabs[n]:=b;

			    For j:=1 to cq2.tabent_num_of_tabs[n] Do
                               Begin
                                  Rd_word(cq2.tabel^,w);
                                  cq2.tabent_tabpos[n,j]:=w;
                               End;
                         End;

                   'U' : Begin
                            cq2.new_tabent_rightjust[n]:=True;
                            Read(cq2.tabel^,b);
			    If b=0 Then cq2.tabent_rightjust[n]:=False
				   Else cq2.tabent_rightjust[n]:=True;
                         End;

                   'l' : begin
                         Rd_word(cq2.tabel^,w);
                         if w<>cq2.LineSpacing then
                         	begin
                                write(cq2.latex^,'\baselineskip=',(w/128):2:2,'ex ');

                                cq2.LineSpacing:=w;
                                end;
                         end;

		   'h','s','P','p' : cq2.Lines[n].line_term:=chr(b);

                   #$FF,#10,#13:;	{do nothing}
                else {if cq2.log<>nil do  !!!!!!!}
		   writeln(#10#13'Error: Bad command in tabel file:',b,' !');
                End {Case};
              End;
        End

{ Er is geen volgende tabelentry dus ook geen volgende row }
{ the tabelentry is 'schoon'.                                 }
{ Zodat het document 'schoon' wordt afgesloten.              }

End;

Procedure __memmove(x,y:Pchar;q:word);
var i:integer;
begin
 for i:=q downto 0 do
 	x[i]:=y[i];
end;

Procedure Open_all_attr_BOL(var cq2:TconvertedPass2);
{ -- Open all command's door the Attributen-rij af te lopen -- }
Var pch:Pchar;
   j:Integer;
Begin
   pch:=cq2.Lines[cq2.cur].Lstring;
   For j:=$01 to cq2.Lines[cq2.cur].num_of_attr Do
   	begin
        __memmove(pch+length(Open_com[cq2.Lines[cq2.cur].attr_BOL[j]]),pch,strlen(pch));
        move(Open_com[cq2.Lines[cq2.cur].attr_BOL[j]][1],pch^,
			length(Open_com[cq2.Lines[cq2.cur].attr_BOL[j]]));
	end;

   cq2.attr_closed := False;
End;


Procedure Close_all_attr_BOL(var cq2:TconvertedPass2);
{ -- Sluit all command's door the Attributen-rij af te lopen -- }
Var
   j:Integer;
Begin
   For j:=cq2.Lines[cq2.cur].num_of_attr Downto $01
   Do Write(cq2.latex^,Close_com[cq2.Lines[cq2.cur].attr_BOL[j]]);

   cq2.attr_closed := True;
End;



Procedure Open_all_attr_EOL(var cq2:TconvertedPass2);
{ -- Open all command's door the Attributen-rij af te lopen -- }
Var j:Integer;
Begin
  For j:=$01 to cq2.Lines[cq2.next].num_of_attr Do
             Write(cq2.latex^,Open_com[cq2.Lines[cq2.next].attr_BOL[j]]);

  cq2.attr_closed := False;
End;

{ -- Sluit all command's door the Attributen-rij af te lopen -- }
Procedure Close_all_attr_EOL(var cq2:TconvertedPass2);
Var j:Integer;
Begin
  For j:=cq2.Lines[cq2.next].num_of_attr Downto $01
  Do Write(cq2.latex^,Close_com[cq2.Lines[cq2.next].attr_BOL[j]]);

  cq2.attr_closed := True;
End;


{ -- Maak het the standard-heading voor one latex-file tied -- }
Procedure Latex_head(var cq2:TconvertedPass2);
Begin
  Writeln(cq2.latex^,'\documentstyle[11pt,wp2latex]{article}');
  Writeln(cq2.latex^,'\begin{document}');

  if Cyrilic then
  	begin
        Writeln(cq2.latex^);
        Writeln(cq2.latex^,'\font\bukvy=wncyr10');
        end;
End;

{ -- Sluit the latex-file op the juiste wijze af -- }
Procedure Latex_foot(var cq2:TconvertedPass2);
Begin
  Writeln(cq2.latex^,'\end{document}')
End;

Procedure Latex_tabset(var cq2:TconvertedPass2);
Var
   atpr,j    : Integer;
   l,ol : Real;

Begin
   atpr:=0;                  { Huiding aantal tabs per row }
   ol:=0;
   For j:=1 to cq2.num_of_tabs Do
	 Begin
         l:=cq2.tabpos[j]/1200 * 2.54;
         Write(cq2.latex^,'\hspace{', l-ol :3:2,'cm}\=');
         atpr:=atpr+1;
         If atpr>=4
         Then Begin
                 Writeln(cq2.latex^,'%');
                 atpr:=0;
              End;
         ol:=l;
      End;
   Writeln(cq2.latex^,'\kill');
End;

Function Change_envir_BOL(var cq2:TconvertedPass2) : Boolean;
Begin
  change_envir_BOL :=		{!!!!!!!! }
	((cq2.Lines[cq2.cur].envir<>cq2.Lines[cq2.pre].envir) and (cq2.Lines[cq2.cur].envir in ['B','L','R','C','T','I','i','Q']));
End;

Function Change_envir_EOL(var cq2:TconvertedPass2) : Boolean;
Begin
  change_envir_EOL :=
     (cq2.Lines[cq2.next].envir<>cq2.Lines[cq2.cur].envir) and	{!!!!!!}
	((cq2.Lines[cq2.cur].Envir in ['B','L','R','C','T','I','i','Q']) or
	 (cq2.Lines[cq2.next].envir in ['B','L','R','C','T','I','i','Q']));
End;


Procedure Open_environment(var cq2:TconvertedPass2);

Begin
   If change_envir_BOL(cq2) Then                { changed environment ? }
        Begin
	   If Not cq2.attr_closed  Then Close_all_attr_BOL(cq2);

	   Case cq2.Lines[cq2.cur].envir of
              'B' : Begin
		       Writeln(cq2.latex^,'\begin{tabular}');
		    End;

	      'C' : Begin
		       Writeln(cq2.latex^,'\begin{center}');
		    End;

              'L' : Begin
		       Writeln(cq2.latex^,'\begin{flushleft}');
		    End;

	      'R' : Begin
		       Writeln(cq2.latex^,'\begin{flushright}');
		    End;

	      'T' : Begin
		       Writeln(cq2.latex^,'\begin{tabbing}');
		       latex_tabset(cq2);
		    End;

	  'i','I' : Begin	{first indent}	{!!!!!!!!!!!!!!!!!!!!!!!}
                    if cq2.Lines[cq2.cur].indent_level<2 then
                       begin
                       if cq2.Lines[cq2.pre].Lstring[0]<>#0
		                then Writeln(cq2.latex^,'\testlastline'#13#10)
                       		else Writeln(cq2.latex^,'\zerotestlastline');
                       end;
		     Write(cq2.latex^,'\begin{indenting}');
		     Writeln(cq2.latex^,'{',cq2.Lines[cq2.cur].ind_leftmargin/1200*2.54:3:2,'cm}');
(*		       Write(cq2.latex^,'{',cq2.ind_rightmargin[cq2.cur]/1200*2.54:3:2,'cm}');
		       If cq2.ind_label[cq2.cur]=1 Then
                            Begin
			       Writeln(cq2.latex^,'%');
			       Write(cq2.latex^,'{');
			    End
		            Else Writeln(cq2.latex^,'{}');*)
		    End;
              'Q' : Begin
		       Writeln(cq2.latex^,'\begin{displaymath}');
                    end;
	   End;

	End

        Else If cq2.Lines[cq2.cur].new_tabset and (cq2.Lines[cq2.cur].Envir='T') Then Latex_tabset(cq2);
End;



Procedure Close_environment(var cq2:TconvertedPass2);
Begin
  Case cq2.Lines[cq2.cur].envir of
              'B' : Begin
		       Writeln(cq2.latex^,'\end{tabular}');
		    End;

              'C' : Begin
                       Writeln(cq2.latex^,'\end{center}');
                    End;

              'L' : Begin
		       Writeln(cq2.latex^,'\end{flushleft}');
		    End;

	      'R' : Begin
		       Writeln(cq2.latex^,'\end{flushright}');
                    End;

              'T' : Begin
                       Writeln(cq2.latex^,'\end{tabbing}');
                    End;

           'I','i': Begin
		      Writeln(cq2.latex^,'\end{indenting}');
                    End;


              'Q' : Begin
                       Writeln(cq2.latex^,'\end{displaymath}');
                    end;
           End;

  cq2.just_envir_closed := True;
End;


Procedure Update_global_information(var cq2:TconvertedPass2);
Var
   j : Integer;

Begin
   If cq2.Lines[cq2.cur].new_tabset
   Then Begin
           cq2.num_of_tabs:=cq2.tabent_num_of_tabs[cq2.cur];
           For j:=1 to cq2.num_of_tabs
           Do cq2.tabpos[j]:=cq2.tabent_tabpos[cq2.cur,j]
        End;

   If cq2.new_tabent_rightjust[cq2.cur]
   Then cq2.new_rightjust := cq2.tabent_rightjust[cq2.cur];

End;


Procedure Change_tabelentry(var cq2:TconvertedPass2);
Var
   help : Integer;

Begin
   help:=cq2.pre;
   cq2.pre:=cq2.cur;
   cq2.cur:=cq2.next;
   cq2.next:=help;
   Read_tabelentry(cq2.next,cq2);
End;

Procedure OptimSectionStr(aline:pchar);
var optimized:Boolean;
    i:integer;
begin
repeat
if aline=nil then exit;
if aline[0]=#0 then exit;

      Optimized:=False;

      i:=StrLen(aLine);
      while aline[i-1]=' ' do
              begin
              aline[i-1]:=#0;
              dec(i);
              end;
      while aline[0]=' ' do
              begin
              StrCopy(aline,aline+1);
              dec(i);
              end;

      if (aline[i-1]='\') and (aline[i-2]='\') then
              begin
              aline[i-2]:=#0;
              dec(i,2);
              end;

      if (aline[i-1]='}') then
              begin
              if StrLComp(aline,'{\bf',4)=0 then
                      begin
                      aline[i-1]:=#0;
                      StrCopy(aline,aline+4);
                      dec(i,5);
                      Optimized:=True;
                      end;
              end;

      if (aline[i-1]='}') then
              begin
	      if ((StrLComp(aline,'{\large',7)=0)or(StrLComp(aline,'{\Large',7)=0))or(StrLComp(aline,'{\LARGE',7)=0) then
                      begin
                      aline[i-1]:=#0;
                      StrCopy(aline,aline+7);
                      dec(i,8);
                      Optimized:=True;
                      end;
              end;

      until not(Optimized)
end;

Function FixBracket(Line:Pchar):integer;
var i,Len:integer;
begin
  if Line=nil then
  	begin
        FixBracket:=0;
	exit;
        end;

  len:=StrLen(Line);
  For i:=len Downto 0 do
        begin
        Line[i+2]:=Line[i];
        end;
  Line[0]:='{';
  Line[1]:='}';
  inc(len,2);
  FixBracket:=Len;
end;

Function TryToRemoveRM(Helps:pchar):Boolean;
var i,j:integer;
begin
 TryToRemoveRM:=False;
 i:=0;
 j:=0;
 if HelpS=nil then exit;

 if HelpS[j]<>'{' then exit;
 inc(j);
 if HelpS[j]<>'\' then exit;
 inc(j);
 if HelpS[j]<>'r' then exit;
 inc(j);
 if HelpS[j]<>'m' then exit;
 inc(j);
 while HelpS[j]=' ' do
 	begin
	inc(j);
        end;
 if HelpS[j]<>'}' then exit;
 inc(j);
{j points to the point after removed area}
 while Helps[j]<>#0 do
 	begin
        helps[i]:=Helps[j];
        inc(i);
        inc(j);
        end;
 helps[i]:=#0;
 TryToRemoveRM:=True;
end;


Function TryToRemoveIT(Helps:pchar):Boolean;
var i,j:integer;
begin
 TryToRemoveIT:=False;
 i:=0;
 j:=0;
 if HelpS=nil then exit;

 if HelpS[j]<>'{' then exit;
 inc(j);
 if HelpS[j]<>'\' then exit;
 inc(j);
 if HelpS[j]<>'i' then exit;
 inc(j);
 if HelpS[j]<>'t' then exit;
 inc(j);
 while HelpS[j]=' ' do
 	begin
	inc(j);
        end;
 if (HelpS[j]='\') and (HelpS[j+1]='/') then inc(j,2);
 if HelpS[j]<>'}' then exit;
 inc(j);
{j points to the point after removed area}
 while Helps[j]<>#0 do
 	begin
        helps[i]:=Helps[j];
        inc(i);
        inc(j);
        end;
 helps[i]:=#0;
 TryToRemoveIT:=True;
end;

{******************---PASS2---*****************}
Procedure Convert_second_strike(var Strip:text;var Tabel:Bin;var FileOut:Text);
Var i      : Integer;
    aLine  : pchar;
    HelpS  : pchar;
    len_reg: Integer;

    cq2:TconvertedPass2;
Begin
   cq2.tabel:=addr(Tabel);
   cq2.Strip:=addr(Strip);
   cq2.Latex:=addr(FileOut);


   cq2.pre:=0;
   cq2.cur:=1;
   cq2.next:=2;

   cq2.Lines[cq2.pre].envir:=' ';
   cq2.Lines[cq2.pre].new_tabset:=False;

   cq2.just_envir_closed:=True;
   cq2.attr_closed := False;

   cq2.rightjust:=True;
   cq2.new_rightjust:=True;
   For i:=0 to 2 Do
      Begin
         Getmem(cq2.Lines[i].Lstring,MaxLineSize);
         cq2.Lines[i].Lstring[0]:=#0;
         cq2.Lines[i].InhibitBsBslash:=False;
         cq2.new_tabent_rightjust[i]:=False;
         cq2.tabent_rightjust[i]:=False;
         cq2.Lines[i].Envir:='?'; {!!!}
      End;

   Read_tabelentry(cq2.cur,cq2);
   Read_tabelentry(cq2.next,cq2);

   cq2.rownum:=1;

   if Verbosing>=1 then
   	begin
	Writeln;
	Writeln('Second pass :');
	Write('Converting-percentage :     ');
        end;


   Latex_head(cq2);

   fGets2(strip,cq2.Lines[cq2.cur].Lstring,MaxLineSize-1);
   While (Not Eof(strip) or (cq2.Lines[cq2.cur].Lstring[0]<>#0)) and (not keypressed) Do
         Begin
	 Update_global_information(cq2);

	 if num_of_lines_stripfile>0 then
		 cq2.convperc := round((100*cq2.rownum)/num_of_lines_stripfile);
	 if cq2.convperc>100 then cq2.convperc:=100;
         if Verbosing>=1 then
             begin
	     Write(chr(8),chr(8),chr(8),chr(8),cq2.convperc:3,'%');
             end;


{read next row from strip file}
         fGets2(strip,cq2.Lines[cq2.next].Lstring,MaxLineSize-1);
         aLine:=cq2.Lines[cq2.cur].Lstring;

	 len_reg := StrLen(aLine);

{!!!!!!!!!!!}

{ More than two spaces must be fixed. }
         if FixSpaces then
 	     if cq2.Lines[cq2.cur].envir<>'Q' then
	        For i:=1 to len_reg-1 Do
		    If (aLine[i]=' ') and (aLine[i+1]=' ') Then
			     aLine[i+1]:='~';{}

{ Correct illegal argument which begins '['. }
	 If ((len_reg>=1) and (aLine[1]='[')) or
	    ((len_reg>=2) and (aLine[1]=' ') and (aLine[2]='[')) Then
			len_reg:=FixBracket(aLine);

{Try to repair \section{ }
          if OptimizeSection then
          	begin
                if (strpos(aLine,'\section{')<>nil) then
                	begin
                        cq2.Lines[cq2.cur].InhibitBsBslash:=True;
                        cq2.Lines[cq2.next].InhibitBsBslash:=True;
                        OptimSectionStr(aline);
                        OptimSectionStr(strpos(aLine,'\section{')+9);
                        end;
                if (strpos(aLine,'\subsection{')<>nil) then
                	begin
                        cq2.Lines[cq2.cur].InhibitBsBslash:=True;
                        cq2.Lines[cq2.next].InhibitBsBslash:=True;
                        OptimSectionStr(aline);
                        OptimSectionStr(strpos(aLine,'\subsection{')+12);
                        end;
                if (strpos(aLine,'\subsubsection{')<>nil) then
                	begin
                        cq2.Lines[cq2.cur].InhibitBsBslash:=True;
                        cq2.Lines[cq2.next].InhibitBsBslash:=True;
                        OptimSectionStr(aline);
                        OptimSectionStr(strpos(aLine,'\subsubsection{')+15);
                        end;
                end;

         len_reg := StrLen(aLine);
{ the row is now corrected. }
	 

	 If cq2.new_rightjust xor cq2.rightjust Then
              Begin
		 cq2.rightjust := cq2.new_rightjust;
		 If cq2.rightjust Then Writeln(cq2.latex^,'\justified')
			          Else Writeln(cq2.latex^,'\raggedright');
	      End;


	 Open_environment(cq2);

	 If len_reg>0 Then
	     Begin
	     If cq2.attr_closed Then Open_all_attr_BOL(cq2);


    { remove dummy items {\rm }
             HelpS:=StrPos(aLine,'{\rm');{}
             while HelpS<>nil do
		    begin
                    if not(TryToRemoveRM(Helps)) then inc(Helps);
	            HelpS:=StrPos(HelpS,'{\rm');{}
        	    end;

    { remove dummy items {\it }         	{!!!!!!!!!!}
             HelpS:=StrPos(aLine,'{\it');{}
             while HelpS<>nil do
		    begin
                    if not(TryToRemoveIT(Helps)) then inc(Helps);
	            HelpS:=StrPos(HelpS,'{\it');{}
        	    end;




	     Write(cq2.latex^,aLine);	{here is written current line}
	     cq2.just_envir_closed := False;
	     End;


	 Case cq2.Lines[cq2.cur].line_term of

	     's','p':Begin
		      Writeln(cq2.latex^);
		      If Change_envir_EOL(cq2) Then
			   Begin
			   If Not cq2.attr_closed Then Close_all_attr_EOL(cq2);
			   Close_environment(cq2);
			   End;
		    End;

	      'h' : Begin
		    If upcase(cq2.Lines[cq2.cur].envir)='I' Then {!!!!!!}
                              Begin
			       If Not cq2.attr_closed Then Close_all_attr_EOL(cq2);
			       Writeln(cq2.latex^);
			       Close_environment(cq2);
			       cq2.Lines[cq2.cur].envir:=' ';
			      End

		         Else Begin
			       cq2.underline:=False;
			       For i:=$01 to $10 Do
			          cq2.underline := cq2.underline
					       Or (cq2.Lines[cq2.next].attr_BOL[i]=$B)
					       Or (cq2.Lines[cq2.next].attr_BOL[i]=$E);

			       If cq2.underline and Not cq2.attr_closed
					       Then Close_all_attr_EOL(cq2);

		       { Elke Indent-environment moet na one harde Return}
		       { Afgesloten worden.}


			       If Change_envir_EOL(cq2) Then
                                   Begin
                                     If cq2.just_envir_closed
				        Then Writeln(cq2.latex^,'\nwln')
				        Else Writeln(cq2.latex^);

				     If Not cq2.attr_closed Then Close_all_attr_EOL(cq2);

				     Close_environment(cq2);
				   End
			         Else Begin
                                      if (cq2.Lines[cq2.cur].Lstring[0]=#0) and
				         (cq2.Lines[cq2.pre].Lstring[0]=#0) then
				           write(cq2.latex^,'\bigskip')
                                      else if cq2.Lines[cq2.next].Lstring[0]=#0 then
                                        begin
                                        cq2.Lines[cq2.next].InhibitBsBslash:=True;
                                        end
                                      else if (cq2.Lines[cq2.cur].Envir<>'T')and(cq2.Lines[cq2.pre].Envir='T') then
                                      	begin	{!!! after Tab must not be \\}
                                       {asm int 3; end;}
                                        end
				      else if not(cq2.Lines[cq2.cur].InhibitBsBslash) then
                                           begin
				           If cq2.just_envir_closed
				               Then Write(cq2.latex^,'\nwln')
				               Else Write(cq2.latex^,'\\');
                                           if cq2.Lines[cq2.next].Lstring[0]='[' then
                                        	   FixBracket(cq2.Lines[cq2.next].Lstring);
                                           end;

                                      Writeln(cq2.latex^);
				       End;
			    End;
		    End;

	      'P' : Begin
		       If Not cq2.attr_closed
		       Then Close_all_attr_EOL(cq2);

		       Writeln(cq2.latex^);
		       Close_environment(cq2);
		       Writeln(cq2.latex^,'\newpage');
		       cq2.Lines[cq2.cur].envir:=' ';
		    End;

	       End {Case};


         cq2.Lines[cq2.pre].Lstring[0]:=#0;
         cq2.Lines[cq2.pre].InhibitBsBslash:=False;
	 Change_tabelentry(cq2);

	 cq2.rownum:=cq2.rownum+1;
      End;

   Latex_foot(cq2);
   Writeln;

   For i:=0 to 2 Do
      Begin
         FreeMem(cq2.Lines[i].Lstring,MaxLineSize);
      end;
End;

end.