
      { Thot structure schema for Scalable Vector Graphics }

STRUCTURE GraphML;

DEFPRES GraphMLP;

ATTR

   { global attributes for all GraphML elements }
   id = text;
   class = text;
   style_ = text;
   xml_space = xml_space_default, xml_space_preserve;

   { global attributes for internal processing }
   Invalid_attribute = text;
   Ghost_restruct = text;
   Highlight = Yes_;        { to show the SVG element corresponding to the
			      current selection in the source view }
   Namespace = text;        { for children of element foreignObject }
   IntEmptyShape = yes_, no_;

STRUCT

   GraphML
	(ATTR viewBox = text;
	      x = text;
              y = text;
	      !height_ = text;
	      !width_ = text;
	      Charset = text)
        = LIST OF (GraphicsElement) + (XMLcomment, XMLPI)
          with height_ ?= '6cm', width_ ?= '10cm';

   g
        (ATTR fill = text;
	      stroke = text;
	      stroke_width = text;
	      transform = text;
              linestyle_ = solid_, dashed_, dotted_)
        = LIST OF (GraphicsElement);

   defs
        (ATTR { requiredFeatures; requiredExtensions; systemLanguage }
	      externalResourcesRequired = false, true;
	      fill;
	      stroke;
	      stroke_width;
	      transform;
	      { graphicsElementEvents })
        = LIST OF (GraphicsElement);

   { path }
	
   Spline
        (ATTR width_;
              height_;
	      transform;
              points = text;
              arrowhead = none_, start, end_, both;
              linestyle_)
        = GRAPHICS;
	
   ClosedSpline
        (ATTR width_;
              height_;
	      transform;
              points;
              linestyle_)
        = GRAPHICS;

   rect
        (ATTR transform;
	      x;
              y;
              width_;
              height_;
	      rx = text;
	      ry = text;
	      fill;
              stroke;
	      stroke_width;
              linestyle_)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   circle
        (ATTR transform;
	      cx = text;
	      cy = text;
              r = text;
	      fill;
              stroke;
	      stroke_width;
              linestyle_)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   ellipse
        (ATTR transform;
	      cx;
	      cy;
	      rx;
	      ry;
	      fill;
              stroke;
	      stroke_width;
              linestyle_)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   line_
        (ATTR transform;
	      x1 = text;
	      y1 = text;
              x2 = text;
	      y2 = text;
	      fill;
              stroke;
	      stroke_width;
              linestyle_;
              arrowhead)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   polyline
        (ATTR width_;
              height_;
	      transform;
              points;
	      fill;
              stroke;
	      stroke_width;
              arrowhead;
              linestyle_)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   polygon
        (ATTR width_;
              height_;
	      transform;
              points;
	      fill;
              stroke;
	      stroke_width;
              linestyle_)
        = AGGREGATE
	      desc; title; metadata;
	      GRAPHICS;
	      END;
	
   text_
        (ATTR transform;
	      x;
	      y)
         = LIST OF (TextComponent);

   tspan
	(ATTR x;
              y;
	      dx = text;
	      dy = text)
	= LIST OF (SpanElement);

   { tref }
   { textPath }
   { altGlyph }
   { altGlyphDef }
   { glyphSub }
   { font }
   { glyph }
   { missing-glyph }
   { hkern }
   { vkern }

   use_
        (ATTR xlink_href = text;
	      { requiredFeatures; requiredExtensions; systemLanguage }
	      externalResourcesRequired;
	      fill;
	      stroke;
	      stroke_width;
	      transform;
	      { graphicsElementEvents }
	      x; 
	      y;
              width_;
              height_)
        = AGGREGATE
              desc; title; metadata;
	      END;
	
   image
	(ATTR xlink_href;
	      transform;
	      x; 
	      y;
              width_;
              height_)
        = AGGREGATE
              desc; title; metadata;
              PICTURE;
	      END;

   symbol_
	(ATTR externalResourcesRequired;
	      fill;
	      stroke;
	      stroke_width;
	      viewBox;
	      preserveAspectRatio = text; 
	      { graphicsElementEvents })
        = LIST OF (GraphicsElement);
	      
   { marker }
   
   desc = TEXT;
	
   title = TEXT;
	
   { clipPath }
   { mask }
   { linearGradient }
   { radialGradient }
   { stop }
   { pattern }

   a
        (ATTR { requiredFeatures; requiredExtensions; systemLanguage }
	      externalResourcesRequired;
	      fill;
              stroke;
	      stroke_width;
	      transform;
	      { graphicsElementEvents }
	      target_ = text)
	= GraphicsElement;

   { view }
   { animate }
   { set }
   { animateMotion }
   { animateColor }
   { animateTransform }

   script
	(ATTR externalResourcesRequired;
	      type = text)
	= TEXT;

   style__
	(ATTR type;
	      media = text;
	      title_ = text)
	= TEXT;

   { color-profile }
   { color-profile-src }
   { font-face }
   { font-face-src }
   { font-face-uri }
   { font-face-format }
   { font-face-name }
   { definition-src }
   { cursor }
   { switch }

   foreignObject
        (ATTR transform;
	      x; 
              y;
              width_;
              height_; 
              fill;
              stroke)
	= BEGIN CASE OF
	      HTML; MathML;
	      END;
          END;
	              
   metadata = TEXT;

   { filter }
   { ... }

   GraphicsElement
	= CASE OF
	      desc; title; metadata; defs;
	      Spline; ClosedSpline;
	      text_; rect; circle; ellipse; line_; polyline; polygon;
	      use_; image; GraphML; g; a;
	      script; style__; symbol_;
	      foreignObject; XLink;
	      END;

   TextComponent
	= CASE OF
	      tspan;	{ must be the first option, to allow the Return key
			  to create tspan elements }
	      TEXT; 
	      desc;
	      title;
	      metadata;
	      END;

   SpanElement
	= CASE OF
	      TEXT;
	      tspan; 
	      desc;
	      title;
	      metadata;
	      END;
   
   XMLcomment = LIST OF (XMLcomment_line = TEXT);

   XMLPI = LIST OF (XMLPI_line = TEXT);

EXCEPT

   GraphML:             IsDraw, MoveResize, NoShowBox, NoMove;
   g:                   NoMove, NoResize, NoShowBox, NoCreate;
   defs:                NoMove, NoResize, NoShowBox, NoCreate;
   Spline:              MoveResize, HighlightChildren, NoShowBox, NoCreate;
   ClosedSpline:        MoveResize, HighlightChildren, NoShowBox, NoCreate;
   rect:                MoveResize, HighlightChildren, NoShowBox, NoCreate;
   circle:              MoveResize, HighlightChildren, NoShowBox, NoCreate;
   ellipse:             MoveResize, HighlightChildren, NoShowBox, NoCreate;
   line_:               MoveResize, HighlightChildren, NoShowBox, NoCreate;
   polyline:            MoveResize, HighlightChildren, NoShowBox, NoCreate;
   polygon:             MoveResize, HighlightChildren, NoShowBox, NoCreate;
   text_:               MoveResize, NoResize, NoShowBox, ReturnCreateWithin,
	                NoCreate;
   tspan:	        NoShowBox; 
   use_:	        NoMove, NoResize, NoShowBox, NoCreate;
   image:	        MoveResize, HighlightChildren, NoShowBox, NoCreate;
   symbol_:	        NoMove, NoResize, NoShowBox, NoCreate;
   a:	                NoMove, NoResize, NoShowBox, NoCreate;
   script:	        NoMove, NoResize, NoShowBox, NoCreate;
   style__:             NoMove, NoResize, NoShowBox, NoCreate;
   foreignObject:       MoveResize, NoCreate;
   PICTURE:             NoMove, NoResize;
   TEXT:                NoMove, NoResize;

   id:                  CssId;
   class:               CssClass;
   Invalid_attribute:   Invisible;
   Highlight:	        Invisible; 
   Ghost_restruct:      Invisible;
   Namespace:	        Invisible;
   IntEmptyShape:       Invisible;

END



