NCSA Mosaic for the X Window System Version 2.4 + fish search from TUE
======================================================================

Welcome to NCSA Mosaic augmented with the "fish search" developed at the
Eindhoven University of Technology.

This README details installation steps that differ from the standard
ones.  README.imake details the changes because of the use of imake.

README details the standard installation.

README-2.0 details major differences and new features in the 2.x
versions of Mosaic and should be read by anyone migrating from Mosaic
1.x.

More complete information and documentation on NCSA Mosaic is
available online, via NCSA Mosaic.

More complete information and documentation on the "fish search" is
available online, via NCSA Mosaic.

Binaries
--------

NCSA Mosaic + fish search compiles and runs on some SVR4 flavors for the 386
(486) PC, with the GNU C-compiler (2.5.8 and others), on Solaris x86 2.1 and
on Sun Sparc with Sunos 4.1.3, and maybe others.
Mosaic may not work with some versions of OpenWindows. It does work with
XFree86, both the X11r5 and X11r6 version.
The regex library does *not* compile on some SVR4 systems with the standard
C compiler (bug in the compiler), and on HPUX you may need to do something
to include alloca (even when you tell regex to not use alloca).

Binaries for Solaris x86 and Sun 4 are available on ftp.win.tue.nl
in pub/infosystems/www/Mosaic-binaries.
The source is available on ftp.win.tue.nl in pub/infosystems/www.
(Sorry for the inconvenience of hiding this stuff far away.
Our ftp-system-administrators did not allow us to put this stuff in a
more visible place.)

Installation Instructions
-------------------------

Installation is different from NCSA's because we included the Imake
support by Rainer Klute.

Examine the file Mosaic.cf, change the appropriate customizable options,
and type 'sh imake.sh', followed by make.

The final result is a single independent executable, src/Mosaic.

A brief description of the search
---------------------------------

Under the 'Navigate' menu there are two new options: one for setting up
the search algorithm and one for displaying the result (which is done
automatically once the search starts).

The navigation algorithm will be described in detail at the RIAO-94
conference on Information Retrieval. A brief discussion of the algorithm
can be found in the proceedings of the WWW-94 conference.

There are 4 different searches:
- you can specify a set of keywords to be matched exactly (but may be
  caseless). documents matching several keywords are ranked higher than
  documents matching only one keyword.
  example:	computing computer
- you can specify / followed by a regular expression (syntax of stock
  GNU regex) to search for a regular expression.
  example:	/comp.ting
  the syntax can be selected from a menu. the "agrep" syntax causes the
  approximate grep to be performed insted of the GNU regex search.
- you can specify ! followed by a command line which must function as a
  filter (i.e. accept standard input and produce standard output) that
  produces a single number as output.
  example:	!grep computing | wc -l

Resources
---------

A number of resources can be set for the search:

Mosaic.fishDocsDirectory:	directory containing documentation
Mosaic.searchMaxTime:	number of minutes the search may take
Mosaic.searchMaxDepth:	depth of search before giving up
Mosaic.searchMaxWidth:	limits the width of search per document
Mosaic.searchHTMLOnly:	search only documents with .html suffix
Mosaic.searchDomainType:	search limited to this level of subdomains
			(0=world, 1= *.x, 2= *.y.x, ... 5=one host only)
Mosaic.searchCaseLess:	boolean toggle case sensitivity
Mosaic.searchUseServers:	pass query to remote servers
Mosaic.searchRegexType:	syntax for regular expressions, can be any one of
			the types that appear in this menu.
Mosaic.searchNumErrors:	number of errors allowed in approximate grep.
Mosaic.searchAnd:	boolean toggle: true = all keywords must occur,
			false = not all keywords need occur.

Bug Reports and Comments
------------------------

Bug reports and other comments can be sent to www@win.tue.nl.

Cheers,

Paul De Bra and Reinier Post
Information Systems Group
Dept. of Computing Science
Eindhoven University of Technology
Eindhoven, the Netherlands.
debra@win.tue.nl, reinpost@win.tue.nl
