#include "StyleAttr.h"
#include "StyleAttrProto.h"

StyleAttr::StyleAttr( StyleAttrProto* proto )
        : _proto( proto )
{
}

StyleAttr::StyleAttr( const StyleAttr& src )
        : _proto( src._proto )
{
}

StyleAttr::~StyleAttr()
{
}

const QString& StyleAttr::name()
{
    return _proto->name();
}

int StyleAttr::type()
{
    return _proto->type();
}

const StyleAttrProto* StyleAttr::proto()
{
    return _proto;
}

StringStyleAttr::StringStyleAttr( StyleAttrProto* proto,
                                  const QString&  value )
        : StyleAttr( proto ),
          _value( value.copy() )
{
}

StringStyleAttr::StringStyleAttr( const StringStyleAttr& src )
        : StyleAttr( src ),
          _value( src._value.copy() )
{
}

const QString& StringStyleAttr::value()
{
    return _value;
}

NumberStyleAttr::NumberStyleAttr( StyleAttrProto* proto,
                                  int             value,
                                  bool            isPercent )
        : StyleAttr( proto ),
          _value( value ),
          _isPercent( isPercent )
{
}

NumberStyleAttr::NumberStyleAttr( const NumberStyleAttr& src )
        : StyleAttr( src ),
          _value( src._value ),
          _isPercent( src._isPercent )
{
}

int NumberStyleAttr::value()
{
    return _value;
}

bool NumberStyleAttr::isPercent()
{
    return _isPercent;
}

EnumeratedStyleAttr::EnumeratedStyleAttr( StyleAttrProto* proto,
                                          int             value )
        : StyleAttr( proto ),
          _value( value )
{
}

EnumeratedStyleAttr::EnumeratedStyleAttr( const EnumeratedStyleAttr& src )
        : StyleAttr( src ),
          _value( src._value )
{
}

int EnumeratedStyleAttr::value()
{
    return _value;
}

ListStyleAttr::ListStyleAttr( StyleAttrProto* proto,
                              const QString&  value )
        : StyleAttr( proto ),
          _value( value.copy() )
{
}

ListStyleAttr::ListStyleAttr( const ListStyleAttr& src )
        : StyleAttr( src ),
          _value( src._value.copy() )
{
}

const QString& ListStyleAttr::value()
{
    return _value;
}
