// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qapp.h>
#include "Bookmarks.h"
#include "Browser.h"
#include "BrowserList.h"
#include "Cache.h"
#include "Connection.h"
#include "ConsoleWindow.h"
#include "FormObjectRenderer.h"
#include "HostCache.h"
#include "Poller.h"
#include "PrefsWindow.h"
#include "Renderer.h"
#include "SgmlCatalog.h"
#include "StyleEditor.h"
#include "StyleSheetManager.h"
#include "StyleSheetProto.h"
#include "Options.h"
#include "DtdManager.h"

HostCache*         hostCache;
Cache*             cache;
Options*           options;
Poller*            poller;
SgmlCatalog*       sgmlCatalog;
DtdManager*        dtdManager;
BrowserList*       browserList;
Bookmarks*         bookmarks;
ConsoleWindow*     console;
PrefsWindow*       prefsWindow;
StyleEditor*       styleEditor;
StyleSheetManager* styleSheetManager;
StyleSheetProto*   styleSheetProto;

void myMessageOutput( QtMsgType type, const char *msg )
{
    switch ( type ) {
        case QtDebugMsg:
            if ( console ) {
                console->debug( msg );
            } else {
                printf( "Debug: %s\n", msg );
            }
            break;
        case QtWarningMsg:
            if ( console ) {
                console->warning( msg );
            } else {
                printf( "Warning: %s\n", msg );
            }
            break;
        case QtFatalMsg:
            printf( "Fatal: %s\n", msg );
            abort();
            break;
    }
}

int main( int argc, char* argv[] )
{
    // Install my own message handler.
    qInstallMsgHandler( myMessageOutput );

    QApplication app( argc, argv );

    app.setFont( QFont( "helvetica", 12 ) );

    // Global instance objects.
    console           = new ConsoleWindow;
    styleSheetProto   = new StyleSheetProto;
    options           = new Options( argc, argv );
    prefsWindow       = new PrefsWindow;
    poller            = new Poller;
    sgmlCatalog       = new SgmlCatalog;
    dtdManager        = new DtdManager;
    styleSheetManager = new StyleSheetManager;
    browserList       = new BrowserList;
    hostCache         = new HostCache;
    cache             = new Cache;
    bookmarks         = new Bookmarks;
    styleEditor       = new StyleEditor;
    
    Browser* browser = new Browser;
    browserList->browserOpened( browser );
    browser->show();
    if ( options->autoLoad() ) {
        browser->open( options->homeUrl() );
    }
    app.exec();

    delete styleSheetProto;
    delete options;
    delete prefsWindow;
    delete poller;
    delete sgmlCatalog;
    delete dtdManager;
    delete styleSheetManager;
    delete browserList;
    delete hostCache;
    delete cache;
    delete bookmarks;
    delete styleEditor;
    delete console;
    
    exit( 0 );
}
