/* $Id: config.h,v 1.2 1997/04/09 17:12:20 sverrehu Exp $ */
#ifndef CONFIG_H
#define CONFIG_H

#include <paths.h> /* _PATH_DEFPATH if you want it */

/* the user running CGI-programs (the Web server). */
#define HTTP_USER "www"

/* name of the user's WWW-directory (no trailing slash). if the path
 * doesn't start with a slash, the user's home-directory is prepended
 * to it. this name is used for checking if the program to start is a
 * legal program: only programs in this directory, or it's
 * subdirectories, are allowed to be started. */
/* #define WWW_ROOT_DIRECTORY "public_html" */
#define WWW_ROOT_DIRECTORY "www_docs"

/* define USE_SCRIPT_NAME to derive the path of programs to execute
 * from the SCRIPT_NAME environment variable set for CGI programs. the
 * string "/~username" is replaced with the user's www root directory.
 * if undefined, argv[0] will be used, a solution that may fail
 * depending on how your Web server executes the program. */
#define USE_SCRIPT_NAME

/* extensions of programs to search for. any extension is removed from
 * the name by which suidcgi is called, and the following extensions are
 * tested. */
#define PROGRAM_EXTENSIONS "", ".cgi", ".bin", ".exe", ".pl", ".sh", ".tcl"

/* the PATH environment variable to give to the program started. */
/* #define DEFAULT_PATH _PATH_DEFPATH */
#define DEFAULT_PATH "/local/gnu/bin:/usr/local/bin:/local/bin:/usr/bin:/bin:/usr/sbin:/sbin"

/* define PASS_ERROR_TO_CLIENT to send error messages to the client in
 * addition to sending it to stderr. */
#define PASS_ERROR_TO_CLIENT

/* environment variables to keep. a few others are set by the program
 * as well, such as PATH, HOME and USER. in addition, all variables
 * starting with HTTP_ are kept, as these contain HTTP header
 * information. the intention of cleaning the environment, is to avoid
 * often-exploited security holes, such as tricking with IFS and
 * LD_*. */
#define SAFE_ENVIRONMENT_VARIABLES \
    /* CGI variables */            \
    "AUTH_TYPE",                   \
    "CONTENT_LENGTH",              \
    "CONTENT_TYPE",                \
    "GATEWAY_INTERFACE",           \
    "PATH_INFO",                   \
    "PATH_TRANSLATED",             \
    "QUERY_STRING",                \
    "REMOTE_ADDR",                 \
    "REMOTE_HOST",                 \
    "REMOTE_IDENT",                \
    "REMOTE_USER",                 \
    "REQUEST_METHOD",              \
    "SCRIPT_NAME",                 \
    "SERVER_NAME",                 \
    "SERVER_PORT",                 \
    "SERVER_PROTOCOL",             \
    "SERVER_SOFTWARE",             \
    /* other */                    \
    "LANG",                        \
    "LC_CTYPE",                    \
    "TZ",

#endif
