/*
 *  hashlib.h - enables hash
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define HASHSIZE    101
#define MAXWORDLEN  128

typedef struct node {
  struct node  *left, *right;
  char         *key;     /* the key   (of this node) */
  char         *value;   /* the value (of this node) */
} Node, *NodePtr;

void  memory_error( void );
char *save_string( char *string );

void  hash_add_peer( Node **node, char *key, char *value );
void  hash_clear_peer( Node **node );
void  hash_list_peer( Node *node );
char *hash_value_peer( Node *node, char *key );

int   hashlib_test_main( void );

int   hash( char *s );
void  hash_init( void );
void  hash_add( char *key, char *value );
void  hash_clear( void );
void  hash_list( void );
char *hash_value( char *key );




