%{
/*
 *  html.y - a parser source for yacc.
 *           without any change, you can make it by GNU bison, too.
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "lexlib.h"

#define yywrap()  1

char buf[16384];

#include "latex.h"
extern ModeType mode;

#include "hashlib.h"

%}
%union {
  int type;
  int addr;
  char *name;
}
%token <type> LP LP_SLASH RP AND SEMICOLON EQUAL SPACE RETURN
%token HTML HEAD TITLE BODY
%token BR HR IMG
%token CENTER ANCHOR PARAGRAPH PARAGRAPH_END FONT BIG SMALL PRE SCRIPT
%token H1 H2 H3 H4 H5 H6
%token BOLD ITALIC TYPEWRITER UNDERLINE 
%token BLOCKQUOTE ADDRESS ISINDEX
%token EM STRONG CODE SAMP KBD TAG_VAR CITE DFN
%token NOBR WBR BASEFONT BLINK
%token TABLE TR TH TD CAPTION
%token O_LIST U_LIST LISTITEM D_LIST D_TERM D_DEFINE MENU DIR
%token FORM INPUT SELECT OPTION TEXTAREA
%token TeX LaTeX LaTeX2e pTeX pLaTeX pLaTeX2e
%token <addr> CONTEXT 
%token STRING 
%token VAR PARAM

%start html
%%
html
    : fragment
    ;

fragment
    : /* empty */
    | fragment CONTEXT
        { do_fragment( poolat($<addr>2) ); }
    | fragment SPACE
        { do_space(); }
    | fragment RETURN
        { do_return(); }
    | fragment tex_family
    | fragment amper
    | fragment LP BR RP
        { do_br(); }
    | fragment LP WBR RP
        { do_wbr(); }
    | fragment LP HR
        { push_mode( mode ); mode = M_HR; }
      tag_options RP
		{ do_hr(); mode = pop_mode(); }
    | fragment LP IMG
        { push_mode( mode ); mode = M_IMG; }
      tag_options RP
        { do_img(); mode = pop_mode(); }
    | fragment LP ISINDEX RP
        {;}
    | fragment LP BASEFONT
      tag_options RP
        {;}
    | fragment tag_begin        fragment tag_end
    | fragment html_begin       fragment html_end
    | fragment head_begin       fragment head_end
    | fragment title_begin      fragment title_end
    | fragment body_begin       fragment body_end
    | fragment anchor_begin     fragment anchor_end
    | fragment center_begin     fragment center_end
    | fragment font_begin       fragment font_end
    | fragment big_begin        fragment big_end
    | fragment small_begin      fragment small_end
    | fragment pre_begin        fragment pre_end
    | fragment h1_begin         fragment h1_end
    | fragment h2_begin         fragment h2_end
    | fragment h3_begin         fragment h3_end
    | fragment h4_begin         fragment h4_end
    | fragment h5_begin         fragment h5_end
    | fragment h6_begin         fragment h6_end
    | fragment paragraph_begin
    | fragment paragraph_end
    | fragment script_begin     fragment script_end
    | fragment bold_begin       fragment bold_end
    | fragment italic_begin     fragment italic_end
    | fragment typewriter_begin fragment typewriter_end
    | fragment underline_begin  fragment underline_end
    | fragment blockquote_begin fragment blockquote_end
    | fragment address_begin    fragment address_end
    | fragment em_begin         fragment em_end
    | fragment strong_begin     fragment strong_end
    | fragment code_begin       fragment code_end
    | fragment samp_begin       fragment samp_end
    | fragment kbd_begin        fragment kbd_end
    | fragment var_begin        fragment var_end
    | fragment cite_begin       fragment cite_end
    | fragment dfn_begin        fragment dfn_end
    | fragment nobr_begin       fragment nobr_end
    | fragment blink_begin      fragment blink_end
    | fragment table_begin table space table_end
    | fragment ulist_begin      fragment ulist_end
    | fragment olist_begin      fragment olist_end
    | fragment menu_begin       fragment menu_end
    | fragment dir_begin        fragment dir_end
    | fragment dlist_begin space dlist_items dlist_end
    | fragment list_item
    | fragment form_begin       fragment form_end
    | fragment form_input
    | fragment select_begin     fragment select_end
    | fragment select_option
    | fragment textarea_begin   fragment textarea_end
    | error tag_end
        { yyerrok; /* clearnode(); */ }
    | error RETURN
        { yyerrok; /* clearnode(); */ }
    ;

html_begin
    : LP HTML RP
        { do_html_begin(); }
    ;
html_end
    : LP_SLASH HTML RP
        { do_html_end(); }
    ;
    
head_begin
    : LP HEAD RP
        {;}
    ; 
head_end
    : LP_SLASH HEAD RP
        {;}
    ;

title_begin
    : LP TITLE RP
        { do_title_begin(); }
    ;
title_end
    : LP_SLASH TITLE RP
        { do_title_end(); }
    ;

body_begin
    : LP BODY 
        { do_body_begin();
		  push_mode( mode );
		  mode = M_BODY; }
      tag_options RP
    ;
body_end
    : LP_SLASH BODY RP
        { do_body_end(); mode = pop_mode(); }
    ;

tag_options
    : /* empty */
        { hash_clear(); }
    | tag_options VAR
        { hash_add( poolat($<addr>2), "1" ); }
    | tag_options VAR EQUAL PARAM
        { hash_add( poolat($<addr>2), poolat($<addr>4) ); }
    ;

amper
    : AND STRING SEMICOLON
        { char *p = (char *)poolat($<addr>2);
		  switch( p[0] ) {
		  case '#':
			do_hichar( atoi(p+1) ); 
			break;
		  case 'a':  
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(224); break;  /* &agrave; */
			case 'a':  do_hichar(225); break;  /* &aacute; */
			case 'c':  do_hichar(226); break;  /* &acirc;  */
			case 't':  do_hichar(227); break;  /* &atilde; */
			case 'u':  do_hichar(228); break;  /* &auml;   */
			case 'r':  do_hichar(229); break;  /* &aring;  */
			case 'e':  do_hichar(230); break;  /* &aelig;  */
			case 'm':  
			default:
			  do_char('&'); break;             /* &amp;  & */
			}
			break;
		  case 'A':  
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(192); break;  /* &Agrave; */
			case 'a':  do_hichar(193); break;  /* &Aacute; */
			case 'c':  do_hichar(194); break;  /* &Acirc;  */
			case 't':  do_hichar(195); break;  /* &Atilde; */
			case 'u':  do_hichar(196); break;  /* &Auml;   */
			case 'r':  do_hichar(197); break;  /* &Aring;  */
			case 'e':  do_hichar(198); break;  /* &Aelig;  */
			case 'm':  
			default:
			  do_char('&'); break;             /* &amp;  & */
			}
			break;
		  case 'c':
			switch( tolower(p[1]) ) {
			case 'o':
			  do_hichar(169); break;           /* &copy;   */
			case 'c':
			default:
			  do_hichar(231); break;           /* &ccedil; */
			}
			break;
		  case 'C':
			switch( tolower(p[1]) ) {
			case 'o':
			  do_hichar(169); break;           /* &copy;   */
			case 'c':  
			default:
			  do_hichar(199); break;           /* &Ccedil; */
			}
			break;
		  case 'e':  
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(232); break;  /* &egrave; */
			case 'c':  do_hichar(234); break;  /* &ecirc;  */
			case 'u':  do_hichar(235); break;  /* &euml;   */
			case 't':  do_hichar(240); break;  /* &eth;    */
            case 'm':  /* &em..; */
			  switch( tolower(p[2]) ) {
			  case 'd':  do_emdash(); break;   /* &emdash; */
			  case 's':
			  default:   do_emsp(); break;     /* &emsp;   */
			  }
			  break;
            case 'n':  /* &en..; */
			  switch( tolower(p[2]) ) {
			  case 'd':  do_endash(); break;   /* &endash; */
			  case 's':
			  default:   do_ensp(); break;     /* &ensp;   */
			  }
			  break;
			case 'a':  
			default:
			  do_hichar(233); break;  /* &eacute; */
			}
			break;
		  case 'E':  
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(200); break;  /* &Egrave; */
			case 'c':  do_hichar(202); break;  /* &Ecirc;  */
			case 'u':  do_hichar(203); break;  /* &Euml;   */
			case 't':  do_hichar(208); break;  /* &ETH;    */
            case 'm':  /* &em..; */
			  switch( tolower(p[2]) ) {
			  case 'd':  do_emdash(); break;   /* &emdash; */
			  case 's':
			  default:   do_emsp(); break;     /* &emsp;   */
			  }
			  break;
            case 'n':  /* &en..; */
			  switch( tolower(p[2]) ) {
			  case 'd':  do_endash(); break;   /* &endash; */
			  case 's':
			  default:   do_ensp(); break;     /* &ensp;   */
			  }
			  break;
			case 'a':  
			default:
			  do_hichar(201); break;           /* &Eacute; */
			}
			break;
		  case 'g': case 'G': 
			do_char('>');                      /* &gt;  >  */
			break;
		  case 'i':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(236); break;  /* &igrave; */
			case 'a':  do_hichar(237); break;  /* &iacute; */
			case 'c':  do_hichar(238); break;  /* &icirc;  */
			case 'u':  
			default:
			  do_hichar(239); break;           /* &iuml;   */
			}
			break;
		  case 'I':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(204); break;  /* &Igrave; */
			case 'a':  do_hichar(205); break;  /* &Iacute; */
			case 'c':  do_hichar(206); break;  /* &Icirc;  */
			case 'u':  
			default:
			  do_hichar(207); break;           /* &Iuml;   */
			}
			break;
		  case 'l': case 'L':
			do_char('<');                      /* &lt;  <  */
			break;
		  case 'n':
			switch( tolower(p[1]) ) {
			case 'b':  do_nbsp(); break;       /* &nbsp;   */
			case 't':
			default:   do_hichar(241); break;  /* &ntilde; */
			}
			break;
		  case 'N':
			switch( tolower(p[1]) ) {
			case 'b':  do_nbsp(); break;       /* &nbsp;   */
			case 't':
			default:   do_hichar(209); break;  /* &Ntilde; */
			}
			break;
		  case 'o':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(242); break;  /* &ograve; */
			case 'a':  do_hichar(243); break;  /* &oacute; */
			case 'c':  do_hichar(244); break;  /* &ocirc;  */
			case 's':  do_hichar(247); break;  /* &oslash; */
			case 't':  do_hichar(245); break;  /* &otilde; */
			case 'u':
			default:
			  do_hichar(246); break;           /* &ouml;   */
			}
			break;
		  case 'O':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(210); break;  /* &Ograve; */
			case 'a':  do_hichar(211); break;  /* &Oacute; */
			case 'c':  do_hichar(212); break;  /* &Ocirc;  */
			case 's':  do_hichar(216); break;  /* &Oslash; */
			case 't':  do_hichar(213); break;  /* &Otilde; */
			case 'u':
			default:
			  do_hichar(214); break;           /* &Ouml;   */
			}
			break;
		  case 'q': case 'Q':
			do_char('"');                      /* &quot; " */
			break;
		  case 's':
			do_hichar(223);                    /* &szlig;  */
			break;
		  case 't':
			do_hichar(254);                    /* &thorn;  */
			break;
		  case 'T':
			do_hichar(222);                    /* &THORN;  */
			break;
		  case 'u':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(249); break;  /* &ugrave; */
			case 'a':  do_hichar(250); break;  /* &uacute; */
			case 'c':  do_hichar(251); break;  /* &ucirc;  */
			case 'u':
			default:
			  do_hichar(252); break;           /* &uuml;   */
			}
			break;
		  case 'U':
			switch( tolower(p[1]) ) {
			case 'g':  do_hichar(217); break;  /* &Ugrave; */
			case 'a':  do_hichar(218); break;  /* &Uacute; */
			case 'c':  do_hichar(219); break;  /* &Ucirc;  */
			case 'u':
			default:
			  do_hichar(220); break;           /* &Uuml;   */
			}
			break;
		  case 'y':
			switch( tolower(p[1]) ) {
			case 'a':  do_hichar(253); break;  /* &yacute; */
			case 'u':
			default:
			  do_hichar(255); break;           /* &yuml;   */
			}
			break;
		  case 'Y':
			do_hichar(221);                    /* &Yacute; */
			break;
		  default:
			break;
		  }
		}
    | AND CONTEXT
        { do_char('&');
		  /* do_fragment( poolat($<addr>5) ); */ }
    | AND SPACE
        { do_char('&'); do_space(); }
    | AND RETURN
        { do_char('&'); do_return(); }
    ;

tex_family
    : TeX
        { do_term("TeX"); }
    | LaTeX
        { do_term("LaTeX"); }
    | LaTeX2e
        { do_term("LaTeX2e"); }
    | pTeX
        { do_term("pTeX"); }
    | pLaTeX
        { do_term("pLaTeX"); }
    | pLaTeX2e
        { do_term("pLaTeX2e"); }
    ;

space
    : /* empty */
    | space SPACE
        { do_space(); }
    | space RETURN
        { do_return(); }
    ;

tag_begin
    : LP VAR
        { push_mode( mode );
          mode = M_UNKNOWN; }
      tag_options RP
    ;
tag_end
    : LP_SLASH VAR RP
        { mode = pop_mode(); }
    ;

anchor_begin
    : LP ANCHOR 
        { push_mode( mode );
	      mode = M_ANCHOR; }
      tag_options RP 
        { do_anchor_begin(); }
    ;
anchor_end
    : LP_SLASH ANCHOR RP 
		{ do_anchor_end(); 
		  mode = pop_mode(); }
    ;

paragraph_begin
    : LP PARAGRAPH
	    { /* mode = M_PARAGRAPH; */ }
      tag_options RP
		{ do_paragraph_begin(); }
    ;
paragraph_end
    : PARAGRAPH_END
        { /* mode = M_UNKNOWN; */
		  do_paragraph_end(); }
    ;

center_begin
    : LP CENTER
        { push_mode( mode );
		  mode = M_CENTER; }
      tag_options RP
        { do_center_begin(); }
    ;
center_end
    : LP_SLASH CENTER RP
        { do_center_end(); 
          mode = pop_mode(); }
    ;

font_begin
    : LP FONT
        { push_mode( mode );
          mode = M_FONT; }
      tag_options RP
        { do_font_begin(); }
    ;
font_end
    : LP_SLASH FONT RP
        { do_font_end(); 
		  mode = pop_mode(); }
    ;
big_begin
    : LP BIG RP
        { push_mode( mode ); mode = M_BIG;
          do_big_begin(); }
    ;
big_end
    : LP_SLASH BIG RP
        { do_big_end(); 
		  mode = pop_mode(); }
    ;
small_begin
    : LP SMALL RP
        { push_mode( mode ); mode = M_SMALL;
          do_small_begin(); }
    ;
small_end
    : LP_SLASH SMALL RP
        { do_small_end(); 
		  mode = pop_mode(); }
    ;

h1_begin
    : LP H1
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(1); }
    ;
h1_end
    : LP_SLASH H1 RP
        { do_h_end(); 
		  mode = pop_mode(); }
    ;

h2_begin
    : LP H2
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(2); }
    ;
h2_end
    : LP_SLASH H2 RP
        { do_h_end();
		  mode = pop_mode(); }
    ;

h3_begin
    : LP H3
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(3); }
    ;
h3_end
    : LP_SLASH H3 RP
        { do_h_end();
		  mode = pop_mode(); }
    ;

h4_begin
    : LP H4
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(4); }
    ;
h4_end
    : LP_SLASH H4 RP
        { do_h_end();
		  mode = pop_mode(); }
    ;

h5_begin
    : LP H5
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(5); }
    ;
h5_end
    : LP_SLASH H5 RP
        { do_h_end();
		  mode = pop_mode(); }
    ;

h6_begin
    : LP H6
        { push_mode( mode );
          mode = M_Hn; }
      tag_options RP
        { do_h_begin(6); }
    ;
h6_end
    : LP_SLASH H6 RP
        { do_h_end();
		  mode = pop_mode(); }
    ;


pre_begin
    : LP PRE RP
        { push_mode( mode );
          mode = M_PRE;
		  do_pre_begin(); }
    ;
pre_end
    : LP_SLASH PRE RP
	    { do_pre_end();
		  mode = pop_mode(); }
    ;
table_begin
    : LP TABLE
        { push_mode( mode );
          mode = M_TABLE; }
      tag_options RP 
		{ table_start(); }
    ;
table
    : /* empty */
    | table space table_caption
    | table space table_lines_begin table_line space table_lines_end
    ;
table_end
    : LP_SLASH TABLE RP
        { table_end();
		  table_show();
		  mode = pop_mode(); }
    ;

table_caption
    : table_caption_begin fragment table_caption_end
    ;
table_caption_begin
    : LP CAPTION
        { push_mode( mode );
          mode = M_CAPTION; }
      tag_options RP
    ;
table_caption_end
    : LP_SLASH CAPTION RP
	    { mode = pop_mode(); }
    ;

table_lines_begin
    : LP TR tag_options RP 
        {;}
    ;
table_line
    : /* empty */
    | table_line space table_cell
        {;}
    ;
table_lines_end
    : LP_SLASH TR RP
        { table_newline(); }
    ;

table_cell
    : table_th_begin fragment table_th_end
    | table_td_begin fragment table_td_end
    ;
table_th_begin
    : LP TH
      tag_options RP 
        { do_table_th_begin(); }
    ;
table_th_end
    : LP_SLASH TH RP 
        { do_table_th_end(); }
    ;
table_td_begin
    : LP TD
      tag_options RP 
        { do_table_td_begin(); }
    ;
table_td_end
    : LP_SLASH TD RP
        { do_table_td_end(); }
    ;

ulist_begin
    : LP U_LIST
        { push_mode( mode );
          mode = M_ULIST; }
      tag_options RP 
		{ do_ulist_begin(); }
    ;
ulist_end
    : LP_SLASH U_LIST RP
		{ do_ulist_end();
		  mode = pop_mode(); }
    ;
olist_begin
    : LP O_LIST
        { push_mode( mode );
          mode = M_OLIST; }
      tag_options RP 
		{ do_olist_begin(); }
    ;
olist_end
    : LP_SLASH O_LIST RP
		{ do_olist_end();
		  mode = pop_mode(); }
    ;
menu_begin
    : LP MENU RP
        { push_mode( mode );
          mode = M_MENU;
		  do_menu_begin(); }
    ;
menu_end
    : LP_SLASH MENU RP
		{ do_menu_end();
		  mode = pop_mode(); }
    ;
dir_begin
    : LP DIR RP
        { push_mode( mode );
          mode = M_DIR;
		  do_dir_begin(); }
    ;
dir_end
    : LP_SLASH DIR RP
		{ do_dir_end();
		  mode = pop_mode(); }
    ;
list_item
    : LP LISTITEM
      tag_options RP 
        { do_listitem(); }
    ;
dlist_begin
    : LP D_LIST
        { push_mode( mode );
          mode = M_DLIST; }
      tag_options RP
		{ do_dlist_begin(); }
    ;
dlist_end
    : LP_SLASH D_LIST RP
		{ do_dlist_end();
		  mode = pop_mode(); }
    ;
dlist_items
    : /* empty */
    | dlist_items dlist_term dlist_define
    ;
dlist_term
    : D_TERM
        { do_dlist_term(); }
      fragment
    ;
dlist_define
    : D_DEFINE
        { do_dlist_define(); }
      fragment
    ;

script_begin
    : LP SCRIPT
        { push_mode( mode );
          mode = M_SCRIPT; }
      tag_options RP
		{ do_script_begin(); }
    ;
script_end
    : LP_SLASH SCRIPT RP
	    { do_script_end();
		  mode = pop_mode(); }
    ;

blockquote_begin
    : LP BLOCKQUOTE
        { push_mode( mode );
          mode = M_BLOCKQUOTE; }
      tag_options RP
		{ do_blockquote_begin(); }
    ;
blockquote_end
    : LP_SLASH BLOCKQUOTE RP
	    { do_blockquote_end();
		  mode = pop_mode(); }
    ;

address_begin
    : LP ADDRESS RP
        { push_mode( mode );
	      mode = M_ADDRESS;
	      do_address_begin(); }
    ;
address_end
    : LP_SLASH ADDRESS RP
	    { do_address_end();
		  mode = pop_mode(); }
    ;

bold_begin
    : LP BOLD RP
        { push_mode( mode );
	      mode = M_BOLD;
	      do_bold_begin(); }
    ;
bold_end
    : LP_SLASH BOLD RP
        { do_bold_end();
	      mode = pop_mode(); }
    ;

italic_begin
    : LP ITALIC RP
        { push_mode( mode );
	      mode = M_ITALIC;
	      do_italic_begin(); }
    ;
italic_end
    : LP_SLASH ITALIC RP
	    { do_italic_end();
		  mode = pop_mode(); }
    ;

underline_begin
    : LP UNDERLINE RP
        { push_mode( mode );
	      mode = M_UNDERLINE;
		  do_underline_begin(); }
    ;
underline_end
    : LP_SLASH UNDERLINE RP
	    { do_underline_end();
		  mode = pop_mode(); }
    ;

typewriter_begin
    : LP TYPEWRITER RP
        { push_mode( mode );
	      mode = M_TYPEWRITER;
	      do_typewriter_begin(); }
    ;
typewriter_end
    : LP_SLASH TYPEWRITER RP
	    { do_typewriter_end();
		  mode = pop_mode(); }
    ;

em_begin
    : LP EM RP
        { push_mode( mode ); mode = M_EM;
	      do_em_begin(); }
    ;
em_end
    : LP_SLASH EM RP
        { do_em_end();
	      mode = pop_mode(); }
    ;

strong_begin
    : LP STRONG RP
        { push_mode( mode ); mode = M_STRONG;
	      do_strong_begin(); }
    ;
strong_end
    : LP_SLASH STRONG RP
        { do_strong_end();
	      mode = pop_mode(); }
    ;

code_begin
    : LP CODE RP
        { push_mode( mode ); mode = M_CODE;
	      do_code_begin(); }
    ;
code_end
    : LP_SLASH CODE RP
        { do_code_end();
	      mode = pop_mode(); }
    ;

samp_begin
    : LP SAMP RP
        { push_mode( mode ); mode = M_SAMP;
	      do_samp_begin(); }
    ;
samp_end
    : LP_SLASH SAMP RP
        { do_samp_end();
	      mode = pop_mode(); }
    ;

kbd_begin
    : LP KBD RP
        { push_mode( mode ); mode = M_KBD;
	      do_kbd_begin(); }
    ;
kbd_end
    : LP_SLASH KBD RP
        { do_kbd_end();
	      mode = pop_mode(); }
    ;

var_begin
    : LP TAG_VAR RP
        { push_mode( mode ); mode = M_VAR;
	      do_var_begin(); }
    ;
var_end
    : LP_SLASH TAG_VAR RP
        { do_var_end();
	      mode = pop_mode(); }
    ;

cite_begin
    : LP CITE RP
        { push_mode( mode ); mode = M_CITE;
	      do_cite_begin(); }
    ;
cite_end
    : LP_SLASH CITE RP
        { do_cite_end();
	      mode = pop_mode(); }
    ;

dfn_begin
    : LP DFN RP
        { push_mode( mode ); mode = M_DFN;
	      do_dfn_begin(); }
    ;
dfn_end
    : LP_SLASH DFN RP
        { do_dfn_end();
	      mode = pop_mode(); }
    ;

nobr_begin
    : LP NOBR RP
        { push_mode( mode ); mode = M_NOBR;
	      do_nobr_begin(); }
    ;
nobr_end
    : LP_SLASH NOBR RP
        { do_nobr_end();
	      mode = pop_mode(); }
    ;

blink_begin
    : LP BLINK RP
        { push_mode( mode ); mode = M_BLINK;
	      do_blink_begin(); }
    ;
blink_end
    : LP_SLASH BLINK RP
        { do_blink_end();
	      mode = pop_mode(); }
    ;

form_begin
    : LP FORM
        { push_mode( mode );
          mode = M_FORM; }
      tag_options RP
		{ do_form_begin(); }
    ;
form_end
    : LP_SLASH FORM RP
        { do_form_end();
	      mode = pop_mode(); }
    ;

form_input
    : LP INPUT tag_options RP
		{ do_form_input(); }
    ;

select_begin
    : LP SELECT
        { push_mode( mode );
          mode = M_SELECT; }
      tag_options RP
		{ do_select_begin(); }
    ;
select_end
    : LP_SLASH SELECT RP
        { do_select_end();
	      mode = pop_mode(); }
    ;
select_option
    : LP OPTION 
      tag_options RP
		{ do_select_option_begin(); }
    ;

textarea_begin
    : LP TEXTAREA 
        { push_mode( mode );
          mode = M_TEXTAREA; }
      tag_options RP
		{ do_textarea_begin(); }
    ;
textarea_end
    : LP_SLASH TEXTAREA RP
        { do_textarea_end();
	      mode = pop_mode(); }
    ;

%%
/* 
 *  display an error message
 */
int yyerror( char *msg )
{
  /* extern int zzlineno; */
 
  /* fprintf(stderr, "%d: %s\n", zzlineno, msg); */

  fprintf(stderr, "%s\n", msg);

  return 0;
}
