/*
 *  http.c - connects to host:80 and fetch something by HTTP
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <sys/file.h>
#include <time.h>

#include "http.h"

int   is_base_set = 0;
int   base_port;
char  base_hostname[80];
char  base_path[256];
char  base_file[256];

int http_connect( char *hostname )
{
  char  c;
  int   soc;
  struct hostent *hp;
  struct sockaddr_in sin;

  /*
   * Next, we need to look up the network
   * address of our host.
   */
  if ((hp = gethostbyname(hostname)) == NULL) {
	fprintf(stderr, "%s: unknown host.\n", hostname);
	return -1;
  }

  /* 
   * Get a socket to work with.  This socket will
   * be in the Internet domain, and will be a 
   * stream socket.
   */
  if ((soc = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("client: socket");
	return -1;
  }

  /* 
   * Create the address we will be connecting to.
   * We use port 80 but put it into network
   * byte order.  Also, we use bcopy (see Chapter
   * 14) to copy the network number.
   */
  sin.sin_family = AF_INET;
  sin.sin_port = htons(80);
  bcopy( hp->h_addr, &sin.sin_addr, hp->h_length );
  
  /*
   * Try to connect to the address.  For this to
   * succeed, the server must already have bound
   * this address, and must have issued a listen()
   * request.
   */
  if (connect(soc, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
	perror("client: connect");
	return -1;
  }

  return soc;
}

FILE *http_get( int soc, char *path )
{
  char  get_url[256];
  FILE *fp;

  fp = fdopen(soc, "r");  /* use stdio for reading the socket. */

  /* send GET strings to the server. */
  sprintf( get_url, "GET %s\n", path );
  send(soc, get_url, strlen(get_url), 0);

  return fp;
}
  
void http_close( int soc )
{
  /*
   * We can simply use close() to terminate the
   * connection, since we're done with both sides.
   */
  close( soc );
}

int url_analyse( char *url, char *hostname, char *path )
{
  char *p, *q;

  for (p=url; *p!=0; p++) {
	/* in order to avoid troubles in system(),
	   convert all 's and `s into an underbar */
	if (*p == 0x27 || *p == 0x60) *p = '_';
  }

  p = strstr(url, "http://");
  if (p != NULL) {
	strncpy( hostname, p+7, 63 );
	q = strchr( hostname, '/' );
	if (q != NULL) {
	  *q = 0;
	  strcpy( path, url+7+strlen(hostname) );
	} else
	  strcpy( path, "/" );  /* 'http://www.naochan.com' type */

	// printf("hostname(%s) path(%s)\n", hostname, path);

	return 80;
  }

  p = strstr(url, "file://");
  if (p != NULL) {
	hostname[0] = '\0';
	strcpy( path, p+7 );

	return 0;
  }

  p = strstr(url, "ftp://");
  if (p != NULL) {
	strncpy( hostname, p+6, 63 );
	q = strchr( hostname, '/' );
	if (q != NULL) {
	  *q = 0;
	  strcpy( path, url+6+strlen(hostname) );
	} else
	  strcpy( path, "/" );

	return 21;
  }

  p = strstr(url, "telnet://");
  if (p != NULL) {
	strcpy( hostname, p+9 );
	path[0] = '\0';

	return 23;
  }

  p = strstr(url, "mailto:");
  if (p != NULL) {
	hostname[0] = '\0';
	if (p[7] == '/')
	  strcpy( path, p+8 ); /* mailto:// */
	else
	  strcpy( path, p+7 ); /* mailto:   */

	return 25;
  }

  if (is_base_set > 0) {
	char  *q, base2[256];

	strcpy( hostname, base_hostname );

	switch( url[0] ) {
	case '#':
	  sprintf( path, "%s%s%s", base_path, base_file, url ); break;
	case '/':
	  strcpy( path, url ); break;
	case '.':
	  strncpy( base2, base_path, strlen(base_path)-1 );
	  base2[strlen(base_path)-1] = '\0';
	  switch( url[1] ) {
	  case '/':  /* ./ */
		sprintf( path, "%s/%s", base2, url+2 );
		break;
	  case '.':  /* .. */
		q = strrchr( base2, '/' );
		if (q != NULL)
		  *q = '\0';
		if ( url[3] != '.' ) {  /* ../[^.] */
		  sprintf( path, "%s/%s", base2, url+3 );  /* skip the ../ */
		} else {                  /* ../.    */
		  if (url[4] == '.') {  /* ../..   */
			q = strrchr( base2, '/' );
			if (q != NULL)
			  *q = '\0';
			sprintf( path, "%s/%s", base2, url+6 );  /* skip the ../ */
		  } else {
			sprintf( path, "%s/%s", base2, url+3 );  /* skip the ../ */
		  }
		}
		break;		
	  default:
		sprintf( path, "%s/%s", base2, url ); break;
	  }
	  break;
	default:
	  sprintf( path, "%s%s", base_path, url ); break;
	}

	return 80;
  }

  strcpy( path, url );  /* assume it's only a filename */
  return 0;
}

int set_base_url( char *url )
{
  char *p;

  base_port = url_analyse( url, base_hostname, base_path );
  p = strrchr( base_path, '/' );
  strcpy( base_file, p+1 ); /* save after '/' of base_path into base_file */
  p[1] = '\0';              /* make base_path end by '/' */

  /* printf("set base url: (%d)(%s)(%s)\n", 
		 base_port, base_hostname, base_path); */

  is_base_set = 1;
}

FILE *open_url( int *soc, char *url )
{
  int   port;
  char  hostname[64], path[200];
  FILE *from;

  port = url_analyse( url, hostname, path );
// fprintf(stderr, "url(%s) --> (%d)(%s)(%s)\n", url, port, hostname, path);
  switch (port) {
  case 80:
	if ((*soc = http_connect( hostname )) == -1)
	  return NULL;

	return http_get( *soc, path );
	
	break;
  case 0:
  default:
	if ((from = fopen( path, "r" )) == NULL) {
	  perror("cannot open the file.");
	  return NULL;
	}
	return from;
	break;
  }
  return NULL;
}

void close_url( int soc )
{
  http_close( soc );
}

int url_get( FILE *to, char *url )
{
  int   soc;
  FILE *from;

  from = open_url( &soc, url );

  if (from != NULL)
	putout( from, to );

  close_url( soc );
}
  

void putout( FILE *from, FILE *to )
{
  int  c;

  while( (c = fgetc(from)) != EOF )
	putc(c, to);
}

int    tmp_count = 0;        /* assume (int_max) images a second */
time_t tmp_second = 0;
char   tmp_sec_str[10 + 1];  /* MMDDhhmmss */

char *produce_nameof_tmpfile( char *suffix )
{
  char    buf[32], *return_string;
  time_t      now_time;
  struct tm  *now_tm;

  time( &now_time );
  if ( now_time != tmp_second ) {
	tmp_second = now_time;
	now_tm = localtime( &now_time );
	sprintf(tmp_sec_str, "%02d%02d%02d%02d%02d", 
			now_tm->tm_mon, now_tm->tm_mday,
			now_tm->tm_hour, now_tm->tm_min, now_tm->tm_sec );
	tmp_count = 0;
  }

  sprintf(buf, "/tmp/br%s%02d%s", tmp_sec_str, ++tmp_count, suffix);
  return_string = (char *)malloc(strlen(buf));
  strcpy( return_string, buf );

  return return_string;
}

int tmp_open( char **tmpfile, int flags, char *suffix )
{
  int  file;

  /* create a name of tmpfile */
  if ((*tmpfile = produce_nameof_tmpfile( suffix )) == NULL) {
	return -1;
  }
  /* open the tmpfile for saving GIF image */
  if ((file = open(*tmpfile, flags, 0644)) == -1) {
	perror("open");
	free( *tmpfile );
	return -1;
  }
  return file;
}  

char *getimage( char *url )
{
  char  hostname[80], path[256];
  char  sh_cmd[256];
  char *tmp_file; /* tmp file for EPSF */

  if ((tmp_file = produce_nameof_tmpfile(".epsf")) == NULL)
	return NULL;

  fprintf(stderr, "Getting %s...\n", url);
  url_analyse( url, hostname, path );

  sprintf(sh_cmd,
		  "%s/gethtml 'http://%s%s' | %s/giftopnm | %s/pnmtops -noturn > '%s'",
		  BINDIR, hostname, path, NETPBMDIR, NETPBMDIR, tmp_file );
  /*
   *   'hostname' and 'path' is from url_analyse().
   *   'tmp_file' is from produce_nameof_tempfile().
   *
   *   Both of them, are already considered about security problems.
   *   But if 'gethtml', 'giftopnm', and 'pnmtops' are dangerous, I don't 
   *   know what may occur.
   */

  system( sh_cmd );

  return tmp_file;  /* name of the tmpfile */
}




