/*
 *  latex.h - some definitions needed by latex.c
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __WEBTEX__LATEX_H__
#define __WEBTEX__LATEX_H__

typedef enum { M_UNKNOWN,
 			   M_BODY, M_PRE, M_HR, M_IMG, M_Hn,
			   M_TABLE, M_CAPTION, M_ULIST, M_OLIST, M_MENU, M_DIR, M_DLIST,
			   M_BOLD, M_ITALIC, M_TYPEWRITER, M_UNDERLINE,
               M_EM, M_STRONG, M_CODE, M_SAMP, M_KBD, M_VAR, M_CITE, M_DFN,
               M_NOBR, M_BLINK, M_BLOCKQUOTE, M_ADDRESS, M_SCRIPT,
			   M_FORM, M_INPUT, M_SELECT, M_OPTION, M_TEXTAREA,
			   M_CENTER, M_ANCHOR, M_PARAGRAPH, 
               M_FONT, M_BIG, M_SMALL
} ModeType;

void push_fontsize( int size );
int pop_fontsize( void );

void push_mode( ModeType mode_type );
ModeType pop_mode( void );

void puts0( char *string );   /* puts() without '\n' */
void putc0( int ch );         /* putchar() */
void puti0( int num );       
void puti0_r( int num );      /* Roman num. (i,ii,iii,iv,v,vi,...) */
int  printf0( char *format, ... );

void latex_begin( void );
void latex_end( void );
 
void do_fragment( char *fragment_string );
void do_space( void );
void do_return( void );
void do_char( char ch );
void do_hichar( int ch );
void do_begin( void );
void do_end( void );
void do_something_begin( char *sth );
void do_something_end( void );

void do_html_begin( void );
void do_html_end( void );
void do_title_begin( void );
void do_title_end( void );
void do_body_begin( void );
void do_body_end( void );

void do_br( void );
void do_wbr( void );
void do_hr( void );
void do_img( void );

void do_paragraph_begin( void );
void do_paragraph_end( void );
void do_h_begin( int h_level );
void do_h_end( void );

void do_anchor_begin( void );
void do_anchor_end( void );
void do_center_begin( void );
void do_center_end( void );
void do_font_begin( void );
void do_font_end( void );
void do_big_begin( void );     /* 0.96 */
void do_big_end( void );       /* 0.96 */
void do_small_begin( void );   /* 0.96 */
void do_small_end( void );     /* 0.96 */
void do_script_begin( void );
void do_script_end( void );
void do_pre_begin( void );
void do_pre_end( void );

/* table.h */

#define TABLE_ROWS_MAX 32
#define TABLE_COLUMNS_MAX 32

typedef struct {
  int   rowspan;      /* row span */
  int   colspan;      /* column span */
  char *content;      /* content of that cell */
  char  align;        /* 'l'eft, (c)enter, 'r'ight  */
  char  valign;       /* 't'op,  (m)iddle, 'b'ottom */
} TableCell;

void table_init( void );
void table_start( void );
void do_table_cell_begin( void );
void do_table_cell_end( void );
void do_table_th_begin( void );
void do_table_th_end( void );
void do_table_td_begin( void );
void do_table_td_end( void );
void table_newline( void );
void table_end( void );
void table_append( int x, int y, char *str );
void table_show( void );

/* listing */

void do_ulist_begin( void );
void do_ulist_end( void );
void do_olist_begin( void );
void do_olist_end( void );
void do_menu_begin( void );
void do_menu_end( void );
void do_dir_begin( void );
void do_dir_end( void );

void do_listitem( void );

void do_dlist_begin( void );
void do_dlist_end( void );
void do_dlist_term( void );
void do_dlist_define( void );

/* other */

void do_bold_begin( void );
void do_bold_end( void );
void do_italic_begin( void );
void do_italic_end( void );
void do_typewriter_begin( void );
void do_typewriter_end( void );
void do_underline_begin( void );
void do_underline_end( void );
void do_blockquote_begin( void );
void do_blockquote_end( void );
void do_address_begin( void );
void do_address_end( void );
void do_em_begin( void );
void do_em_end( void );
void do_strong_begin( void );
void do_strong_end( void );
void do_code_begin( void );
void do_code_end( void );
void do_samp_begin( void );
void do_samp_end( void );
void do_kbd_begin( void );
void do_kbd_end( void );
void do_var_begin( void );
void do_var_end( void );
void do_cite_begin( void );
void do_cite_end( void );
void do_dfn_begin( void );
void do_dfn_end( void );
void do_nobr_begin( void );
void do_nobr_end( void );
void do_blink_begin( void );
void do_blink_end( void );

void do_ensp( void );
void do_emsp( void );
void do_nbsp( void );
void do_endash( void );
void do_emdash( void );

void do_term( char *term );

void do_form_begin( void );
void do_form_end( void );
void do_form_input( void );
void do_select_begin( void );
void do_select_end( void );
void do_select_option_begin( void );
void do_textarea_begin( void );
void do_textarea_end( void );

#endif  /* latex.h */


