/*
 *  lexlib.c - enable pool memory for (f)lex
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include "lexlib.h"

int  poolcnt = 1;               
char poolarea[POOLSIZE] = { 0 };  /* poolat(0) = "" */

int pool(char *p)
{
  int  cnt_keep, cnt_next, len;

  cnt_keep = poolcnt;
  len = strlen(p);
  if (p[0] == '"' && p[len-1] == '"') {
	len -= 2;
	p++;
	p[len] = '\0';
  }
  cnt_next = poolcnt + len + 1;

  if (cnt_next > POOLSIZE)
	fprintf(stderr, "poolarea overflow");
  else {
    strcpy(&poolarea[poolcnt], p);
    poolcnt = cnt_next; 
  }
  return cnt_keep;
}

char *poolat(int pool_index)
{
  return &poolarea[pool_index];
}

int ppcat( int pool_a, int pool_b )
{
  char *p_a, *p_b;
  char *temp_buf;
  int   rv;
 
  p_a = &poolarea[pool_a];
  p_b = &poolarea[pool_b];

  temp_buf = (char *)malloc(strlen(p_a) + strlen(p_b) + 1);
  sprintf(temp_buf, "%s%s", p_a, p_b);
  rv = pool(temp_buf); 
  free(temp_buf);

printf("p(%s) + p(%s) --> (%s)\n", 
	   &poolarea[pool_a], &poolarea[pool_b], &poolarea[rv] );  
  return rv;
}

int pscat( int pool_a, char *str_b )
{
  char *p_a;
  char *temp_buf;
  int   rv;
 
  p_a = &poolarea[pool_a];

  temp_buf = (char *)malloc(strlen(p_a) + strlen(str_b) + 1);
  sprintf(temp_buf, "%s%s", p_a, str_b);
  rv = pool(temp_buf); 
  free(temp_buf);
  
printf("p(%s) + \"%s\" --> (%s)\n", 
	   &poolarea[pool_a], str_b, &poolarea[rv] );  
  return rv;
}

int spcat( char *str_a, int pool_b )
{
  char *p_b;
  char *temp_buf;
  int   rv;
 
  p_b = &poolarea[pool_b];

  temp_buf = (char *)malloc(strlen(str_a) + strlen(p_b) + 1);
  sprintf(temp_buf, "%s%s", str_a, p_b);
  rv = pool(temp_buf); 
  free(temp_buf);
  
  printf("\"%s\" + p(%s) --> (%s)\n", 
		 str_a, &poolarea[pool_b], &poolarea[rv] );  
  return rv;
}


