/*
 *  main.c - a main routine for webtex
 *
 *	Copyright (c) 1997 Naoya Tozuka <naochan@naochan.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You cannot use this program and its sources for commercial purposes.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>                 /* getopt() */

#include "hashlib.h"
#include "latex.h"
#include "http.h"

extern int  yyparse();

extern int   is_debug_mode;         /* in http.l */
extern int   is_graphic_enable;     /* in latex.c */
extern int   is_japanese_mode;      /* in latex.c */
extern int   is_showlink_mode;      /* in latex.c */

extern char *optarg;
extern int   optind;

extern FILE *yyin, *yyout;

/****************************************************

  webtex [-g][-j][-o file][-b baseURL][-d][-v] URL
    -g : show GIF image (as webtex can)
    -j : Japanese EUC mode
    -o : output LaTeX filename (default: in stdout)
    -b : base URL (default: same as <URL>)
    -d : show debug message (in stderr)
    -v : show version 

 ****************************************************/

void show_usage( void )
{
  puts("  webtex [-f][-g][-j][-o file][-b baseURL][-d][-v] URL");
  puts("    -f : show <A HREF=\"...\"> URLs in \\footnote");
  puts("    -g : show GIF image (as webtex can)");
  puts("    -j : Japanese EUC mode");
  puts("    -o : output LaTeX filename (default: in stdout)");
  puts("    -b : base URL (default: same as <URL>)");
  puts("    -d : show debug message (in stderr)");
  puts("    -v : show version");
}
void show_version( void )
{
  printf( "webtex version %g\n", (float)VERSION );
}


int main( int argc, char **argv )
{
  int    opt, v, soc = -1, is_base_set = 0;
  FILE  *fp = NULL;

/* if (argc == 1) {
	 show_usage();
	 exit(0);
   } */

  hash_init();
  table_init();

  if ((argc == 2) && (strncmp(argv[1], "http://", 7) == 0)) {
	yyin = open_url( &soc, argv[1] );
	if (is_base_set == 0) {
	  set_base_url( argv[1] );
	  is_base_set = 1;
	}
  } else {
	while (( opt = getopt( argc, argv, "fgjo:b:dv" )) != EOF ){
	  switch( opt ) {
	  case 'f':  /* show link URL */
		is_showlink_mode = 1;
		break;
	  case 'g':  /* enable GIF images */
		is_graphic_enable = 1;
		break;
	  case 'j':  /* Japanese EUC mode */
		is_japanese_mode = 1;
		break;
	  case 'o':  /* output file */	  
		if ((fp = fopen( optarg, "w" )) == NULL) {
		  fprintf(stderr, "cannot open file '%s'.\n", optarg);
		  exit(1);
		}
		yyout = fp;
		break;
	  case 'b':  /* base URL */
		if (strncmp(optarg, "http://", 7) == 0)
		  set_base_url( optarg );
		else
		  set_base_url( "http://localhost/" );
		is_base_set = 1;
		break;
	  case 'v':  /* show version */
		show_version();
		exit(0);
	  case 'd':  /* show debug info. */
		is_debug_mode = 1;
		break;
	  default:
		/* fprintf(stderr, "Unknown option -%c\n", opt); */
		show_usage();
		exit(0);
	  }
	  if (optind < argc && argv[optind][0] != '-') {
		if (strncmp(argv[optind], "http://", 7) == 0) {
		  yyin = open_url( &soc, argv[optind] );
		  if (is_base_set == 0) {
			set_base_url( argv[optind] );
			is_base_set = 1;
		  }
		  optind++;
		}
	  }
	}
  }
  latex_begin();   /* \documentstyle[epsbox]{jarticle} */
                   /* \begin{document}                 */
  v = (yyparse());

  latex_end();     /* \end{document}                   */

  if (soc > -1)
	close_url( soc );

  return v;
}

