	{ I. Vatton 	 Novembre 1994-1995  }

{ Variables used in ifdefs: PAGE, BLACK_WHITE, US_PAPER, LINK_NUMBER, LANDSDSCAPE}

PRESENTATION HTML;

VIEWS
   Formatted_view, Structure_view, Links_view, Alternate_view, Table_of_contents;

#ifdef US_PAPER
#define PAGE
#endif { US_PAPER }

#if defined(PAGE) || defined(LANDSCAPE)
PRINT
   Formatted_view;
#endif

#define STRUCT_INDENT 1.5
#define TAG_FONTSIZE 12 pt
#define DOC_FONTSIZE 12 pt
#define TAG_Weight Normal
#define TAG_Visibility 7

#ifdef BLACK_WHITE
#define TAG_Color Black
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#define INVALID_Color Black
#define UNKNOWNTAG_Color Black
#define LINK_Color Black
#else
#define TAG_Color Blue
#define ATTR_Color Blue
#define ATTRVALUE_Color Enclosing=
#define INVALID_Color Red
#define UNKNOWNTAG_Color Red
#define LINK_Color DarkIndigo1
#endif

#define TAG_Font Helvetica
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Style_Links_view Italics
#define ATTR_Visibility 6
#define INPUT_Font Courier
#define COMMENT_Visibility 5
#define COMMENT_Font Helvetica
#define COMMENT_Style Italics
#define COMMENT_Weight Normal
#define INVALID_Style Roman
#define INVALID_Weight Normal
#define INVALID_Visibility 5
#define INVALID_Font Helvetica
#define TableHSpace 0.2
#define TableVSpace 0.3
#define VSpaceBeforeH1 0.5
#define VSpaceBeforeH2 0.5
#define VSpaceBeforeH3 0.5
#define VSpaceBeforeH4 0.5
#define VSpaceBeforeH5 0.5
#define VSpaceBeforeH6 0.5
#define VSpaceInToC 0.2
#define LIST_INDENT 2.3
#define LIST_NUMBER_WIDTH 2
#define LIST_UL_WIDTH 1.5

COUNTERS
   ItemCounter : Rank of List_Item init Start Reinit ItemValue;
#ifdef PAGE
   CptPage : Rank of Page(Formatted_view);
   CptLinksPage : Rank of Page(Links_view);
   CptToCPage : Rank of Page(Table_of_contents);
#endif
#ifdef LINK_NUMBER
   AnchorCounter : Set 0 on HTML add 1 on Anchor with ExternalLink
				 add 1 on Quotation with ExternalLink
				 add 1 on Block_Quote with ExternalLink
				 add 1 on INS with ExternalLink
				 add 1 on DEL with ExternalLink;
#endif
   H2Counter : Set 0 on H1 add 1 on H2;
   H3Counter : Set 0 on H1 set 0 on H2 add 1 on H3;
   H4Counter : Set 0 on H1 set 0 on H2 set 0 on H3 add 1 on H4;
   H5Counter : Set 0 on H1 set 0 on H2 set 0 on H3 set 0 on H4 add 1 on H5;
   H6Counter : Set 0 on H1 set 0 on H2 set 0 on H3 set 0 on H4 set 0 on H5 add 1 on H6;

DEFAULT
	BEGIN
	HorizRef: Enclosed . HRef;
	VertRef: * . Left;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	VertPos: Top = Previous . Bottom;
	HorizPos: Left = Enclosing . Left;
	Justify: Enclosing =;
	Hyphenate: Enclosing =;
	LineSpacing: Enclosing =;
	LineWeight: Enclosing =;
	LineBreak: Yes;
	PageBreak: Yes;
	Visibility: Enclosing =;
	Font: Enclosing =;
	Style: Enclosing =;
	Weight: Enclosing =;
	Underline: Enclosing =;
	Thickness: Enclosing =;
	Size: Enclosing =;
	Adjust: Enclosing =;
	Indent: Enclosing =;
	Depth: Enclosing =;
	FillPattern: nopattern;
	END;

BOXES

#ifdef LINK_NUMBER
 AnchorNumInFormattedView:
	BEGIN
	Content: (Text ' [' Value(AnchorCounter, Arabic) Text ']');
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 BlockNumInFormattedView:
	BEGIN
	Content: (Text ' [' Value(AnchorCounter, Arabic) Text ']');
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 AnchorNumInLinkView:
	BEGIN
	Content: (Text '[' Value(AnchorCounter, Arabic) Text ']  ');
	Visibility: 0;
	IN Links_view
		Visibility: Creator =;
	END;

 TargetPageNumber:
	BEGIN
	Content: (Text ' (page ' Value(PageNumber(Formatted_view), Arabic) Text ')');
	Visibility: 0;
	END;

 SeeTargetPage:
	BEGIN
	Copy (TargetPageNumber);
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;
#endif

 H2_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H3_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H4_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H5_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H6_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic) Text '.'
		  Value(H6Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 HTML_S: BEGIN
	Content: Text 'html';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Enclosing . Top + 0.5;
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 VerticalLine: BEGIN
	Content: Graphics 'W';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Creator . Top;
		Height: Creator . Height;
		Width: 1.1;
		LineWeight: 1 px;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 HEAD_S: BEGIN
	Content: Text 'head';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SCRIPT_S: BEGIN
	Content: Text 'script';
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 META_S: BEGIN
	Content: Text 'meta';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 LINK_S: BEGIN
	Content: Text 'link';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_REL: BEGIN
	Content: Text ' rel=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_REL: BEGIN
	Content: (REL);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_REL_ANCH: BEGIN
	Content: Text ' rel=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_REL_ANCH: BEGIN
	Content: (REL);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_REV: BEGIN
	Content: Text ' rev=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_REV: BEGIN
	Content: (REV);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_REV_ANCH: BEGIN
	Content: Text ' rev=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_REV_ANCH: BEGIN
	Content: (REV);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 BASE_S: BEGIN
	Content: Text 'base';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BODY_S: BEGIN
	Content: Text 'body';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TITLE_S: BEGIN
	Content: Text 'title';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 INDEX_S: BEGIN
	Content: Text 'isindex';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

  STYLE_S: BEGIN
	Content: Text 'style';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

  ATTR_PROFILE: BEGIN
	Content: Text ' profile=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  VALUE_PROFILE: BEGIN
	Content: (profile);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

  ATTR_PROMPT: BEGIN
	Content: Text ' prompt=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  VALUE_PROMPT: BEGIN
	Content: (Prompt);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

  VAL_ATTR_PROMPT: BEGIN
	Content: (Prompt);
	VertPos: Top = Previous . Bottom;
	IN Structure_view
		Visibility: 0;	
	END;

 INDEX_TXT:  BEGIN
	Content: Text 'This is a searchable index.';
	VertPos: Top = Previous . Bottom;
	IN Structure_view
		Visibility: 0;
	END;

  ATTR_TYPE: BEGIN
	Content: Text ' type=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  VALUE_NOTATION: BEGIN
	Content: (Notation);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

  ATTR_CLASS: BEGIN
	Content: Text ' class=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  VALUE_CLASS: BEGIN
	Content: (Class);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

  ATTR_ID: BEGIN
	Content: Text ' id=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  VALUE_ID: BEGIN
	Content: (ID);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ID_ANCH: BEGIN
	Content: Text ' id=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_ID_ANCH: BEGIN
	Content: (ID);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_DIR_LTR: BEGIN
	Content: Text ' dir=ltr';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_DIR_RTL: BEGIN
	Content: Text ' dir=rtl';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_ONCLICK: BEGIN
	Content: Text ' onclick=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONCLICK: BEGIN
	Content: (onclick);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONDBLCLICK: BEGIN
	Content: Text ' ondblclick=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONDBLCLICK: BEGIN
	Content: (ondblclick);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONMOUSEDOWN: BEGIN
	Content: Text ' onmousedown=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONMOUSEDOWN: BEGIN
	Content: (onmousedown);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONMOUSEUP: BEGIN
	Content: Text ' onmouseup=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONMOUSEUP: BEGIN
	Content: (onmouseup);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONMOUSEOVER: BEGIN
	Content: Text ' onmouseover=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONMOUSEOVER: BEGIN
	Content: (onmouseover);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONMOUSEMOVE: BEGIN
	Content: Text ' onmousemove=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONMOUSEMOVE: BEGIN
	Content: (onmousemove);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONMOUSEOUT: BEGIN
	Content: Text ' onmouseout=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONMOUSEOUT: BEGIN
	Content: (onmouseout);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONKEYPRESS: BEGIN
	Content: Text ' onkeypress=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONKEYPRESS: BEGIN
	Content: (onkeypress);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONKEYDOWN: BEGIN
	Content: Text ' onkeydown=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONKEYDOWN: BEGIN
	Content: (onkeydown);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONKEYUP: BEGIN
	Content: Text ' onkeyup=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONKEYUP: BEGIN
	Content: (onkeyup);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONLOAD: BEGIN
	Content: Text ' onload=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONLOAD: BEGIN
	Content: (onload);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONUNLOAD: BEGIN
	Content: Text ' onunload=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONUNLOAD: BEGIN
	Content: (onunload);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONFOCUS: BEGIN
	Content: Text ' onfocus=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONFOCUS: BEGIN
	Content: (onfocus);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONBLUR: BEGIN
	Content: Text ' onblur=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONBLUR: BEGIN
	Content: (onblur);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONSUBMIT: BEGIN
	Content: Text ' onsubmit=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONSUBMIT: BEGIN
	Content: (onsubmit);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONRESET: BEGIN
	Content: Text ' onreset=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONRESET: BEGIN
	Content: (onreset);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONSELECT: BEGIN
	Content: Text ' onselect=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONSELECT: BEGIN
	Content: (onselect);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ONCHANGE: BEGIN
	Content: Text ' onchange=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ONCHANGE: BEGIN
	Content: (onchange);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_ROWHEIGHT: BEGIN
	Content: (RowHeight);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_COLWIDTH: BEGIN
	Content: (ColWidth);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_FRAMENAME: BEGIN
	Content: (FrameName);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_FRAMENAME: BEGIN
	Content: Text ' name= ';
	Style: Bold;
	IN Links_view BEGIN
		Style: Enclosing =;
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_FRAMENAME1: BEGIN
	Content: (FrameName);
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_FRAMESRC: BEGIN
	Content: (FrameSrc);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_FRAMESRC: BEGIN
	Content: Text ' src=';
	Style: Bold;
	IN Links_view BEGIN
		Style: Enclosing =;
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_FRAMESRC1: BEGIN
	Content: (FrameSrc);
	Foreground: LINK_Color;
	IN Links_view BEGIN
		Foreground: Enclosing =;
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#endif
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 ATTR_FRAMEBORDER_1: BEGIN
	Content: Text ' frameborder=1';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 ATTR_FRAMEBORDER_0: BEGIN
	Content: Text ' frameborder=0';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_MARGINWIDTH: BEGIN
	Content: Text ' marginwidth=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_MARGINWIDTH: BEGIN
	Content: (marginwidth);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_MARGINHEIGHT: BEGIN
	Content: Text ' marginheight=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_MARGINHEIGHT: BEGIN
	Content: (marginheight);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NORESIZE: BEGIN
	Content: Text ' noresize';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SCROLLING_YES: BEGIN
	Content: Text ' scrolling=yes';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SCROLLING_NO: BEGIN
	Content: Text ' scrolling=no';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SCROLLING_AUTO: BEGIN
	Content: Text ' scrolling=auto';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  ATTR_LANG: BEGIN
	Content: Text ' lang=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_LANG: BEGIN
	Content: (Langue);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_CONTENT_TYPE: BEGIN
	Content: (content_type);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_LANGUAGE: BEGIN
	Content: Text ' language=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SCRIPT_LANGUAGE: BEGIN
	Content: (script_language);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_SCRIPT_SRC: BEGIN
	Content: (script_src);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_DEFER: BEGIN
	Content: Text ' defer';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_EVENT: BEGIN
	Content: Text ' event=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_EVENT: BEGIN
	Content: (event);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_FOR: BEGIN
	Content: Text ' for=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_FOR: BEGIN
	Content: (for_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_ASSOC_CTRL: BEGIN
	Content: (Associated_control);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ButtonTypeButton: BEGIN
	Content: Text ' type=button';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 ButtonTypeSubmit: BEGIN
	Content: Text ' type=submit';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 ButtonTypeReset: BEGIN
	Content: Text ' type=reset';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_HTTPEQUIV: BEGIN
	Content: Text ' http-equiv=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HTTPEQUIV: BEGIN
	Content: (http_equiv);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_METANAME: BEGIN
	Content: (meta_name);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CONTENT: BEGIN
	Content: Text ' content=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CONTENT: BEGIN
	Content: (meta_content);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_SCHEME: BEGIN
	Content: Text ' scheme=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SCHEME: BEGIN
	Content: (scheme);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_Invalid_attribute: BEGIN
	Content: (Invalid_attribute);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
#ifdef BLACK_WHITE
		Underline: CrossedOut;
#else
		Foreground: INVALID_Color;
#endif
		END;	
	END;

 VALUE_EntityName: BEGIN
        Content: (EntityName);
        Visibility: 0;
        IN Structure_view BEGIN
                Visibility: ATTR_Visibility;	
		Size: DOC_FONTSIZE;
		Foreground: TAG_Color;
		if NOT within Comment_line AND NOT within PI_line
		   BEGIN
		   HorizPos: Left = Previous . Right;
		   VertPos: HRef = Previous . HRef;
		   END;
		if within Comment_line 
		   HorizPos: Left = Previous . Right;
		if within PI_line 
		   HorizPos: Left = Previous . Right;
                END;
        END;

 ATTR_XML_SPACE_DEFAULT: BEGIN
	Content: Text ' xml:space=default';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_XML_SPACE_PRESERVE: BEGIN
	Content: Text ' xml:space=preserve';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 APPLET_S: BEGIN
	Content: Text 'applet';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 PARAM_S: BEGIN
	Content: Text 'param';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 OBJECT_S: BEGIN
	Content: Text 'object';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 P_S: BEGIN
	Content: Text 'p';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H1_S: BEGIN
	Content: Text 'h1';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H2_S: BEGIN
	Content: Text 'h2';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H3_S: BEGIN
	Content: Text 'h3';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H4_S: BEGIN
	Content: Text 'h4';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H5_S: BEGIN
	Content: Text 'h5';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 H6_S: BEGIN
	Content: Text 'h6';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BASEFONT_S: BEGIN
	Content: Text 'basefont';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 UL_S: BEGIN
	Content: Text 'ul';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 OL_S: BEGIN
	Content: Text 'ol';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DIR_S: BEGIN
	Content: Text 'dir';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 MENU_S: BEGIN
	Content: Text 'menu';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DL_S: BEGIN
	Content: Text 'dl';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DT_S: BEGIN
	Content: Text 'dt';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;
 DD_S: BEGIN
	Content: Text 'dd';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ADDRESS_S: BEGIN
	Content: Text 'address';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 PRE_S: BEGIN
	Content: Text 'pre';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BLOCKQUOTE_S: BEGIN
	Content: Text 'blockquote';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

  FORM_S: BEGIN
	Content: Text 'form';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SELECT_S: BEGIN
	Content: Text 'select';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 OPTION_S: BEGIN
	Content: Text 'option';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 OPTGROUP_S: BEGIN
	Content: Text 'optgroup';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TEXTAREA_S: BEGIN
	Content: Text 'textarea';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 FIELDSET_S: BEGIN
	Content: Text 'fieldset';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 LEGEND_S: BEGIN
	Content: Text 'legend';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_Checkbox: BEGIN
	Content: Text ' type=checkbox';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Radio: BEGIN
	Content: Text ' type=radio';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Text: BEGIN
	Content: Text ' type=text';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 Text_Mark: BEGIN
	Content: Graphics 'Z';	{ draw the top and left side of the box }
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left - 1 px;
	Width: Enclosing . Width + 2 px;
	Height: Enclosing . Height;
	Foreground : Black;
	LineWeight: 2 px;
	Depth: Creator + 1;
	Visibility: Enclosing =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 Text_Frame: BEGIN
	Content: Graphics 'R';
	VertPos: Top = Enclosing . Top - 1 px;
	HorizPos: Left = Enclosing . Left - 1 px;
	Width: Enclosing . Width + 2 px;
	Height: Enclosing . Height;
	FillPattern: backgroundcolor;
	Foreground : White;
	LineWeight: 1 px;
	Depth: Creator + 2;
	Visibility: Enclosing =;
	InLine: No;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 BrowseLabel: BEGIN
	Content: Text ' Browse...';
	VertPos: Top = Creator . Top;
	HorizPos: Left = Creator . Right;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	PaddingTop: 1 px;
	PaddingLeft: 1 px;
	PaddingBottom: 1 px;
	PaddingRight: 1 px;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: White;
	BorderLeftColor: White;
	BorderBottomColor: Black;
	BorderRightColor: Black;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

#ifndef PAGE
 Target_gif: BEGIN
	Content: Picture 'target.gif';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Visibility: 4;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 5;
	IN Table_of_contents
		Visibility: 5;
	END;
#endif

 Option_gif: BEGIN
	Content: Picture 'option.gif';
	HorizPos: Left = Enclosing . Left + 0.2;
	VertPos: HMiddle = Enclosing . Top + 0.5;
        HorizRef: * . Bottom;	
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 Option_space: BEGIN
	Content: Text ' ';
	HorizPos: Left = Previous . Right;
	VertPos: HMiddle = Enclosing . Top + 0.5;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 IMG_S: BEGIN
        Content: Text 'img';
        Visibility: 0;
        IN Structure_view BEGIN
                Size: TAG_FONTSIZE;
                Weight: TAG_Weight;
                Visibility: TAG_Visibility;  Foreground: TAG_Color;
                END;
        END;

 IMG_in_S: BEGIN
	Content: Text 'input type=image ';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 INVALID_E: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
#ifdef BLACK_WHITE
		Underline: CrossedOut;
#else
		Foreground: Creator =;
#endif
		END;
	END;

 COMMENT_S: BEGIN
	Content: Text '<!--';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		END;
	END;

 COMMENT_END: BEGIN
	Content: Text '-->';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Foreground: TAG_Color;
		END;
	END;

 PI_S: BEGIN
	Content: Text '<?';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		END;
	END;

 PI_END: BEGIN
	Content: Text '?>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Foreground: TAG_Color;
		END;
	END;

 ATTR_SRC: BEGIN
	Content: Text ' src=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SRC: BEGIN
	Content: (SRC);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ALT: BEGIN
	Content: Text ' alt=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ALT: BEGIN
	Visibility: 0;
	Content: (ALT);
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		END;
	IN Links_view BEGIN
		HorizPos: Left = Previous . Right;
		HorizRef: * . Top + 1;
		VertPos: HRef = Previous . HRef;
		END;	
	END;

 ATTR_LONGDESC: BEGIN
	Content: Text ' longdesc=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_LONGDESC: BEGIN
	Content: (longdesc);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_USEMAP: BEGIN
	Content: Text ' usemap=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_USEMAP: BEGIN
	Visibility: 0;
	Content: (USEMAP);
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 CLEAR_LEFT: BEGIN
	Content: Text ' clear=left';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 CLEAR_RIGHT: BEGIN
	Content: Text ' clear=right';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 CLEAR_ALL: BEGIN
	Content: Text ' clear=all';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 CLEAR_NONE: BEGIN
	Content: Text ' clear=none';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_TOP: BEGIN
	Content: Text ' align=top';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_MIDDLE: BEGIN
	Content: Text ' align=middle';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_BOTTOM: BEGIN
	Content: Text ' align=bottom';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_LEFT: BEGIN
	Content: Text ' align=left';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_CENTER: BEGIN
	Content: Text ' align=center';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_RIGHT: BEGIN
	Content: Text ' align=right';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_JUSTIFY: BEGIN
	Content: Text ' align=justify';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ALIGN_CHAR: BEGIN
	Content: Text ' align=char';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_CHAR: BEGIN
	Content: Text ' char=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CHAR: BEGIN
	Content: (char);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CHAROFF: BEGIN
	Content: Text ' charoff=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CHAROFF: BEGIN
	Content: (charoff);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALIGN_TOP: BEGIN
	Content: Text ' valign=top';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALIGN_MIDDLE: BEGIN
	Content: Text ' valign=middle';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALIGN_BOTTOM: BEGIN
	Content: Text ' valign=bottom';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALIGN_BASELINE: BEGIN
	Content: Text ' valign=baseline';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_ISMAP: BEGIN
	Content: Text ' ismap';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 INPUT_S: BEGIN
	Content: Text 'input';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 LABEL_S: BEGIN
	Content: Text 'label';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BUTTON_S: BEGIN
	Content: Text 'button';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_Hidden: BEGIN
	Content: Text ' type=hidden';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_File: BEGIN
	Content: Text ' type=file';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Password: BEGIN
	Content: Text ' type=password';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Reset: BEGIN
	Content: Text ' type=reset';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Submit: BEGIN
	Content: Text ' type=submit';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Button: BEGIN
	Content: Text ' type=button';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_MULTIPLE: BEGIN
	Content: Text ' multiple';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SELECTED: BEGIN
	Content: Text ' selected';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_CHECKED: BEGIN
	Content: Text ' checked';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_DISABLED: BEGIN
	Content: Text ' disabled';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_READONLY: BEGIN
	Content: Text ' readonly';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_LABEL: BEGIN
	Content: Text ' label=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_LABEL: BEGIN
	Content: (label);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ACCEPT: BEGIN
	Content: Text ' accept=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ACCEPT: BEGIN
	Content: (accept);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_VALUE: BEGIN
	Content: Text ' value=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_VALUE: BEGIN
	Content: (Value_);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_MENUSIZE: BEGIN
	Content: (MenuSize);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_SIZE: BEGIN
	Content: Text ' size=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_AREA_SIZE: BEGIN
	Content: (Area_Size);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_BASEFONTSIZE: BEGIN
	Content: (BaseFontSize);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_FONT_SIZE: BEGIN
	Content: (Font_size);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_FACE: BEGIN
	Content: Text ' face=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_BASEFONTFACE: BEGIN
	Content: (BaseFontFace);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_FACE: BEGIN
	Content: (face);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_MAXLENGTH: BEGIN
	Content: Text ' maxlength=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_MAXLENGTH: BEGIN
	Content: (MaxLength);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ROWS: BEGIN
	Content: Text ' rows=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ROWS: BEGIN
	Content: (Rows);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_COLS: BEGIN
	Content: Text ' cols=';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_COLS: BEGIN
	Content: (Columns);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 Value_Box: BEGIN
	Content: (Value_);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	PaddingTop: 1 px;
	PaddingLeft: 3 px;
	PaddingBottom: 1 px;
	PaddingRight: 3 px;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: White;
	BorderLeftColor: White;
	BorderBottomColor: Black;
	BorderRightColor: Black;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background: Creator =;
	FillPattern: backgroundcolor;
	IN Structure_view
		Visibility: 0;
	END;

 Toggle_gif: BEGIN
	Content: Picture 'toggle.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ToggleS_gif: BEGIN
	Content: Picture 'toggle-s.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 Radio_gif: BEGIN
	Content: Picture 'radio.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;	
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 RadioS_gif: BEGIN
	Content: Picture 'radio-s.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 BR_S: BEGIN
	Content: Text 'br';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 I_S: BEGIN
	Content: Text 'i';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 B_S: BEGIN
	Content: Text 'b';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TT_S: BEGIN
	Content: Text 'tt';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 U_S: BEGIN
	Content: Text 'u';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 STRIKE_S: BEGIN
	Content: Text 'strike';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BIG_S: BEGIN
	Content: Text 'big';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SMALL_S: BEGIN
	Content: Text 'small';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SUB_S: BEGIN
	Content: Text 'sub';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SUP_S: BEGIN
	Content: Text 'sup';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 EM_S: BEGIN
	Content: Text 'em';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 STRONG_S: BEGIN
	Content: Text 'strong';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DFN_S: BEGIN
	Content: Text 'dfn';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 CODE_S: BEGIN
	Content: Text 'code';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SAMP_S: BEGIN
	Content: Text 'samp';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 KBD_S: BEGIN
	Content: Text 'kbd';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 VAR_S: BEGIN
	Content: Text 'var';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 CITE_S: BEGIN
	Content: Text 'cite';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ABBR_S: BEGIN
	Content: Text 'abbr';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ACRONYM_S: BEGIN
	Content: Text 'acronym';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 FONT_S: BEGIN
	Content: Text 'font';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 Q_S: BEGIN
	Content: Text 'q';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DOUBLE_QUOTE: BEGIN
	Content: Text '"';
	VertPos: HRef = Previous . Href;
	HorizPos:  Left = Previous . Right;
	IN Structure_view
		Visibility: 0;
	END;

 QUOTE: BEGIN
	Content: Text '''';
	VertPos: HRef = Previous . Href;
	HorizPos:  Left = Previous . Right;
	IN Structure_view
		Visibility: 0;
	END;

 INS_S: BEGIN
	Content: Text 'ins';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 DEL_S: BEGIN
	Content: Text 'del';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 SPAN_S: BEGIN
	Content: Text 'span';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BDO_S: BEGIN
	Content: Text 'bdo';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 FRAMESET_S: BEGIN
	Content: Text 'frameset';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

#ifndef PAGE
 FRAME_Label: BEGIN
	Content: Text 'frame';
	Style: Bold;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 NOFRAMES_Sep1: BEGIN
	Content: Graphics 'h';
	LineWeight: 1 px;
	Width: Enclosing . Width;
	Height: 0.5;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 NOFRAMES_Sep2: BEGIN
	Content: Graphics 'h';
	LineWeight: 1 px;
	Width: Enclosing . Width;
	Height: 0.5;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;
#endif

 NOFRAMES_S: BEGIN
	Content: Text 'noframes';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 FRAME_S: BEGIN
	Content: Text 'frame';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 IFRAME_S: BEGIN
	Content: Text 'iframe';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 A_S: BEGIN
	Content: Text 'a';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_CHARSET: BEGIN
	Content: Text ' charset=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CHARSET: BEGIN
	Content: (charset);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NAME: BEGIN
	Content: Text ' name=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
	        Visibility: ATTR_Visibility; Foreground: ATTR_Color; 
		END;
	END;
 VALUE_NAME: BEGIN
	Content: (NAME);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NAME_ANCH: BEGIN
	Content: Text ' name=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_NAME_ANCH: BEGIN
	Content: (NAME);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_HREF: BEGIN
	Content: Text ' href=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HREF: BEGIN
	Content: (HREF_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_HREF_LINKS_VIEW: BEGIN
	Content: Text ' href=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;

 VALUE_HREF_LINKS_VIEW: BEGIN
	Content: (HREF_);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_HREFLANG: BEGIN
	Content: Text ' hreflang=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HREFLANG: BEGIN
	Content: (hreflang);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_MEDIA: BEGIN
	Content: Text ' media=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_MEDIA: BEGIN
	Content: (media);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_TARGET: BEGIN
	Content: Text ' target=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_TARGET: BEGIN
	Content: (target_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CITE: BEGIN
	Content: Text ' cite=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CITE: BEGIN
	Content: (cite);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CITE_LINKS_VIEW: BEGIN
	Content: Text ' cite=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;

 VALUE_CITE_LINKS_VIEW: BEGIN
	Content: (cite);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_DATETIME: BEGIN
	Content: Text ' datetime=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_DATETIME: BEGIN
	Content: (datetime);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_TITLE: BEGIN
	Content: Text ' title=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_TITLE: BEGIN
	Content: (Title);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_TITLE_ANCH: BEGIN
	Content: Text ' title=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Visibility: 5;
		END;
	END;

 VALUE_TITLE_ANCH: BEGIN
	Content: (Title);
	Visibility: 0;
	IN Links_view BEGIN
		Visibility: 5;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 ATTR_TITLE_FRAME: BEGIN
	Content: Text ' title=';
	Style: Bold;
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 VALUE_TITLE_FRAME: BEGIN
	Content: (Title);
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 ATTR_ACCESSKEY: BEGIN
	Content: Text ' accesskey=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ACCESSKEY: BEGIN
	Content: (accesskey);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_TABINDEX: BEGIN
	Content: Text ' tabindex=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_TABINDEX: BEGIN
	Content: (tabindex);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ActURL: BEGIN
	Content: Text ' action=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_ActURL: BEGIN
	Content: (Script_URL);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 MethodGet_S: BEGIN
	Content: Text ' method=get';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 MethodPost_S: BEGIN
	Content: Text ' method=post';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_ENCTYPE: BEGIN
	Content: Text ' enctype=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ENCTYPE: BEGIN
	Content: (ENCTYPE);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ACCEPT_CHARSET: BEGIN
	Content: Text ' accept-charset=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ACCEPT_CHARSET: BEGIN
	Content: (accept_charset);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_STYLE: BEGIN
	Content: Text ' style=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_STYLE: BEGIN
	Content: (Style\240);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 LI_S: BEGIN
	Content: Text 'li';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 UL_DISC: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	FillPattern: foregroundcolor;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_UL_WIDTH;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_SQUARE: BEGIN
	Content: Graphics 'R';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_UL_WIDTH;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_CIRCLE: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_UL_WIDTH;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 OL_NUM_ARABIC:
	BEGIN
	Content: (Value(ItemCounter, Arabic) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LALPHA:
	BEGIN
	Content: (Value(ItemCounter, lowercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UALPHA:
	BEGIN
	Content: (Value(ItemCounter, Uppercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LROMAN:
	BEGIN
	Content: (Value(ItemCounter, lRoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UROMAN:
	BEGIN
	Content: (Value(ItemCounter, URoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Enclosing . Left + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 HR_S: BEGIN
	Content: Text 'hr';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ISINDEX_Graph1: BEGIN
	Content: Graphics 'b';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height: 1;
	Foreground: Black;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	END;

#ifdef PAGE
 HR_Print: BEGIN
	Content: Graphics 'h';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	Foreground: Black;
	LineWeight: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		LineWeight: 1 px;
	END;
#else
 HR_Alt: BEGIN
	Content: Graphics 'h';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	Foreground: Black;
	LineWeight: 1 px;
	Visibility: 0;
	IN Alternate_view
	      Visibility: Creator =;
	END;

 HR_Graph1: BEGIN
	Content: Graphics 'Z';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Foreground: Creator =;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 HR_Graph2: BEGIN
	Content: Graphics 'X';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Foreground: White;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX_Graph2: BEGIN
	Content: Graphics 't';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height:  1;
	Foreground: White;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX_Graph2A: BEGIN
	Content: Graphics 't';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height:  1;
	Foreground: White;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;
#endif

 ATTR_HEIGHT: BEGIN
	Content: Text ' height=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HEIGHT: BEGIN
	Content: (Height_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_WIDTH: BEGIN
	Content: Text ' width=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_WIDTH__: BEGIN
	Content: (Width__);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_HSPACE: BEGIN
	Content: Text ' hspace=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HSPACE: BEGIN
	Content: (hspace);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_VSPACE: BEGIN
	Content: Text ' vspace=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_VSPACE: BEGIN
	Content: (vspace);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_DECLARE: BEGIN
	Content: Text ' declare';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_CODEBASE: BEGIN
	Content: Text ' codebase=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CODEBASE: BEGIN
	Content: (codebase);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CODE: BEGIN
	Content: Text ' code=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CODE: BEGIN
	Content: (code);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_OBJECT: BEGIN
	Content: Text ' object=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_OBJECT: BEGIN
	Content: (object);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_APPLET_NAME: BEGIN
	Content: (applet_name);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_PARAM_NAME: BEGIN
	Content: (Param_name);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_PARAM_VALUE: BEGIN
	Content: (Param_value);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_VALUETYPE_DATA: BEGIN
	Content: Text ' valuetype=data';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_VALUETYPE_REF: BEGIN
	Content: Text ' valuetype=ref';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_VALUETYPE_OBJECT: BEGIN
	Content: Text ' valuetype=object';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_PARAM_TYPE: BEGIN
	Content: (Param_type);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CLASSID: BEGIN
	Content: Text ' classid=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_CLASSID: BEGIN
	Content: (classid);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_DATA: BEGIN
	Content: Text ' data=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_DATA: BEGIN
	Content: (data);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_OBJECT_TYPE: BEGIN
	Content: (Object_type);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ARCHIVE: BEGIN
	Content: Text ' archive=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ARCHIVE: BEGIN
	Content: (archive);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_STANDBY: BEGIN
	Content: Text ' standby=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_STANDBY: BEGIN
	Content: (standby);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_LINK_TYPE: BEGIN
	Content: (Link_type);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CODETYPE: BEGIN
	Content: Text ' codetype=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
 VALUE_CODETYPE: BEGIN
	Content: (codetype);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NOSHADE: BEGIN
	Content: Text ' noshade';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_ARABIC: BEGIN
	Content: Text ' type=1';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_LALPHA: BEGIN
	Content: Text ' type=a';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_UALPHA: BEGIN
	Content: Text ' type=A';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_LROMAN: BEGIN
	Content: Text ' type=i';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_UROMAN: BEGIN
	Content: Text ' type=I';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_DISC: BEGIN
	Content: Text ' type=disc';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_SQUARE: BEGIN
	Content: Text ' type=square';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_TYPE_CIRCLE: BEGIN
	Content: Text ' type=circle';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_START: BEGIN
	Content: Text ' start=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_START: BEGIN
	Content: (Start);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_COMPACT: BEGIN
	Content: Text ' compact';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SIZE: BEGIN
	Content: (Size_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_COLOR: BEGIN
	Content: Text ' color=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_COLOR: BEGIN
	Content: (color);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_BASEFONTCOLOR: BEGIN
	Content: (BaseFontColor);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_BACKGROUND: BEGIN
	Content: Text ' background=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_BACKGROUND: BEGIN
	Content: (background_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_BGCOLOR: BEGIN
	Content: Text ' bgcolor=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_BGCOLOR: BEGIN
	Content: (BackgroundColor);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_TEXTCOLOR: BEGIN
	Content: Text ' text=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_TEXTCOLOR: BEGIN
	Content: (TextColor);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_LINKCOLOR: BEGIN
	Content: Text ' link=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_LINKCOLOR: BEGIN
	Content: (LinkColor);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_VLINKCOLOR: BEGIN
	Content: Text ' vlink=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_VLINKCOLOR: BEGIN
	Content: (VisitedLinkColor);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ALINKCOLOR: BEGIN
	Content: Text ' alink=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ALINKCOLOR: BEGIN
	Content: (ActiveLinkColor);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

{ ---- Table ---- }

 TABLE_S: BEGIN
	Content: Text 'table';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_SUMMARY: BEGIN
	Content: Text ' summary=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SUMMARY: BEGIN
	Content: (summary);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_BORDER: BEGIN
	Content: Text ' border=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_VOID: BEGIN
	Content: Text ' frame=void';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_ABOVE: BEGIN
	Content: Text ' frame=above';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_BELOW: BEGIN
	Content: Text ' frame=below';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_HSIDES: BEGIN
	Content: Text ' frame=hsides';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_LHS: BEGIN
	Content: Text ' frame=lhs';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_RHS: BEGIN
	Content: Text ' frame=rhs';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_VSIDES: BEGIN
	Content: Text ' frame=vsides';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_BOX: BEGIN
	Content: Text ' frame=box';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 FRAME_BORDER: BEGIN
	Content: Text ' frame=border';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 RULES_NONE: BEGIN
	Content: Text ' rules=none';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 RULES_GROUPS: BEGIN
	Content: Text ' rules=groups';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 RULES_ROWS: BEGIN
	Content: Text ' rules=rows';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 RULES_COLS: BEGIN
	Content: Text ' rules=cols';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 RULES_ALL: BEGIN
	Content: Text ' rules=all';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_BORDER: BEGIN
	Content: (Border);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CELLSPACING: BEGIN
	Content: Text ' cellspacing=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CELLSPACING: BEGIN
	Content: (cellspacing);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CELLPADDING: BEGIN
	Content: Text ' cellpadding=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_CELLPADDING: BEGIN
	Content: (cellpadding);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_DATAPAGESIZE: BEGIN
	Content: Text ' datapagesize=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_DATAPAGESIZE: BEGIN
	Content: (datapagesize);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 VALUE_IMG_BORDER: BEGIN
	Content: (Img_border);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 CAPTION_S: BEGIN
	Content: Text 'caption';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 COLGROUP_S: BEGIN
	Content: Text 'colgroup';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 COL_S: BEGIN
	Content: Text 'col';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_ABBR: BEGIN
	Content: Text ' abbr=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ABBR: BEGIN
	Content: (abbr);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_AXIS: BEGIN
	Content: Text ' axis=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_AXIS: BEGIN
	Content: (axis);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_HEADERS: BEGIN
	Content: Text ' headers=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_HEADERS: BEGIN
	Content: (headers);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_SCOPE: BEGIN
	Content: Text ' scope=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SCOPE: BEGIN
	Content: (scope);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_SPAN: BEGIN
	Content: Text ' span=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_SPAN: BEGIN
	Content: (span_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_ROWSPAN: BEGIN
	Content: Text ' rowspan=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_ROWSPAN: BEGIN
	Content: (rowspan_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_COLSPAN: BEGIN
	Content: Text ' colspan=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_COLSPAN: BEGIN
	Content: (colspan_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NOWRAP: BEGIN
	Content: Text ' nowrap';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 TR_S: BEGIN
	Content: Text 'tr';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 THEAD_S: BEGIN
	Content: Text 'thead';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TFOOT_S: BEGIN
	Content: Text 'tfoot';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TBODY_S: BEGIN
	Content: Text 'tbody';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TH_S: BEGIN
	Content: Text 'th';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 TD_S: BEGIN
	Content: Text 'td';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 CellExtFrame: BEGIN
	Content: Graphics '0';
	ShowBox;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Creator . Left;
	Width: Creator . Width;
	Height: Bottom = Referred Table_row . Bottom;
	VertOverflow : Yes;
	BorderTopWidth: Creator =;
	BorderRightWidth: Creator =;
	BorderBottomWidth: Creator =;
	BorderLeftWidth: Creator =;
	BorderTopColor: Creator =;
	BorderRightColor: Creator =;
	BorderBottomColor: Creator =;
	BorderLeftColor: Creator =;
	BorderTopStyle: Creator =;
	BorderRightStyle: Creator =;
	BorderBottomStyle: Creator =;
	BorderLeftStyle: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	FillPattern: Creator =;
	Depth: Creator + 2;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 CellFrame: BEGIN
	Content: Graphics '0';
	ShowBox;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Creator . Left;
	Width: Creator . Width;
	Height: Enclosing . Height;
	BorderTopWidth: Creator =;
	BorderRightWidth: Creator =;
	BorderBottomWidth: Creator =;
	BorderLeftWidth: Creator =;
	BorderTopColor: Creator =;
	BorderRightColor: Creator =;
	BorderBottomColor: Creator =;
	BorderLeftColor: Creator =;
	BorderTopStyle: Creator =;
	BorderRightStyle: Creator =;
	BorderBottomStyle: Creator =;
	BorderLeftStyle: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	FillPattern: Creator =;
	Depth: Creator + 4;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 MAP_S: BEGIN
	Content: Text 'map';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 MAP_dummy: BEGIN
	Content: Graphics ' ';
	Width: 1 px;
	Height: 1 px;
	VertPos: Top = Previous NOT MAP . Bottom;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 AREA_S: BEGIN
	Content: Text 'area';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 ATTR_SHAPE_RECT: BEGIN
	Content: Text ' shape=rect';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SHAPE_CIRCLE: BEGIN
	Content: Text ' shape=circle';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_SHAPE_POLY: BEGIN
	Content: Text ' shape=poly';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_COORDS: BEGIN
	Content: Text ' coords=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 VALUE_COORDS: BEGIN
	Content: (coords);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_NOHREF: BEGIN
	Content: Text ' nohref';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 DIV_S: BEGIN
	Content: Text 'div';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 CENTER_S: BEGIN
	Content: Text 'center';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 NOSCRIPT_S: BEGIN
	Content: Text 'noscript';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

{ ---- Pages ---- }

#ifdef PAGE
#ifndef LANDSCAPE
  TitleHead:
	BEGIN
	Visibility: 0;
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Copy (TITLE);
	Justify: No;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.2 cm;
	Height:  Enclosed . Height;
	Size : 11 pt;
	Font: times;
	Style: Italics;	
	Weight: Normal;
	END;
#endif { LANDSCAPE }

  URLhead:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Copy (Document_URL);
	Justify: No;
	HorizPos: Left = Previous PAGE_BREAK . Left;
#ifdef LANDSCAPE
	Height:   0.8 cm;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
#else { LANDSCAPE }
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.7 cm;
	Height:   1.2 cm;
#endif { LANDSCAPE }
	Size : 8 pt;
	Font: times;
	Style: Roman;	
	Weight: Normal;
	END;

  Spacehead:
	BEGIN
#ifdef LANDSCAPE
	Visibility: 0;
#endif { LANDSCAPE }
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: Text ' ';
	Justify: No;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.7 cm;
	Height:   1.2 cm;
	Size : 8 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

#ifndef LANDSCAPE
  PageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptPage, Arabic));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#ifdef LANDSCAPE
	VertPos: Top = Next PAGE_BREAK . Top - 0.3 cm;
	Height:   1 cm;
#else { LANDSCAPE }
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
#endif { LANDSCAPE }
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;
#endif { LANDSCAPE }

  LinksPageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptLinksPage, lroman));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#ifdef LANDSCAPE
	VertPos: Top = Next PAGE_BREAK . Top - 0.3 cm;
	Height:   1 cm;
#else { LANDSCAPE }
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
#endif { LANDSCAPE }
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

  ToCPageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptToCPage, Uroman));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#ifdef LANDSCAPE
	VertPos: Top = Next PAGE_BREAK . Top - 0.3 cm;
	Height:   1 cm;
#else { LANDSCAPE }
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
#endif { LANDSCAPE }
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

  BottomSpace:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
#ifdef LANDSCAPE
	Height:   1 cm;
#else { LANDSCAPE }
	Height:   1.4 cm;
#endif { LANDSCAPE }
	Width: 1 pt;
	Underline: NoUnderline;
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

  ThePage:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
	ShowBox;
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 23.8 cm;
	Height: 18.2 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 16.2 cm;
	Height: 23.8 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#else { US_PAPER }
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#endif { US_PAPER }
#ifndef LANDSCAPE
	if NOT One(CptPage) CreateAfter (TitleHead);
#endif { LANDSCAPE }
	CreateAfter (Spacehead);
	if PrintURL CreateAfter (URLhead);
#ifndef LANDSCAPE
	if NOT One(CptPage) CreateBefore (PageNum);
	if NOT One(CptPage) CreateBefore (BottomSpace);
#endif { LANDSCAPE }
	Underline: NoUnderline;
	END;

  LinksPage:
	BEGIN
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 23.8 cm;
	Height: 18.2 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 16.2 cm;
	Height: 23.8 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#else { US_PAPER }
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#endif { US_PAPER }
#ifndef LANDSCAPE
	CreateAfter (TitleHead);
#endif { LANDSCAPE }
	CreateAfter (Spacehead);
	if PrintURL
	   CreateAfter (URLhead);
	if NOT One(CptLinksPage) CreateBefore (LinksPageNum);
	IF Not One(CptLinksPage) CreateBefore (BottomSpace);
	Underline: NoUnderline;
	END;

  ToCPage:
	BEGIN
	Background : White;
	Foreground : Black;
	ShowBox;
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 18.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 16.2 cm;
	Height: 23.8 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#else { US_PAPER }
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else { LANDSCAPE }
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif { LANDSCAPE }
#endif { US_PAPER }
#ifndef LANDSCAPE
	CreateAfter (TitleHead);
#endif { LANDSCAPE }
	CreateAfter (URLhead);
	if NOT One(CptToCPage) CreateBefore (ToCPageNum);
	IF Not One(CptToCPage) CreateBefore (BottomSpace);
	Underline: NoUnderline;
	END;

  HeadingPageNumber:
	BEGIN
	Visibility: 0;
	IN Table_of_contents
	   BEGIN
	   Visibility: Creator =;
	   VertPos: Bottom = Previous . Bottom;
	   HorizPos: Right = Enclosing . Right;
	   Content: (Value (PageNumber(Formatted_view), Arabic));
	   Underline: NoUnderline;
	   END;
	END;

  LinkPageNumber:
	BEGIN
	Visibility: 0;
	IN Links_view
	   BEGIN
	   Visibility: Creator =;
	   VertPos: Bottom = Creator . Bottom;
	   HorizPos: Right = Enclosing . Right;
	   Content: (Value (PageNumber(Formatted_view), Arabic));
	   Underline: NoUnderline;
	   END;
	END;
#else

 BodyBottomSpace: BEGIN
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
	Content: Graphics ' ';
	Height: 1 cm;
	Width: 1;
	END;
#endif

#ifndef PAGE
 IndexBox: BEGIN
	Content: Picture 'index.gif';
	HorizPos: Left = Root . Left;
	VertPos: Top = Creator . Top;
	VertOverflow : Yes;
	HorizOverflow : Yes;
	Inline: No;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;
#endif

RULES

 HTML:	BEGIN
	Depth: 5000;
	Adjust: Left;
	Justify: No;
	Indent: 0;
	Font: Times;
	Style: Roman;
	Weight: Normal;
	LineWeight: 0;
	Width: Enclosing . Width;
#ifdef PAGE
	Size: 11 pt;
	HorizPos: VMiddle = Enclosing.VMiddle;
	Page(ThePage);
#else
	Height: Enclosing . Height min;
	Size: DOC_FONTSIZE;
	HorizPos: Left = Enclosing . Left;
#endif
	VertPos: Top = Enclosing . Top;
	CreateFirst(HTML_S);
	IN Structure_view BEGIN
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - 1;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + 1;
		Font: Helvetica;
		END;
	IN Links_view BEGIN
#ifdef PAGE
		Page(LinksPage);
#endif
		Height: Enclosed . Height;
		Visibility: 10;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Page(ToCPage);
#endif
		Height: Enclosed . Height;
		Visibility: 10;
		END;
	IN Alternate_view BEGIN
		Font: Courier;
		Height: Enclosed . Height;
		END;
	END;

  HEAD:	BEGIN
	Visibility: 0;
	CreateBefore(HEAD_S);
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 BODY:	BEGIN
	CreateBefore(BODY_S);
	IF NOT within NOFRAMES BEGIN
		MarginTop: 0.2;
		VertPos: Top = Previous AnyElem . Bottom;
		END;
	IF within NOFRAMES BEGIN
		CreateWith(VerticalLine);
		VertPos: Top = Previous . Bottom;
		END;
#ifdef PAGE
	Width: Enclosing . Width;
	Hyphenate: Yes;
#else
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height: Enclosing . Height min;
	Hyphenate: No;
	MarginLeft: 0.5 cm;
	MarginRight: 0.5 cm;
	IF NOT within NOFRAMES
		CreateLast(BodyBottomSpace);
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
                HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		MarginTop: 0;
		MarginLeft: 0;
		MarginRight: 0;
#ifndef PAGE
                Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
#endif
		END;
	IN Links_view BEGIN
		MarginTop: 0;
		MarginLeft: 0.5;
		MarginRight: 0;
		Visibility: Enclosing =;
		Height: Enclosed . Height;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		Height: Enclosed . Height;
		END;
	END;

 Document_URL:	BEGIN
#ifndef PAGE
	Visibility: 0;
#else
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
#endif
	END;

 TITLE:	BEGIN
	CreateBefore(TITLE_S);
#ifndef PAGE
	Visibility: 0;
#endif
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		FillPattern: nopattern;
		Visibility: Enclosing =;
		END;
	IN Table_of_contents
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX: BEGIN
	CreateBefore(INDEX_S);
	CreateBefore(ISINDEX_Graph1);
#ifndef PAGE
	CreateBefore(ISINDEX_Graph2);
#endif
	if NOT Prompt
	    CreateFirst(INDEX_TXT);
	CreateFirst(VAL_ATTR_PROMPT);
	CreateAfter(ISINDEX_Graph1);
#ifndef PAGE
	CreateAfter(ISINDEX_Graph2A);
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous INDEX_S . Top;
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 BASE:	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	CreateBefore(BASE_S);
#ifndef BLACK_WHITE
	Foreground: Blue;
#endif
	Visibility: 0;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Foreground: ATTR_Color;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;
		Size: TAG_FONTSIZE;
		END;
	IN Links_view
		Visibility: 0;
	END;

 STYLE_: BEGIN
	CreateBefore(STYLE_S);
	Visibility: 0;
	Line;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Visibility: Enclosing =;
		END;
	END;

 SCRIPT: BEGIN
	CreateBefore(SCRIPT_S);
	Visibility: 0;
	Line;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 META:  BEGIN
	CreateBefore(META_S);
	Visibility: 0;
	IN Structure_view BEGIN
		Width: 1 px;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous META_S . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 LINK:	BEGIN
	CreateBefore(LINK_S);
#ifndef BLACK_WHITE
	Foreground: Blue;
#endif
	Visibility: 0;
	IN Structure_view BEGIN
		Width: 1 px;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous LINK_S . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;
	END;

 C_Empty: BEGIN
	Width: 1 px;
	Height: 1 px;
	if NOT within Frame
	   Visibility: 0;
	FillPattern: nopattern;
	IN Structure_view
	   BEGIN
	   if within ISINDEX
		Height: Enclosed . Height;
	   if within Checkbox_Input
		Height: 1 px;
	   if within Radio_Input
		Height: 1 px;
	   END;
	END;

 H1:	BEGIN
	CreateBefore(H1_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH1;
	MarginBottom: 0.2;
	Width: Enclosing . Width;
	Size: Enclosing + 6;
	Weight: Bold;
	Hyphenate: No;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginBottom: 0;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		Adjust: VMiddle;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: VMiddle;
		HorizPos: Left = Enclosing . Left;
#else
		HorizPos: Left = Enclosing . Left + 1;
		Width: Enclosing . Width - 1.2;
#endif
		MarginTop: VSpaceInToC;
		Size: Enclosing +2;
		Visibility: 10;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H2:	BEGIN
	CreateBefore(H2_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	CreateAfter (HeadingPageNumber);
#endif
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH2;
	Width: Enclosing . Width;
	Size: Enclosing + 4;
	Weight: Bold;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		Weight: Enclosing =;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 1.2;
#endif
		HorizPos: Left = Enclosing . Left + 1;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 9;
		MarginTop: VSpaceInToC;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H3:	BEGIN
	CreateBefore(H3_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	CreateAfter (HeadingPageNumber);
#endif
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH3;
	Width: Enclosing . Width;
	Size: Enclosing + 2;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 2.2;
#endif
		HorizPos: Left = Enclosing . Left + 2;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 8;
		MarginTop: VSpaceInToC;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H4:	BEGIN
	CreateBefore(H4_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	CreateAfter (HeadingPageNumber);
#endif
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH4;
	Width: Enclosing . Width;
	Size: Enclosing =;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		Weight: Enclosing =;
		Size: Enclosing =;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 3.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 3;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 7;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H5:	BEGIN
	CreateBefore(H5_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	CreateAfter (HeadingPageNumber);
#endif
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH5;
	Width: Enclosing . Width;
	Size: Enclosing - 2;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		NoLine;
		END;
	IN Alternate_view
		Size: Enclosing =;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 4.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 4;
		Size: Enclosing =;
		Visibility: 6;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H6:	BEGIN
	CreateBefore(H6_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	CreateAfter (HeadingPageNumber);
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: VSpaceBeforeH6;
	Size: Enclosing - 4;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		NoLine;
		END;
	IN Alternate_view
		Size: Enclosing =;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 5.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 5;
		Size: Enclosing =;
		Visibility: 5;
		END;
	IN Links_view
		Visibility: 0;
	END;

 BaseFont:
	BEGIN
	CreateBefore(BASEFONT_S);
	Visibility: 0;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous PARAM_S . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;
 BR:
	BEGIN
	CreateBefore(BR_S);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view
		Visibility: 0;
	END;

 Italic_text:
	BEGIN
	CreateBefore(I_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Bold_text:
	BEGIN
	CreateBefore(B_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Weight: Bold;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Teletype_text:
	BEGIN
	CreateBefore(TT_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Underlined_text:
	BEGIN
	CreateBefore(U_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Underline: Underlined;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Underline: NoUnderline;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Struck_text:
	BEGIN
	CreateBefore(STRIKE_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Underline: CrossedOut;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Underline: NoUnderline;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Big_text:
	BEGIN
	CreateBefore(BIG_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Size: 6;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Size: Enclosing =;
	END;
 Small_text:
	BEGIN
	CreateBefore(SMALL_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Size: 3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Size: Enclosing =;
	END;
 Subscript:
	BEGIN
	CreateBefore(SUB_S);
	CreateWith(VerticalLine);
	LineBreak: No;
	Size: Enclosing * 60 %;
	HorizRef: Enclosed . HRef - 0.3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef - 1;
		END;
	END;
 Superscript:
	BEGIN
	CreateBefore(SUP_S);
	CreateWith(VerticalLine);
	LineBreak: No;
	Size: Enclosing * 60 %;
	HorizRef: Enclosed . HRef + 0.4;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef + 1;
		END;
	END;

 Emphasis:
	BEGIN	
	CreateBefore(EM_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Strong:
	BEGIN
	CreateBefore(STRONG_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Weight: Bold;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Def:
	BEGIN
	CreateBefore(DFN_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Size: Enclosing + 1;
	Weight: Bold;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		END;
	END;
 Code:
	BEGIN
	CreateBefore(CODE_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		END;
	END;
 Sample:
	BEGIN
	CreateBefore(SAMP_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Keyboard:
	BEGIN
	CreateBefore(KBD_S);
	CreateWith(VerticalLine);
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	Style: Oblique;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Variable:
	BEGIN
	CreateBefore(VAR_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Oblique;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Style: Enclosing =;
		END;
	END;
 Cite:
	BEGIN
	CreateBefore(CITE_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Times;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		Style: Enclosing =;
		END;
	END;

 ABBR:
	BEGIN
	CreateBefore(ABBR_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 ACRONYM:
	BEGIN
	CreateBefore(ACRONYM_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Font_: BEGIN
	CreateBefore(FONT_S);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Previous NOT MAP . Bottom + 0.4;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Applet: BEGIN
	CreateBefore(APPLET_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop:  0.4;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;	
	IN Links_view
		Visibility: 0;
	END;

 Parameter: BEGIN
	CreateBefore(PARAM_S);
	Visibility: 0;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous PARAM_S . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 Object: BEGIN
	CreateBefore(OBJECT_S);
	CreateWith(VerticalLine);
	if within HEAD
		Visibility: 0;
	Width: Enclosing . Width;
	Height: 100;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.4;
	LineBreak: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;	
	IN Alternate_view
		Height: Enclosed . Height;
	IN Links_view
		Visibility: 0;
	END;

 Object_Content: BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		VertPos: Top = Enclosing . Top;
		HorizPos: Left = Enclosing . Left;
		END;
	END;

 Quotation: BEGIN
	CreateBefore(Q_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IF not within Quotation
		BEGIN
		CreateBefore(DOUBLE_QUOTE);
		CreateAfter(DOUBLE_QUOTE);
		END;
	IF within Quotation
		BEGIN
		CreateBefore(QUOTE);
		CreateAfter(QUOTE);
		END;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 INS:	BEGIN
	CreateBefore(INS_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Style: Italics;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Style: Enclosing =;
		END;
	END;

 DEL:	BEGIN
	CreateBefore(DEL_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Underline: CrossedOut;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Underline: Enclosing =;
		END;
	END;

 Span:	BEGIN
	CreateBefore(SPAN_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 BDO:	BEGIN
	CreateBefore(BDO_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 HTMLfragment:
	BEGIN
	Width: Enclosing . Width;
	Depth: Enclosing =;
	END;

 Paragraph: BEGIN
	CreateBefore(P_S);
	CreateWith(VerticalLine);
	Line;
	LineBreak: Yes;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	if NOT within Table
	   and NOT within GraphML
	   Justify: Yes;
#endif
	Adjust: Enclosing =;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	if NOT within Definition and NOT within List_Item BEGIN
	    MarginTop: 0.2;
	    MarginBottom: 0.4;
	    END;
	IN Structure_view BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Pseudo_paragraph: BEGIN
	Line;
	LineSpacing: 0;
	LineBreak: Yes;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
	if NOT within Table
#ifdef GRAPHML
	   and NOT within GraphML
#endif
	   Justify: Yes;
#endif
	Adjust: Enclosing =;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Definition_List: BEGIN
	CreateBefore(DL_S);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.4;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Definition_Item: BEGIN
	Width: Enclosing . Width;
	END;

 Term_List: BEGIN
	Width: Enclosing . Width;
	END;

 Term:	BEGIN
	CreateBefore(DT_S);
	CreateWith(VerticalLine);
	Line;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width: Enclosing . Width;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		NoLine;
		END;
	END;

 Definition: BEGIN
	CreateBefore(DD_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width - LIST_INDENT;
	HorizPos: Left = Enclosing . Left + LIST_INDENT;
#ifdef PAGE
#ifdef GRAPHML
	if NOT within GraphML
#endif
	Justify: Yes;
#endif
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Justify: No;
		END;
	END;

 Unnumbered_List: BEGIN
	CreateBefore(UL_S);
	CreateWith(VerticalLine);
	LineBreak: No;
#ifdef PAGE
	if NOT within Table
#ifdef GRAPHML
	   and NOT within GraphML
#endif
	   Justify: Yes;
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	if NOT within Definition and NOT within List_Item
	   MarginTop: 0.5;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Justify: No;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Numbered_List:	BEGIN
	CreateBefore(OL_S);
	CreateWith(VerticalLine);
	LineBreak: No;
#ifdef PAGE
	if NOT within Table
#ifdef GRAPHML
	   and NOT within GraphML
#endif
	   Justify: Yes;
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	if NOT within Definition and NOT within List_Item
	   MarginTop: 0.5;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Address: BEGIN
	CreateBefore(ADDRESS_S);
	CreateWith(VerticalLine);
	Line;
	Style: Italics;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.5;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Style: Enclosing =;
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Menu:	BEGIN
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.5;
	CreateBefore(MENU_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Directory: BEGIN
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.5;
	CreateBefore(DIR_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 List_Item: BEGIN
	CreateBefore(LI_S);
	CreateWith(VerticalLine);
	LineBreak: No;
	HorizPos: Left = Enclosing . Left + LIST_INDENT;
	Width: Enclosing . Width - LIST_INDENT;
	VertPos: Top = Previous AnyElem . Bottom;
	IN Structure_view
		BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Preformatted: BEGIN
	CreateBefore(PRE_S);
	CreateWith(VerticalLine);
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.4;
	If within Center
	   HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: Left;
	Font: Courier;
	Line;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	IN Structure_view BEGIN
		NoLine;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Horizontal_Rule: BEGIN
	CreateBefore(HR_S);
#ifdef PAGE
	CreateLast(HR_Print);
#else
	CreateLast(HR_Alt);
	CreateLast(HR_Graph1);
	if not within Preformatted
	   CreateLast(HR_Graph2);
#endif
	Width: Enclosing . Width;
	Height: 2 px;
	HorizPos: VMiddle = Enclosing . VMiddle;
	VertPos: Top = Previous . Bottom;
	MarginTop: 0.2;
	LineWeight: 1 px;
	Foreground: Black;
	IN Alternate_view
		BEGIN
		Height: 1;
		VertPos: Top = Previous . Bottom;
		END;
	IN Structure_view
		Height: 1 px;
	IN Links_view
		Visibility: 0;
	END;

 Form:	BEGIN
	CreateBefore(FORM_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	Gather: Yes;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Option_Menu: BEGIN
	{CreateEnclosing(Option_Box);}
	CreateBefore(SELECT_S);
	CreateWith(VerticalLine);
	CreateFirst(Option_gif);
	CreateLast(Option_space);
	ShowBox;
	Background : White;
	Foreground : Black;
	FillPattern: nopattern;
	BorderTopWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderTopColor: Grey;
	BorderRightColor: Black;
	BorderBottomColor: Black;
	BorderLeftColor: Grey;
	BorderTopStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	BorderLeftStyle: Solid;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	LineBreak: No;
	HorizPos: Left = Enclosing . Left + 0.2;	
	VertPos: Top = Enclosing . Top + 0.4;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
		BorderTopWidth: 0 px;
		BorderRightWidth: 0 px;
		BorderBottomWidth: 0 px;
		BorderLeftWidth: 0 px;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Option_item: BEGIN
	Visibility: 0;
	END;
	
 Option: BEGIN
	CreateBefore(OPTION_S);
	Visibility: 0;
	HorizPos: Left = Option_gif . Right + 0.2;	
	VertPos: Top = Previous Option . Bottom;
	MarginTop: 0.1;
	LineBreak: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Visibility: Enclosing =;
	END;

 OptGroup: BEGIN
	CreateBefore(OPTGROUP_S);
	CreateWith(VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Visibility: Enclosing =;
	END;

 Text_Area: BEGIN
	CreateBefore(TEXTAREA_S);
	Width: 20 ex;
	Height: 2 Min;
	LineBreak: No;
	Font: INPUT_Font;
	Depth: Enclosing + 1;
#ifndef BLACK_WHITE
	Background : LightRed4;
#endif
	HorizPos: Left = Enclosing . Left + 0.2;	
	VertPos: Top = Enclosing . Top + 0.4;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Width: Enclosed . Width;
		Height: Enclosed . Height;
		Size: Enclosing =;
		END;
	END;

 FIELDSET: BEGIN
	CreateBefore(FIELDSET_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.2;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 LEGEND: BEGIN
	CreateBefore(LEGEND_S);
	CreateWith(VerticalLine);
	Line;
#ifdef PAGE
	PageBreak: No;
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width : Enclosing . Width;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		NoLine;
		END;
	END;

 Inserted_Text: BEGIN
	Line;
	HorizPos: Left = Enclosing . Left + 0.4;
	VertPos: Top = Enclosing . Top + 0.3;
	Width: Enclosing . Width - 0.6;
	{Size: GrandFather =;}
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	END;

 Frame: BEGIN
	CreateBefore(Text_Mark);
	CreateBefore(Text_Frame);
	Width: 1 px;  Height: 1 px;
	Depth: Enclosing =;
	IN Structure_view
		Visibility: 0;
	END;

 Checkbox_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Checkbox);
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	LineBreak: No;
	Width: 1 px;  Height: 1 px;
	In Structure_view BEGIN
		Visibility: Enclosing =;
		Height: DOC_FONTSIZE;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		END;
	END;

 Radio_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Radio);
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	LineBreak: No;
	Width: 1 px;  Height: 1 px;
	In Structure_view BEGIN
		Visibility: Enclosing =;
		Height: DOC_FONTSIZE;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		END;
	END;

 Text_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Text);
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	Width: 20 ex Min;
	Height: 2 Min;
	Font: INPUT_Font;
	Depth: Enclosing + 1;
	LineBreak: No;
	Adjust: Left;
#ifndef BLACK_WHITE
	Background : LightRed4;
#endif
	IN Structure_view BEGIN
		Width: 1 px;
		Height: DOC_FONTSIZE;
		Size: Enclosing =;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		END;
	END;

 File_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_File);
	CreateAfter(BrowseLabel);
	Width: 20 ex Min;
	Height: 2 Min;
	Font: INPUT_Font;
	Depth: Enclosing + 1;
	LineBreak: No;
	Adjust: Left;
#ifndef BLACK_WHITE
	Background : LightRed4;
#endif
	IN Structure_view BEGIN
		Width: 1 px;
		Height: DOC_FONTSIZE;
		Size: Enclosing =;
		END;
	END;

 Hidden_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Hidden);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Height: DOC_FONTSIZE;
		END;
	END;

 Password_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Password);
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	Width: 20 ex Min;
	Height: 2 Min;
	Font: INPUT_Font;
	Depth: Enclosing + 1;
	LineBreak: No;
	Adjust: Left;
#ifndef BLACK_WHITE
	Background : LightRed4;
#endif
	IN Structure_view BEGIN
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		Width: 1 px;
		Height: DOC_FONTSIZE;
		Size: Enclosing =;
		END;
	END;

 Reset_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Reset);
	CreateFirst(Value_Box);
	Depth: Enclosing + 1;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	LineBreak: No;
	HorizPos: Left = Enclosing . Left + 0.2;	
	VertPos: Top = Enclosing . Top + 0.4;
	HorizRef: * . HMiddle;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: 1 px;
		Height: DOC_FONTSIZE;
		END;
	END;

 Submit_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Submit);
	CreateFirst(Value_Box);
	Depth: Enclosing + 1;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	LineBreak: No;
	HorizPos: Left = Enclosing . Left + 0.2;	
	VertPos: Top = Enclosing . Top + 0.4;
	HorizRef: * . HMiddle;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: 1 px;
		Height: DOC_FONTSIZE;
		END;
	END;

 Button_Input: BEGIN
	CreateBefore(INPUT_S);
	CreateBefore(ATTR_Button);
	CreateFirst(Value_Box);
	Depth: Enclosing + 1;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	LineBreak: No;
	HorizPos: Left = Enclosing . Left + 0.2;	
	VertPos: Top = Enclosing . Top + 0.4;
	HorizRef: * . HMiddle;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: 1 px;
		Height: DOC_FONTSIZE;
		END;
	END;

 LABEL: BEGIN
 	CreateBefore(LABEL_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 BUTTON: BEGIN
	CreateBefore(BUTTON_S);
	CreateWith(VerticalLine);
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	PaddingTop: 1 px;
	PaddingLeft: 1 px;
	PaddingBottom: 1 px;
	PaddingRight: 1 px;
	BorderTopWidth: 2 px;
	BorderLeftWidth: 2 px;
	BorderBottomWidth: 2 px;
	BorderRightWidth: 2 px;
	BorderTopColor: White;
	BorderLeftColor: White;
	BorderBottomColor: Black;
	BorderRightColor: Black;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
#ifndef BLACK_WHITE
	Background: Grey;
#endif
	FillPattern: backgroundcolor;
	ShowBox;
	LineBreak: No;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Block_Quote: BEGIN
	CreateBefore(BLOCKQUOTE_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Enclosing . Left + 2;	
	VertPos: Top = Previous AnyElem . Bottom;
	MarginTop: 0.4;
	Width: Enclosing . Width - 4;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		BEGIN
		Visibility: 0;	{ attribute "cite" changes visibility }
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		Indent: -2;
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Width: Enclosing . Width;
#endif
		END;
	END;

 PICTURE_UNIT: BEGIN
	if IsInput
		CreateBefore(IMG_in_S);
	if NOT Immediately within Object AND NOT IsInput
		CreateBefore(IMG_S);
	LineBreak: No;
	PageBreak: No;
	if Immediately within Object BEGIN
		Width: Enclosing . Width;
		Height: Enclosing . Height;
		VertPos: Top = Enclosing . Top;
		END;
	HorizRef: * . Bottom;
	IN Structure_view BEGIN
		Height: 1 px;
		Width: 1 px;
		if NOT Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		END;
	IN Alternate_view BEGIN
		Height: 1 px;
		Width: 1 px;
		if NOT Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		END;
	IN Links_view
#ifndef PAGE
		if Immediately within BODY
#endif
		   Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 Anchor: BEGIN
	CreateBefore(A_S);
	CreateWith(VerticalLine);
#ifdef PAGE
	CreateAfter(LinkPageNumber);
#endif
	if not immediately within BODY and not immediately within Division
	   BEGIN
	   HorizPos: Left = Previous . Right;
	   VertPos: HRef = Previous . HRef;
	   END;
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	IN Links_view BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		Indent: -2;
#ifdef PAGE
		Visibility: 0;	{ attribute HREF_ changes visibility }
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Visibility: 7;
		Width: Enclosing . Width;
#endif
		END;
	END;

 TEXT_UNIT:	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	if within Inserted_Text
		Depth: 0;
	IN Structure_view BEGIN
		if NOT within Comment_line AND NOT within PI_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if NOT within Invalid_element
		   Style: Enclosing =;
		if within Text_Input
		   Visibility: 0;
		if within Comment_line
		   HorizPos: Left = Previous . Right;
		if within PI_line
		   HorizPos: Left = Previous . Right;
		if within Preformatted
		   Font: Courier;
		END;
	END;

#ifdef PAGE
 PAGE_BREAK:
	BEGIN
	HorizOverflow : Yes;
	Underline: NoUnderline;
	Visibility: 10;
	END;
#endif

 MAP:	BEGIN
	CreateBefore(MAP_S);
	CreateWith(VerticalLine);
	CreateAfter(MAP_dummy);
	Depth: Enclosing + 8;
	LineBreak: No;
	Visibility: 0;
	Gather: Yes;
	InLine: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Font: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 AREA:	BEGIN
	CreateBefore(AREA_S);
 	HorizPos: Left = Enclosing . Left UserSpecified;
 	VertPos: Top = Enclosing . Top UserSpecified;
	Width: 5 pt UserSpecified;
	Height: 5 pt UserSpecified;
	Depth: 0;
	FillPattern: nopattern;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Width: 1 px;
		VertPos: Top = Previous AREA_S . Top;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 GRAPHICS_UNIT : BEGIN
	Visibility: Enclosing =;
	Height: Enclosing . Height;
	Width: Enclosing . Width;	
	IN Structure_view
	   Visibility: 0;
	END;

{ ---- Table ---- }

 Table:
	BEGIN
	Gather: Yes;
	LineBreak: No;
	Depth: Enclosing - 5;
#ifdef PAGE
	PageBreak: Yes;
	NoBreak1 : 3;
	NoBreak2 : 1;
#endif
	Justify: No;
	VertPos: Top = Previous NOT MAP . Bottom;
	{MarginTop: 0.5;}
	if within Center
		HorizPos: VMiddle = Enclosing . VMiddle;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	Adjust: Left;
	CreateBefore(TABLE_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Links_view
		Visibility: 0;
	END;

 CAPTION:
	BEGIN
	Line;
#ifdef PAGE
	PageBreak: No;
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Adjust: VMiddle;
	CreateBefore(CAPTION_S);
	CreateWith(VerticalLine);
	if within Table
	   BEGIN
	   Width : Enclosing . Width;
	   HorizPos: Left = Enclosing . Left;
	   VertPos: Bottom = Table_head . Top - cellspacing px;
	   END;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Adjust: Left;
		NoLine;
		END;
	END;

 Cols:  BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Visibility: Enclosing =;
		END;
	END;

 COLGROUP:
	BEGIN
	Visibility: 1;
	CreateBefore(COLGROUP_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Adjust: Left;
		Visibility: Enclosing =;
		END;
	END;

 COL:
	BEGIN
	Visibility: 1;
	CreateBefore(COL_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Adjust: Left;
		Visibility: Enclosing =;
		END;
	END;

 Table_head:
	BEGIN
	HorizRef: * . Top;
	HorizPos: Left = Enclosing . Left;
	Width: Enclosed . Width;
	VertPos: nil;
#ifdef PAGE
	PageBreak: No;
#endif
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	END;

 Column_head:
	BEGIN
	HorizRef: * . Top;
	HorizPos: Left = Previous . Right;
	VertPos: Top = Enclosing . Top;
	Width: Enclosed . Width;
	Height: 1 px;
	END;

 C_Head:
	BEGIN
	HorizRef: * . Top;
	VertPos : Top = Enclosing . Top;
	Width: 20 px;
	Height: 1 px;
	FillPattern: nopattern;
	END;

 thead:
	BEGIN
	CreateBefore(THEAD_S);
	CreateWith(VerticalLine);
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
#ifdef PAGE
	PageBreak: No;
#endif
	VertPos: Top = Previous . Bottom;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 tfoot:
	BEGIN
	CreateBefore(TFOOT_S);
	CreateWith(VerticalLine);
#ifdef PAGE
	PageBreak: No;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 Table_body:
	BEGIN
#ifdef PAGE
	PageBreak: Yes;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 tbody:
	BEGIN
	CreateBefore(TBODY_S);
	CreateWith(VerticalLine);
#ifdef PAGE
	PageBreak: Yes;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 Table_row:
	BEGIN
	VertPos: Top = Previous . Bottom;
	CreateBefore(TR_S);
	CreateWith(VerticalLine);
#ifdef PAGE
	{**** the next rule should be deleted, but deleting it causes
	      the print program to crash when formatting a very high
	      table row *****}
	{PageBreak: No;}
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		Width: Enclosing . Width;
		END;
	END;

 Data_cell:
	BEGIN
	VertPos : Top = Enclosing . Top;
	HorizPos: Left = Previous Table_cell . Right;
	Width: 20 px;
	Depth: Enclosing - 5;
	Adjust: Enclosing =;
	if NOT RowExt AND  immediately within Table_row
	  CreateAfter(CellFrame);
	CreateBefore(TD_S);
	CreateWith(VerticalLine);
	PaddingTop: 0.2;
	PaddingRight: 0.2;
	PaddingBottom: 0.2;
	PaddingLeft: 0.2;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		END;	
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	END;

 Heading_cell:
	BEGIN
	VertPos : Top = Enclosing . Top;
	HorizPos: Left = Previous Table_cell . Right;
	Width: 20 px;
	Depth: Enclosing - 5;
	Weight: Bold;
	Adjust: VMiddle;
	if NOT RowExt
	  CreateAfter(CellFrame);
	CreateBefore(TH_S);
	CreateWith(VerticalLine);
	PaddingTop: 0.2;
	PaddingLeft: 0.2;
	PaddingBottom: 0.2;
	PaddingRight: 0.2;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		Weight : Enclosing =;
		Adjust : Enclosing =;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		END;	
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	END;

 Table_foot:
	BEGIN
	Width: Previous . Width;
	VertPos: Bottom = Previous . Bottom;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	END;

 C_Foot:
	BEGIN
	Height: 1 pt;
	FillPattern: nopattern;
	END;

 Division:
	BEGIN
	CreateBefore(DIV_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	IF NOT within Division
	   MarginTop: VSpaceBeforeH2;
	IF within 1 Division
	   MarginTop: VSpaceBeforeH3;
	IF within 2 Division
	   MarginTop: VSpaceBeforeH4;
	IF within 3 Division
	   MarginTop: VSpaceBeforeH5;
	IF within >3 Division
	   MarginTop: VSpaceBeforeH6;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;	
		END;
	IN Links_view
		Visibility: 0;
	END;

  Center:
	BEGIN
	CreateBefore(CENTER_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom + 0.4;
	Adjust: VMiddle;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Adjust: Enclosing =;	
		END;
	IN Alternate_view
		Adjust: Left;
	IN Links_view
		Visibility: 0;
	END;

  NOSCRIPT:
	BEGIN
	CreateBefore(NOSCRIPT_S);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous NOT MAP . Bottom;
	MarginTop: 0.4;
	IN Structure_view BEGIN
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

  Invalid_element:
	BEGIN
	Visibility: 0;
	if NOT AnyAttributes
	  CreateAfter(INVALID_E);
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Visibility: INVALID_Visibility;
		Style: INVALID_Style; Weight: INVALID_Weight;
#ifdef BLACK_WHITE
		Underline: CrossedOut;
#else
		Foreground: INVALID_Color;
#endif
		Font: INVALID_Font;
		END;
	END;

  Comment\240:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width;
		END;
	END;

  Comment_line:
	BEGIN
	IF First CreateFirst(COMMENT_S);
	IF Last CreateLast(COMMENT_END);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
	END;


  XMLPI:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width;
		END;
	END;

  PI_line:
	BEGIN
	IF First CreateFirst(PI_S);
	IF Last CreateLast(PI_END);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
	END;

  FRAMESET: BEGIN
	CreateBefore(FRAMESET_S);
	CreateWith(VerticalLine);
#ifdef PAGE
	Width: Enclosing . Width;
#else
	IF within FRAMESET
		Width: Enclosing . Width;
	IF not within FRAMESET
		BEGIN
		HorizPos: Left = Enclosing . Left + 0.5 cm;
		Width: Enclosing . Width - 1 cm;
		END;
#endif
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;		
	END;

  Frames: BEGIN
        Width: Enclosing . Width;
        END;

  NOFRAMES: BEGIN
	VertPos: Top = Previous AnyElem . Bottom;
	Width: Enclosing . Width;
#ifdef PAGE
	Hyphenate: Yes;
#else
	Height: Enclosing . Height min;
	Hyphenate: No;
	CreateFirst(NOFRAMES_Sep1);
	CreateLast(NOFRAMES_Sep2);
#endif
	CreateBefore(NOFRAMES_S);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
#ifndef PAGE
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
#endif
		END;
	IN Links_view BEGIN
		Visibility: Enclosing =;
		Height: Enclosed . Height;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		Height: Enclosed . Height;
		END;
	END;

  FRAME: BEGIN
	CreateBefore(FRAME_S);
#ifdef PAGE
	Visibility: 0;
#else
	CreateFirst (FRAME_Label);
#endif
	Line;
	Indent: -3;
	Width: Enclosing . Width;
	IN Structure_view BEGIN
		Visibility: 1;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;		
	IN Table_of_contents
		Visibility: 0;
	END;

  IFRAME: BEGIN
	CreateBefore(IFRAME_S);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Width: 3 cm;
	LineBreak: No;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

ATTRIBUTES

 Langue:
	BEGIN
	If HTML and RealLang
	   BEGIN
	   CreateFirst(ATTR_LANG);
	   CreateFirst(VALUE_LANG);
	   END;
	If not HTML
	   BEGIN
	   CreateBefore(ATTR_LANG);
	   CreateBefore(VALUE_LANG);
	   END;
	END;

 HREF_:
	BEGIN
        CreateBefore(ATTR_HREF);
        CreateBefore(VALUE_HREF);
	IF Anchor
	   BEGIN
	   CreateLast(ATTR_HREF_LINKS_VIEW);
	   CreateLast(VALUE_HREF_LINKS_VIEW);
	   END;

#ifdef LINK_NUMBER
        IF Anchor and not InternalLink
           BEGIN
           CreateFirst(AnchorNumInLinkView);
           CreateAfter(AnchorNumInFormattedView);
           END;
#endif
#ifdef PAGE
	IF Anchor
	   Underline: Underlined;
	IN Links_view
		if Anchor
		   BEGIN
		   Visibility: 7;
		   Underline: Enclosing =;
		   END;
#else
#ifdef BLACK_WHITE
	IF Anchor
	   Underline: Underlined;
#endif
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;	
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	END;

 charset: BEGIN
	CreateBefore(ATTR_CHARSET);
	CreateBefore(VALUE_CHARSET);
	END;

 hreflang: BEGIN
	CreateBefore(ATTR_HREFLANG);
	CreateBefore(VALUE_HREFLANG);
	END;

 media: BEGIN
	CreateBefore(ATTR_MEDIA);
	CreateBefore(VALUE_MEDIA);
	END;

 target_: BEGIN
	CreateBefore(ATTR_TARGET);
	CreateBefore(VALUE_TARGET);
	END;

 cite:
	BEGIN
	CreateBefore(ATTR_CITE);
	CreateBefore(VALUE_CITE);
	CreateLast(ATTR_CITE_LINKS_VIEW);
	CreateLast(VALUE_CITE_LINKS_VIEW);
#ifdef LINK_NUMBER
	IF not InternalLink
	   CreateFirst(AnchorNumInLinkView);
        IF not InternalLink and not Block_Quote
           CreateAfter(AnchorNumInFormattedView);
	IF not InternalLink and Block_Quote
           CreateBefore(BlockNumInFormattedView);
#endif
#ifdef PAGE
	CreateAfter(LinkPageNumber);
#endif
	IN Links_view BEGIN
		Visibility: 7;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		Indent: -2;
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Width: Enclosing . Width;
#endif
		END;
	END;

 datetime:
	BEGIN
	CreateBefore(ATTR_DATETIME);
	CreateBefore(VALUE_DATETIME);
	END;

 ShowAreas (AREA):
	LineWeight: 2 pt;

 SectionNumbering (H2):
	CreateFirst(H2_section_number);
 SectionNumbering (H3):
	CreateFirst(H3_section_number);
 SectionNumbering (H4):
	CreateFirst(H4_section_number);
 SectionNumbering (H5):
	CreateFirst(H5_section_number);
 SectionNumbering (H6):
	CreateFirst(H6_section_number);

 Namespaces:
	BEGIN
	END;

 InternalLink:
        BEGIN
#ifdef LINK_NUMBER
        CreateAfter(SeeTargetPage);
#endif
#ifdef PAGE
        IN Links_view
           Visibility: 0;
#endif
        END;
 
#ifndef PAGE
#ifndef BLACK_WHITE
 PseudoClass = 'link':
	BEGIN
	Foreground: LINK_Color;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	IN Links_view
		Foreground: Enclosing =;
	END;
 PseudoClass = 'visited':
	BEGIN
	Foreground: DarkBlue3;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	END;
 PseudoClass = 'active':
	BEGIN
        Foreground: Red;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	END;
#endif
#endif

 content_type: BEGIN
	CreateBefore(ATTR_TYPE);
	CreateBefore(VALUE_CONTENT_TYPE);
	END;

 script_language: BEGIN
	CreateBefore(ATTR_LANGUAGE);
	CreateBefore(VALUE_SCRIPT_LANGUAGE);
	END;

 script_src: BEGIN
	CreateBefore(ATTR_SRC);
	CreateBefore(VALUE_SCRIPT_SRC);
	END;

 defer:
	CreateBefore(ATTR_DEFER);

 event: BEGIN
	CreateBefore(ATTR_EVENT);
	CreateBefore(VALUE_EVENT);
	END;

 for_:	BEGIN
	CreateBefore(ATTR_FOR);
	CreateBefore(VALUE_FOR);
	END;

 http_equiv: BEGIN
	CreateBefore(ATTR_HTTPEQUIV);
	CreateBefore(VALUE_HTTPEQUIV);
	END;

 meta_name: BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_METANAME);
	END;

 meta_content: BEGIN
	CreateBefore(ATTR_CONTENT);
	CreateBefore(VALUE_CONTENT);
	END;

 scheme: BEGIN
	CreateBefore(ATTR_SCHEME);
	CreateBefore(VALUE_SCHEME);
	END;

 USEMAP: BEGIN
	CreateBefore(ATTR_USEMAP);
	CreateBefore(VALUE_USEMAP);
	END;

 ALT:   BEGIN
	CreateBefore(ATTR_ALT);
	CreateBefore(VALUE_ALT);
	END;

 longdesc: BEGIN
	CreateBefore(ATTR_LONGDESC);
	CreateBefore(VALUE_LONGDESC);
	END;

 Title:	BEGIN
	CreateBefore(ATTR_TITLE);
	CreateBefore(VALUE_TITLE);
	CreateLast(ATTR_TITLE_ANCH);
	CreateLast(VALUE_TITLE_ANCH);
	IF FRAME
		BEGIN
		CreateLast (ATTR_TITLE_FRAME);
		CreateLast (VALUE_TITLE_FRAME);
		END;
	END;

 accesskey: BEGIN
	CreateBefore(ATTR_ACCESSKEY);
	CreateBefore(VALUE_ACCESSKEY);
	END;

 tabindex: BEGIN
	CreateBefore(ATTR_TABINDEX);
	CreateBefore(VALUE_TABINDEX);
	END;

 Associated_control: BEGIN
	CreateBefore(ATTR_FOR);
	CreateBefore(VALUE_ASSOC_CTRL);
	END;

 Button_type = button:
	CreateBefore (ButtonTypeButton);
 Button_type = submit:
	CreateBefore (ButtonTypeSubmit);
 Button_type = reset:
	CreateBefore (ButtonTypeReset);

 NAME(Anchor):
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_NAME);
#ifndef PAGE
	CreateFirst(Target_gif);
#endif
	CreateLast(ATTR_NAME_ANCH);
	CreateLast(VALUE_NAME_ANCH);
#ifdef LINK_NUMBER
        CreateAfter(TargetPageNumber);
#endif
#ifndef PAGE
#ifdef BLACK_WHITE
	Underline: Underlined;
#endif
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	END;
 NAME(MAP):
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_NAME);
	CreateLast(ATTR_NAME_ANCH);
	CreateLast(VALUE_NAME_ANCH);
#ifndef PAGE
#ifdef BLACK_WHITE
	Underline: Underlined;
#else
	Foreground: LINK_Color;
#endif
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	END;
 NAME:
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_NAME);
	END;

 Script_URL:
	BEGIN
	CreateBefore(ATTR_ActURL);
	CreateBefore(VALUE_ActURL);
	END;
 METHOD = Post_:
	BEGIN
	CreateBefore(MethodPost_S);
	END;
 METHOD = Get_:
	BEGIN
	CreateBefore(MethodGet_S);
	END;
 ENCTYPE:
	BEGIN
	CreateBefore(ATTR_ENCTYPE);
	CreateBefore(VALUE_ENCTYPE);
	END;
 accept_charset:
	BEGIN
	CreateBefore(ATTR_ACCEPT_CHARSET);
	CreateBefore(VALUE_ACCEPT_CHARSET);
	END;

 COMPACT:
	BEGIN
	CreateBefore(ATTR_COMPACT);
	END;

 REL:
	BEGIN
	CreateBefore(ATTR_REL);
	CreateBefore(VALUE_REL);
	CreateLast(ATTR_REL_ANCH);
	CreateLast(VALUE_REL_ANCH);
	END;

 REV:
	BEGIN
	CreateBefore(ATTR_REV);
	CreateBefore(VALUE_REV);
	CreateLast(ATTR_REV_ANCH);
	CreateLast(VALUE_REV_ANCH);
	END;

 SRC:   BEGIN
	CreateBefore(ATTR_SRC);
	CreateBefore(VALUE_SRC);
	END;

 Width__:
	BEGIN
	CreateBefore(ATTR_WIDTH);
	CreateBefore(VALUE_WIDTH__);
	END;

 IntWidthPxl:
	BEGIN
	If AREA
	   Width: IntWidthPxl px UserSpecified;
	If NOT AREA
	   Width: IntWidthPxl px;
	IN Structure_view BEGIN
	   If NOT PICTURE_UNIT
	   	Width: Enclosing . Width;
	   If PICTURE_UNIT
		Width: 1 px;
	   END;
	IN Alternate_view BEGIN
	   Width: Enclosing . Width;
	   END;
	END;

 IntWidthPercent:
	BEGIN
	Width: Enclosing . Width * IntWidthPercent %;
	IN Structure_view BEGIN
	   If NOT PICTURE_UNIT
	   	Width: Enclosing . Width;
	   If PICTURE_UNIT
		Width: 1 px;
	   END;
	IN Alternate_view BEGIN
	  If Data_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  If Heading_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  If NOT Data_cell and NOT Heading_cell
	   Width: Enclosing . Width;
	   END;
	END;

 Height_:
	BEGIN
	CreateBefore(ATTR_HEIGHT);
	CreateBefore(VALUE_HEIGHT);
	if Data_cell
	   Height: Height_ px min;
        if Heading_cell
	   Height: Height_ px min;
        If NOT Data_cell and NOT Heading_cell
	   Height: Height_ px;
	IN Structure_view BEGIN
	   If PICTURE_UNIT
	        Height: 1 px;
	   If NOT PICTURE_UNIT
		Height: Enclosed . Height;
	   END;
	IN Alternate_view BEGIN
	   If PICTURE_UNIT
	        Height: 1 px;
	   If NOT PICTURE_UNIT
		Height: Enclosed . Height;
	   END;
	END;

 hspace:
	BEGIN
	CreateBefore(ATTR_HSPACE);
	CreateBefore(VALUE_HSPACE);
	MarginLeft: hspace pt;
	MarginRight: hspace pt;
	END;

 vspace:
	BEGIN
	CreateBefore(ATTR_VSPACE);
	CreateBefore(VALUE_VSPACE);
	MarginTop: vspace pt;
	MarginBottom: vspace pt;
	In Structure_view
	   VertPos: Top = Previous . Bottom;
	END;

 declare:
	CreateBefore (ATTR_DECLARE);

 codebase:
	BEGIN
	CreateBefore(ATTR_CODEBASE);
	CreateBefore(VALUE_CODEBASE);
	END;

 code:
	BEGIN
	CreateBefore(ATTR_CODE);
	CreateBefore(VALUE_CODE);
	END;

 object:
	BEGIN
	CreateBefore(ATTR_OBJECT);
	CreateBefore(VALUE_OBJECT);
	END;

 applet_name:
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_APPLET_NAME);
	END;

 Param_name:
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_PARAM_NAME);
	END;

 Param_value:
	BEGIN
	CreateBefore(ATTR_VALUE);
	CreateBefore(VALUE_PARAM_VALUE);
	END;

 valuetype = data_:
	CreateBefore(ATTR_VALUETYPE_DATA);
 valuetype = ref:
	CreateBefore(ATTR_VALUETYPE_REF);
 valuetype = object_:
	CreateBefore(ATTR_VALUETYPE_OBJECT);

 Param_type:
	BEGIN
	CreateBefore(ATTR_TYPE);
	CreateBefore(VALUE_PARAM_TYPE);
	END;

 classid:
	BEGIN
	CreateBefore(ATTR_CLASSID);
	CreateBefore(VALUE_CLASSID);
	END;

 data:
	BEGIN
	CreateBefore(ATTR_DATA);
	CreateBefore(VALUE_DATA);
	END;

 Object_type:
	BEGIN
	CreateBefore(ATTR_TYPE);
	CreateBefore(VALUE_OBJECT_TYPE);
	END;

 Link_type:
	BEGIN
	CreateBefore(ATTR_TYPE);
	CreateBefore(VALUE_LINK_TYPE);
	END;

 codetype:
	BEGIN
	CreateBefore(ATTR_CODETYPE);
	CreateBefore(VALUE_CODETYPE);
	END;

 archive:
	BEGIN
	CreateBefore(ATTR_ARCHIVE);
	CreateBefore(VALUE_ARCHIVE);
	END;

 standby:
	BEGIN
	CreateBefore(ATTR_STANDBY);
	CreateBefore(VALUE_STANDBY);
	END;

 Img_border:
	BEGIN
	CreateBefore(ATTR_BORDER);
	CreateBefore(VALUE_IMG_BORDER);
	BorderTopWidth: Border px;
	BorderLeftWidth: Border px;
	BorderBottomWidth: Border px;
	BorderRightWidth: Border px;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	END;

 NoShade:
	CreateBefore(ATTR_NOSHADE);

 Size_ < 2:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_SIZE);
	Height: 2 pt;
#ifdef PAGE
	LineWeight: Size_ pt;
#endif
	IN Alternate_view
		BEGIN
		Height: 1;
		LineWeight: 1 pt;
		END;
	IN Structure_view
		Height: 1 pt;
	END;

 Size_ > 1:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_SIZE);
	Height: Size_ pt;
#ifdef PAGE
	LineWeight: Size_ pt;
#endif
	IN Alternate_view
		BEGIN
		Height: 1;
		LineWeight: 1 pt;
		END;
	IN Structure_view
		Height: 1 pt;
	END;

 NumberStyle = Arabic_ :
	CreateBefore(ATTR_TYPE_ARABIC);
 NumberStyle = LowerAlpha :
	CreateBefore(ATTR_TYPE_LALPHA);
 NumberStyle = UpperAlpha :
	CreateBefore(ATTR_TYPE_UALPHA);
 NumberStyle = LowerRoman :
	CreateBefore(ATTR_TYPE_LROMAN);
 NumberStyle = UpperRoman :
	CreateBefore(ATTR_TYPE_UROMAN);

 BulletStyle = disc :
	CreateBefore(ATTR_TYPE_DISC);
 BulletStyle = square :
	CreateBefore(ATTR_TYPE_SQUARE);
 BulletStyle = circle :
	CreateBefore(ATTR_TYPE_CIRCLE);

 ItemStyle = Arabic_ :
	CreateBefore(ATTR_TYPE_ARABIC);
 ItemStyle = LowerAlpha :
	CreateBefore(ATTR_TYPE_LALPHA);
 ItemStyle = UpperAlpha :
	CreateBefore(ATTR_TYPE_UALPHA);
 ItemStyle = LowerRoman :
	CreateBefore(ATTR_TYPE_LROMAN);
 ItemStyle = UpperRoman :
	CreateBefore(ATTR_TYPE_UROMAN);
 ItemStyle = disc :
	CreateBefore(ATTR_TYPE_DISC);
 ItemStyle = square :
	CreateBefore(ATTR_TYPE_SQUARE);
 ItemStyle = circle :
	CreateBefore(ATTR_TYPE_CIRCLE);

 IntItemStyle = Arabic_ :
	CreateBefore(OL_NUM_ARABIC);
 IntItemStyle = LowerAlpha :
	CreateBefore(OL_NUM_LALPHA);
 IntItemStyle = UpperAlpha :
	CreateBefore(OL_NUM_UALPHA);
 IntItemStyle = LowerRoman :
	CreateBefore(OL_NUM_LROMAN);
 IntItemStyle = UpperRoman :
	CreateBefore(OL_NUM_UROMAN);
 IntItemStyle = disc :
	CreateBefore(UL_DISC);
 IntItemStyle = square :
	CreateBefore(UL_SQUARE);
 IntItemStyle = circle :
	CreateBefore(UL_CIRCLE);

 Start:
	BEGIN
	CreateBefore(ATTR_START);
	CreateBefore(VALUE_START);
	END;

 Clear = Left_:
	CreateBefore(CLEAR_LEFT);
 Clear = Right_:
	CreateBefore(CLEAR_RIGHT);
 Clear = All_:
	CreateBefore(CLEAR_ALL);
 Clear = None_:
	CreateBefore(CLEAR_NONE);

 Alignment = Top_:
	BEGIN
	CreateBefore(ALIGN_TOP);
	HorizRef: * . Top + 0.7;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Middle_:
	BEGIN
	CreateBefore(ALIGN_MIDDLE);
	HorizRef: * . HMiddle + 0.2;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Bottom_:
	BEGIN
	CreateBefore(ALIGN_BOTTOM);
	HorizRef: * . Bottom;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Left_:
	BEGIN
	CreateBefore(ALIGN_LEFT);
	HorizPos: Left = Enclosing . Left;
	Adjust: Left;
	END;
 Alignment = Right_:
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	HorizPos: Right = Enclosing . Right;
	Adjust: Left;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		Adjust: Left;
		END;
	END;

 Align = left_:
	BEGIN
	CreateBefore(ALIGN_LEFT);
	Adjust: Left;
	HorizPos: Left = Enclosing . Left;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 Align = center_:
	BEGIN
	CreateBefore(ALIGN_CENTER);
	Adjust: VMiddle;
	HorizPos: VMiddle = Enclosing . VMiddle;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 Align = right_:
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	Adjust: Right;
	HorizPos: Right = Enclosing . Right;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;

 TextAlign = left_:
	BEGIN
	CreateBefore(ALIGN_LEFT);
	Adjust: Left;
	END;
 TextAlign = center_:
	BEGIN
	CreateBefore(ALIGN_CENTER);
	Adjust: VMiddle;	
	In Structure_view
	   Adjust: Left;
	END;
 TextAlign = right_:
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	Adjust: Right;
	In Structure_view
	   Adjust: Left;
	END;
 TextAlign = justify_:
	BEGIN
	CreateBefore(ALIGN_JUSTIFY);
	Adjust: Left;
	Justify: Yes;
	In Structure_view
	   Justify: Enclosing =;
	END;
 TextAlign (Table) = center_:
	BEGIN
	HorizPos: VMiddle = Enclosing . VMiddle;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 TextAlign (Table) = right_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;

 ISMAP:
	CreateBefore(ATTR_ISMAP);

 BaseFontSize:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_BASEFONTSIZE);
	END;
 BaseFontColor:
	BEGIN
	CreateBefore(ATTR_COLOR);
	CreateBefore(VALUE_BASEFONTCOLOR);
	END;
 BaseFontFace:
	BEGIN
	CreateBefore(ATTR_FACE);
	CreateBefore(VALUE_BASEFONTFACE);
	END;

 Font_size:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_FONT_SIZE);
	END;
 face:
	BEGIN
	CreateBefore(ATTR_FACE);
	CreateBefore(VALUE_FACE);
	END;
 IntSizeIncr:
	BEGIN
	Size: Enclosing + IntSizeIncr;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;
 IntSizeDecr:
	BEGIN
	Size: Enclosing - IntSizeDecr;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;
 IntSizeRel:
	BEGIN
	Size: IntSizeRel;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;

 color:
	BEGIN
	CreateBefore(ATTR_COLOR);
	CreateBefore(VALUE_COLOR);
	END;

 background_:
	BEGIN
	CreateBefore(ATTR_BACKGROUND);
	CreateBefore(VALUE_BACKGROUND);
	END;

 BackgroundColor:
	BEGIN
	CreateBefore(ATTR_BGCOLOR);
	CreateBefore(VALUE_BGCOLOR);
	END;

 TextColor:
	BEGIN
	CreateBefore(ATTR_TEXTCOLOR);
	CreateBefore(VALUE_TEXTCOLOR);
	END;

 LinkColor:
	BEGIN
	CreateBefore(ATTR_LINKCOLOR);
	CreateBefore(VALUE_LINKCOLOR);
	END;

 VisitedLinkColor:
	BEGIN
	CreateBefore(ATTR_VLINKCOLOR);
	CreateBefore(VALUE_VLINKCOLOR);
	END;

 ActiveLinkColor:
	BEGIN
	CreateBefore(ATTR_ALINKCOLOR);
	CreateBefore(VALUE_ALINKCOLOR);
	END;

 Value_:
	BEGIN
	CreateBefore(ATTR_VALUE);
	CreateBefore(VALUE_VALUE);
	IN Structure_view BEGIN
	    if NOT Option BEGIN
	       HorizPos: Left = Previous . Right;
	       VertPos: HRef = Previous . HRef;
	       END;
	    END;
	END;
 Multiple:
	CreateBefore(ATTR_MULTIPLE);
 MenuSize:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_MENUSIZE);
	END;

 Selected:
	BEGIN
	CreateBefore(ATTR_SELECTED);
	Visibility: 5 {*****};
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: Enclosing =;
	IN Alternate_view
		Visibility: Enclosing =;
	IN Table_of_contents
		Visibility: Enclosing =;
	END;

 Checked(Checkbox_Input) = Yes_:
	BEGIN
	CreateBefore(ToggleS_gif);
	CreateBefore(ATTR_CHECKED);
	END;
 Checked(Checkbox_Input) = No_:
	CreateBefore(Toggle_gif);
 Checked(Radio_Input) = Yes_:
	BEGIN
	CreateBefore(RadioS_gif);
	CreateBefore(ATTR_CHECKED);
	END;
 Checked(Radio_Input) = No_:
	CreateBefore(Radio_gif);

 disabled:
	CreateBefore(ATTR_DISABLED);

 readonly:
	CreateBefore (ATTR_READONLY);

 label:
	BEGIN
	CreateBefore(ATTR_LABEL);
	CreateBefore(VALUE_LABEL);
	END;

 accept:
	BEGIN
	CreateBefore(ATTR_ACCEPT);
	CreateBefore(VALUE_ACCEPT);
	END;

 LAlign = Top_:
	BEGIN
	CreateBefore(ALIGN_TOP);
	VertPos: Top = Enclosing . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	END;
 LAlign = Bottom_:
	BEGIN
	CreateBefore(ALIGN_BOTTOM);
	END;
 LAlign = Left_:
	BEGIN
	CreateBefore(ALIGN_LEFT);
	Adjust: Left;
	IN Structure_view
		Adjust: Enclosing =;
	END;
 LAlign = Right_:
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	Adjust: Right;
	IN Structure_view
		Adjust: Enclosing =;
	END;

 Area_Size:
	BEGIN
	CreateBefore(ATTR_SIZE);
	CreateBefore(VALUE_AREA_SIZE);
	Width: Area_Size ex Min;
	IN Structure_view BEGIN
		Width: 1 pt;
		Height: 1 pt;
		END;
	END;

 MaxLength:
	BEGIN
	CreateBefore(ATTR_MAXLENGTH);
	CreateBefore(VALUE_MAXLENGTH);
	END;
 Rows:
	BEGIN
	CreateBefore(ATTR_ROWS);
	CreateBefore(VALUE_ROWS);
	Height: Rows Min;
	IN Structure_view
		BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Height: Enclosed . Height;
		END;
	END;
 Columns:
	BEGIN
	CreateBefore(ATTR_COLS);
	CreateBefore(VALUE_COLS);
	if Text_Area
	   Width: Columns ex;
	IN Structure_view
	    BEGIN
	    if Text_Area
		BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Width: Enclosed . Width;
		END;
	    END;
	END;

{ ---- Table ---- }

 summary:
	BEGIN
	CreateBefore(ATTR_SUMMARY);
	CreateBefore(VALUE_SUMMARY);
	END;

 frame = void:
	CreateBefore(FRAME_VOID);
 frame = above:
	CreateBefore(FRAME_ABOVE);
 frame = below:
	CreateBefore(FRAME_BELOW);
 frame = hsides:
	CreateBefore(FRAME_HSIDES);
 frame = lhs:
	CreateBefore(FRAME_LHS);
 frame = rhs:
	CreateBefore(FRAME_RHS);
 frame = vsides:
	CreateBefore(FRAME_VSIDES);
 frame = box:
	CreateBefore(FRAME_BOX);
 frame = border:
	CreateBefore(FRAME_BORDER);

 rules_ = none_:
	CreateBefore(RULES_NONE);
 rules_ = groups:
	CreateBefore(RULES_GROUPS);
 rules_ = rows:
	CreateBefore(RULES_ROWS);
 rules_ = cols:
	CreateBefore(RULES_COLS);
 rules_ = all:
	CreateBefore(RULES_ALL);

 cellspacing (Table_head) > 0:
	BEGIN
	PaddingLeft: cellspacing px;	
	PaddingRight: cellspacing px;
	BorderRightWidth: Border px;
	END;
 cellspacing (Column_head):
	BEGIN
	HorizPos: Left = Previous . Right + cellspacing px;
	IN Structure_view
	   VertPos: Top = Previous . Bottom;
	END;
 cellspacing (Column_head) > 0:
	BorderRightWidth: Border px;
 cellspacing (thead) > 0:
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (Table_body):
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 cellspacing (tbody) > 0:
	BEGIN
	VertPos: Top = Previous tbody . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (tfoot) > 0:
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (Table_row):
	BEGIN
	VertPos: Top = Previous Table_row . Bottom + cellspacing px;
	IN Structure_view
	   VertPos: Top = Previous . Bottom;
	IN Alternate_view
	   VertPos: Top = Previous . Bottom;
	END;
 cellspacing (Heading_cell) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 cellspacing (Data_cell) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 cellspacing:
	BEGIN
	CreateBefore(ATTR_CELLSPACING);
	CreateBefore(VALUE_CELLSPACING);
	END;

 cellpadding (Data_cell):
	BEGIN
	PaddingTop: cellpadding px;
	PaddingRight: cellpadding px;
	PaddingBottom: cellpadding px;
	PaddingLeft: cellpadding px;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;

 cellpadding (Heading_cell):
	BEGIN
	PaddingTop: cellpadding px;
	PaddingRight: cellpadding px;
	PaddingBottom: cellpadding px;
	PaddingLeft: cellpadding px;	
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellpadding:
	BEGIN
	CreateBefore(ATTR_CELLPADDING);
	CreateBefore(VALUE_CELLPADDING);
	END;

 Border (Table_head)> 0:
	BEGIN
	MarginLeft: Border px;
	END;
 Border (Column_head)> 0:
	BEGIN
	MarginRight: Border px;
	END;
 Border (thead)> 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (tbody) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (tfoot) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (Heading_cell) > 0:
	BEGIN
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 Border (Data_cell) > 0:
	BEGIN
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 Border:
	BEGIN
	CreateBefore(ATTR_BORDER);
	CreateBefore(VALUE_BORDER);
	END;

 datapagesize:
	BEGIN
	CreateBefore(ATTR_DATAPAGESIZE);
	CreateBefore(VALUE_DATAPAGESIZE);
	END;

 Ref_column:
	BEGIN
        Width: Referred . Width;
	HorizPos: Left = Referred . Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		Width: Right = Enclosing . Right;
		HorizPos: Left = Previous . Left + STRUCT_INDENT;
		END;
	END;

 ColExt:
	BEGIN
	Width: Right = Referred . Right;
	IN Structure_view
		Width: Enclosing . Width;
	IN Alternate_view BEGIN
		Width: Right = Enclosing . Right;
		HorizPos: Left = Previous . Left + STRUCT_INDENT;
		END;
	END;

 RowExt:
	BEGIN
	CreateAfter(CellExtFrame);
	VertOverflow: Yes;
	IN Structure_view BEGIN
		Height : Enclosed . Height;
		VertOverflow: No;
		END;	
	IN Alternate_view BEGIN
		Height : Enclosed . Height;
		VertOverflow: No;
		END;	
	END;

 abbr:
	BEGIN
	CreateBefore(ATTR_ABBR);
	CreateBefore(VALUE_ABBR);
	END;

 axis:
	BEGIN
	CreateBefore(ATTR_AXIS);
	CreateBefore(VALUE_AXIS);
	END;

 headers:
	BEGIN
	CreateBefore(ATTR_HEADERS);
	CreateBefore(VALUE_HEADERS);
	END;

 scope:
	BEGIN
	CreateBefore(ATTR_SCOPE);
	CreateBefore(VALUE_SCOPE);
	END;

 span_:
	BEGIN
	CreateBefore(ATTR_SPAN);
	CreateBefore(VALUE_SPAN);
	END;

 rowspan_:
	BEGIN
	CreateBefore(ATTR_ROWSPAN);
	CreateBefore(VALUE_ROWSPAN);
	END;

 colspan_:
	BEGIN
	CreateBefore(ATTR_COLSPAN);
	CreateBefore(VALUE_COLSPAN);
	END;

 Position = Position_top :
	BEGIN
	CreateBefore(ALIGN_TOP);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_bottom :
	BEGIN
	CreateBefore(ALIGN_BOTTOM);
	VertPos: Top = Table_foot . Bottom + cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_left :
	BEGIN
	CreateBefore(ALIGN_LEFT);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	Adjust: Left;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_right :
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	Adjust: Right;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		Adjust: Left;
		END;
	END;

 Cell_align = Cell_left :
	BEGIN
	CreateBefore(ALIGN_LEFT);
	Adjust: Left;
	Justify : No;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	END;
	
 Cell_align = Cell_center :
	BEGIN
	CreateBefore(ALIGN_CENTER);
	Adjust: VMiddle;
	Justify : No;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 Cell_align = Cell_right :
	BEGIN
	CreateBefore(ALIGN_RIGHT);
	Adjust: Right;
	Justify : No;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 Cell_align = Cell_justify :
	BEGIN
	CreateBefore(ALIGN_JUSTIFY);
	Adjust: Left;
	Justify : Yes;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		Justify: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		Justify: Enclosing =;
		END;
	END;

 Cell_align = Cell_char :
	BEGIN
	CreateBefore(ALIGN_CHAR);
	Adjust: Right;
	Justify : No;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 char:
  	BEGIN
	CreateBefore(ATTR_CHAR);
	CreateBefore(VALUE_CHAR);
	END;

 charoff:
  	BEGIN
	CreateBefore(ATTR_CHAROFF);
	CreateBefore(VALUE_CHAROFF);
	END;

 Row_valign (Data_cell) = Row_top :
	BEGIN
	VertPos : Top = Next CellFrame . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_top :
	BEGIN
	VertPos : Top = Next CellFrame . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_top :
	CreateBefore(VALIGN_TOP);

 Row_valign (Data_cell) = Row_middle :
	BEGIN
	VertPos : HMiddle = Next CellFrame . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_middle :
	BEGIN
	VertPos : HMiddle = Next CellFrame . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_middle :
	CreateBefore(VALIGN_MIDDLE);

 Row_valign (Data_cell) = Row_bottom :
	BEGIN
	VertPos : Bottom = Next CellFrame . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_bottom :
	BEGIN
	VertPos : Bottom = Next CellFrame . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_bottom :
	CreateBefore(VALIGN_BOTTOM);

 Row_valign (Data_cell) = Row_baseline :
	BEGIN
	VertPos : Top = Next CellFrame . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_baseline :
	BEGIN
	VertPos : Top = Next CellFrame . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_baseline :
	CreateBefore(VALIGN_BASELINE);

 Cell_valign = Cell_top :
	BEGIN
	CreateBefore(VALIGN_TOP);
	VertPos : Top = Next . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_middle :
	BEGIN
	CreateBefore(VALIGN_MIDDLE);
	VertPos : HMiddle = Next . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_bottom :
	BEGIN
	CreateBefore(VALIGN_BOTTOM);
	VertPos : Bottom = Next . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_baseline :
	BEGIN
	CreateBefore(VALIGN_BASELINE);
	VertPos : Top = Next . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 No_wrap = no_wrap :
	BEGIN
	CreateBefore(ATTR_NOWRAP);
	Hyphenate: No;
	END;

 Ref_IMG:
	BEGIN
	Visibility: Enclosing =;
	VertPos: Top = Refered . Top;
	HorizPos: Left = Refered . Left;
	Width: Refered . Width;
	Height: Refered . Height;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		 Visibility: 0;
	END;

 AreaRef_IMG:
	BEGIN
	VertPos: Top = Refered . Top;
	HorizPos: Left = Refered . Left;
	Width: Refered . Width;
	Height: Refered . Height;
	IN Structure_view BEGIN
		Width: 1 pt;
		Height: Enclosed . Height;
		VertPos: Top = Previous AREA_S . Top;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 x_coord(AREA):
	BEGIN
 	HorizPos: Left = Enclosing . Left + x_coord px UserSpecified;
	IN Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;
 y_coord(AREA):
	BEGIN
 	VertPos: Top = Enclosing . Top + y_coord px UserSpecified;
	IN Structure_view
 	   VertPos: Top = Previous AREA_S . Top;
	END;

  height\240(AREA):
	BEGIN
	Height: height\240 px UserSpecified;
	IN Structure_view
	   Height: Enclosed . Height;
	END;

  height\240(Table_row):
	BEGIN
	Height: height\240 px min;
	IN Structure_view
	   Height: Enclosed . Height;
	IN Alternate_view
	   Height: Enclosed . Height;
	END;

  shape = rectangle:
	CreateBefore(ATTR_SHAPE_RECT);
  shape = circle:
	CreateBefore(ATTR_SHAPE_CIRCLE);
  shape = polygon:
	CreateBefore(ATTR_SHAPE_POLY);

  coords:
	BEGIN
	CreateBefore(ATTR_COORDS);
	CreateBefore(VALUE_COORDS);
	END;

  nohref:
	CreateBefore(ATTR_NOHREF);

  Style\240:
	BEGIN
	CreateBefore(ATTR_STYLE);
	CreateBefore(VALUE_STYLE);
	END;

  profile:
  	BEGIN
	CreateBefore(ATTR_PROFILE);
	CreateBefore(VALUE_PROFILE);
	END;

  Prompt:
  	BEGIN
	CreateBefore(ATTR_PROMPT);
	CreateBefore(VALUE_PROMPT);
	END;

  Notation:
  	BEGIN
	CreateBefore(ATTR_TYPE);
	CreateBefore(VALUE_NOTATION);
	END;

  Class:
	BEGIN
	CreateBefore(ATTR_CLASS);
	CreateBefore(VALUE_CLASS);
	END;

 ID:
	BEGIN
	CreateBefore(ATTR_ID);
	CreateBefore(VALUE_ID);
#ifndef PAGE
	if PICTURE_UNIT
	   CreateBefore(Target_gif);
	if not PICTURE_UNIT
	   CreateFirst(Target_gif);
#endif
	if Anchor BEGIN
	   CreateLast(ATTR_ID_ANCH);
	   CreateLast(VALUE_ID_ANCH);
#ifdef LINK_NUMBER
           CreateAfter(TargetPageNumber);
#endif
#ifndef PAGE
#ifdef BLACK_WHITE
	   Underline: Underlined;
#endif
#endif
	   END;
	IN Structure_view
           BEGIN
	   if Anchor BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	   END;
	IN Alternate_view
	   BEGIN
	   if Anchor BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	   END;
	END;

  dir = ltr:
	CreateBefore(ATTR_DIR_LTR);

  dir = rtl:
	CreateBefore(ATTR_DIR_RTL);

  onclick:
	BEGIN
	CreateBefore(ATTR_ONCLICK);
	CreateBefore(VALUE_ONCLICK);
	END;

  ondblclick:
	BEGIN
	CreateBefore(ATTR_ONDBLCLICK);
	CreateBefore(VALUE_ONDBLCLICK);
	END;

  onmousedown:
	BEGIN
	CreateBefore(ATTR_ONMOUSEDOWN);
	CreateBefore(VALUE_ONMOUSEDOWN);
	END;

  onmouseup:
	BEGIN
	CreateBefore(ATTR_ONMOUSEUP);
	CreateBefore(VALUE_ONMOUSEUP);
	END;

  onmouseover:
	BEGIN
	CreateBefore(ATTR_ONMOUSEOVER);
	CreateBefore(VALUE_ONMOUSEOVER);
	END;

  onmousemove:
	BEGIN
	CreateBefore(ATTR_ONMOUSEMOVE);
	CreateBefore(VALUE_ONMOUSEMOVE);
	END;

  onmouseout:
	BEGIN
	CreateBefore(ATTR_ONMOUSEOUT);
	CreateBefore(VALUE_ONMOUSEOUT);
	END;

  onkeypress:
	BEGIN
	CreateBefore(ATTR_ONKEYPRESS);
	CreateBefore(VALUE_ONKEYPRESS);
	END;

  onkeydown:
	BEGIN
	CreateBefore(ATTR_ONKEYDOWN);
	CreateBefore(VALUE_ONKEYDOWN);
	END;

  onkeyup:
	BEGIN
	CreateBefore(ATTR_ONKEYUP);
	CreateBefore(VALUE_ONKEYUP);
	END;

  onload:
	BEGIN
	CreateBefore(ATTR_ONLOAD);
	CreateBefore(VALUE_ONLOAD);
	END;

  onunload:
	BEGIN
	CreateBefore(ATTR_ONUNLOAD);
	CreateBefore(VALUE_ONUNLOAD);
	END;

  onfocus:
	BEGIN
	CreateBefore(ATTR_ONFOCUS);
	CreateBefore(VALUE_ONFOCUS);
	END;

  onblur:
	BEGIN
	CreateBefore(ATTR_ONBLUR);
	CreateBefore(VALUE_ONBLUR);
	END;

  onsubmit:
	BEGIN
	CreateBefore(ATTR_ONSUBMIT);
	CreateBefore(VALUE_ONSUBMIT);
	END;

  onreset:
	BEGIN
	CreateBefore(ATTR_ONRESET);
	CreateBefore(VALUE_ONRESET);
	END;

  onselect:
	BEGIN
	CreateBefore(ATTR_ONSELECT);
	CreateBefore(VALUE_ONSELECT);
	END;

  onchange:
	BEGIN
	CreateBefore(ATTR_ONCHANGE);
	CreateBefore(VALUE_ONCHANGE);
	END;

  RowHeight:
	BEGIN
	CreateBefore(ATTR_ROWS);
	CreateBefore(VALUE_ROWHEIGHT);
	END;

  ColWidth:
	BEGIN
	CreateBefore(ATTR_COLS);
	CreateBefore(VALUE_COLWIDTH);
	END;

  FrameName:
	BEGIN
	CreateBefore(ATTR_NAME);
	CreateBefore(VALUE_FRAMENAME);
	CreateLast (ATTR_FRAMENAME);
	CreateLast (VALUE_FRAMENAME1);
	END;

  FrameSrc:
	BEGIN
	CreateBefore(ATTR_SRC);
	CreateBefore(VALUE_FRAMESRC);
	if FRAME
	   BEGIN
	   CreateLast (ATTR_FRAMESRC);
	   CreateLast (VALUE_FRAMESRC1);
	   END;
	END;

  frameborder = Border1:
	CreateBefore(ATTR_FRAMEBORDER_1);

  frameborder = Border0:
	CreateBefore(ATTR_FRAMEBORDER_0);

  marginwidth:
	BEGIN
	CreateBefore(ATTR_MARGINWIDTH);
	CreateBefore(VALUE_MARGINWIDTH);
	END;

  marginheight:
	BEGIN
	CreateBefore(ATTR_MARGINHEIGHT);
	CreateBefore(VALUE_MARGINHEIGHT);
	END;

  no_resize:
	CreateBefore(ATTR_NORESIZE);

  scrolling = Yes_:
	CreateBefore(ATTR_SCROLLING_YES);
  scrolling = No_:
	CreateBefore(ATTR_SCROLLING_NO);
  scrolling = auto_:
	CreateBefore(ATTR_SCROLLING_AUTO);

  Invalid_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(VALUE_Invalid_attribute);
	if PICTURE_UNIT
	   CreateBefore(VALUE_Invalid_attribute);
	if Invalid_element
	   CreateAfter(VALUE_Invalid_attribute);
	if Invalid_element and LastAttr
	   CreateAfter(INVALID_E);
	if Anchor
	   CreateBefore(VALUE_Invalid_attribute);
	if NOT TEXT_UNIT and NOT PICTURE_UNIT and NOT Invalid_element and NOT Anchor
	   CreateBefore(VALUE_Invalid_attribute);
	END;

  EntityName:
	BEGIN
	CreateBefore(VALUE_EntityName);
	IN Structure_view
		Visibility: 1;
	END;

  xml_space = xml_space_default:
	CreateBefore(ATTR_XML_SPACE_DEFAULT);

  xml_space = xml_space_preserve:
	CreateBefore(ATTR_XML_SPACE_PRESERVE);

#ifndef PAGE
  Highlight:
	BEGIN
        if TEXT_UNIT
	   CreateAfter (IndexBox);
	if NOT TEXT_UNIT
	   CreateLast (IndexBox);
	END;
#endif

  Error_type = UnknownTag:
	BEGIN
#ifdef BLACK_WHITE
	Underline: CrossedOut;
#else
	Foreground: UNKNOWNTAG_Color;
#endif
	if LastAttr
	   CreateAfter(INVALID_E);
	END;

  Error_type = BadPosition:
	if LastAttr
	   CreateAfter(INVALID_E);

END
