#include <regex.h>

/* You can edit MYSQL_??? definitions
 * indexer will use it to connect to MySQL database by default
 * But better (and more secure) way is to provide
 * that information in template
 *
 * Please see README.templates for details
 */

#define MYSQL_HOST	"localhost"
#define MYSQL_DB	"udmsearch"
#define MYSQL_USER	"foo"
#define MYSQL_PASS	"bar"

#define INDEXER_USER_AGENT "UdmSearch"
#define DEFAULT_PROXY_PORT 3128

#define MAXFILTER	128

#define DEFAULT_REINDEX_TIME	7*24*60*60
#define DEFAULT_MAX_HOPS	256
#define READ_TIMEOUT		90
#define MAXNETERRORS		16


#define MAXDOCSIZE	1024*1024  /* 1Mb */
#define MAXTEXTSIZE	128
#define MAXTITLESIZE	128
#define MAXKEYWORDSIZE	255
#define MAXDESCSIZE	100
#define WSIZE		1024
#define STRSIZ		1024

/****
 * Nothing should be edited below!
 */

#define F_ALLOW    0
#define F_DISALLOW 1
#define F_HEAD     2
  
typedef struct word_struct {
	int count;
	char *word;
} WORD;

typedef struct robots_struct {
	char *hostinfo;
	char *path;
} ROBOT;

typedef struct server_struct {
	char *url;
	char *charset;
	char *proxy;
	char *basic_auth;
	int  proxy_port;
	int  period;
	int  hint;
	int  net_errors;
	int  max_net_errors;
	int  read_timeout;
	int  outside;
	int  maxhops;
	int  gindex;
	int  gfollow;
	int  deletebad;
	int  userobots;
	int  bodyweight;
	int  titleweight;
	int  urlweight;
	int  descweight;
	int  keywordweight;
} SERVER;

typedef struct filter_struct {
	regex_t filter;
	int     filter_type;
} FILTER;
