#ifndef _PARSER_H
#define _PARSER_H

#define PARSER_COMMENT 	  '#'
#define PARSER_DELIMITERS " \t\n\r"
#define PARSER_QUOTES     "\""

#define MAXPARSERS 256
#define MAXARGV 16

#define MIME_FROM 0
#define MIME_TO   1

typedef struct parser_struct{
        char *from_mime;
	char *to_mime;
        char *parser;
	char **argv;
	int fileposition;	
	char *charset;
} PARSER;

int AddMime(char *buffer);
char *mime_parse(char *from_mime, int *to_mime, char *buf, int length, int maxlen);
char *mime_name(int mime, int type);
char *mime_charset(int mime);

#endif
